/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.pair.tags;

import java.awt.Adjustable;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openstreetmap.josm.gui.conflict.pair.MergeDecisionType;
import org.openstreetmap.josm.gui.conflict.pair.tags.MergedTableCellRenderer;
import org.openstreetmap.josm.gui.conflict.pair.tags.MineTableCellRenderer;
import org.openstreetmap.josm.gui.conflict.pair.tags.TagMergeColumnModel;
import org.openstreetmap.josm.gui.conflict.pair.tags.TagMergeModel;
import org.openstreetmap.josm.gui.conflict.pair.tags.TheirTableCellRenderer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class TagMerger
extends JPanel {
    private JTable mineTable;
    private JTable mergedTable;
    private JTable theirTable;
    private final TagMergeModel model = new TagMergeModel();
    private JButton btnKeepMine;
    private JButton btnKeepTheir;
    AdjustmentSynchronizer adjustmentSynchronizer;

    protected JScrollPane embeddInScrollPane(JTable table) {
        JScrollPane pane = new JScrollPane(table);
        pane.setHorizontalScrollBarPolicy(30);
        pane.setVerticalScrollBarPolicy(20);
        this.adjustmentSynchronizer.synchronizeAdjustment(pane.getVerticalScrollBar());
        return pane;
    }

    protected JScrollPane buildMineTagTable() {
        this.mineTable = new JTable(this.model, new TagMergeColumnModel(new MineTableCellRenderer()));
        this.mineTable.setName("table.my");
        return this.embeddInScrollPane(this.mineTable);
    }

    protected JScrollPane buildTheirTable() {
        this.theirTable = new JTable(this.model, new TagMergeColumnModel(new TheirTableCellRenderer()));
        this.theirTable.setName("table.their");
        return this.embeddInScrollPane(this.theirTable);
    }

    protected JScrollPane buildMergedTable() {
        this.mergedTable = new JTable(this.model, new TagMergeColumnModel(new MergedTableCellRenderer()));
        this.mergedTable.setName("table.merged");
        return this.embeddInScrollPane(this.mergedTable);
    }

    protected void build() {
        GridBagConstraints gc = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        this.adjustmentSynchronizer = new AdjustmentSynchronizer();
        gc.gridx = 0;
        gc.gridy = 0;
        gc.gridwidth = 1;
        gc.gridheight = 1;
        gc.fill = 0;
        gc.anchor = 10;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        gc.insets = new Insets(10, 0, 10, 0);
        JLabel lbl = new JLabel(I18n.tr("My version (local dataset)"));
        this.add((Component)lbl, gc);
        gc.gridx = 2;
        gc.gridy = 0;
        gc.gridwidth = 1;
        gc.gridheight = 1;
        gc.fill = 0;
        gc.anchor = 10;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        lbl = new JLabel(I18n.tr("Merged version"));
        this.add((Component)lbl, gc);
        gc.gridx = 4;
        gc.gridy = 0;
        gc.gridwidth = 1;
        gc.gridheight = 1;
        gc.fill = 0;
        gc.anchor = 10;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        gc.insets = new Insets(0, 0, 0, 0);
        lbl = new JLabel(I18n.tr("Their version (server dataset)"));
        this.add((Component)lbl, gc);
        gc.gridx = 0;
        gc.gridy = 1;
        gc.gridwidth = 1;
        gc.gridheight = 1;
        gc.fill = 1;
        gc.anchor = 23;
        gc.weightx = 0.3;
        gc.weighty = 1.0;
        this.add((Component)this.buildMineTagTable(), gc);
        gc.gridx = 1;
        gc.gridy = 1;
        gc.gridwidth = 1;
        gc.gridheight = 1;
        gc.fill = 0;
        gc.anchor = 10;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        KeepMineAction keepMineAction = new KeepMineAction();
        this.mineTable.getSelectionModel().addListSelectionListener(keepMineAction);
        this.btnKeepMine = new JButton(keepMineAction);
        this.btnKeepMine.setName("button.keepmine");
        this.add((Component)this.btnKeepMine, gc);
        gc.gridx = 2;
        gc.gridy = 1;
        gc.gridwidth = 1;
        gc.gridheight = 1;
        gc.fill = 1;
        gc.anchor = 23;
        gc.weightx = 0.3;
        gc.weighty = 1.0;
        this.add((Component)this.buildMergedTable(), gc);
        gc.gridx = 3;
        gc.gridy = 1;
        gc.gridwidth = 1;
        gc.gridheight = 1;
        gc.fill = 0;
        gc.anchor = 10;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        KeepTheirAction keepTheirAction = new KeepTheirAction();
        this.btnKeepTheir = new JButton(keepTheirAction);
        this.btnKeepTheir.setName("button.keeptheir");
        this.add((Component)this.btnKeepTheir, gc);
        gc.gridx = 4;
        gc.gridy = 1;
        gc.gridwidth = 1;
        gc.gridheight = 1;
        gc.fill = 1;
        gc.anchor = 23;
        gc.weightx = 0.3;
        gc.weighty = 1.0;
        this.add((Component)this.buildTheirTable(), gc);
        this.theirTable.getSelectionModel().addListSelectionListener(keepTheirAction);
        DoubleClickAdapter dblClickAdapter = new DoubleClickAdapter();
        this.mineTable.addMouseListener(dblClickAdapter);
        this.theirTable.addMouseListener(dblClickAdapter);
        gc.gridx = 2;
        gc.gridy = 2;
        gc.gridwidth = 1;
        gc.gridheight = 1;
        gc.fill = 0;
        gc.anchor = 10;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        UndecideAction undecidedAction = new UndecideAction();
        this.mergedTable.getSelectionModel().addListSelectionListener(undecidedAction);
        JButton btnUndecide = new JButton(undecidedAction);
        btnUndecide.setName("button.undecide");
        this.add((Component)btnUndecide, gc);
    }

    public TagMerger() {
        this.build();
    }

    public TagMergeModel getModel() {
        return this.model;
    }

    class UndecideAction
    extends AbstractAction
    implements ListSelectionListener {
        public UndecideAction() {
            ImageIcon icon = ImageProvider.get("dialogs/conflict", "tagundecide.png");
            if (icon != null) {
                this.putValue("SmallIcon", icon);
                this.putValue("Name", "");
            } else {
                this.putValue("Name", I18n.tr("Undecide"));
            }
            this.putValue("ShortDescription", I18n.tr("Mark the selected tags as undecided"));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent arg0) {
            int[] rows = TagMerger.this.mergedTable.getSelectedRows();
            if (rows == null || rows.length == 0) {
                return;
            }
            TagMerger.this.model.decide(rows, MergeDecisionType.UNDECIDED);
        }

        public void valueChanged(ListSelectionEvent e) {
            this.setEnabled(TagMerger.this.mergedTable.getSelectedRowCount() > 0);
        }
    }

    class DoubleClickAdapter
    extends MouseAdapter {
        DoubleClickAdapter() {
        }

        public void mouseClicked(MouseEvent e) {
            MergeDecisionType mergeDecision;
            if (e.getClickCount() != 2) {
                return;
            }
            JTable table = null;
            if (e.getSource() == TagMerger.this.mineTable) {
                table = TagMerger.this.mineTable;
                mergeDecision = MergeDecisionType.KEEP_MINE;
            } else if (e.getSource() == TagMerger.this.theirTable) {
                table = TagMerger.this.theirTable;
                mergeDecision = MergeDecisionType.KEEP_THEIR;
            } else if (e.getSource() == TagMerger.this.mergedTable) {
                table = TagMerger.this.mergedTable;
                mergeDecision = MergeDecisionType.UNDECIDED;
            } else {
                return;
            }
            int row = table.rowAtPoint(e.getPoint());
            TagMerger.this.model.decide(row, mergeDecision);
        }
    }

    class AdjustmentSynchronizer
    implements AdjustmentListener {
        private final ArrayList<Adjustable> synchronizedAdjustables = new ArrayList();

        public void synchronizeAdjustment(Adjustable adjustable) {
            if (adjustable == null) {
                return;
            }
            if (this.synchronizedAdjustables.contains(adjustable)) {
                return;
            }
            this.synchronizedAdjustables.add(adjustable);
            adjustable.addAdjustmentListener(this);
        }

        public void adjustmentValueChanged(AdjustmentEvent e) {
            for (Adjustable a : this.synchronizedAdjustables) {
                if (a == e.getAdjustable()) continue;
                a.setValue(e.getValue());
            }
        }
    }

    class KeepTheirAction
    extends AbstractAction
    implements ListSelectionListener {
        public KeepTheirAction() {
            ImageIcon icon = ImageProvider.get("dialogs/conflict", "tagkeeptheir.png");
            if (icon != null) {
                this.putValue("SmallIcon", icon);
                this.putValue("Name", "");
            } else {
                this.putValue("Name", I18n.tr(">"));
            }
            this.putValue("ShortDescription", I18n.tr("Keep the selected key/value pairs from the server dataset"));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent arg0) {
            int[] rows = TagMerger.this.theirTable.getSelectedRows();
            if (rows == null || rows.length == 0) {
                return;
            }
            TagMerger.this.model.decide(rows, MergeDecisionType.KEEP_THEIR);
        }

        public void valueChanged(ListSelectionEvent e) {
            this.setEnabled(TagMerger.this.theirTable.getSelectedRowCount() > 0);
        }
    }

    class KeepMineAction
    extends AbstractAction
    implements ListSelectionListener {
        public KeepMineAction() {
            ImageIcon icon = ImageProvider.get("dialogs/conflict", "tagkeepmine.png");
            if (icon != null) {
                this.putValue("SmallIcon", icon);
                this.putValue("Name", "");
            } else {
                this.putValue("Name", I18n.tr(">"));
            }
            this.putValue("ShortDescription", I18n.tr("Keep the selected key/value pairs from the local dataset"));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent arg0) {
            int[] rows = TagMerger.this.mineTable.getSelectedRows();
            if (rows == null || rows.length == 0) {
                return;
            }
            TagMerger.this.model.decide(rows, MergeDecisionType.KEEP_MINE);
        }

        public void valueChanged(ListSelectionEvent e) {
            this.setEnabled(TagMerger.this.mineTable.getSelectedRowCount() > 0);
        }
    }
}

