/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.tags;

import java.util.Collection;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.osm.TagCollection;
import org.openstreetmap.josm.data.osm.TigerUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagConflictResolutionUtil {
    private TagConflictResolutionUtil() {
    }

    public static void normalizeTagCollectionBeforeEditing(TagCollection tc, Collection<? extends OsmPrimitive> merged) {
        tc.removeByKey("created_by");
        int numNodesWithTags = 0;
        for (OsmPrimitive osmPrimitive : merged) {
            if (osmPrimitive.getKeys().size() <= 0) continue;
            ++numNodesWithTags;
        }
        if (numNodesWithTags <= 1) {
            return;
        }
        for (String string : tc.getKeys()) {
            for (OsmPrimitive osmPrimitive : merged) {
                if (osmPrimitive.get(string) != null) continue;
                tc.add(new Tag(string, ""));
            }
        }
    }

    public static void combineTigerTags(TagCollection tc) {
        for (String key : tc.getKeys()) {
            if (!TigerUtils.isTigerTag(key)) continue;
            tc.setUniqueForKey(key, TigerUtils.combineTags(key, tc.getValues(key)));
        }
    }

    public static void completeTagCollectionForEditing(TagCollection tc) {
        for (String key : tc.getKeys()) {
            tc.add(new Tag(key, ""));
        }
    }
}

