/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.plaf.basic.BasicArrowButton;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AutoScaleAction;
import org.openstreetmap.josm.actions.search.SearchAction;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.OsmPrimitivRenderer;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectionListDialog
extends ToggleDialog
implements SelectionChangedListener,
Layer.LayerChangeListener {
    private static final int SELECTION_HISTORY_SIZE = 10;
    private final DefaultListModel list = new DefaultListModel();
    private LinkedList<Collection<? extends OsmPrimitive>> selectionHistory;
    private JList displaylist = new JList(this.list);
    private SideButton selectButton;
    private SideButton searchButton;
    private JPopupMenu popupMenu;
    private JMenuItem zoomToElement;
    private Collection<? extends OsmPrimitive> historyIgnoreSelection = null;

    public SelectionListDialog() {
        super(I18n.tr("Current Selection"), "selectionlist", I18n.tr("Open a selection list window."), Shortcut.registerShortcut("subwindow:selection", I18n.tr("Toggle: {0}", I18n.tr("Current Selection")), 84, 4, 1), 150, true);
        this.selectionHistory = new LinkedList();
        this.popupMenu = new JPopupMenu();
        this.displaylist.setCellRenderer(new OsmPrimitivRenderer());
        this.displaylist.setSelectionMode(2);
        this.displaylist.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && e.getButton() == 1) {
                    SelectionListDialog.this.updateMap();
                }
            }

            public void mousePressed(MouseEvent e) {
                SelectionListDialog.this.showPopupMenu(e);
            }

            public void mouseReleased(MouseEvent e) {
                SelectionListDialog.this.showPopupMenu(e);
            }
        });
        this.add((Component)new JScrollPane(this.displaylist), "Center");
        JPanel buttonPanel = new JPanel(new GridLayout(1, 2));
        this.selectButton = new SideButton(I18n.marktr("Select"), "select", "SelectionList", I18n.tr("Set the selected elements on the map to the selected items in the list above."), new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SelectionListDialog.this.updateMap();
            }
        });
        buttonPanel.add(this.selectButton);
        BasicArrowButton selectionHistoryMenuButton = this.createArrowButton(this.selectButton);
        selectionHistoryMenuButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SelectionListDialog.this.showSelectionHistoryMenu();
            }
        });
        this.add((Component)buttonPanel, "South");
        this.zoomToElement = new JMenuItem(I18n.tr("Zoom to selected element(s)"));
        this.zoomToElement.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SelectionListDialog.this.zoomToSelectedElement();
            }
        });
        this.searchButton = new SideButton(I18n.marktr("Search"), "search", "SelectionList", I18n.tr("Search for objects."), Main.main.menu.search);
        buttonPanel.add(this.searchButton);
        BasicArrowButton searchHistoryMenuButton = this.createArrowButton(this.searchButton);
        searchHistoryMenuButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SelectionListDialog.this.showSearchHistoryMenu();
            }
        });
        this.popupMenu.add(this.zoomToElement);
        JMenuItem zoomToSelection = new JMenuItem(I18n.tr("Zoom to selection"));
        zoomToSelection.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SelectionListDialog.this.zoomToSelection();
            }
        });
        this.popupMenu.add(zoomToSelection);
        if (Main.main.getCurrentDataSet() != null) {
            this.selectionChanged(Main.main.getCurrentDataSet().getSelected());
        }
        DataSet.selListeners.add(this);
        Layer.listeners.add(this);
    }

    private BasicArrowButton createArrowButton(SideButton parentButton) {
        BasicArrowButton arrowButton = new BasicArrowButton(5, null, null, Color.BLACK, null);
        arrowButton.setBorder(BorderFactory.createEmptyBorder());
        parentButton.setLayout(new BorderLayout());
        parentButton.add((Component)arrowButton, "East");
        return arrowButton;
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        if (b && Main.main.getCurrentDataSet() != null) {
            this.selectionChanged(Main.main.getCurrentDataSet().getSelected());
        }
    }

    protected void showPopupMenu(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.zoomToElement.setVisible(this.displaylist.getSelectedIndex() >= 0);
            this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    public void zoomToSelection() {
        new AutoScaleAction("selection").actionPerformed(null);
    }

    public void zoomToSelectedElement() {
        BoundingXYVisitor box = new BoundingXYVisitor();
        int[] selected = this.displaylist.getSelectedIndices();
        if (selected.length == 0) {
            return;
        }
        for (int i = 0; i < selected.length; ++i) {
            Object o = this.list.get(selected[i]);
            if (!(o instanceof OsmPrimitive)) continue;
            ((OsmPrimitive)o).visit(box);
        }
        if (box.getBounds() == null) {
            return;
        }
        box.enlargeBoundingBox();
        Main.map.mapView.recalculateCenterScale(box);
    }

    private void showSelectionHistoryMenu() {
        if (this.selectionHistory.size() == 0) {
            return;
        }
        JPopupMenu historyMenu = new JPopupMenu();
        for (Collection collection : this.selectionHistory) {
            SelectionMenuItem item = new SelectionMenuItem(collection);
            historyMenu.add(item);
        }
        Rectangle r = this.selectButton.getBounds();
        historyMenu.show(this.selectButton, r.x, r.y + r.height);
    }

    private void showSearchHistoryMenu() {
        if (SearchAction.searchHistory.size() == 0) {
            return;
        }
        JPopupMenu historyMenu = new JPopupMenu();
        for (SearchAction.SearchSetting s : SearchAction.searchHistory) {
            SearchMenuItem item = new SearchMenuItem(s);
            historyMenu.add(item);
        }
        Rectangle r = this.searchButton.getBounds();
        historyMenu.show(this.searchButton, r.x, r.y + r.height);
    }

    @Override
    public void selectionChanged(Collection<? extends OsmPrimitive> newSelection) {
        if (this.list == null || !this.isVisible()) {
            return;
        }
        OsmPrimitive[] selArr = DataSet.sort(newSelection);
        this.list.setSize(selArr.length);
        int i = 0;
        for (OsmPrimitive osm : selArr) {
            this.list.setElementAt(osm, i++);
        }
        if (this.selectionHistory != null && newSelection.size() > 0 && !newSelection.equals(this.historyIgnoreSelection)) {
            this.historyIgnoreSelection = null;
            try {
                Collection<? extends OsmPrimitive> first = this.selectionHistory.getFirst();
                if (first.equals(newSelection)) {
                    return;
                }
            }
            catch (NoSuchElementException e) {
                // empty catch block
            }
            this.selectionHistory.addFirst(newSelection);
            while (this.selectionHistory.size() > 10) {
                this.selectionHistory.removeLast();
            }
        }
        int ways = 0;
        int nodes = 0;
        int relations = 0;
        for (OsmPrimitive osmPrimitive : newSelection) {
            if (osmPrimitive instanceof Way) {
                ++ways;
                continue;
            }
            if (osmPrimitive instanceof Node) {
                ++nodes;
                continue;
            }
            if (!(osmPrimitive instanceof Relation)) continue;
            ++relations;
        }
        if (nodes + ways + relations != 0) {
            this.setTitle(I18n.tr("Sel.: Rel.:{0} / Ways:{1} / Nodes:{2}", relations, ways, nodes));
        } else {
            this.setTitle(I18n.tr("Selection"));
        }
    }

    public void updateMap() {
        LinkedList<OsmPrimitive> sel = new LinkedList<OsmPrimitive>();
        for (int i = 0; i < this.list.getSize(); ++i) {
            if (!this.displaylist.isSelectedIndex(i)) continue;
            sel.add((OsmPrimitive)this.list.get(i));
        }
        Main.main.getCurrentDataSet().setSelected(sel);
    }

    @Override
    public void activeLayerChange(Layer oldLayer, Layer newLayer) {
        if (newLayer instanceof OsmDataLayer) {
            OsmDataLayer dataLayer = (OsmDataLayer)newLayer;
            this.selectionChanged(dataLayer.data.getSelected());
        } else {
            List selection = Collections.emptyList();
            this.selectionChanged(selection);
        }
    }

    @Override
    public void layerAdded(Layer newLayer) {
    }

    @Override
    public void layerRemoved(Layer oldLayer) {
    }

    protected class SearchMenuItem
    extends JMenuItem
    implements ActionListener {
        protected SearchAction.SearchSetting s;

        public SearchMenuItem(SearchAction.SearchSetting s) {
            super(s.toString());
            this.s = s;
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent e) {
            SearchAction.searchWithoutHistory(this.s);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SelectionMenuItem
    extends JMenuItem
    implements ActionListener {
        protected Collection<? extends OsmPrimitive> sel;

        public SelectionMenuItem(Collection<? extends OsmPrimitive> sel) {
            this.sel = sel;
            int ways = 0;
            int nodes = 0;
            int relations = 0;
            for (OsmPrimitive osmPrimitive : sel) {
                if (osmPrimitive instanceof Way) {
                    ++ways;
                    continue;
                }
                if (osmPrimitive instanceof Node) {
                    ++nodes;
                    continue;
                }
                if (!(osmPrimitive instanceof Relation)) continue;
                ++relations;
            }
            String text = "";
            if (ways != 0) {
                text = text + (text.length() > 0 ? ", " : "") + I18n.trn("{0} way", "{0} ways", ways, ways);
            }
            if (nodes != 0) {
                text = text + (text.length() > 0 ? ", " : "") + I18n.trn("{0} node", "{0} nodes", nodes, nodes);
            }
            if (relations != 0) {
                text = text + (text.length() > 0 ? ", " : "") + I18n.trn("{0} relation", "{0} relations", relations, relations);
            }
            this.setText(I18n.tr("Selection: {0}", text));
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SelectionListDialog.this.historyIgnoreSelection = this.sel;
            Main.main.getCurrentDataSet().setSelected(this.sel);
        }
    }
}

