/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.gui.dialogs.DialogsPanel;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.help.Helpful;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public class ToggleDialog
extends JPanel
implements Helpful {
    private ToggleDialogAction toggleAction;
    private String preferencePrefix;
    private DialogsPanel dialogsPanel;
    private TitleBar titleBar;
    private boolean isShowing;
    private boolean isDocked;
    private boolean isCollapsed;
    private int preferredHeight;
    private JLabel lblMinimized;
    private JDialog detachedDialog;

    public ToggleDialog(String name, String iconName, String tooltip, Shortcut shortcut, int preferredHeight) {
        this(name, iconName, tooltip, shortcut, preferredHeight, false);
    }

    public ToggleDialog(String name, String iconName, String tooltip, Shortcut shortcut, int preferredHeight, boolean defShow) {
        super(new BorderLayout());
        this.preferencePrefix = iconName;
        this.setPreferredSize(new Dimension(0, preferredHeight));
        this.setMinimumSize(new Dimension(0, 0));
        this.preferredHeight = preferredHeight;
        this.toggleAction = new ToggleDialogAction(name, "dialogs/" + iconName, tooltip, shortcut, iconName);
        String helpId = "Dialog/" + this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1);
        this.toggleAction.putValue("help", helpId.substring(0, helpId.length() - 6));
        this.setLayout(new BorderLayout());
        this.lblMinimized = new JLabel(ImageProvider.get("misc", "normal"));
        this.titleBar = new TitleBar(name, iconName);
        this.add((Component)this.titleBar, "North");
        this.setBorder(BorderFactory.createEtchedBorder());
        this.isShowing = Main.pref.getBoolean(this.preferencePrefix + ".visible", defShow);
        this.isDocked = Main.pref.getBoolean(this.preferencePrefix + ".docked", true);
        this.isCollapsed = Main.pref.getBoolean(this.preferencePrefix + ".minimized", false);
    }

    public void showDialog() {
        this.setIsShowing(true);
        if (!this.isDocked) {
            this.detach();
        } else {
            this.dock();
            this.setVisible(true);
        }
        this.setIsShowing(true);
        this.toggleAction.putValue("selected", false);
        this.toggleAction.putValue("selected", true);
    }

    public void hideDialog() {
        this.closeDetachedDialog();
        this.setVisible(false);
        this.setIsShowing(false);
        this.toggleAction.putValue("selected", false);
    }

    protected void dock() {
        this.detachedDialog = null;
        this.titleBar.setVisible(true);
        this.setIsDocked(true);
    }

    protected void detach() {
        this.setContentVisible(true);
        this.setVisible(true);
        this.titleBar.setVisible(false);
        this.detachedDialog = new DetachedDialog();
        this.detachedDialog.setVisible(true);
        this.setIsDocked(false);
    }

    public void collapse() {
        this.setContentVisible(false);
        this.setIsCollapsed(true);
        this.setPreferredSize(new Dimension(0, 20));
        this.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        this.setMinimumSize(new Dimension(Integer.MAX_VALUE, 20));
        this.lblMinimized.setIcon(ImageProvider.get("misc", "minimized"));
    }

    protected void expand() {
        this.setContentVisible(true);
        this.setIsCollapsed(false);
        this.setPreferredSize(new Dimension(0, this.preferredHeight));
        this.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.lblMinimized.setIcon(ImageProvider.get("misc", "normal"));
    }

    protected void setContentVisible(boolean visible) {
        Component[] comps = this.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (comps[i] == this.titleBar) continue;
            comps[i].setVisible(visible);
        }
    }

    public void closeDetachedDialog() {
        if (this.detachedDialog != null) {
            this.detachedDialog.setVisible(false);
            this.detachedDialog.getContentPane().removeAll();
            this.detachedDialog.dispose();
        }
    }

    protected Rectangle getDetachedGeometry(Rectangle last) {
        return last;
    }

    protected Dimension getDefaultDetachedSize() {
        return new Dimension(Main.map.DEF_TOGGLE_DLG_WIDTH, this.preferredHeight);
    }

    public AbstractAction getToggleAction() {
        return this.toggleAction;
    }

    public String getPreferencePrefix() {
        return this.preferencePrefix;
    }

    public void setDialogsPanel(DialogsPanel dialogsPanel) {
        this.dialogsPanel = dialogsPanel;
    }

    public String getName() {
        return "toggleDialog." + this.preferencePrefix;
    }

    public void setTitle(String title) {
        this.titleBar.setTitle(title);
    }

    private void setIsShowing(boolean val) {
        this.isShowing = val;
        Main.pref.put(this.preferencePrefix + ".visible", val);
    }

    private void setIsDocked(boolean val) {
        this.isDocked = val;
        Main.pref.put(this.preferencePrefix + ".docked", val);
    }

    private void setIsCollapsed(boolean val) {
        this.isCollapsed = val;
        Main.pref.put(this.preferencePrefix + ".minimized", val);
    }

    public int getPreferredHeight() {
        return this.preferredHeight;
    }

    public boolean isDialogShowing() {
        return this.isShowing;
    }

    public boolean isDialogInDefaultView() {
        return this.isShowing && this.isDocked && !this.isCollapsed;
    }

    public boolean isDialogInCollapsedView() {
        return this.isShowing && this.isDocked && this.isCollapsed;
    }

    public String helpTopic() {
        String help = this.getClass().getName();
        help = help.substring(help.lastIndexOf(46) + 1, help.length() - 6);
        return "Dialog/" + help;
    }

    private class DetachedDialog
    extends JDialog {
        public DetachedDialog() {
            super(JOptionPane.getFrameForComponent(Main.parent));
            this.getContentPane().add(ToggleDialog.this);
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    DetachedDialog.this.rememberGeometry();
                    DetachedDialog.this.getContentPane().removeAll();
                    DetachedDialog.this.dispose();
                    ToggleDialog.this.dock();
                    ToggleDialog.this.expand();
                    ToggleDialog.this.dialogsPanel.reconstruct(DialogsPanel.Action.INVISIBLE_TO_DEFAULT, ToggleDialog.this);
                }
            });
            this.addMouseListener(new MouseAdapter(){

                public void mouseEntered(MouseEvent e) {
                    super.mouseEntered(e);
                    System.out.println("requesting focus ...");
                    DetachedDialog.this.requestFocusInWindow();
                }
            });
            String bounds = Main.pref.get(ToggleDialog.this.preferencePrefix + ".bounds", null);
            if (bounds != null) {
                String[] b = bounds.split(",");
                this.setBounds(ToggleDialog.this.getDetachedGeometry(new Rectangle(Integer.parseInt(b[0]), Integer.parseInt(b[1]), Integer.parseInt(b[2]), Integer.parseInt(b[3]))));
            } else {
                ToggleDialog.this.setPreferredSize(ToggleDialog.this.getDefaultDetachedSize());
                this.pack();
                this.setLocationRelativeTo(Main.parent);
            }
            this.setTitle(ToggleDialog.this.titleBar.getTitle());
            HelpUtil.setHelpContext(this.getRootPane(), ToggleDialog.this.helpTopic());
        }

        protected void rememberGeometry() {
            Main.pref.put(ToggleDialog.this.preferencePrefix + ".bounds", ToggleDialog.this.detachedDialog.getX() + "," + ToggleDialog.this.detachedDialog.getY() + "," + ToggleDialog.this.detachedDialog.getWidth() + "," + ToggleDialog.this.detachedDialog.getHeight());
        }
    }

    private class TitleBar
    extends JPanel {
        private final JLabel lblTitle;
        private final JComponent lblTitle_weak;

        public TitleBar(String toggleDialogName, String iconName) {
            this.setLayout(new GridBagLayout());
            ToggleDialog.this.lblMinimized = new JLabel(ImageProvider.get("misc", "normal"));
            this.add(ToggleDialog.this.lblMinimized);
            ImageIcon inIcon = ImageProvider.get("dialogs", iconName);
            ImageIcon smallIcon = new ImageIcon(inIcon.getImage().getScaledInstance(16, 16, 4));
            this.lblTitle = new JLabel("", smallIcon, 11);
            this.lblTitle.setIconTextGap(8);
            JPanel conceal = new JPanel();
            conceal.add(this.lblTitle);
            conceal.setVisible(false);
            this.add((Component)conceal, GBC.std());
            this.lblTitle_weak = new JComponent(){

                public void paintComponent(Graphics g) {
                    TitleBar.this.lblTitle.paint(g);
                }
            };
            this.lblTitle_weak.setPreferredSize(new Dimension(Integer.MAX_VALUE, 20));
            this.lblTitle_weak.setMinimumSize(new Dimension(0, 20));
            this.add((Component)this.lblTitle_weak, GBC.std().fill(2));
            this.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    if (ToggleDialog.this.isCollapsed) {
                        ToggleDialog.this.expand();
                        ToggleDialog.this.dialogsPanel.reconstruct(DialogsPanel.Action.COLLAPSED_TO_DEFAULT, ToggleDialog.this);
                    } else {
                        ToggleDialog.this.collapse();
                        ToggleDialog.this.dialogsPanel.reconstruct(DialogsPanel.Action.ELEMENT_SHRINKS, null);
                    }
                }
            });
            JButton sticky = new JButton(ImageProvider.get("misc", "sticky"));
            sticky.setToolTipText(I18n.tr("Undock the panel"));
            sticky.setBorder(BorderFactory.createEmptyBorder());
            sticky.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ToggleDialog.this.detach();
                    ToggleDialog.this.dialogsPanel.reconstruct(DialogsPanel.Action.ELEMENT_SHRINKS, null);
                }
            });
            this.add(sticky);
            JButton close = new JButton(ImageProvider.get("misc", "close"));
            close.setToolTipText(I18n.tr("Close this panel. You can reopen it with the buttons in the left toolbar."));
            close.setBorder(BorderFactory.createEmptyBorder());
            close.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ToggleDialog.this.hideDialog();
                    ToggleDialog.this.dialogsPanel.reconstruct(DialogsPanel.Action.ELEMENT_SHRINKS, null);
                }
            });
            this.add(close);
            this.setToolTipText(I18n.tr("Click to minimize/maximize the panel content"));
            this.setTitle(toggleDialogName);
        }

        public void setTitle(String title) {
            this.lblTitle.setText(title);
            this.lblTitle_weak.repaint();
        }

        public String getTitle() {
            return this.lblTitle.getText();
        }
    }

    public final class ToggleDialogAction
    extends JosmAction {
        private ToggleDialogAction(String name, String iconName, String tooltip, Shortcut shortcut, String prefname) {
            super(name, iconName, tooltip, shortcut, false);
        }

        public void actionPerformed(ActionEvent e) {
            if (ToggleDialog.this.isShowing) {
                ToggleDialog.this.hideDialog();
                ToggleDialog.this.dialogsPanel.reconstruct(DialogsPanel.Action.ELEMENT_SHRINKS, null);
            } else {
                ToggleDialog.this.showDialog();
                ToggleDialog.this.expand();
                ToggleDialog.this.dialogsPanel.reconstruct(DialogsPanel.Action.INVISIBLE_TO_DEFAULT, ToggleDialog.this);
            }
        }
    }
}

