/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.TreeSet;
import java.util.Vector;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationNodeMap {
    private HashMap<Node, TreeSet<Integer>> points;
    private HashMap<Node, Integer> nodes;
    private Vector<Integer> remaining;
    private ArrayList<RelationMember> members;

    RelationNodeMap(ArrayList<RelationMember> members) {
        this.members = members;
        this.points = new HashMap();
        this.nodes = new HashMap();
        this.remaining = new Vector();
        for (int i = 0; i < members.size(); ++i) {
            RelationMember m = members.get(i);
            if (m.getMember().incomplete) {
                this.remaining.add(i);
                continue;
            }
            this.add(i, m);
        }
    }

    Integer find(Node node, int current) {
        Integer result = null;
        try {
            result = this.nodes.get(node);
            if (result == null) {
                result = this.points.get(node).first();
                if (this.members.get(current).getMember() == this.members.get(result).getMember()) {
                    result = this.points.get(node).last();
                }
            }
        }
        catch (NullPointerException f) {
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        return result;
    }

    void add(int n, RelationMember m) {
        if (m.isWay()) {
            Way w = m.getWay();
            if (w.lastNode() == w.firstNode()) {
                this.nodes.put(w.firstNode(), n);
            } else {
                if (!this.points.containsKey(w.firstNode())) {
                    this.points.put(w.firstNode(), new TreeSet());
                }
                this.points.get(w.firstNode()).add(n);
                if (!this.points.containsKey(w.lastNode())) {
                    this.points.put(w.lastNode(), new TreeSet());
                }
                this.points.get(w.lastNode()).add(n);
            }
        } else if (m.isNode()) {
            Node node = m.getNode();
            this.nodes.put(node, n);
        } else {
            this.remaining.add(n);
        }
    }

    boolean remove(int n, RelationMember a) {
        boolean result;
        if (a.isWay()) {
            Way w = a.getWay();
            if (w.firstNode() == w.lastNode()) {
                result = this.nodes.remove(w.firstNode()) != null;
            } else {
                result = this.points.get(w.firstNode()).remove(n);
                result &= this.points.get(w.lastNode()).remove(n);
            }
        } else {
            result = this.nodes.remove(a.getMember()) != null;
        }
        return result;
    }

    void move(int from, int to) {
        if (from != to) {
            RelationMember b = this.members.get(from);
            RelationMember a = this.members.get(to);
            this.remove(to, b);
            this.add(to, a);
        }
    }

    boolean isEmpty() {
        return this.points.isEmpty() && this.nodes.isEmpty();
    }

    Vector<Integer> getRemaining() {
        return this.remaining;
    }

    Integer pop() {
        Node node = null;
        Integer result = null;
        if (!this.nodes.isEmpty()) {
            node = this.nodes.keySet().iterator().next();
            result = this.nodes.get(node);
            this.nodes.remove(node);
        } else if (!this.points.isEmpty()) {
            for (TreeSet<Integer> set : this.points.values()) {
                if (set.isEmpty()) continue;
                result = set.first();
                Way w = this.members.get(result).getWay();
                this.points.get(w.firstNode()).remove(result);
                this.points.get(w.lastNode()).remove(result);
                break;
            }
        }
        return result;
    }
}

