/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation;

import org.openstreetmap.josm.tools.I18n;

public class WayConnectionType {
    public final boolean connectedToPrevious;
    public final boolean connectedToNext;
    public final int direction;
    public final boolean invalid;

    public WayConnectionType(boolean connectedToPrevious, boolean connectedToNext, int direction) {
        this.connectedToPrevious = connectedToPrevious;
        this.connectedToNext = connectedToNext;
        this.direction = direction;
        this.invalid = false;
    }

    public WayConnectionType() {
        this.connectedToPrevious = false;
        this.connectedToNext = false;
        this.direction = 1;
        this.invalid = true;
    }

    public String getToolTip() {
        if (this.invalid) {
            return "";
        }
        if (this.connectedToPrevious && this.connectedToNext) {
            return I18n.tr("way is connected");
        }
        if (this.connectedToPrevious) {
            return I18n.tr("way is connected to previous relation member");
        }
        if (this.connectedToNext) {
            return I18n.tr("way is connected to next relation member");
        }
        return I18n.tr("way is not connected to previous or next relation member");
    }
}

