/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.download;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.openstreetmap.josm.gui.download.SizeButton;
import org.openstreetmap.josm.gui.download.SlippyMapChooser;
import org.openstreetmap.josm.gui.download.SourceButton;

public class OsmMapControl
extends MouseAdapter
implements MouseMotionListener,
MouseListener {
    private static final Timer timer = new Timer(true);
    private MoveTask moveTask = new MoveTask();
    private static long timerInterval = 20L;
    private static final double MAX_SPEED = 20.0;
    private static final double ACCELERATION = 0.1;
    private Point iStartSelectionPoint;
    private Point iEndSelectionPoint;
    private final SlippyMapChooser iSlippyMapChooser;
    private SizeButton iSizeButton = null;
    private SourceButton iSourceButton = null;

    public OsmMapControl(SlippyMapChooser navComp, JPanel contentPane, SizeButton sizeButton, SourceButton sourceButton) {
        this.iSlippyMapChooser = navComp;
        this.iSlippyMapChooser.addMouseListener(this);
        this.iSlippyMapChooser.addMouseMotionListener(this);
        String[] n = new String[]{",", ".", "up", "right", "down", "left"};
        int[] k = new int[]{44, 46, 38, 39, 40, 37};
        if (contentPane != null) {
            for (int i = 0; i < n.length; ++i) {
                contentPane.getInputMap(2).put(KeyStroke.getKeyStroke(k[i], 128), "MapMover.Zoomer." + n[i]);
            }
        }
        this.iSizeButton = sizeButton;
        this.iSourceButton = sourceButton;
        InputMap inputMap = navComp.getInputMap(2);
        ActionMap actionMap = navComp.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(39, 0, false), "MOVE_RIGHT");
        inputMap.put(KeyStroke.getKeyStroke(37, 0, false), "MOVE_LEFT");
        inputMap.put(KeyStroke.getKeyStroke(38, 0, false), "MOVE_UP");
        inputMap.put(KeyStroke.getKeyStroke(40, 0, false), "MOVE_DOWN");
        inputMap.put(KeyStroke.getKeyStroke(39, 0, true), "STOP_MOVE_HORIZONTALLY");
        inputMap.put(KeyStroke.getKeyStroke(37, 0, true), "STOP_MOVE_HORIZONTALLY");
        inputMap.put(KeyStroke.getKeyStroke(38, 0, true), "STOP_MOVE_VERTICALLY");
        inputMap.put(KeyStroke.getKeyStroke(40, 0, true), "STOP_MOVE_VERTICALLY");
        inputMap.put(KeyStroke.getKeyStroke(38, 128, false), "ZOOM_IN");
        inputMap.put(KeyStroke.getKeyStroke(38, 256, false), "ZOOM_IN");
        inputMap.put(KeyStroke.getKeyStroke(38, 512, false), "ZOOM_IN");
        inputMap.put(KeyStroke.getKeyStroke(40, 128, false), "ZOOM_OUT");
        inputMap.put(KeyStroke.getKeyStroke(40, 256, false), "ZOOM_OUT");
        inputMap.put(KeyStroke.getKeyStroke(40, 512, false), "ZOOM_OUT");
        actionMap.put("MOVE_RIGHT", new MoveXAction(1));
        actionMap.put("MOVE_LEFT", new MoveXAction(-1));
        actionMap.put("MOVE_UP", new MoveYAction(-1));
        actionMap.put("MOVE_DOWN", new MoveYAction(1));
        actionMap.put("STOP_MOVE_HORIZONTALLY", new MoveXAction(0));
        actionMap.put("STOP_MOVE_VERTICALLY", new MoveYAction(0));
        actionMap.put("ZOOM_IN", new ZoomInAction());
        actionMap.put("ZOOM_OUT", new ZoomOutAction());
    }

    public void mousePressed(MouseEvent e) {
        if (e.getButton() == 1 && !this.iSizeButton.hit(e.getPoint())) {
            this.iStartSelectionPoint = e.getPoint();
            this.iEndSelectionPoint = e.getPoint();
        }
    }

    public void mouseDragged(MouseEvent e) {
        if ((e.getModifiersEx() & 0x400) == 1024 && this.iStartSelectionPoint != null) {
            this.iEndSelectionPoint = e.getPoint();
            this.iSlippyMapChooser.setSelection(this.iStartSelectionPoint, this.iEndSelectionPoint);
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (e.getButton() == 1) {
            int sourceButton = this.iSourceButton.hit(e.getPoint());
            if (this.iSizeButton.hit(e.getPoint())) {
                this.iSizeButton.toggle();
                this.iSlippyMapChooser.resizeSlippyMap();
            } else if (sourceButton == 1) {
                this.iSourceButton.toggle();
                this.iSlippyMapChooser.repaint();
            } else if (sourceButton == 2 || sourceButton == 3 || sourceButton == 4) {
                this.iSlippyMapChooser.toggleMapSource(sourceButton);
            } else if (e.getClickCount() == 1) {
                this.iSlippyMapChooser.setSelection(this.iStartSelectionPoint, e.getPoint());
                this.iEndSelectionPoint = null;
                this.iStartSelectionPoint = null;
            }
        }
    }

    public void mouseMoved(MouseEvent e) {
    }

    private class ZoomOutAction
    extends AbstractAction {
        private ZoomOutAction() {
        }

        public void actionPerformed(ActionEvent e) {
            OsmMapControl.this.iSlippyMapChooser.zoomOut();
        }
    }

    private class ZoomInAction
    extends AbstractAction {
        private ZoomInAction() {
        }

        public void actionPerformed(ActionEvent e) {
            OsmMapControl.this.iSlippyMapChooser.zoomIn();
        }
    }

    private class MoveTask
    extends TimerTask {
        private double speedX = 1.0;
        private double speedY = 1.0;
        private int directionX = 0;
        private int directionY = 0;
        protected boolean scheduled = false;

        private MoveTask() {
        }

        protected void setDirectionX(int directionX) {
            this.directionX = directionX;
            this.updateScheduleStatus();
        }

        protected void setDirectionY(int directionY) {
            this.directionY = directionY;
            this.updateScheduleStatus();
        }

        private void updateScheduleStatus() {
            boolean newMoveTaskState;
            boolean bl = newMoveTaskState = this.directionX != 0 || this.directionY != 0;
            if (newMoveTaskState != this.scheduled) {
                this.scheduled = newMoveTaskState;
                if (newMoveTaskState) {
                    timer.schedule((TimerTask)this, 0L, timerInterval);
                } else {
                    OsmMapControl.this.moveTask = new MoveTask();
                    this.cancel();
                }
            }
        }

        public void run() {
            switch (this.directionX) {
                case -1: {
                    if (this.speedX > -1.0) {
                        this.speedX = -1.0;
                    }
                    if (!(this.speedX > -20.0)) break;
                    this.speedX -= 0.1;
                    break;
                }
                case 0: {
                    this.speedX = 0.0;
                    break;
                }
                case 1: {
                    if (this.speedX < 1.0) {
                        this.speedX = 1.0;
                    }
                    if (!(this.speedX < 20.0)) break;
                    this.speedX += 0.1;
                }
            }
            switch (this.directionY) {
                case -1: {
                    if (this.speedY > -1.0) {
                        this.speedY = -1.0;
                    }
                    if (!(this.speedY > -20.0)) break;
                    this.speedY -= 0.1;
                    break;
                }
                case 0: {
                    this.speedY = 0.0;
                    break;
                }
                case 1: {
                    if (this.speedY < 1.0) {
                        this.speedY = 1.0;
                    }
                    if (!(this.speedY < 20.0)) break;
                    this.speedY += 0.1;
                }
            }
            int moveX = (int)Math.floor(this.speedX);
            int moveY = (int)Math.floor(this.speedY);
            if (moveX != 0 || moveY != 0) {
                OsmMapControl.this.iSlippyMapChooser.moveMap(moveX, moveY);
            }
        }
    }

    private class MoveYAction
    extends AbstractAction {
        int direction;

        public MoveYAction(int direction) {
            this.direction = direction;
        }

        public void actionPerformed(ActionEvent e) {
            OsmMapControl.this.moveTask.setDirectionY(this.direction);
        }
    }

    private class MoveXAction
    extends AbstractAction {
        int direction;

        public MoveXAction(int direction) {
            this.direction = direction;
        }

        public void actionPerformed(ActionEvent e) {
            OsmMapControl.this.moveTask.setDirectionX(this.direction);
        }
    }
}

