/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.help;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Locale;
import java.util.Observable;
import java.util.Observer;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.help.HelpBrowserHistory;
import org.openstreetmap.josm.gui.help.HelpContentReader;
import org.openstreetmap.josm.gui.help.HelpContentReaderException;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.help.MissingHelpContentException;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.OpenBrowser;

public class HelpBrowser
extends JFrame {
    private static final Logger logger = Logger.getLogger(HelpBrowser.class.getName());
    private static HelpBrowser instance;
    private JEditorPane help;
    private JScrollPane spHelp;
    private HelpBrowserHistory history;
    private String url;
    private HelpContentReader reader = new HelpContentReader(HelpUtil.getWikiBaseUrl());

    public static HelpBrowser getInstance() {
        if (instance == null) {
            instance = new HelpBrowser();
        }
        return instance;
    }

    public static void launchBrowser(String helpTopic) {
        HelpBrowser browser = HelpBrowser.getInstance();
        browser.openHelpTopic(helpTopic);
        browser.setVisible(true);
        browser.toFront();
    }

    protected StyleSheet buildStyleSheet() {
        StyleSheet ss = new StyleSheet();
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("help-browser.css")));
        StringBuffer css = new StringBuffer();
        try {
            String line = null;
            while ((line = reader.readLine()) != null) {
                css.append(line);
                css.append("\n");
            }
            reader.close();
        }
        catch (Exception e) {
            System.err.println(I18n.tr("Failed to read CSS file ''help-browser.css''. Exception is: {0}", e.toString()));
            e.printStackTrace();
            return ss;
        }
        ss.addRule(css.toString());
        return ss;
    }

    protected JToolBar buildToolBar() {
        JToolBar tb = new JToolBar();
        tb.add(new JButton(new HomeAction()));
        tb.add(new JButton(new BackAction(this.history)));
        tb.add(new JButton(new ForwardAction(this.history)));
        tb.add(new JButton(new ReloadAction()));
        tb.add(new JSeparator());
        tb.add(new JButton(new OpenInBrowserAction()));
        tb.add(new JButton(new EditAction()));
        return tb;
    }

    protected void build() {
        this.help = new JEditorPane();
        HTMLEditorKit kit = new HTMLEditorKit();
        kit.setStyleSheet(this.buildStyleSheet());
        this.help.setEditorKit(kit);
        this.help.setEditable(false);
        this.help.addHyperlinkListener(new HyperlinkHandler());
        this.help.setContentType("text/html");
        this.history = new HelpBrowserHistory(this);
        JPanel p = new JPanel(new BorderLayout());
        this.setContentPane(p);
        this.spHelp = new JScrollPane(this.help);
        p.add((Component)this.spHelp, "Center");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                HelpBrowser.this.setVisible(false);
            }
        });
        p.add((Component)this.buildToolBar(), "North");
        this.help.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "Close");
        this.help.getActionMap().put("Close", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                HelpBrowser.this.setVisible(false);
            }
        });
        this.setTitle(I18n.tr("JOSM Help Browser"));
    }

    public HelpBrowser() {
        this.build();
    }

    public String getUrl() {
        return this.url;
    }

    protected void handleMissingHelpContent(String relativeHelpTopic) {
        String message = I18n.tr("<html><p class=\"warning-header\">Help content for help topic missing</p><p class=\"warning-body\">Help content for the help topic <strong>{0}</strong> is not available yet. It is missing both in your local language ({1}) and in english.<br><br>Please help to improve the JOSM help system and fill in the missing information.You can both edit the <a href=\"{2}\">help topic in your local language ({1})</a> and the <a href=\"{3}\">help topic in english</a>.</p></html>", relativeHelpTopic, Locale.getDefault().getDisplayName(), HelpUtil.getHelpTopicEditUrl(HelpUtil.buildAbsoluteHelpTopic(relativeHelpTopic)), HelpUtil.getHelpTopicEditUrl(HelpUtil.buildAbsoluteHelpTopic(relativeHelpTopic, Locale.ENGLISH)));
        this.help.setText(message);
    }

    protected void handleHelpContentReaderException(String relativeHelpTopic, HelpContentReaderException e) {
        String message = I18n.tr("<html><p class=\"error-header\">Error when retrieving help information</p><p class=\"error-body\">The content for the help topic <strong>{0}</strong> could not be loaded. The error message is (untranslated):<br><tt>{1}</tt></p></html>", relativeHelpTopic, e.toString());
        this.help.setText(message);
    }

    protected void scrollToTop() {
        JScrollBar sb = this.spHelp.getVerticalScrollBar();
        sb.setValue(sb.getMinimum());
    }

    protected void loadRelativeHelpTopic(String relativeHelpTopic) {
        String url = HelpUtil.getHelpTopicUrl(HelpUtil.buildAbsoluteHelpTopic(relativeHelpTopic));
        String content = null;
        try {
            content = this.reader.fetchHelpTopicContent(url);
        }
        catch (MissingHelpContentException e) {
            url = HelpUtil.getHelpTopicUrl(HelpUtil.buildAbsoluteHelpTopic(relativeHelpTopic, Locale.ENGLISH));
            try {
                logger.info("fetching url: " + url);
                content = this.reader.fetchHelpTopicContent(url);
            }
            catch (MissingHelpContentException e1) {
                this.handleMissingHelpContent(relativeHelpTopic);
                return;
            }
            catch (HelpContentReaderException e1) {
                e1.printStackTrace();
                this.handleHelpContentReaderException(relativeHelpTopic, e1);
                return;
            }
        }
        catch (HelpContentReaderException e) {
            e.printStackTrace();
            this.handleHelpContentReaderException(relativeHelpTopic, e);
            return;
        }
        this.help.setText(content);
        this.history.setCurrentUrl(url);
        this.url = url;
        this.scrollToTop();
    }

    protected void loadAbsoluteHelpTopic(String absoluteHelpTopic) {
        String url = HelpUtil.getHelpTopicUrl(absoluteHelpTopic);
        String content = null;
        try {
            content = this.reader.fetchHelpTopicContent(url);
        }
        catch (MissingHelpContentException e) {
            this.handleMissingHelpContent(absoluteHelpTopic);
            return;
        }
        catch (HelpContentReaderException e) {
            e.printStackTrace();
            this.handleHelpContentReaderException(absoluteHelpTopic, e);
            return;
        }
        this.help.setText(content);
        this.history.setCurrentUrl(url);
        this.url = url;
        this.scrollToTop();
    }

    public void openUrl(String url) {
        if (!this.isVisible()) {
            this.setVisible(true);
            this.toFront();
        } else {
            this.toFront();
        }
        String helpTopic = HelpUtil.extractAbsoluteHelpTopic(url);
        if (helpTopic == null) {
            try {
                this.url = url;
                this.help.setPage(url);
            }
            catch (IOException e) {
                HelpAwareOptionPane.showOptionDialog(Main.parent, I18n.tr("<html>Failed to open help page for url {0}.<br>This is most likely due to a network problem, please check your<br>your internet connection</html>", url.toString()), I18n.tr("Failed to open URL"), 0, null, null, null, null);
            }
            this.history.setCurrentUrl(url);
        } else {
            this.loadAbsoluteHelpTopic(helpTopic);
        }
    }

    public void openHelpTopic(String relativeHelpTopic) {
        if (!this.isVisible()) {
            this.setVisible(true);
            this.toFront();
        } else {
            this.toFront();
        }
        this.loadRelativeHelpTopic(relativeHelpTopic);
    }

    class HyperlinkHandler
    implements HyperlinkListener {
        HyperlinkHandler() {
        }

        protected boolean scrollToElementWithId(String id) {
            Document d = HelpBrowser.this.help.getDocument();
            if (d instanceof HTMLDocument) {
                HTMLDocument doc = (HTMLDocument)d;
                Element element = doc.getElement(id);
                try {
                    Rectangle r = HelpBrowser.this.help.modelToView(element.getStartOffset());
                    if (r != null) {
                        Rectangle vis = HelpBrowser.this.help.getVisibleRect();
                        r.height = vis.height;
                        HelpBrowser.this.help.scrollRectToVisible(r);
                        return true;
                    }
                }
                catch (BadLocationException e) {
                    System.err.println(I18n.tr("Warning: bad location in HTML document. Exception was: " + e.toString()));
                    e.printStackTrace();
                }
            }
            return false;
        }

        protected String getUrlFragment(HyperlinkEvent e) {
            AttributeSet set = e.getSourceElement().getAttributes();
            Object value = set.getAttribute(HTML.Tag.A);
            if (value == null || !(value instanceof SimpleAttributeSet)) {
                return null;
            }
            SimpleAttributeSet atts = (SimpleAttributeSet)value;
            if ((value = atts.getAttribute(HTML.Attribute.HREF)) == null) {
                return null;
            }
            String s = (String)value;
            if (s.matches("#.*")) {
                return s.substring(1);
            }
            return null;
        }

        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                return;
            }
            if (e.getURL() == null) {
                String fragment = this.getUrlFragment(e);
                if (fragment != null) {
                    if (!this.scrollToElementWithId(fragment)) {
                        HelpBrowser.this.help.scrollToReference(fragment);
                    }
                } else {
                    HelpAwareOptionPane.showOptionDialog(Main.parent, I18n.tr("Failed to open help page. The target URL is empty."), I18n.tr("Failed to open help page"), 0, null, null, null, null);
                }
            } else if (e.getURL().toString().endsWith("action=edit")) {
                OpenBrowser.displayUrl(e.getURL().toString());
            } else {
                HelpBrowser.this.url = e.getURL().toString();
                HelpBrowser.this.openUrl(e.getURL().toString());
            }
        }
    }

    class HomeAction
    extends AbstractAction {
        public HomeAction() {
            this.putValue("ShortDescription", I18n.tr("Go to the JOSM help home page"));
            this.putValue("SmallIcon", ImageProvider.get("help", "home"));
        }

        public void actionPerformed(ActionEvent e) {
            HelpBrowser.this.openHelpTopic("/");
        }
    }

    class ForwardAction
    extends AbstractAction
    implements Observer {
        private HelpBrowserHistory history;

        public ForwardAction(HelpBrowserHistory history) {
            this.history = history;
            history.addObserver(this);
            this.putValue("ShortDescription", I18n.tr("Go to the next page"));
            this.putValue("SmallIcon", ImageProvider.get("help", "next"));
            this.setEnabled(history.canGoForward());
        }

        public void actionPerformed(ActionEvent e) {
            this.history.forward();
        }

        public void update(Observable o, Object arg) {
            this.setEnabled(this.history.canGoForward());
        }
    }

    class BackAction
    extends AbstractAction
    implements Observer {
        private HelpBrowserHistory history;

        public BackAction(HelpBrowserHistory history) {
            this.history = history;
            history.addObserver(this);
            this.putValue("ShortDescription", I18n.tr("Go to the previous page"));
            this.putValue("SmallIcon", ImageProvider.get("help", "previous"));
            this.setEnabled(history.canGoBack());
        }

        public void actionPerformed(ActionEvent e) {
            this.history.back();
        }

        public void update(Observable o, Object arg) {
            System.out.println("BackAction: canGoBoack=" + this.history.canGoBack());
            this.setEnabled(this.history.canGoBack());
        }
    }

    class ReloadAction
    extends AbstractAction {
        public ReloadAction() {
            this.putValue("ShortDescription", I18n.tr("Reload the current help page"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "refresh"));
        }

        public void actionPerformed(ActionEvent e) {
            HelpBrowser.this.openUrl(HelpBrowser.this.getUrl());
        }
    }

    class EditAction
    extends AbstractAction {
        public EditAction() {
            this.putValue("ShortDescription", I18n.tr("Edit the current help page"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "edit"));
        }

        public void actionPerformed(ActionEvent e) {
            if (!HelpBrowser.this.getUrl().startsWith(HelpUtil.getWikiBaseHelpUrl())) {
                String message = I18n.tr("<html>The current URL <tt>{0}</tt><br>is an external URL. Editing is only possible for help topics<br>on the help server <tt>{1}</tt>.</html>", HelpBrowser.this.getUrl(), HelpUtil.getWikiBaseUrl());
                JOptionPane.showMessageDialog(Main.parent, message, I18n.tr("Warning"), 2);
                return;
            }
            String url = HelpBrowser.this.getUrl();
            url = url.replaceAll("#[^#]*$", "");
            OpenBrowser.displayUrl(url + "?action=edit");
        }
    }

    class OpenInBrowserAction
    extends AbstractAction {
        public OpenInBrowserAction() {
            this.putValue("ShortDescription", I18n.tr("Open the current help page in an external browser"));
            this.putValue("SmallIcon", ImageProvider.get("help", "internet"));
        }

        public void actionPerformed(ActionEvent e) {
            OpenBrowser.displayUrl(HelpBrowser.this.getUrl());
        }
    }
}

