/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.help;

import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.tools.I18n;

public class HelpBrowserProxy {
    private static HelpBrowserProxy instance;
    private Process helpBrowserProcess;
    private PrintWriter pw;

    public static HelpBrowserProxy getInstance() {
        if (instance == null) {
            instance = new HelpBrowserProxy();
        }
        return instance;
    }

    protected void launch() {
        ArrayList<String> cmdLine = new ArrayList<String>();
        String javaBin = null;
        javaBin = System.getProperty("os.name").toLowerCase().startsWith("windows") ? "javaw.exe" : "java";
        cmdLine.add(new File(new File(System.getProperty("java.home"), "bin"), javaBin).toString());
        cmdLine.add("-classpath");
        cmdLine.add(System.getProperty("java.class.path"));
        cmdLine.add("org.openstreetmap.josm.gui.help.HelpApplication");
        if (System.getProperty("josm.home") != null) {
            cmdLine.add("-Djosm.home=" + System.getProperty("josm.home"));
        }
        String[] cmds = new String[cmdLine.size()];
        cmdLine.toArray(cmds);
        try {
            this.helpBrowserProcess = Runtime.getRuntime().exec(cmds);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.helpBrowserProcess != null) {
            this.pw = new PrintWriter(new OutputStreamWriter(this.helpBrowserProcess.getOutputStream()));
        }
    }

    public void setUrlForHelpTopic(String relativeHelpTopic) {
        if (this.helpBrowserProcess == null) {
            this.launch();
        }
        if (this.helpBrowserProcess == null) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Failed to launch the external help browser"), I18n.tr("Error"), 0);
            System.err.println("Failed to launch browser");
            return;
        }
        this.pw.println("setUrlForHelpTopic " + relativeHelpTopic);
        this.pw.flush();
    }

    public void exit() {
        if (this.helpBrowserProcess == null) {
            return;
        }
        this.pw.println("exit");
        this.pw.flush();
        this.pw.close();
        this.helpBrowserProcess.destroy();
    }
}

