/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.history.History;
import org.openstreetmap.josm.gui.history.CoordinateInfoViewer;
import org.openstreetmap.josm.gui.history.HistoryBrowserModel;
import org.openstreetmap.josm.gui.history.NodeListViewer;
import org.openstreetmap.josm.gui.history.RelationMemberListViewer;
import org.openstreetmap.josm.gui.history.TagInfoViewer;
import org.openstreetmap.josm.gui.history.VersionTable;
import org.openstreetmap.josm.tools.I18n;

public class HistoryBrowser
extends JPanel {
    private HistoryBrowserModel model = new HistoryBrowserModel();
    private TagInfoViewer tagInfoViewer;
    private NodeListViewer nodeListViewer;
    private RelationMemberListViewer relationMemberListViewer;
    private CoordinateInfoViewer coordinateInfoViewer;
    private JTabbedPane tpViewers;

    protected JScrollPane embeddInScrollPane(JTable table) {
        JScrollPane pane = new JScrollPane(table);
        pane.setHorizontalScrollBarPolicy(30);
        pane.setVerticalScrollBarPolicy(20);
        return pane;
    }

    protected JPanel createVersionTablePanel() {
        JPanel pnl = new JPanel();
        pnl.setLayout(new BorderLayout());
        VersionTable tbl = new VersionTable(this.model);
        pnl.add((Component)this.embeddInScrollPane(tbl), "Center");
        return pnl;
    }

    protected JPanel createVersionComparePanel() {
        this.tpViewers = new JTabbedPane();
        this.tagInfoViewer = new TagInfoViewer(this.model);
        this.nodeListViewer = new NodeListViewer(this.model);
        this.relationMemberListViewer = new RelationMemberListViewer(this.model);
        this.coordinateInfoViewer = new CoordinateInfoViewer(this.model);
        JPanel pnl = new JPanel();
        pnl.setLayout(new BorderLayout());
        pnl.add((Component)this.tpViewers, "Center");
        return pnl;
    }

    protected void build() {
        this.setLayout(new BorderLayout());
        JPanel left = this.createVersionTablePanel();
        JPanel right = this.createVersionComparePanel();
        JSplitPane pane = new JSplitPane(1, left, right);
        this.add((Component)pane, "Center");
        pane.setOneTouchExpandable(true);
        pane.setDividerLocation(200);
        Dimension minimumSize = new Dimension(100, 50);
        left.setMinimumSize(minimumSize);
        right.setMinimumSize(minimumSize);
    }

    public HistoryBrowser() {
        this.build();
    }

    public HistoryBrowser(History history) {
        this();
        this.populate(history);
    }

    public void populate(History history) {
        this.model.setHistory(history);
        this.tpViewers.add(this.tagInfoViewer);
        this.tpViewers.setTitleAt(0, I18n.tr("Tags"));
        if (history.getEarliest().getType().equals((Object)OsmPrimitiveType.NODE)) {
            this.tpViewers.add(this.coordinateInfoViewer);
            this.tpViewers.setTitleAt(1, I18n.tr("Coordinates"));
        } else if (history.getEarliest().getType().equals((Object)OsmPrimitiveType.WAY)) {
            this.tpViewers.add(this.nodeListViewer);
            this.tpViewers.setTitleAt(1, I18n.tr("Nodes"));
        } else if (history.getEarliest().getType().equals((Object)OsmPrimitiveType.RELATION)) {
            this.tpViewers.add(this.relationMemberListViewer);
            this.tpViewers.setTitleAt(1, I18n.tr("Members"));
        }
        this.revalidate();
    }

    public History getHistory() {
        return this.model.getHistory();
    }

    public HistoryBrowserModel getModel() {
        return this.model;
    }
}

