/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.awt.Dimension;
import java.awt.Point;
import java.util.HashMap;
import java.util.Map;
import org.openstreetmap.josm.gui.history.HistoryBrowserDialog;
import org.openstreetmap.josm.tools.WindowGeometry;

public class HistoryBrowserDialogManager {
    private static HistoryBrowserDialogManager instance;
    private Map<Long, HistoryBrowserDialog> dialogs = new HashMap<Long, HistoryBrowserDialog>();

    public static HistoryBrowserDialogManager getInstance() {
        if (instance == null) {
            instance = new HistoryBrowserDialogManager();
        }
        return instance;
    }

    protected HistoryBrowserDialogManager() {
    }

    public boolean existsDialog(long id) {
        return this.dialogs.containsKey(id);
    }

    public void show(long id, HistoryBrowserDialog dialog) {
        if (this.dialogs.values().contains(dialog)) {
            this.show(id);
        } else {
            this.placeOnScreen(dialog);
            dialog.setVisible(true);
            this.dialogs.put(id, dialog);
        }
    }

    public void show(long id) {
        if (this.dialogs.keySet().contains(id)) {
            this.dialogs.get(id).toFront();
        }
    }

    protected boolean hasDialogWithCloseUpperLeftCorner(Point p) {
        for (HistoryBrowserDialog dialog : this.dialogs.values()) {
            Point corner = dialog.getLocation();
            if (p.x < corner.x - 5 || corner.x + 5 < p.x || p.y < corner.y - 5 || corner.y + 5 < p.y) continue;
            return true;
        }
        return false;
    }

    public void placeOnScreen(HistoryBrowserDialog dialog) {
        WindowGeometry geometry = WindowGeometry.centerOnScreen(new Dimension(800, 500));
        geometry.apply(dialog);
        Point p = dialog.getLocation();
        while (this.hasDialogWithCloseUpperLeftCorner(p)) {
            p.x += 20;
            p.y += 20;
        }
        dialog.setLocation(p);
    }

    public void hide(HistoryBrowserDialog dialog) {
        long id = 0L;
        for (long i : this.dialogs.keySet()) {
            if (this.dialogs.get(i) != dialog) continue;
            id = i;
            break;
        }
        if (id > 0L) {
            this.dialogs.remove(id);
        }
        dialog.setVisible(false);
        dialog.dispose();
    }
}

