/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Observable;
import java.util.logging.Logger;
import javax.swing.table.DefaultTableModel;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.history.History;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.data.osm.history.HistoryRelation;
import org.openstreetmap.josm.data.osm.history.HistoryWay;
import org.openstreetmap.josm.gui.history.PointInTimeType;
import org.openstreetmap.josm.tools.I18n;

public class HistoryBrowserModel
extends Observable {
    private static Logger logger = Logger.getLogger(HistoryBrowserModel.class.getName());
    private History history;
    private HistoryOsmPrimitive reference;
    private HistoryOsmPrimitive current;
    private VersionTableModel versionTableModel = new VersionTableModel();
    private TagTableModel currentTagTableModel = new TagTableModel(PointInTimeType.CURRENT_POINT_IN_TIME);
    private TagTableModel referenceTagTableModel = new TagTableModel(PointInTimeType.REFERENCE_POINT_IN_TIME);
    private NodeListTableModel currentNodeListTableModel = new NodeListTableModel(PointInTimeType.CURRENT_POINT_IN_TIME);
    private NodeListTableModel referenceNodeListTableModel = new NodeListTableModel(PointInTimeType.REFERENCE_POINT_IN_TIME);
    private RelationMemberTableModel currentRelationMemberTableModel = new RelationMemberTableModel(PointInTimeType.CURRENT_POINT_IN_TIME);
    private RelationMemberTableModel referenceRelationMemberTableModel = new RelationMemberTableModel(PointInTimeType.REFERENCE_POINT_IN_TIME);

    public HistoryBrowserModel() {
    }

    public HistoryBrowserModel(History history) {
        this();
        this.setHistory(history);
    }

    public History getHistory() {
        return this.history;
    }

    public void setHistory(History history) {
        this.history = history;
        if (history.getNumVersions() > 0) {
            this.current = history.getEarliest();
            this.reference = history.getEarliest();
        }
        this.initTagTableModels();
        this.fireModelChange();
    }

    protected void fireModelChange() {
        this.setChanged();
        this.notifyObservers();
        this.versionTableModel.fireTableDataChanged();
    }

    public VersionTableModel getVersionTableModel() {
        return this.versionTableModel;
    }

    protected void initTagTableModels() {
        this.currentTagTableModel.initKeyList();
        this.referenceTagTableModel.initKeyList();
    }

    protected void initNodeListTabeModels() {
        this.currentNodeListTableModel.fireTableDataChanged();
        this.referenceNodeListTableModel.fireTableDataChanged();
    }

    protected void initMemberListTableModels() {
        this.currentRelationMemberTableModel.fireTableDataChanged();
        this.referenceRelationMemberTableModel.fireTableDataChanged();
    }

    public TagTableModel getTagTableModel(PointInTimeType pointInTimeType) throws IllegalArgumentException {
        if (pointInTimeType == null) {
            throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' must not be null.", "pointInTimeType"));
        }
        if (pointInTimeType.equals((Object)PointInTimeType.CURRENT_POINT_IN_TIME)) {
            return this.currentTagTableModel;
        }
        if (pointInTimeType.equals((Object)PointInTimeType.REFERENCE_POINT_IN_TIME)) {
            return this.referenceTagTableModel;
        }
        return null;
    }

    public NodeListTableModel getNodeListTableModel(PointInTimeType pointInTimeType) throws IllegalArgumentException {
        if (pointInTimeType == null) {
            throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' must not be null.", "pointInTimeType"));
        }
        if (pointInTimeType.equals((Object)PointInTimeType.CURRENT_POINT_IN_TIME)) {
            return this.currentNodeListTableModel;
        }
        if (pointInTimeType.equals((Object)PointInTimeType.REFERENCE_POINT_IN_TIME)) {
            return this.referenceNodeListTableModel;
        }
        return null;
    }

    public RelationMemberTableModel getRelationMemberTableModel(PointInTimeType pointInTimeType) throws IllegalArgumentException {
        if (pointInTimeType == null) {
            throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' must not be null.", "pointInTimeType"));
        }
        if (pointInTimeType.equals((Object)PointInTimeType.CURRENT_POINT_IN_TIME)) {
            return this.currentRelationMemberTableModel;
        }
        if (pointInTimeType.equals((Object)PointInTimeType.REFERENCE_POINT_IN_TIME)) {
            return this.referenceRelationMemberTableModel;
        }
        return null;
    }

    public void setReferencePointInTime(HistoryOsmPrimitive reference) throws IllegalArgumentException, IllegalStateException {
        if (reference == null) {
            throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' must not be null.", "reference"));
        }
        if (this.history == null) {
            throw new IllegalStateException(I18n.tr("History not initialized yet. Failed to set reference primitive."));
        }
        if (reference.getId() != this.history.getId()) {
            throw new IllegalArgumentException(I18n.tr("Failed to set reference. Reference ID {0} does not match history ID {1}.", reference.getId(), this.history.getId()));
        }
        HistoryOsmPrimitive primitive = this.history.getByVersion(reference.getVersion());
        if (primitive == null) {
            throw new IllegalArgumentException(I18n.tr("Failed to set reference. Reference version {0} not available in history.", reference.getVersion()));
        }
        this.reference = reference;
        this.initTagTableModels();
        this.initNodeListTabeModels();
        this.initMemberListTableModels();
        this.setChanged();
        this.notifyObservers();
    }

    public void setCurrentPointInTime(HistoryOsmPrimitive current) throws IllegalArgumentException, IllegalStateException {
        if (current == null) {
            throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' must not be null.", "current"));
        }
        if (this.history == null) {
            throw new IllegalStateException(I18n.tr("History not initialized yet. Failed to set current primitive."));
        }
        if (current.getId() != this.history.getId()) {
            throw new IllegalArgumentException(I18n.tr("Failed to set reference. Reference ID {0} does not match history ID {1}.", current.getId(), this.history.getId()));
        }
        HistoryOsmPrimitive primitive = this.history.getByVersion(current.getVersion());
        if (primitive == null) {
            throw new IllegalArgumentException(I18n.tr("Failed to set current primitive. Current version {0} not available in history.", current.getVersion()));
        }
        this.current = current;
        this.initTagTableModels();
        this.initNodeListTabeModels();
        this.initMemberListTableModels();
        this.setChanged();
        this.notifyObservers();
    }

    public HistoryOsmPrimitive getCurrentPointInTime() {
        return this.getPointInTime(PointInTimeType.CURRENT_POINT_IN_TIME);
    }

    public HistoryOsmPrimitive getReferencePointInTime() {
        return this.getPointInTime(PointInTimeType.REFERENCE_POINT_IN_TIME);
    }

    public HistoryOsmPrimitive getPointInTime(PointInTimeType type) throws IllegalArgumentException {
        if (type == null) {
            throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' must not be null.", "type"));
        }
        if (type.equals((Object)PointInTimeType.CURRENT_POINT_IN_TIME)) {
            return this.current;
        }
        if (type.equals((Object)PointInTimeType.REFERENCE_POINT_IN_TIME)) {
            return this.reference;
        }
        return null;
    }

    public class RelationMemberTableModel
    extends DefaultTableModel {
        private PointInTimeType pointInTimeType;

        private RelationMemberTableModel(PointInTimeType pointInTimeType) {
            this.pointInTimeType = pointInTimeType;
        }

        public int getRowCount() {
            int n = 0;
            if (HistoryBrowserModel.this.current != null && HistoryBrowserModel.this.current.getType().equals((Object)OsmPrimitiveType.RELATION)) {
                n = ((HistoryRelation)HistoryBrowserModel.this.current).getNumMembers();
            }
            if (HistoryBrowserModel.this.reference != null && HistoryBrowserModel.this.reference.getType().equals((Object)OsmPrimitiveType.RELATION)) {
                n = Math.max(n, ((HistoryRelation)HistoryBrowserModel.this.reference).getNumMembers());
            }
            return n;
        }

        protected HistoryRelation getRelation() {
            if (this.pointInTimeType.equals((Object)PointInTimeType.CURRENT_POINT_IN_TIME)) {
                if (!HistoryBrowserModel.this.current.getType().equals((Object)OsmPrimitiveType.RELATION)) {
                    return null;
                }
                return (HistoryRelation)HistoryBrowserModel.this.current;
            }
            if (this.pointInTimeType.equals((Object)PointInTimeType.REFERENCE_POINT_IN_TIME)) {
                if (!HistoryBrowserModel.this.reference.getType().equals((Object)OsmPrimitiveType.RELATION)) {
                    return null;
                }
                return (HistoryRelation)HistoryBrowserModel.this.reference;
            }
            return null;
        }

        protected HistoryRelation getOppositeRelation() {
            PointInTimeType opposite = this.pointInTimeType.opposite();
            if (opposite.equals((Object)PointInTimeType.CURRENT_POINT_IN_TIME)) {
                if (!HistoryBrowserModel.this.current.getType().equals((Object)OsmPrimitiveType.RELATION)) {
                    return null;
                }
                return (HistoryRelation)HistoryBrowserModel.this.current;
            }
            if (opposite.equals((Object)PointInTimeType.REFERENCE_POINT_IN_TIME)) {
                if (!HistoryBrowserModel.this.reference.getType().equals((Object)OsmPrimitiveType.RELATION)) {
                    return null;
                }
                return (HistoryRelation)HistoryBrowserModel.this.reference;
            }
            return null;
        }

        public Object getValueAt(int row, int column) {
            HistoryRelation relation = this.getRelation();
            if (relation == null) {
                return null;
            }
            if (row >= relation.getNumMembers()) {
                return null;
            }
            return relation.getMembers().get(row);
        }

        public boolean isCellEditable(int row, int column) {
            return false;
        }

        public boolean isSameInOppositeWay(int row) {
            HistoryRelation thisRelation = this.getRelation();
            HistoryRelation oppositeRelation = this.getOppositeRelation();
            if (thisRelation == null || oppositeRelation == null) {
                return false;
            }
            if (row >= oppositeRelation.getNumMembers()) {
                return false;
            }
            return thisRelation.getMembers().get(row).getPrimitiveId() == oppositeRelation.getMembers().get(row).getPrimitiveId() && thisRelation.getMembers().get(row).getRole().equals(oppositeRelation.getMembers().get(row).getRole());
        }

        public boolean isInOppositeWay(int row) {
            HistoryRelation thisRelation = this.getRelation();
            HistoryRelation oppositeRelation = this.getOppositeRelation();
            if (thisRelation == null || oppositeRelation == null) {
                return false;
            }
            return oppositeRelation.getMembers().contains(thisRelation.getMembers().get(row));
        }
    }

    public class NodeListTableModel
    extends DefaultTableModel {
        private PointInTimeType pointInTimeType;

        private NodeListTableModel(PointInTimeType pointInTimeType) {
            this.pointInTimeType = pointInTimeType;
        }

        public int getRowCount() {
            int n = 0;
            if (HistoryBrowserModel.this.current != null && HistoryBrowserModel.this.current.getType().equals((Object)OsmPrimitiveType.WAY)) {
                n = ((HistoryWay)HistoryBrowserModel.this.current).getNumNodes();
            }
            if (HistoryBrowserModel.this.reference != null && HistoryBrowserModel.this.reference.getType().equals((Object)OsmPrimitiveType.WAY)) {
                n = Math.max(n, ((HistoryWay)HistoryBrowserModel.this.reference).getNumNodes());
            }
            return n;
        }

        protected HistoryWay getWay() {
            if (this.pointInTimeType.equals((Object)PointInTimeType.CURRENT_POINT_IN_TIME)) {
                if (!HistoryBrowserModel.this.current.getType().equals((Object)OsmPrimitiveType.WAY)) {
                    return null;
                }
                return (HistoryWay)HistoryBrowserModel.this.current;
            }
            if (this.pointInTimeType.equals((Object)PointInTimeType.REFERENCE_POINT_IN_TIME)) {
                if (!HistoryBrowserModel.this.reference.getType().equals((Object)OsmPrimitiveType.WAY)) {
                    return null;
                }
                return (HistoryWay)HistoryBrowserModel.this.reference;
            }
            return null;
        }

        protected HistoryWay getOppositeWay() {
            PointInTimeType opposite = this.pointInTimeType.opposite();
            if (opposite.equals((Object)PointInTimeType.CURRENT_POINT_IN_TIME)) {
                if (!HistoryBrowserModel.this.current.getType().equals((Object)OsmPrimitiveType.WAY)) {
                    return null;
                }
                return (HistoryWay)HistoryBrowserModel.this.current;
            }
            if (opposite.equals((Object)PointInTimeType.REFERENCE_POINT_IN_TIME)) {
                if (!HistoryBrowserModel.this.reference.getType().equals((Object)OsmPrimitiveType.WAY)) {
                    return null;
                }
                return (HistoryWay)HistoryBrowserModel.this.reference;
            }
            return null;
        }

        public Object getValueAt(int row, int column) {
            HistoryWay way = this.getWay();
            if (way == null) {
                return null;
            }
            if (row >= way.getNumNodes()) {
                return null;
            }
            return way.getNodes().get(row);
        }

        public boolean isCellEditable(int row, int column) {
            return false;
        }

        public boolean isSameInOppositeWay(int row) {
            HistoryWay thisWay = this.getWay();
            HistoryWay oppositeWay = this.getOppositeWay();
            if (thisWay == null || oppositeWay == null) {
                return false;
            }
            if (row >= oppositeWay.getNumNodes()) {
                return false;
            }
            return thisWay.getNodeId(row) == oppositeWay.getNodeId(row);
        }

        public boolean isInOppositeWay(int row) {
            HistoryWay thisWay = this.getWay();
            HistoryWay oppositeWay = this.getOppositeWay();
            if (thisWay == null || oppositeWay == null) {
                return false;
            }
            return oppositeWay.getNodes().contains(thisWay.getNodeId(row));
        }
    }

    public class TagTableModel
    extends DefaultTableModel {
        private ArrayList<String> keys;
        private PointInTimeType pointInTimeType;

        protected void initKeyList() {
            HashSet<String> keySet = new HashSet<String>();
            if (HistoryBrowserModel.this.current != null) {
                keySet.addAll(HistoryBrowserModel.this.current.getTags().keySet());
            }
            if (HistoryBrowserModel.this.reference != null) {
                keySet.addAll(HistoryBrowserModel.this.reference.getTags().keySet());
            }
            this.keys = new ArrayList(keySet);
            Collections.sort(this.keys);
            this.fireTableDataChanged();
        }

        protected TagTableModel(PointInTimeType type) {
            this.pointInTimeType = type;
            this.initKeyList();
        }

        public int getRowCount() {
            if (this.keys == null) {
                return 0;
            }
            return this.keys.size();
        }

        public Object getValueAt(int row, int column) {
            return this.keys.get(row);
        }

        public boolean isCellEditable(int row, int column) {
            return false;
        }

        public boolean hasTag(String key) {
            HistoryOsmPrimitive primitive = HistoryBrowserModel.this.getPointInTime(this.pointInTimeType);
            if (primitive == null) {
                return false;
            }
            return primitive.hasTag(key);
        }

        public String getValue(String key) {
            HistoryOsmPrimitive primitive = HistoryBrowserModel.this.getPointInTime(this.pointInTimeType);
            if (primitive == null) {
                return null;
            }
            return primitive.get(key);
        }

        public boolean oppositeHasTag(String key) {
            PointInTimeType opposite = this.pointInTimeType.opposite();
            HistoryOsmPrimitive primitive = HistoryBrowserModel.this.getPointInTime(opposite);
            if (primitive == null) {
                return false;
            }
            return primitive.hasTag(key);
        }

        public String getOppositeValue(String key) {
            PointInTimeType opposite = this.pointInTimeType.opposite();
            HistoryOsmPrimitive primitive = HistoryBrowserModel.this.getPointInTime(opposite);
            if (primitive == null) {
                return null;
            }
            return primitive.get(key);
        }

        public boolean hasSameValueAsOpposite(String key) {
            String value = this.getValue(key);
            String oppositeValue = this.getOppositeValue(key);
            if (value == null || oppositeValue == null) {
                return false;
            }
            return value.equals(oppositeValue);
        }

        public PointInTimeType getPointInTimeType() {
            return this.pointInTimeType;
        }

        public boolean isCurrentPointInTime() {
            return this.pointInTimeType.equals((Object)PointInTimeType.CURRENT_POINT_IN_TIME);
        }

        public boolean isReferencePointInTime() {
            return this.pointInTimeType.equals((Object)PointInTimeType.REFERENCE_POINT_IN_TIME);
        }
    }

    public class VersionTableModel
    extends DefaultTableModel {
        private VersionTableModel() {
        }

        public int getRowCount() {
            if (HistoryBrowserModel.this.history == null) {
                return 0;
            }
            return HistoryBrowserModel.this.history.getNumVersions();
        }

        public Object getValueAt(int row, int column) {
            if (HistoryBrowserModel.this.history == null) {
                return null;
            }
            return HistoryBrowserModel.this.history.get(row);
        }

        public boolean isCellEditable(int row, int column) {
            return false;
        }

        public void setReferencePointInTime(int row) {
            if (HistoryBrowserModel.this.history == null) {
                return;
            }
            if (row < 0 || row > HistoryBrowserModel.this.history.getNumVersions()) {
                return;
            }
            HistoryOsmPrimitive reference = HistoryBrowserModel.this.history.get(row);
            HistoryBrowserModel.this.setReferencePointInTime(reference);
        }

        public void setCurrentPointInTime(int row) {
            if (HistoryBrowserModel.this.history == null) {
                return;
            }
            if (row < 0 || row > HistoryBrowserModel.this.history.getNumVersions()) {
                return;
            }
            HistoryOsmPrimitive current = HistoryBrowserModel.this.history.get(row);
            HistoryBrowserModel.this.setCurrentPointInTime(current);
        }

        public boolean isReferencePointInTime(int row) {
            if (HistoryBrowserModel.this.history == null) {
                return false;
            }
            if (row < 0 || row > HistoryBrowserModel.this.history.getNumVersions()) {
                return false;
            }
            HistoryOsmPrimitive p = HistoryBrowserModel.this.history.get(row);
            return p.equals(HistoryBrowserModel.this.reference);
        }

        public HistoryOsmPrimitive getPrimitive(int row) {
            return HistoryBrowserModel.this.history.get(row);
        }
    }
}

