/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.io.IOException;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.UserInfo;
import org.openstreetmap.josm.gui.ExceptionDialogUtil;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.io.UploadDialog;
import org.openstreetmap.josm.io.ChangesetQuery;
import org.openstreetmap.josm.io.OsmServerChangesetReader;
import org.openstreetmap.josm.io.OsmServerUserInfoReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

public class DownloadOpenChangesetsTask
extends PleaseWaitRunnable {
    private boolean cancelled;
    private OsmServerChangesetReader reader;
    private List<Changeset> changesets;
    private UploadDialog.OpenChangesetModel model;
    private Exception lastException;
    private UserInfo userInfo;

    public DownloadOpenChangesetsTask(UploadDialog.OpenChangesetModel model) {
        super(I18n.tr("Downloading open changesets ...", false));
        this.model = model;
    }

    protected void cancel() {
        this.cancelled = true;
        this.reader.cancel();
    }

    protected void finish() {
        if (this.cancelled) {
            return;
        }
        if (this.lastException != null) {
            ExceptionDialogUtil.explainException(this.lastException);
            return;
        }
        if (this.changesets.isEmpty()) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("There are no open changesets"), I18n.tr("No open changesets"), 1);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DownloadOpenChangesetsTask.this.model.setChangesets(DownloadOpenChangesetsTask.this.changesets);
            }
        });
    }

    protected UserInfo fetchUserInfo() throws OsmTransferException {
        OsmServerUserInfoReader reader = new OsmServerUserInfoReader();
        return reader.fetchUserInfo(this.getProgressMonitor().createSubTaskMonitor(1, false));
    }

    protected void realRun() throws SAXException, IOException, OsmTransferException {
        try {
            if (this.model.getUserId() == 0L) {
                this.userInfo = this.fetchUserInfo();
                this.model.setUserId(this.userInfo.getId());
            }
            if (this.cancelled) {
                return;
            }
            this.reader = new OsmServerChangesetReader();
            ChangesetQuery query = new ChangesetQuery().forUser(this.model.getUserId()).beingOpen();
            this.changesets = this.reader.queryChangesets(query, this.getProgressMonitor().createSubTaskMonitor(1, false));
        }
        catch (Exception e) {
            if (this.cancelled) {
                return;
            }
            this.lastException = e;
        }
    }

    public boolean isCancelled() {
        return this.cancelled;
    }
}

