/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.OsmPrimitivRenderer;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.help.ContextSensitiveHelpAction;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.io.ChangesetCellRenderer;
import org.openstreetmap.josm.gui.io.CloseChangesetTask;
import org.openstreetmap.josm.gui.io.DownloadOpenChangesetsTask;
import org.openstreetmap.josm.gui.tagging.TagEditorModel;
import org.openstreetmap.josm.gui.tagging.TagEditorPanel;
import org.openstreetmap.josm.gui.tagging.TagModel;
import org.openstreetmap.josm.gui.widgets.HistoryComboBox;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.WindowGeometry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UploadDialog
extends JDialog {
    public static final String HISTORY_KEY = "upload.comment.history";
    private static UploadDialog uploadDialog;
    private PrimitiveList lstAdd;
    private JLabel lblAdd;
    private JScrollPane spAdd;
    private PrimitiveList lstUpdate;
    private JLabel lblUpdate;
    private JScrollPane spUpdate;
    private PrimitiveList lstDelete;
    private JLabel lblDelete;
    private JScrollPane spDelete;
    private JPanel pnlLists;
    private TagEditorPanel tagEditorPanel;
    private JTabbedPane southTabbedPane;
    private JButton btnUpload;
    private ChangesetSelectionPanel pnlChangesetSelection;
    private boolean canceled = false;

    public static UploadDialog getUploadDialog() {
        if (uploadDialog == null) {
            uploadDialog = new UploadDialog();
        }
        return uploadDialog;
    }

    protected JPanel buildListsPanel() {
        this.pnlLists = new JPanel();
        this.pnlLists.setLayout(new GridBagLayout());
        return this.pnlLists;
    }

    protected JPanel buildContentPanel() {
        JPanel pnl = new JPanel();
        pnl.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        pnl.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.fill = 1;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        pnl.add((Component)this.buildListsPanel(), gc);
        this.southTabbedPane = new JTabbedPane();
        this.southTabbedPane.add(new JPanel());
        this.tagEditorPanel = new TagEditorPanel();
        this.southTabbedPane.add(this.tagEditorPanel);
        this.pnlChangesetSelection = new ChangesetSelectionPanel();
        this.southTabbedPane.setComponentAt(0, this.pnlChangesetSelection);
        this.southTabbedPane.setTitleAt(0, I18n.tr("Settings"));
        this.southTabbedPane.setToolTipTextAt(0, I18n.tr("Decide how to upload the data and which changeset to use"));
        this.southTabbedPane.setTitleAt(1, I18n.tr("Tags of new changeset"));
        this.southTabbedPane.setToolTipTextAt(1, I18n.tr("Apply tags to the changeset data is uploaded to"));
        this.southTabbedPane.addChangeListener(new TabbedPaneChangeLister());
        JPanel pnl1 = new JPanel();
        pnl1.setLayout(new BorderLayout());
        pnl1.add((Component)this.southTabbedPane, "Center");
        gc.fill = 2;
        gc.gridy = 1;
        gc.weightx = 1.0;
        gc.weighty = 0.0;
        pnl.add((Component)pnl1, gc);
        return pnl;
    }

    protected JPanel buildActionPanel() {
        JPanel pnl = new JPanel();
        pnl.setLayout(new FlowLayout(1));
        pnl.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        UploadAction uploadAction = new UploadAction();
        this.btnUpload = new SideButton(uploadAction);
        pnl.add(this.btnUpload);
        this.btnUpload.setFocusable(true);
        InputMap inputMap = this.btnUpload.getInputMap();
        inputMap.put(KeyStroke.getKeyStroke(10, 0), "doUpload");
        this.btnUpload.getActionMap().put("doUpload", uploadAction);
        CancelAction cancelAction = new CancelAction();
        pnl.add(new SideButton(cancelAction));
        this.getRootPane().registerKeyboardAction(cancelAction, KeyStroke.getKeyStroke(27, 0), 2);
        pnl.add(new SideButton(new ContextSensitiveHelpAction("/Dialogs/UploadDialog")));
        HelpUtil.setHelpContext(this.getRootPane(), "/Dialogs/UploadDialog");
        return pnl;
    }

    protected void build() {
        this.setTitle(I18n.tr("Upload"));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.buildContentPanel(), "Center");
        this.getContentPane().add((Component)this.buildActionPanel(), "South");
        this.addWindowListener(new WindowEventHandler());
    }

    public UploadDialog() {
        super(JOptionPane.getFrameForComponent(Main.parent), true);
        OsmPrimitivRenderer renderer = new OsmPrimitivRenderer();
        this.lstAdd = new PrimitiveList();
        this.lstAdd.setCellRenderer(renderer);
        this.lstAdd.setVisibleRowCount(Math.min(this.lstAdd.getModel().getSize(), 10));
        this.spAdd = new JScrollPane(this.lstAdd);
        this.lblAdd = new JLabel(I18n.tr("Objects to add:"));
        this.lstUpdate = new PrimitiveList();
        this.lstUpdate.setCellRenderer(renderer);
        this.lstUpdate.setVisibleRowCount(Math.min(this.lstUpdate.getModel().getSize(), 10));
        this.spUpdate = new JScrollPane(this.lstUpdate);
        this.lblUpdate = new JLabel(I18n.tr("Objects to modify:"));
        this.lstDelete = new PrimitiveList();
        this.lstDelete.setCellRenderer(renderer);
        this.lstDelete.setVisibleRowCount(Math.min(this.lstDelete.getModel().getSize(), 10));
        this.spDelete = new JScrollPane(this.lstDelete);
        this.lblDelete = new JLabel(I18n.tr("Objects to delete:"));
        this.build();
    }

    public void setUploadedPrimitives(List<OsmPrimitive> add, List<OsmPrimitive> update, List<OsmPrimitive> delete) {
        this.lstAdd.getPrimitiveListModel().setPrimitives(add);
        this.lstUpdate.getPrimitiveListModel().setPrimitives(update);
        this.lstDelete.getPrimitiveListModel().setPrimitives(delete);
        GridBagConstraints gcLabel = new GridBagConstraints();
        gcLabel.fill = 2;
        gcLabel.weightx = 1.0;
        gcLabel.weighty = 0.0;
        gcLabel.anchor = 23;
        GridBagConstraints gcList = new GridBagConstraints();
        gcList.fill = 1;
        gcList.weightx = 1.0;
        gcList.weighty = 1.0;
        gcList.anchor = 10;
        this.pnlLists.removeAll();
        int y = -1;
        if (!add.isEmpty()) {
            ++y;
            gcLabel.gridy = y++;
            this.lblAdd.setText(I18n.trn("{0} object to add:", "{0} objects to add:", add.size(), add.size()));
            this.pnlLists.add((Component)this.lblAdd, gcLabel);
            gcList.gridy = y;
            this.pnlLists.add((Component)this.spAdd, gcList);
        }
        if (!update.isEmpty()) {
            ++y;
            gcLabel.gridy = y++;
            this.lblUpdate.setText(I18n.trn("{0} object to modifiy:", "{0} objects to modify:", update.size(), update.size()));
            this.pnlLists.add((Component)this.lblUpdate, gcLabel);
            gcList.gridy = y;
            this.pnlLists.add((Component)this.spUpdate, gcList);
        }
        if (!delete.isEmpty()) {
            ++y;
            gcLabel.gridy = y++;
            this.lblDelete.setText(I18n.trn("{0} object to delete:", "{0} objects to delete:", delete.size(), delete.size()));
            this.pnlLists.add((Component)this.lblDelete, gcLabel);
            gcList.gridy = y;
            this.pnlLists.add((Component)this.spDelete, gcList);
        }
    }

    public void rememberUserInput() {
        this.pnlChangesetSelection.rememberUserInput();
    }

    public void startUserInput() {
        this.tagEditorPanel.initAutoCompletion(Main.main.getEditLayer());
        this.pnlChangesetSelection.startUserInput();
    }

    public Changeset getChangeset() {
        Changeset cs = this.pnlChangesetSelection.getChangeset();
        this.tagEditorPanel.getModel().applyToPrimitive(cs);
        cs.put("comment", this.getUploadComment());
        return cs;
    }

    public void setOrUpdateChangeset(Changeset cs) {
        this.pnlChangesetSelection.setOrUpdateChangeset(cs);
    }

    public boolean isDoCloseAfterUpload() {
        return this.pnlChangesetSelection.isCloseAfterUpload();
    }

    protected String getDefaultCreatedBy() {
        Object ua = System.getProperties().get("http.agent");
        return ua == null ? "JOSM" : ua.toString();
    }

    protected String getUploadComment() {
        switch (this.southTabbedPane.getSelectedIndex()) {
            case 0: {
                return this.pnlChangesetSelection.getUploadComment();
            }
            case 1: {
                TagModel tm = this.tagEditorPanel.getModel().get("comment");
                return tm == null ? "" : tm.getValue();
            }
        }
        return "";
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    protected void setCanceled(boolean canceled) {
        this.canceled = canceled;
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            new WindowGeometry(this.getClass().getName() + ".geometry", WindowGeometry.centerInWindow(Main.parent, new Dimension(400, 600))).apply(this);
        } else if (!visible && this.isShowing()) {
            new WindowGeometry(this).remember(this.getClass().getName() + ".geometry");
        }
        super.setVisible(visible);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class OpenChangesetModel
    extends DefaultComboBoxModel {
        private List<Changeset> changesets = new ArrayList<Changeset>();
        private long uid;
        private Changeset selectedChangeset = null;

        protected Changeset getChangesetById(long id) {
            for (Changeset cs : this.changesets) {
                if (cs.getId() != id) continue;
                return cs;
            }
            return null;
        }

        protected void internalAddOrUpdate(Changeset cs) {
            Changeset other = this.getChangesetById(cs.getId());
            if (other != null) {
                cs.cloneFrom(other);
            } else {
                this.changesets.add(cs);
            }
        }

        public void addOrUpdate(Changeset cs) {
            if (cs.getId() <= 0L) {
                throw new IllegalArgumentException(I18n.tr("Changeset ID > 0 expected. Got {0}.", cs.getId()));
            }
            this.internalAddOrUpdate(cs);
            this.fireContentsChanged(this, 0, this.getSize());
        }

        public void remove(long id) {
            Changeset cs = this.getChangesetById(id);
            if (cs != null) {
                this.changesets.remove(cs);
            }
            this.fireContentsChanged(this, 0, this.getSize());
        }

        public void setChangesets(Collection<Changeset> changesets) {
            this.changesets.clear();
            if (changesets != null) {
                for (Changeset cs : changesets) {
                    this.internalAddOrUpdate(cs);
                }
            }
            this.fireContentsChanged(this, 0, this.getSize());
            if (this.getSelectedItem() == null && !this.changesets.isEmpty()) {
                this.setSelectedItem(this.changesets.get(0));
            } else if (this.getSelectedItem() != null) {
                if (changesets.contains(this.getSelectedItem())) {
                    this.setSelectedItem(this.getSelectedItem());
                } else if (!this.changesets.isEmpty()) {
                    this.setSelectedItem(this.changesets.get(0));
                } else {
                    this.setSelectedItem(null);
                }
            } else {
                this.setSelectedItem(null);
            }
        }

        public void setUserId(long uid) {
            this.uid = uid;
        }

        public long getUserId() {
            return this.uid;
        }

        public void selectFirstChangeset() {
            if (this.changesets == null || this.changesets.isEmpty()) {
                return;
            }
            this.setSelectedItem(this.changesets.get(0));
        }

        public void removeChangeset(Changeset cs) {
            if (cs == null) {
                return;
            }
            this.changesets.remove(cs);
            if (this.selectedChangeset == cs) {
                this.selectFirstChangeset();
            }
            this.fireContentsChanged(this, 0, this.getSize());
        }

        @Override
        public Object getElementAt(int index) {
            return this.changesets.get(index);
        }

        @Override
        public int getIndexOf(Object anObject) {
            return this.changesets.indexOf(anObject);
        }

        @Override
        public int getSize() {
            return this.changesets.size();
        }

        @Override
        public Object getSelectedItem() {
            return this.selectedChangeset;
        }

        @Override
        public void setSelectedItem(Object anObject) {
            if (anObject == null) {
                this.selectedChangeset = null;
                super.setSelectedItem(null);
                return;
            }
            if (!(anObject instanceof Changeset)) {
                return;
            }
            Changeset cs = (Changeset)anObject;
            if (cs.getId() == 0L || !cs.isOpen()) {
                return;
            }
            Changeset candidate = this.getChangesetById(cs.getId());
            if (candidate == null) {
                return;
            }
            this.selectedChangeset = candidate;
            super.setSelectedItem(this.selectedChangeset);
        }
    }

    class ChangesetSelectionPanel
    extends JPanel
    implements ListDataListener {
        private ButtonGroup bgUseNewOrExisting;
        private JRadioButton rbUseNew;
        private JRadioButton rbExisting;
        private JComboBox cbOpenChangesets;
        private JButton btnRefresh;
        private JButton btnClose;
        private JCheckBox cbCloseAfterUpload;
        private OpenChangesetModel model;
        private HistoryComboBox cmt;
        private JCheckBox cbUseAtomicUpload;

        protected JPanel buildAtomicUploadControlPanel() {
            JPanel pnl = new JPanel();
            pnl.setLayout(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.fill = 2;
            gc.weightx = 1.0;
            gc.anchor = 23;
            this.cbUseAtomicUpload = new JCheckBox(I18n.tr("Upload all changes in one request"));
            pnl.add((Component)this.cbUseAtomicUpload, gc);
            this.cbUseAtomicUpload.setToolTipText(I18n.tr("Enable to upload all changes in one request, disable to use one request per changed primitive"));
            boolean useAtomicUpload = Main.pref.getBoolean("osm-server.atomic-upload", true);
            this.cbUseAtomicUpload.setSelected(useAtomicUpload);
            this.cbUseAtomicUpload.setEnabled(OsmApi.getOsmApi().hasSupportForDiffUploads());
            return pnl;
        }

        protected JPanel buildUploadCommentPanel() {
            JPanel pnl = new JPanel();
            pnl.setLayout(new GridBagLayout());
            pnl.add((Component)new JLabel(I18n.tr("Provide a brief comment for the changes you are uploading:")), GBC.eol().insets(0, 5, 10, 3));
            this.cmt = new HistoryComboBox();
            this.cmt.setToolTipText(I18n.tr("Enter an upload comment (min. 3 characters)"));
            LinkedList<String> cmtHistory = new LinkedList<String>(Main.pref.getCollection(UploadDialog.HISTORY_KEY, new LinkedList<String>()));
            Collections.reverse(cmtHistory);
            this.cmt.setPossibleItems(cmtHistory);
            this.cmt.getEditor().addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    TagModel tm = UploadDialog.this.tagEditorPanel.getModel().get("comment");
                    if (tm == null) {
                        UploadDialog.this.tagEditorPanel.getModel().add(new TagModel("comment", ChangesetSelectionPanel.this.cmt.getText()));
                    } else {
                        tm.setValue(ChangesetSelectionPanel.this.cmt.getText());
                    }
                    UploadDialog.this.tagEditorPanel.getModel().fireTableDataChanged();
                }
            });
            this.cmt.getEditor().addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    UploadDialog.this.btnUpload.requestFocusInWindow();
                }
            });
            pnl.add((Component)this.cmt, GBC.eol().fill(2));
            return pnl;
        }

        protected void build() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            this.bgUseNewOrExisting = new ButtonGroup();
            gc.gridwidth = 4;
            gc.gridy = 0;
            gc.fill = 2;
            gc.weightx = 1.0;
            gc.anchor = 23;
            this.add((Component)this.buildAtomicUploadControlPanel(), gc);
            gc.gridwidth = 4;
            gc.gridy = 1;
            gc.fill = 2;
            gc.weightx = 1.0;
            gc.anchor = 23;
            this.add((Component)this.buildUploadCommentPanel(), gc);
            gc.gridwidth = 4;
            gc.gridy = 2;
            gc.fill = 2;
            gc.weightx = 0.0;
            gc.anchor = 23;
            this.rbUseNew = new JRadioButton(I18n.tr("Open a new changeset"));
            this.rbUseNew.setToolTipText(I18n.tr("Open a new changeset and use it in the next upload"));
            this.bgUseNewOrExisting.add(this.rbUseNew);
            this.add((Component)this.rbUseNew, gc);
            gc.gridx = 0;
            gc.gridy = 3;
            gc.gridwidth = 1;
            this.rbExisting = new JRadioButton(I18n.tr("Use an open changeset"));
            this.rbExisting.setToolTipText(I18n.tr("Upload data to an already opened changeset"));
            this.bgUseNewOrExisting.add(this.rbExisting);
            this.add((Component)this.rbExisting, gc);
            gc.gridx = 1;
            gc.gridy = 3;
            gc.gridwidth = 1;
            gc.weightx = 1.0;
            this.model = new OpenChangesetModel();
            this.cbOpenChangesets = new JComboBox(this.model);
            this.cbOpenChangesets.setToolTipText("Select an open changeset");
            this.cbOpenChangesets.setRenderer(new ChangesetCellRenderer());
            this.cbOpenChangesets.addItemListener(new ChangesetListItemStateListener());
            Dimension d = this.cbOpenChangesets.getPreferredSize();
            d.width = 200;
            this.cbOpenChangesets.setPreferredSize(d);
            d.width = 100;
            this.cbOpenChangesets.setMinimumSize(d);
            this.model.addListDataListener(this);
            this.add((Component)this.cbOpenChangesets, gc);
            gc.gridx = 2;
            gc.gridy = 3;
            gc.gridwidth = 1;
            gc.weightx = 0.0;
            this.btnRefresh = new JButton(new RefreshAction());
            this.add((Component)this.btnRefresh, gc);
            gc.gridx = 3;
            gc.gridy = 3;
            gc.gridwidth = 1;
            gc.weightx = 0.0;
            CloseChangesetAction closeChangesetAction = new CloseChangesetAction();
            this.btnClose = new JButton(closeChangesetAction);
            this.cbOpenChangesets.addItemListener(closeChangesetAction);
            this.add((Component)this.btnClose, gc);
            gc.gridx = 0;
            gc.gridy = 4;
            gc.gridwidth = 4;
            this.cbCloseAfterUpload = new JCheckBox(I18n.tr("Close changeset after upload"));
            this.cbCloseAfterUpload.setToolTipText(I18n.tr("Select to close the changeset after the next upload"));
            this.add((Component)this.cbCloseAfterUpload, gc);
            this.cbCloseAfterUpload.setSelected(true);
            this.rbUseNew.getModel().addItemListener(new RadioButtonHandler());
            this.rbExisting.getModel().addItemListener(new RadioButtonHandler());
            this.refreshGUI();
        }

        public ChangesetSelectionPanel() {
            this.build();
        }

        public void rememberUserInput() {
            this.cmt.addCurrentItemToHistory();
            Main.pref.putCollection(UploadDialog.HISTORY_KEY, this.cmt.getHistory());
            Main.pref.put("osm-server.atomic-upload", this.cbUseAtomicUpload.isSelected());
        }

        public void startUserInput() {
            List<String> history = this.cmt.getHistory();
            if (history != null && !history.isEmpty()) {
                this.cmt.setText(history.get(0));
            }
            this.cmt.requestFocusInWindow();
            this.cmt.getEditor().getEditorComponent().requestFocusInWindow();
        }

        public void prepareDialogForNextUpload(Changeset cs) {
            if (cs == null || cs.getId() == 0L) {
                this.rbUseNew.setSelected(true);
                this.cbCloseAfterUpload.setSelected(true);
            }
            if (cs.getId() == 0L) {
                this.rbUseNew.setSelected(true);
                this.cbCloseAfterUpload.setSelected(true);
            } else if (cs.isOpen()) {
                this.rbExisting.setSelected(true);
                this.cbCloseAfterUpload.setSelected(false);
            } else {
                this.rbUseNew.setSelected(true);
                this.cbCloseAfterUpload.setSelected(true);
            }
        }

        public String getUploadComment() {
            return this.cmt.getText();
        }

        public void setUploadComment(String uploadComment) {
            this.cmt.setText(uploadComment);
        }

        public void initEditingOfUploadComment(String comment) {
            this.setUploadComment(comment);
            this.cmt.getEditor().selectAll();
            this.cmt.requestFocusInWindow();
        }

        protected void refreshGUI() {
            this.rbExisting.setEnabled(this.model.getSize() > 0);
            if (this.model.getSize() == 0 && !this.rbUseNew.isSelected()) {
                this.rbUseNew.setSelected(true);
            }
            this.cbOpenChangesets.setEnabled(this.model.getSize() > 0 && this.rbExisting.isSelected());
        }

        public void contentsChanged(ListDataEvent e) {
            this.refreshGUI();
        }

        public void intervalAdded(ListDataEvent e) {
            this.refreshGUI();
        }

        public void intervalRemoved(ListDataEvent e) {
            this.refreshGUI();
        }

        public Changeset getChangeset() {
            if (this.rbUseNew.isSelected() || this.cbOpenChangesets.getSelectedItem() == null) {
                return new Changeset();
            }
            Changeset cs = (Changeset)this.cbOpenChangesets.getSelectedItem();
            if (cs == null) {
                return new Changeset();
            }
            return cs;
        }

        public void setOrUpdateChangeset(Changeset cs) {
            if (cs == null) {
                UploadDialog.this.tagEditorPanel.getModel().clear();
                UploadDialog.this.tagEditorPanel.getModel().add("created_by", UploadDialog.this.getDefaultCreatedBy());
                UploadDialog.this.tagEditorPanel.getModel().appendNewTag();
            } else if (cs.getId() == 0L) {
                if (cs.get("created_by") == null) {
                    cs.put("created_by", UploadDialog.this.getDefaultCreatedBy());
                }
                UploadDialog.this.tagEditorPanel.getModel().initFromPrimitive(cs);
                UploadDialog.this.tagEditorPanel.getModel().appendNewTag();
            } else if (cs.getId() > 0L && cs.isOpen()) {
                if (cs.get("created_by") == null) {
                    cs.put("created_by", UploadDialog.this.getDefaultCreatedBy());
                }
                UploadDialog.this.tagEditorPanel.getModel().initFromPrimitive(cs);
                this.model.addOrUpdate(cs);
                cs = this.model.getChangesetById(cs.getId());
                this.cbOpenChangesets.setSelectedItem(cs);
            } else if (cs.getId() > 0L && !cs.isOpen()) {
                if (cs.get("created_by") == null) {
                    cs.put("created_by", UploadDialog.this.getDefaultCreatedBy());
                }
                UploadDialog.this.tagEditorPanel.getModel().initFromPrimitive(cs);
                this.model.removeChangeset(cs);
                if (this.model.getSize() == 0) {
                    this.rbUseNew.setSelected(true);
                    this.model.setSelectedItem(null);
                    UploadDialog.this.southTabbedPane.setTitleAt(1, I18n.tr("Tags of new changeset"));
                }
            }
            this.prepareDialogForNextUpload(cs);
        }

        public void setUseNewChangeset() {
            this.rbUseNew.setSelected(true);
        }

        public void setUseExistingChangeset() {
            this.rbExisting.setSelected(true);
            if (this.cbOpenChangesets.getSelectedItem() == null && this.model.getSize() > 0) {
                this.cbOpenChangesets.setSelectedItem(this.model.getElementAt(0));
            }
        }

        public boolean isCloseAfterUpload() {
            return this.cbCloseAfterUpload.isSelected();
        }

        class CloseChangesetAction
        extends AbstractAction
        implements ItemListener {
            public CloseChangesetAction() {
                this.putValue("Name", I18n.tr("Close"));
                this.putValue("SmallIcon", ImageProvider.get("closechangeset"));
                this.putValue("ShortDescription", I18n.tr("Close the currently selected open changeset"));
                this.refreshEnabledState();
            }

            public void actionPerformed(ActionEvent e) {
                Changeset cs = (Changeset)ChangesetSelectionPanel.this.cbOpenChangesets.getSelectedItem();
                if (cs == null) {
                    return;
                }
                CloseChangesetTask task = new CloseChangesetTask(Collections.singletonList(cs));
                Main.worker.submit(task);
            }

            protected void refreshEnabledState() {
                this.setEnabled(ChangesetSelectionPanel.this.cbOpenChangesets.getModel().getSize() > 0 && ChangesetSelectionPanel.this.cbOpenChangesets.getSelectedItem() != null);
            }

            public void itemStateChanged(ItemEvent e) {
                this.refreshEnabledState();
            }
        }

        class RefreshAction
        extends AbstractAction {
            public RefreshAction() {
                this.putValue("ShortDescription", I18n.tr("Load the list of your open changesets from the server"));
                this.putValue("SmallIcon", ImageProvider.get("dialogs", "refresh"));
            }

            public void actionPerformed(ActionEvent e) {
                DownloadOpenChangesetsTask task = new DownloadOpenChangesetsTask(ChangesetSelectionPanel.this.model);
                Main.worker.submit(task);
            }
        }

        class ChangesetListItemStateListener
        implements ItemListener {
            ChangesetListItemStateListener() {
            }

            public void itemStateChanged(ItemEvent e) {
                Changeset cs = (Changeset)ChangesetSelectionPanel.this.cbOpenChangesets.getSelectedItem();
                if (cs == null) {
                    UploadDialog.this.southTabbedPane.setTitleAt(1, I18n.tr("Tags of new changeset"));
                    cs = new Changeset();
                    UploadDialog.this.tagEditorPanel.getModel().applyToPrimitive(cs);
                    if (cs.get("created_by") == null) {
                        cs.put("created_by", UploadDialog.this.getDefaultCreatedBy());
                    }
                    cs.put("comment", ChangesetSelectionPanel.this.cmt.getText());
                    UploadDialog.this.tagEditorPanel.getModel().initFromPrimitive(cs);
                } else {
                    UploadDialog.this.southTabbedPane.setTitleAt(1, I18n.tr("Tags of changeset {0}", cs.getId()));
                    if (cs.get("created_by") == null) {
                        cs.put("created_by", UploadDialog.this.getDefaultCreatedBy());
                    }
                    UploadDialog.this.tagEditorPanel.getModel().initFromPrimitive(cs);
                }
            }
        }

        class RadioButtonHandler
        implements ItemListener {
            RadioButtonHandler() {
            }

            public void itemStateChanged(ItemEvent e) {
                if (ChangesetSelectionPanel.this.rbUseNew.isSelected()) {
                    UploadDialog.this.southTabbedPane.setTitleAt(1, I18n.tr("Tags of new changeset"));
                    Changeset cs = new Changeset();
                    UploadDialog.this.tagEditorPanel.getModel().applyToPrimitive(cs);
                    if (cs.get("created_by") == null) {
                        cs.put("created_by", UploadDialog.this.getDefaultCreatedBy());
                    }
                    cs.put("comment", ChangesetSelectionPanel.this.cmt.getText());
                    UploadDialog.this.tagEditorPanel.getModel().initFromPrimitive(cs);
                } else {
                    Changeset cs;
                    if (ChangesetSelectionPanel.this.cbOpenChangesets.getSelectedItem() == null) {
                        ChangesetSelectionPanel.this.model.selectFirstChangeset();
                    }
                    if ((cs = (Changeset)ChangesetSelectionPanel.this.cbOpenChangesets.getSelectedItem()) != null) {
                        cs.put("comment", ChangesetSelectionPanel.this.cmt.getText());
                        UploadDialog.this.southTabbedPane.setTitleAt(1, I18n.tr("Tags of changeset {0}", cs.getId()));
                        UploadDialog.this.tagEditorPanel.getModel().initFromPrimitive(cs);
                    }
                }
                ChangesetSelectionPanel.this.refreshGUI();
            }
        }
    }

    class WindowEventHandler
    extends WindowAdapter {
        WindowEventHandler() {
        }

        public void windowClosing(WindowEvent e) {
            UploadDialog.this.setCanceled(true);
        }

        public void windowOpened(WindowEvent e) {
            UploadDialog.this.startUserInput();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class PrimitiveListModel
    extends AbstractListModel {
        private List<OsmPrimitive> primitives;

        public PrimitiveListModel() {
            this.primitives = new ArrayList<OsmPrimitive>();
        }

        public PrimitiveListModel(List<OsmPrimitive> primitives) {
            this.setPrimitives(primitives);
        }

        public void setPrimitives(List<OsmPrimitive> primitives) {
            this.primitives = primitives == null ? new ArrayList<OsmPrimitive>() : primitives;
            this.fireContentsChanged(this, 0, this.getSize());
        }

        @Override
        public Object getElementAt(int index) {
            if (this.primitives == null) {
                return null;
            }
            return this.primitives.get(index);
        }

        @Override
        public int getSize() {
            if (this.primitives == null) {
                return 0;
            }
            return this.primitives.size();
        }
    }

    class PrimitiveList
    extends JList {
        public PrimitiveList() {
            super(new PrimitiveListModel());
        }

        public PrimitiveListModel getPrimitiveListModel() {
            return (PrimitiveListModel)this.getModel();
        }
    }

    class CancelAction
    extends AbstractAction {
        public CancelAction() {
            this.putValue("Name", I18n.tr("Cancel"));
            this.putValue("SmallIcon", ImageProvider.get("cancel"));
            this.putValue("ShortDescription", I18n.tr("Cancel the upload and resume editing"));
        }

        public void actionPerformed(ActionEvent e) {
            UploadDialog.this.setCanceled(true);
            UploadDialog.this.setVisible(false);
        }
    }

    class UploadAction
    extends AbstractAction {
        public UploadAction() {
            this.putValue("Name", I18n.tr("Upload Changes"));
            this.putValue("SmallIcon", ImageProvider.get("upload"));
            this.putValue("ShortDescription", I18n.tr("Upload the changed primitives"));
        }

        protected void warnIllegalUploadComment() {
            JOptionPane.showMessageDialog(UploadDialog.this, I18n.tr("Please enter a comment for this upload changeset (min. 3 characters)"), I18n.tr("Illegal upload comment"), 0);
        }

        public void actionPerformed(ActionEvent e) {
            if (UploadDialog.this.getUploadComment().trim().length() < 3) {
                this.warnIllegalUploadComment();
                UploadDialog.this.southTabbedPane.setSelectedIndex(0);
                UploadDialog.this.pnlChangesetSelection.initEditingOfUploadComment(UploadDialog.this.getUploadComment());
                return;
            }
            UploadDialog.this.setCanceled(false);
            UploadDialog.this.setVisible(false);
        }
    }

    class TabbedPaneChangeLister
    implements ChangeListener {
        TabbedPaneChangeLister() {
        }

        protected boolean hasCommentTag() {
            TagEditorModel model = UploadDialog.this.tagEditorPanel.getModel();
            return model.get("comment") != null;
        }

        protected TagModel getEmptyTag() {
            TagEditorModel model = UploadDialog.this.tagEditorPanel.getModel();
            TagModel tm = model.get("");
            if (tm != null) {
                return tm;
            }
            tm = new TagModel("", "");
            model.add(tm);
            return tm;
        }

        protected TagModel getOrCreateCommentTag() {
            TagEditorModel model = UploadDialog.this.tagEditorPanel.getModel();
            if (this.hasCommentTag()) {
                return model.get("comment");
            }
            TagModel tm = this.getEmptyTag();
            tm.setName("comment");
            return tm;
        }

        protected void removeCommentTag() {
            TagEditorModel model = UploadDialog.this.tagEditorPanel.getModel();
            model.delete("comment");
        }

        protected void refreshCommentTag() {
            TagModel tm = this.getOrCreateCommentTag();
            tm.setName("comment");
            tm.setValue(UploadDialog.this.pnlChangesetSelection.getUploadComment().trim());
            if (UploadDialog.this.pnlChangesetSelection.getUploadComment().trim().equals("")) {
                this.removeCommentTag();
            }
            UploadDialog.this.tagEditorPanel.getModel().fireTableDataChanged();
        }

        public void stateChanged(ChangeEvent e) {
            if (UploadDialog.this.southTabbedPane.getSelectedIndex() == 0) {
                TagModel tm = UploadDialog.this.tagEditorPanel.getModel().get("comment");
                UploadDialog.this.pnlChangesetSelection.initEditingOfUploadComment(tm == null ? "" : tm.getValue());
            } else if (UploadDialog.this.southTabbedPane.getSelectedIndex() == 1) {
                this.refreshCommentTag();
            }
        }
    }
}

