/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.util.Collection;
import java.util.HashSet;
import org.openstreetmap.josm.actions.upload.CyclicUploadDependencyException;
import org.openstreetmap.josm.data.APIDataSet;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.io.AbstractIOTask;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.OsmApiPrimitiveGoneException;
import org.openstreetmap.josm.io.OsmServerWriter;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;

class UploadLayerTask
extends AbstractIOTask
implements Runnable {
    private OsmServerWriter writer;
    private OsmDataLayer layer;
    private ProgressMonitor monitor;
    private Changeset changeset;
    private boolean closeChangesetAfterUpload;
    private Collection<OsmPrimitive> toUpload;
    private HashSet<OsmPrimitive> processedPrimitives;

    public UploadLayerTask(OsmDataLayer layer, ProgressMonitor monitor, Changeset changeset, boolean closeChangesetAfterUpload) {
        if (layer == null) {
            throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' must not be null.", layer));
        }
        if (monitor == null) {
            monitor = NullProgressMonitor.INSTANCE;
        }
        this.layer = layer;
        this.monitor = monitor;
        this.changeset = changeset;
        this.closeChangesetAfterUpload = closeChangesetAfterUpload;
        this.processedPrimitives = new HashSet();
    }

    protected OsmPrimitive getPrimitive(OsmPrimitiveType type, long id) {
        for (OsmPrimitive p : this.toUpload) {
            if (!OsmPrimitiveType.from(p).equals((Object)type) || p.getId() != id) continue;
            return p;
        }
        return null;
    }

    protected void recoverFromGoneOnServer(OsmApiPrimitiveGoneException e, ProgressMonitor monitor) throws OsmTransferException {
        if (!e.isKnownPrimitive()) {
            throw e;
        }
        OsmPrimitive p = this.getPrimitive(e.getPrimitiveType(), e.getPrimitiveId());
        if (p == null) {
            throw e;
        }
        if (p.isDeleted()) {
            System.out.println(I18n.tr("Warning: primitive ''{0}'' is already deleted on the server. Skipping this primitive and retrying to upload.", p.getDisplayName(DefaultNameFormatter.getInstance())));
            this.processedPrimitives.addAll(this.writer.getProcessedPrimitives());
            this.processedPrimitives.add(p);
            this.toUpload.removeAll(this.processedPrimitives);
            return;
        }
        throw e;
    }

    public void run() {
        this.monitor.subTask(I18n.tr("Preparing primitives to upload ..."));
        APIDataSet ds = new APIDataSet(this.layer.data);
        try {
            ds.adjustRelationUploadOrder();
        }
        catch (CyclicUploadDependencyException e) {
            this.setLastException(e);
            return;
        }
        this.toUpload = ds.getPrimitives();
        if (this.toUpload.isEmpty()) {
            return;
        }
        this.writer = new OsmServerWriter();
        try {
            while (true) {
                try {
                    ProgressMonitor m = this.monitor.createSubTaskMonitor(-1, false);
                    if (this.isCancelled()) {
                        return;
                    }
                    this.writer.uploadOsm(this.layer.data.version, this.toUpload, this.changeset, m);
                    this.processedPrimitives.addAll(this.writer.getProcessedPrimitives());
                }
                catch (OsmApiPrimitiveGoneException e) {
                    this.recoverFromGoneOnServer(e, this.monitor);
                    continue;
                }
                break;
            }
            if (this.closeChangesetAfterUpload && this.changeset != null && this.changeset.getId() > 0L) {
                OsmApi.getOsmApi().closeChangeset(this.changeset, this.monitor.createSubTaskMonitor(0, false));
            }
        }
        catch (Exception sxe) {
            if (this.isCancelled()) {
                System.out.println("Ignoring exception caught because upload is cancelled. Exception is: " + sxe.toString());
                return;
            }
            this.setLastException(sxe);
        }
        if (this.isCancelled()) {
            return;
        }
        this.layer.cleanupAfterUpload(this.processedPrimitives);
        DataSet.fireSelectionChanged(this.layer.data.getSelected());
        this.layer.fireDataChange();
        this.layer.onPostUploadToServer();
    }

    public void cancel() {
        this.setCancelled(true);
        if (this.writer != null) {
            this.writer.cancel();
        }
    }
}

