/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint;

import java.awt.Color;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.ImageIcon;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.mappaint.AreaElemStyle;
import org.openstreetmap.josm.gui.mappaint.ElemStyles;
import org.openstreetmap.josm.gui.mappaint.IconElemStyle;
import org.openstreetmap.josm.gui.mappaint.LineElemStyle;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.gui.mappaint.Rule;
import org.openstreetmap.josm.tools.ColorHelper;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class ElemStyleHandler
extends DefaultHandler {
    boolean inDoc;
    boolean inRule;
    boolean inCondition;
    boolean inElemStyle;
    boolean inLine;
    boolean inLineMod;
    boolean inIcon;
    boolean inArea;
    boolean inScaleMax;
    boolean inScaleMin;
    boolean hadLine;
    boolean hadLineMod;
    boolean hadIcon;
    boolean hadArea;
    ElemStyles styles;
    String styleName;
    RuleElem rule = new RuleElem();

    public ElemStyleHandler(String name) {
        this.styleName = name;
        this.inArea = false;
        this.inIcon = false;
        this.inLine = false;
        this.inElemStyle = false;
        this.inCondition = false;
        this.inRule = false;
        this.inDoc = false;
        this.rule.init();
        this.styles = MapPaintStyles.getStyles();
    }

    Color convertColor(String colString) {
        int i = colString.indexOf("#");
        Color ret = i < 0 ? Main.pref.getColor("mappaint." + this.styleName + "." + colString, Color.red) : (i == 0 ? ColorHelper.html2color(colString) : Main.pref.getColor("mappaint." + this.styleName + "." + colString.substring(0, i), ColorHelper.html2color(colString.substring(i))));
        return ret;
    }

    public void startDocument() {
        this.inDoc = true;
    }

    public void endDocument() {
        this.inDoc = false;
    }

    private void error(String message) {
        System.out.println(this.styleName + " (" + this.rule.rule.key + "=" + this.rule.rule.value + "): " + message);
    }

    private void startElementLine(String qName, Attributes atts, LineElemStyle line) {
        for (int count = 0; count < atts.getLength(); ++count) {
            if (atts.getQName(count).equals("width")) {
                String val = atts.getValue(count);
                if (val.startsWith("+")) {
                    line.width = Integer.parseInt(val.substring(1));
                    line.widthMode = LineElemStyle.WidthMode.OFFSET;
                    continue;
                }
                if (val.startsWith("-")) {
                    line.width = Integer.parseInt(val);
                    line.widthMode = LineElemStyle.WidthMode.OFFSET;
                    continue;
                }
                if (val.endsWith("%")) {
                    line.width = Integer.parseInt(val.substring(0, val.length() - 1));
                    line.widthMode = LineElemStyle.WidthMode.PERCENT;
                    continue;
                }
                line.width = Integer.parseInt(val);
                continue;
            }
            if (atts.getQName(count).equals("colour")) {
                line.color = this.convertColor(atts.getValue(count));
                continue;
            }
            if (atts.getQName(count).equals("realwidth")) {
                line.realWidth = Integer.parseInt(atts.getValue(count));
                continue;
            }
            if (atts.getQName(count).equals("dashed")) {
                try {
                    String[] parts = atts.getValue(count).split(",");
                    line.dashed = new float[parts.length];
                    for (int i = 0; i < parts.length; ++i) {
                        line.dashed[i] = Integer.parseInt(parts[i]);
                    }
                    continue;
                }
                catch (NumberFormatException nfe) {
                    boolean dashed = Boolean.parseBoolean(atts.getValue(count));
                    if (!dashed) continue;
                    line.dashed = new float[]{9.0f};
                    continue;
                }
            }
            if (atts.getQName(count).equals("dashedcolour")) {
                line.dashedColor = this.convertColor(atts.getValue(count));
                continue;
            }
            if (atts.getQName(count).equals("priority")) {
                line.priority = Integer.parseInt(atts.getValue(count));
                continue;
            }
            if (atts.getQName(count).equals("mode")) {
                line.over = !atts.getValue(count).equals("under");
                continue;
            }
            this.error("The element \"" + qName + "\" has unknown attribute \"" + atts.getQName(count) + "\"!");
        }
    }

    public void startElement(String uri, String name, String qName, Attributes atts) {
        if (this.inDoc) {
            if (qName.equals("rule")) {
                this.inRule = true;
            } else if (qName.equals("rules")) {
                if (this.styleName == null) {
                    String n = atts.getValue("name");
                    if (n == null) {
                        n = "standard";
                    }
                    this.styleName = n;
                }
            } else if (qName.equals("scale_max")) {
                this.inScaleMax = true;
            } else if (qName.equals("scale_min")) {
                this.inScaleMin = true;
            } else if (qName.equals("condition") && this.inRule) {
                this.inCondition = true;
                Rule r = this.rule.rule;
                if (r.key != null) {
                    if (this.rule.rules == null) {
                        this.rule.rules = new LinkedList<Rule>();
                    }
                    this.rule.rules.add(new Rule(this.rule.rule));
                    r = new Rule();
                    this.rule.rules.add(r);
                }
                for (int count = 0; count < atts.getLength(); ++count) {
                    if (atts.getQName(count).equals("k")) {
                        r.key = atts.getValue(count);
                        continue;
                    }
                    if (atts.getQName(count).equals("v")) {
                        r.value = atts.getValue(count);
                        continue;
                    }
                    if (atts.getQName(count).equals("b")) {
                        r.boolValue = atts.getValue(count);
                        continue;
                    }
                    this.error("The element \"" + qName + "\" has unknown attribute \"" + atts.getQName(count) + "\"!");
                }
                if (r.key == null) {
                    this.error("The condition has no key!");
                }
            } else if (qName.equals("line")) {
                this.inLine = true;
                this.hadLine = true;
                this.startElementLine(qName, atts, this.rule.line);
                if (this.rule.line.widthMode != LineElemStyle.WidthMode.ABSOLUTE) {
                    this.error("Relative widths are not possible for normal lines");
                    this.rule.line.widthMode = LineElemStyle.WidthMode.ABSOLUTE;
                }
            } else if (qName.equals("linemod")) {
                this.inLineMod = true;
                this.hadLineMod = true;
                this.startElementLine(qName, atts, this.rule.linemod);
            } else if (qName.equals("icon")) {
                this.inIcon = true;
                for (int count = 0; count < atts.getLength(); ++count) {
                    if (atts.getQName(count).equals("src")) {
                        ImageIcon icon = MapPaintStyles.getIcon(atts.getValue(count), this.styleName);
                        this.hadIcon = icon != null;
                        this.rule.icon.icon = icon;
                        continue;
                    }
                    if (atts.getQName(count).equals("annotate")) {
                        this.rule.icon.annotate = Boolean.parseBoolean(atts.getValue(count));
                        continue;
                    }
                    if (atts.getQName(count).equals("priority")) {
                        this.rule.icon.priority = Integer.parseInt(atts.getValue(count));
                        continue;
                    }
                    this.error("The element \"" + qName + "\" has unknown attribute \"" + atts.getQName(count) + "\"!");
                }
            } else if (qName.equals("area")) {
                this.inArea = true;
                this.hadArea = true;
                for (int count = 0; count < atts.getLength(); ++count) {
                    if (atts.getQName(count).equals("colour")) {
                        this.rule.area.color = this.convertColor(atts.getValue(count));
                        continue;
                    }
                    if (atts.getQName(count).equals("closed")) {
                        this.rule.area.closed = Boolean.parseBoolean(atts.getValue(count));
                        continue;
                    }
                    if (atts.getQName(count).equals("priority")) {
                        this.rule.area.priority = Integer.parseInt(atts.getValue(count));
                        continue;
                    }
                    this.error("The element \"" + qName + "\" has unknown attribute \"" + atts.getQName(count) + "\"!");
                }
            } else {
                this.error("The element \"" + qName + "\" is unknown!");
            }
        }
    }

    public void endElement(String uri, String name, String qName) {
        if (this.inRule && qName.equals("rule")) {
            if (this.hadLine) {
                this.styles.add(this.styleName, this.rule.rule, this.rule.rules, new LineElemStyle(this.rule.line, this.rule.scaleMax, this.rule.scaleMin));
            }
            if (this.hadLineMod) {
                this.styles.addModifier(this.styleName, this.rule.rule, this.rule.rules, new LineElemStyle(this.rule.linemod, this.rule.scaleMax, this.rule.scaleMin));
            }
            if (this.hadIcon) {
                this.styles.add(this.styleName, this.rule.rule, this.rule.rules, new IconElemStyle(this.rule.icon, this.rule.scaleMax, this.rule.scaleMin));
            }
            if (this.hadArea) {
                this.styles.add(this.styleName, this.rule.rule, this.rule.rules, new AreaElemStyle(this.rule.area, this.rule.scaleMax, this.rule.scaleMin));
            }
            this.inRule = false;
            this.hadArea = false;
            this.hadIcon = false;
            this.hadLineMod = false;
            this.hadLine = false;
            this.rule.init();
        } else if (this.inCondition && qName.equals("condition")) {
            this.inCondition = false;
        } else if (this.inLine && qName.equals("line")) {
            this.inLine = false;
        } else if (this.inLineMod && qName.equals("linemod")) {
            this.inLineMod = false;
        } else if (this.inIcon && qName.equals("icon")) {
            this.inIcon = false;
        } else if (this.inArea && qName.equals("area")) {
            this.inArea = false;
        } else if (qName.equals("scale_max")) {
            this.inScaleMax = false;
        } else if (qName.equals("scale_min")) {
            this.inScaleMin = false;
        }
    }

    public void characters(char[] ch, int start, int length) {
        if (this.inScaleMax) {
            this.rule.scaleMax = Long.parseLong(new String(ch, start, length));
        } else if (this.inScaleMin) {
            this.rule.scaleMin = Long.parseLong(new String(ch, start, length));
        }
    }

    class RuleElem {
        Rule rule = new Rule();
        Collection<Rule> rules;
        long scaleMax;
        long scaleMin;
        LineElemStyle line = new LineElemStyle();
        LineElemStyle linemod = new LineElemStyle();
        AreaElemStyle area = new AreaElemStyle();
        IconElemStyle icon = new IconElemStyle();

        RuleElem() {
        }

        public void init() {
            this.rules = null;
            this.scaleMax = 1000000000L;
            this.scaleMin = 0L;
            this.line.init();
            this.rule.init();
            this.linemod.init();
            this.area.init();
            this.icon.init();
        }
    }
}

