/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.preferences.PreferenceDialog;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class DrawingPreference
implements PreferenceSetting {
    private ButtonGroup gpsLinesGroup;
    private JRadioButton drawRawGpsLinesAll = new JRadioButton(I18n.tr("All"));
    private JRadioButton drawRawGpsLinesLocal = new JRadioButton(I18n.tr("Local files"));
    private JRadioButton drawRawGpsLinesNone = new JRadioButton(I18n.tr("None"));
    private ActionListener drawRawGpsLinesActionListener;
    private JTextField drawRawGpsMaxLineLength = new JTextField(8);
    private JTextField drawRawGpsMaxLineLengthLocal = new JTextField(8);
    private JCheckBox forceRawGpsLines = new JCheckBox(I18n.tr("Force lines if no segments imported."));
    private JCheckBox largeGpsPoints = new JCheckBox(I18n.tr("Draw large GPS points."));
    private JCheckBox hdopCircleGpsPoints = new JCheckBox(I18n.tr("Draw a circle form HDOP value."));
    private ButtonGroup colorGroup;
    private JRadioButton colorTypeVelocity = new JRadioButton(I18n.tr("Velocity (red = slow, green = fast)"));
    private JRadioButton colorTypeDilution = new JRadioButton(I18n.tr("Dilution of Position (red = high, green = low, if available)"));
    private JRadioButton colorTypeNone = new JRadioButton(I18n.tr("Single Color (can be customized for named layers)"));
    private JComboBox colorTypeVelocityTune = new JComboBox<String>(new String[]{I18n.tr("Car"), I18n.tr("Bicycle"), I18n.tr("Foot")});
    private JCheckBox directionHint = new JCheckBox(I18n.tr("Draw Direction Arrows"));
    private JCheckBox drawGpsArrows = new JCheckBox(I18n.tr("Draw Direction Arrows"));
    private JCheckBox drawGpsArrowsFast = new JCheckBox(I18n.tr("Fast drawing (looks uglier)"));
    private JTextField drawGpsArrowsMinDist = new JTextField(8);
    private JCheckBox interestingDirections = new JCheckBox(I18n.tr("Only interesting direction hints (e.g. with oneway tag)."));
    private JCheckBox headArrow = new JCheckBox(I18n.tr("Only on the head of a way."));
    private JCheckBox segmentOrderNumber = new JCheckBox(I18n.tr("Draw segment order numbers"));
    private JCheckBox sourceBounds = new JCheckBox(I18n.tr("Draw boundaries of downloaded data"));
    private JCheckBox virtualNodes = new JCheckBox(I18n.tr("Draw virtual nodes in select mode"));
    private JCheckBox inactive = new JCheckBox(I18n.tr("Draw inactive layers in other color"));
    private JCheckBox useAntialiasing = new JCheckBox(I18n.tr("Smooth map graphics (antialiasing)"));

    public void addGui(PreferenceDialog gui) {
        gui.display.setPreferredSize(new Dimension(400, 600));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.gpsLinesGroup = new ButtonGroup();
        this.gpsLinesGroup.add(this.drawRawGpsLinesNone);
        this.gpsLinesGroup.add(this.drawRawGpsLinesLocal);
        this.gpsLinesGroup.add(this.drawRawGpsLinesAll);
        Boolean lf = Main.pref.getBoolean("draw.rawgps.lines.localfiles", false);
        if (Main.pref.getBoolean("draw.rawgps.lines", true)) {
            this.drawRawGpsLinesAll.setSelected(true);
        } else if (lf.booleanValue()) {
            this.drawRawGpsLinesLocal.setSelected(true);
        } else {
            this.drawRawGpsLinesNone.setSelected(true);
        }
        panel.add((Component)new JLabel(I18n.tr("Draw lines between raw GPS points")), GBC.eol().insets(20, 0, 0, 0));
        panel.add((Component)this.drawRawGpsLinesNone, GBC.eol().insets(40, 0, 0, 0));
        panel.add((Component)this.drawRawGpsLinesLocal, GBC.eol().insets(40, 0, 0, 0));
        panel.add((Component)this.drawRawGpsLinesAll, GBC.eol().insets(40, 0, 0, 0));
        this.drawRawGpsLinesActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DrawingPreference.this.forceRawGpsLines.setEnabled(!DrawingPreference.this.drawRawGpsLinesNone.isSelected());
                DrawingPreference.this.drawRawGpsMaxLineLength.setEnabled(!DrawingPreference.this.drawRawGpsLinesNone.isSelected() && !DrawingPreference.this.drawRawGpsLinesLocal.isSelected());
                DrawingPreference.this.drawRawGpsMaxLineLengthLocal.setEnabled(!DrawingPreference.this.drawRawGpsLinesNone.isSelected());
                DrawingPreference.this.drawGpsArrows.setEnabled(!DrawingPreference.this.drawRawGpsLinesNone.isSelected());
                DrawingPreference.this.drawGpsArrowsFast.setEnabled(DrawingPreference.this.drawGpsArrows.isSelected() && DrawingPreference.this.drawGpsArrows.isEnabled());
                DrawingPreference.this.drawGpsArrowsMinDist.setEnabled(DrawingPreference.this.drawGpsArrows.isSelected() && DrawingPreference.this.drawGpsArrows.isEnabled());
            }
        };
        this.drawRawGpsLinesNone.addActionListener(this.drawRawGpsLinesActionListener);
        this.drawRawGpsLinesLocal.addActionListener(this.drawRawGpsLinesActionListener);
        this.drawRawGpsLinesAll.addActionListener(this.drawRawGpsLinesActionListener);
        this.drawRawGpsMaxLineLengthLocal.setText(Integer.toString(Main.pref.getInteger("draw.rawgps.max-line-length.local", -1)));
        this.drawRawGpsMaxLineLengthLocal.setToolTipText(I18n.tr("Maximum length (in meters) to draw lines for local files. Set to '-1' to draw all lines."));
        this.drawRawGpsMaxLineLengthLocal.setEnabled(!this.drawRawGpsLinesNone.isSelected());
        panel.add((Component)new JLabel(I18n.tr("Maximum length for local files (meters)")), GBC.std().insets(40, 0, 0, 0));
        panel.add((Component)this.drawRawGpsMaxLineLengthLocal, GBC.eol().fill(2).insets(5, 0, 0, 5));
        this.drawRawGpsMaxLineLength.setText(Integer.toString(Main.pref.getInteger("draw.rawgps.max-line-length", 200)));
        this.drawRawGpsMaxLineLength.setToolTipText(I18n.tr("Maximum length (in meters) to draw lines. Set to '-1' to draw all lines."));
        this.drawRawGpsMaxLineLength.setEnabled(!this.drawRawGpsLinesNone.isSelected());
        panel.add((Component)new JLabel(I18n.tr("Maximum length (meters)")), GBC.std().insets(40, 0, 0, 0));
        panel.add((Component)this.drawRawGpsMaxLineLength, GBC.eol().fill(2).insets(5, 0, 0, 5));
        this.forceRawGpsLines.setToolTipText(I18n.tr("Force drawing of lines if the imported data contain no line information."));
        this.forceRawGpsLines.setSelected(Main.pref.getBoolean("draw.rawgps.lines.force", false));
        this.forceRawGpsLines.setEnabled(!this.drawRawGpsLinesNone.isSelected());
        panel.add((Component)this.forceRawGpsLines, GBC.eop().insets(40, 0, 0, 0));
        this.drawGpsArrows.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DrawingPreference.this.drawGpsArrowsFast.setEnabled(DrawingPreference.this.drawGpsArrows.isSelected() && DrawingPreference.this.drawGpsArrows.isEnabled());
                DrawingPreference.this.drawGpsArrowsMinDist.setEnabled(DrawingPreference.this.drawGpsArrows.isSelected() && DrawingPreference.this.drawGpsArrows.isEnabled());
            }
        });
        this.drawGpsArrows.setToolTipText(I18n.tr("Draw direction arrows for lines, connecting GPS points."));
        this.drawGpsArrows.setSelected(Main.pref.getBoolean("draw.rawgps.direction", false));
        this.drawGpsArrows.setEnabled(!this.drawRawGpsLinesNone.isSelected());
        panel.add((Component)this.drawGpsArrows, GBC.eop().insets(40, 0, 0, 0));
        this.drawGpsArrowsFast.setToolTipText(I18n.tr("Draw the direction arrows using table lookups instead of complex math."));
        this.drawGpsArrowsFast.setSelected(Main.pref.getBoolean("draw.rawgps.alternatedirection", false));
        this.drawGpsArrowsFast.setEnabled(this.drawGpsArrows.isSelected() && this.drawGpsArrows.isEnabled());
        panel.add((Component)this.drawGpsArrowsFast, GBC.eop().insets(60, 0, 0, 0));
        this.drawGpsArrowsMinDist.setToolTipText(I18n.tr("Don't draw arrows if they are not at least this distance away from the last one."));
        this.drawGpsArrowsMinDist.setText(Integer.toString(Main.pref.getInteger("draw.rawgps.min-arrow-distance", 0)));
        this.drawGpsArrowsMinDist.setEnabled(this.drawGpsArrows.isSelected() && this.drawGpsArrows.isEnabled());
        panel.add((Component)new JLabel(I18n.tr("Minimum distance (pixels)")), GBC.std().insets(60, 0, 0, 0));
        panel.add((Component)this.drawGpsArrowsMinDist, GBC.eol().fill(2).insets(5, 0, 0, 5));
        this.hdopCircleGpsPoints.setSelected(Main.pref.getBoolean("draw.rawgps.hdopcircle", true));
        this.hdopCircleGpsPoints.setToolTipText(I18n.tr("Draw a circle form HDOP value."));
        panel.add((Component)this.hdopCircleGpsPoints, GBC.eop().insets(20, 0, 0, 0));
        this.largeGpsPoints.setSelected(Main.pref.getBoolean("draw.rawgps.large", false));
        this.largeGpsPoints.setToolTipText(I18n.tr("Draw larger dots for the GPS points."));
        panel.add((Component)this.largeGpsPoints, GBC.eop().insets(20, 0, 0, 0));
        this.colorGroup = new ButtonGroup();
        this.colorGroup.add(this.colorTypeNone);
        this.colorGroup.add(this.colorTypeVelocity);
        this.colorGroup.add(this.colorTypeDilution);
        this.colorTypeVelocity.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                DrawingPreference.this.colorTypeVelocityTune.setEnabled(DrawingPreference.this.colorTypeVelocity.isSelected());
            }
        });
        switch (Main.pref.getInteger("draw.rawgps.colors", 0)) {
            case 0: {
                this.colorTypeNone.setSelected(true);
                break;
            }
            case 1: {
                this.colorTypeVelocity.setSelected(true);
                break;
            }
            case 2: {
                this.colorTypeDilution.setSelected(true);
            }
        }
        this.colorTypeNone.setToolTipText(I18n.tr("All points and track segments will have the same color. Can be customized in Layer Manager."));
        this.colorTypeVelocity.setToolTipText(I18n.tr("Colors points and track segments by velocity."));
        this.colorTypeDilution.setToolTipText(I18n.tr("Colors points and track segments by dilution of position (HDOP). Your capture device needs to logs that information."));
        int ccts = Main.pref.getInteger("draw.rawgps.colorTracksTune", 45);
        this.colorTypeVelocityTune.setSelectedIndex(ccts == 10 ? 2 : (ccts == 20 ? 1 : 0));
        this.colorTypeVelocityTune.setToolTipText(I18n.tr("Allows to tune the track coloring for different average speeds."));
        this.colorTypeVelocityTune.setEnabled(this.colorTypeVelocity.isSelected() && this.colorTypeVelocity.isEnabled());
        panel.add(Box.createVerticalGlue(), GBC.eol().insets(0, 20, 0, 0));
        panel.add((Component)new JLabel(I18n.tr("Track and Point Coloring")), GBC.eol().insets(20, 0, 0, 0));
        panel.add((Component)this.colorTypeNone, GBC.eol().insets(40, 0, 0, 0));
        panel.add((Component)this.colorTypeVelocity, GBC.std().insets(40, 0, 0, 0));
        panel.add((Component)this.colorTypeVelocityTune, GBC.eop().insets(5, 0, 0, 5));
        panel.add((Component)this.colorTypeDilution, GBC.eol().insets(40, 0, 0, 0));
        panel.add(Box.createVerticalGlue(), GBC.eol().fill(1));
        JScrollPane scrollpane = new JScrollPane(panel);
        scrollpane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gui.displaycontent.addTab(I18n.tr("GPS Points"), scrollpane);
        panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.directionHint.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (DrawingPreference.this.directionHint.isSelected()) {
                    DrawingPreference.this.interestingDirections.setSelected(Main.pref.getBoolean("draw.segment.relevant_directions_only", true));
                    DrawingPreference.this.headArrow.setSelected(Main.pref.getBoolean("draw.segment.head_only", false));
                } else {
                    DrawingPreference.this.interestingDirections.setSelected(false);
                    DrawingPreference.this.headArrow.setSelected(false);
                }
                DrawingPreference.this.interestingDirections.setEnabled(DrawingPreference.this.directionHint.isSelected());
                DrawingPreference.this.headArrow.setEnabled(DrawingPreference.this.directionHint.isSelected());
            }
        });
        this.directionHint.setToolTipText(I18n.tr("Draw direction hints for way segments."));
        this.directionHint.setSelected(Main.pref.getBoolean("draw.segment.direction", true));
        panel.add((Component)this.directionHint, GBC.eop().insets(20, 0, 0, 0));
        this.interestingDirections.setToolTipText(I18n.tr("Only interesting direction hints (e.g. with oneway tag)."));
        this.interestingDirections.setSelected(Main.pref.getBoolean("draw.segment.relevant_directions_only", true));
        this.interestingDirections.setEnabled(this.directionHint.isSelected());
        panel.add((Component)this.interestingDirections, GBC.eop().insets(40, 0, 0, 0));
        this.headArrow.setToolTipText(I18n.tr("Only on the head of a way."));
        this.headArrow.setSelected(Main.pref.getBoolean("draw.segment.head_only", false));
        this.headArrow.setEnabled(this.directionHint.isSelected());
        panel.add((Component)this.headArrow, GBC.eop().insets(40, 0, 0, 0));
        this.segmentOrderNumber.setToolTipText(I18n.tr("Draw the order numbers of all segments within their way."));
        this.segmentOrderNumber.setSelected(Main.pref.getBoolean("draw.segment.order_number", false));
        panel.add((Component)this.segmentOrderNumber, GBC.eop().insets(20, 0, 0, 0));
        this.useAntialiasing.setToolTipText(I18n.tr("Apply antialiasing to the map view resulting in a smoother appearance."));
        this.useAntialiasing.setSelected(Main.pref.getBoolean("mappaint.use-antialiasing", false));
        panel.add((Component)this.useAntialiasing, GBC.eop().insets(20, 0, 0, 0));
        this.sourceBounds.setToolTipText(I18n.tr("Draw the boundaries of data loaded from the server."));
        this.sourceBounds.setSelected(Main.pref.getBoolean("draw.data.downloaded_area", true));
        panel.add((Component)this.sourceBounds, GBC.eop().insets(20, 0, 0, 0));
        this.virtualNodes.setToolTipText(I18n.tr("Draw virtual nodes in select mode for easy way modification."));
        this.virtualNodes.setSelected(Main.pref.getInteger("mappaint.node.virtual-size", 8) != 0);
        panel.add((Component)this.virtualNodes, GBC.eop().insets(20, 0, 0, 0));
        this.inactive.setToolTipText(I18n.tr("Draw the inactive data layers in a different color."));
        this.inactive.setSelected(Main.pref.getBoolean("draw.data.inactive_color", true));
        panel.add((Component)this.inactive, GBC.eop().insets(20, 0, 0, 0));
        panel.add(Box.createVerticalGlue(), GBC.eol().fill(1));
        scrollpane = new JScrollPane(panel);
        scrollpane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gui.displaycontent.addTab(I18n.tr("OSM Data"), scrollpane);
    }

    public boolean ok() {
        Main.pref.put("draw.rawgps.lines", this.drawRawGpsLinesAll.isSelected());
        Main.pref.put("draw.rawgps.lines.localfiles", this.drawRawGpsLinesLocal.isSelected());
        Main.pref.put("draw.rawgps.max-line-length", this.drawRawGpsMaxLineLength.getText());
        Main.pref.put("draw.rawgps.max-line-length.local", this.drawRawGpsMaxLineLengthLocal.getText());
        Main.pref.put("draw.rawgps.lines.force", this.forceRawGpsLines.isSelected());
        Main.pref.put("draw.rawgps.direction", this.drawGpsArrows.isSelected());
        Main.pref.put("draw.rawgps.alternatedirection", this.drawGpsArrowsFast.isSelected());
        Main.pref.put("draw.rawgps.min-arrow-distance", this.drawGpsArrowsMinDist.getText());
        if (this.colorTypeVelocity.isSelected()) {
            Main.pref.putInteger("draw.rawgps.colors", 1);
        } else if (this.colorTypeDilution.isSelected()) {
            Main.pref.putInteger("draw.rawgps.colors", 2);
        } else {
            Main.pref.putInteger("draw.rawgps.colors", 0);
        }
        int ccti = this.colorTypeVelocityTune.getSelectedIndex();
        Main.pref.putInteger("draw.rawgps.colorTracksTune", ccti == 2 ? 10 : (ccti == 1 ? 20 : 45));
        Main.pref.put("draw.rawgps.hdopcircle", this.hdopCircleGpsPoints.isSelected());
        Main.pref.put("draw.rawgps.large", this.largeGpsPoints.isSelected());
        Main.pref.put("draw.segment.direction", this.directionHint.isSelected());
        Main.pref.put("draw.segment.relevant_directions_only", this.interestingDirections.isSelected());
        Main.pref.put("draw.segment.head_only", this.headArrow.isSelected());
        Main.pref.put("draw.segment.order_number", this.segmentOrderNumber.isSelected());
        Main.pref.put("draw.data.downloaded_area", this.sourceBounds.isSelected());
        Main.pref.put("draw.data.inactive_color", this.inactive.isSelected());
        Main.pref.put("mappaint.use-antialiasing", this.useAntialiasing.isSelected());
        int vn = Main.pref.getInteger("mappaint.node.virtual-size", 8);
        if (this.virtualNodes.isSelected()) {
            if (vn < 1) {
                vn = 8;
            }
        } else {
            vn = 0;
        }
        Main.pref.putInteger("mappaint.node.virtual-size", vn);
        return false;
    }

    public static class Factory
    implements PreferenceSettingFactory {
        public PreferenceSetting createPreferenceSetting() {
            return new DrawingPreference();
        }
    }
}

