/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences;

import java.awt.Component;
import java.util.Locale;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.preferences.LafPreference;
import org.openstreetmap.josm.gui.preferences.PreferenceDialog;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class LanguagePreference
implements PreferenceSetting {
    private JComboBox langCombo;
    private final Locale AUTO_LANGUAGE = null;

    public void addGui(PreferenceDialog gui) {
        this.langCombo = new JComboBox<Locale>(I18n.getAvailableTranslations());
        this.langCombo.insertItemAt(this.AUTO_LANGUAGE, 0);
        this.langCombo.insertItemAt(Locale.ENGLISH, 1);
        String ln = Main.pref.get("language");
        this.langCombo.setSelectedIndex(0);
        if (ln != null) {
            for (int i = 1; i < this.langCombo.getItemCount(); ++i) {
                if (!((Locale)this.langCombo.getItemAt(i)).toString().equals(ln)) continue;
                this.langCombo.setSelectedIndex(i);
                break;
            }
        }
        final ListCellRenderer oldRenderer = this.langCombo.getRenderer();
        this.langCombo.setRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Locale l = (Locale)value;
                return oldRenderer.getListCellRendererComponent(list, l == LanguagePreference.this.AUTO_LANGUAGE ? I18n.tr("Default (Auto determined)") : l.getDisplayName(), index, isSelected, cellHasFocus);
            }
        });
        LafPreference lafPreference = gui.getSetting(LafPreference.class);
        JPanel panel = lafPreference.panel;
        panel.add((Component)new JLabel(I18n.tr("Language")), GBC.std().insets(20, 0, 0, 0));
        panel.add(GBC.glue(5, 0), GBC.std().fill(2));
        panel.add((Component)this.langCombo, GBC.eol().fill(2));
        panel.add(Box.createVerticalGlue(), GBC.eol().fill(1));
    }

    public boolean ok() {
        if (this.langCombo.getSelectedItem() == null) {
            return Main.pref.put("language", null);
        }
        return Main.pref.put("language", ((Locale)this.langCombo.getSelectedItem()).toString());
    }

    public static class Factory
    implements PreferenceSettingFactory {
        public PreferenceSetting createPreferenceSetting() {
            return new LanguagePreference();
        }
    }
}

