/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.preferences.PreferenceDialog;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.gui.preferences.StyleSources;
import org.openstreetmap.josm.gui.tagging.TaggingPreset;
import org.openstreetmap.josm.gui.tagging.TaggingPresetMenu;
import org.openstreetmap.josm.gui.tagging.TaggingPresetSeparator;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class TaggingPresetPreference
implements PreferenceSetting {
    public static Collection<TaggingPreset> taggingPresets;
    private StyleSources sources;
    private JCheckBox sortMenu;
    private JCheckBox enableDefault;

    public void addGui(PreferenceDialog gui) {
        this.sortMenu = new JCheckBox(I18n.tr("Sort presets menu"), Main.pref.getBoolean("taggingpreset.sortmenu", false));
        this.enableDefault = new JCheckBox(I18n.tr("Enable built-in defaults"), Main.pref.getBoolean("taggingpreset.enable-defaults", true));
        JPanel panel = new JPanel(new GridBagLayout());
        JScrollPane scrollpane = new JScrollPane(panel);
        panel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        panel.add((Component)this.sortMenu, GBC.eol().insets(5, 5, 5, 0));
        panel.add((Component)this.enableDefault, GBC.eol().insets(5, 0, 5, 0));
        this.sources = new StyleSources("taggingpreset.sources", "taggingpreset.icon.sources", "http://josm.openstreetmap.de/presets", false, I18n.tr("Tagging Presets"));
        panel.add((Component)this.sources, GBC.eol().fill(1));
        gui.mapcontent.addTab(I18n.tr("Tagging Presets"), scrollpane);
    }

    public boolean ok() {
        boolean restart = Main.pref.put("taggingpreset.enable-defaults", this.enableDefault.getSelectedObjects() != null);
        if (Main.pref.put("taggingpreset.sortmenu", this.sortMenu.getSelectedObjects() != null)) {
            restart = true;
        }
        if (this.sources.finish()) {
            restart = true;
        }
        return restart;
    }

    public static void initialize() {
        taggingPresets = TaggingPreset.readFromPreferences();
        if (taggingPresets.isEmpty()) {
            Main.main.menu.presetsMenu.setVisible(false);
        } else {
            HashMap<TaggingPresetMenu, JMenu> submenus = new HashMap<TaggingPresetMenu, JMenu>();
            for (TaggingPreset p : taggingPresets) {
                JMenu m;
                JMenu jMenu = m = p.group != null ? (JMenu)submenus.get(p.group) : Main.main.menu.presetsMenu;
                if (p instanceof TaggingPresetSeparator) {
                    m.add(new JSeparator());
                    continue;
                }
                if (p instanceof TaggingPresetMenu) {
                    JMenu submenu = new JMenu(p);
                    submenu.setText(p.getLocaleName());
                    ((TaggingPresetMenu)p).menu = submenu;
                    submenus.put((TaggingPresetMenu)p, submenu);
                    m.add(submenu);
                    continue;
                }
                JMenuItem mi = new JMenuItem(p);
                mi.setText(p.getLocaleName());
                m.add(mi);
            }
        }
        if (Main.pref.getBoolean("taggingpreset.sortmenu")) {
            TaggingPresetMenu.sortMenu(Main.main.menu.presetsMenu);
        }
    }

    public static class Factory
    implements PreferenceSettingFactory {
        public PreferenceSetting createPreferenceSetting() {
            return new TaggingPresetPreference();
        }
    }
}

