/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.tagging.TagCellEditor;
import org.openstreetmap.josm.gui.tagging.TagEditorModel;
import org.openstreetmap.josm.gui.tagging.TagTable;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionCache;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionList;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class TagEditorPanel
extends JPanel {
    private TagEditorModel model;
    private TagTable tagTable;
    private AutoCompletionCache acCache;
    private AutoCompletionList acList;

    protected JPanel buildTagTableEditorPanel() {
        JPanel pnl = new JPanel();
        this.model = new TagEditorModel();
        this.tagTable = new TagTable(this.model);
        pnl.setLayout(new BorderLayout());
        pnl.add((Component)new JScrollPane(this.tagTable), "Center");
        return pnl;
    }

    protected JPanel buildButtonsPanel() {
        JPanel pnl = new JPanel();
        pnl.setLayout(new BoxLayout(pnl, 1));
        AddAction addAction = new AddAction();
        pnl.add(new JButton(addAction));
        this.tagTable.addPropertyChangeListener(addAction);
        DeleteAction deleteAction = new DeleteAction();
        this.tagTable.getSelectionModel().addListSelectionListener(deleteAction);
        this.tagTable.addPropertyChangeListener(deleteAction);
        pnl.add(new JButton(deleteAction));
        return pnl;
    }

    protected void build() {
        this.setLayout(new GridBagLayout());
        JPanel tablePanel = this.buildTagTableEditorPanel();
        JPanel buttonPanel = this.buildButtonsPanel();
        GridBagConstraints gc = new GridBagConstraints();
        gc.fill = 3;
        gc.weightx = 0.0;
        gc.weighty = 1.0;
        gc.anchor = 18;
        this.add((Component)buttonPanel, gc);
        gc.gridx = 1;
        gc.fill = 1;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        gc.anchor = 10;
        this.add((Component)tablePanel, gc);
    }

    public TagEditorPanel() {
        this.build();
    }

    public TagEditorModel getModel() {
        return this.model;
    }

    public void initAutoCompletion(OsmDataLayer layer) {
        this.acCache = AutoCompletionCache.getCacheForLayer(layer);
        this.acCache.initFromDataSet();
        this.acList = new AutoCompletionList();
        TagCellEditor editor = (TagCellEditor)this.tagTable.getColumnModel().getColumn(0).getCellEditor();
        editor.setAutoCompletionCache(this.acCache);
        editor.setAutoCompletionList(this.acList);
        editor = (TagCellEditor)this.tagTable.getColumnModel().getColumn(1).getCellEditor();
        editor.setAutoCompletionCache(this.acCache);
        editor.setAutoCompletionList(this.acList);
    }

    public void setEnabled(boolean enabled) {
        this.tagTable.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    class DeleteAction
    extends AbstractAction
    implements ListSelectionListener,
    PropertyChangeListener {
        public DeleteAction() {
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "delete"));
            this.putValue("ShortDescription", I18n.tr("Delete the selection in the tag table"));
            this.updateEnabledState();
        }

        public void actionPerformed(ActionEvent e) {
            this.run();
        }

        protected void deleteTagNames() {
            int[] rows = TagEditorPanel.this.tagTable.getSelectedRows();
            TagEditorPanel.this.model.deleteTagNames(rows);
        }

        protected void deleteTagValues() {
            int[] rows = TagEditorPanel.this.tagTable.getSelectedRows();
            TagEditorPanel.this.model.deleteTagValues(rows);
        }

        protected void deleteTags() {
            TagEditorPanel.this.model.deleteTags(TagEditorPanel.this.tagTable.getSelectedRows());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void run() {
            if (!this.isEnabled()) {
                return;
            }
            if (TagEditorPanel.this.tagTable.getSelectedColumnCount() == 1) {
                if (TagEditorPanel.this.tagTable.getSelectedColumn() == 0) {
                    this.deleteTagNames();
                } else {
                    if (TagEditorPanel.this.tagTable.getSelectedColumn() != 1) throw new IllegalStateException("unexpected selected column: getSelectedColumn() is " + TagEditorPanel.this.tagTable.getSelectedColumn());
                    this.deleteTagValues();
                }
            } else if (TagEditorPanel.this.tagTable.getSelectedColumnCount() == 2) {
                this.deleteTags();
            }
            if (TagEditorPanel.this.model.getRowCount() != 0) return;
            TagEditorPanel.this.model.ensureOneTag();
        }

        public void updateEnabledState() {
            this.setEnabled(TagEditorPanel.this.tagTable.isEnabled() && (TagEditorPanel.this.tagTable.getSelectedRowCount() > 0 || TagEditorPanel.this.tagTable.getSelectedColumnCount() > 0));
        }

        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState();
        }

        public void propertyChange(PropertyChangeEvent evt) {
            this.updateEnabledState();
        }
    }

    class AddAction
    extends AbstractAction
    implements PropertyChangeListener {
        public AddAction() {
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "add"));
            this.putValue("ShortDescription", I18n.tr("Add a new tag"));
            this.updateEnabledState();
        }

        public void actionPerformed(ActionEvent e) {
            TagEditorPanel.this.model.appendNewTag();
        }

        protected void updateEnabledState() {
            this.setEnabled(TagEditorPanel.this.tagTable.isEnabled());
        }

        public void propertyChange(PropertyChangeEvent evt) {
            this.updateEnabledState();
        }
    }
}

