/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.QuadStateCheckBox;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.tagging.AutoCompletingTextField;
import org.openstreetmap.josm.gui.tagging.TaggingPresetMenu;
import org.openstreetmap.josm.gui.tagging.TaggingPresetSeparator;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionCache;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionItemPritority;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionList;
import org.openstreetmap.josm.io.MirroredInputStream;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.UrlLabel;
import org.openstreetmap.josm.tools.XmlObjectParser;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaggingPreset
extends AbstractAction
implements Layer.LayerChangeListener {
    public TaggingPresetMenu group = null;
    public String name;
    public String name_context;
    public String locale_name;
    public static final String OPTIONAL_TOOLTIP_TEXT = "Optional tooltip text";
    public static final String DIFFERENT = I18n.tr("<different>");
    public List<String> types;
    public List<Item> data = new LinkedList<Item>();
    private static HashMap<String, String> lastValue = new HashMap();
    private static Collection<String> allowedtypes = Arrays.asList(I18n.marktr("way"), I18n.marktr("node"), I18n.marktr("relation"), I18n.marktr("closedway"));
    private boolean originalSelectionEmpty = false;

    static Usage determineTextUsage(Collection<OsmPrimitive> sel, String key) {
        Usage returnValue = new Usage();
        returnValue.values = new TreeSet();
        for (OsmPrimitive s : sel) {
            String v = s.get(key);
            if (v != null) {
                returnValue.values.add(v);
            } else {
                returnValue.hadEmpty = true;
            }
            returnValue.hadKeys = !returnValue.values.isEmpty() | returnValue.hadEmpty;
        }
        return returnValue;
    }

    static Usage determineBooleanUsage(Collection<OsmPrimitive> sel, String key) {
        Usage returnValue = new Usage();
        returnValue.values = new TreeSet();
        for (OsmPrimitive s : sel) {
            String booleanValue = OsmUtils.getNamedOsmBoolean(s.get(key));
            if (booleanValue == null) continue;
            returnValue.values.add(booleanValue);
        }
        return returnValue;
    }

    public TaggingPreset() {
        Layer.listeners.add(this);
        this.updateEnabledState();
    }

    public void setDisplayName() {
        this.putValue("Name", this.getName());
        this.putValue("toolbar", "tagging_" + this.getRawName());
    }

    public String getLocaleName() {
        if (this.locale_name == null) {
            this.locale_name = this.name_context != null ? I18n.trc(this.name_context, this.name) : I18n.tr(this.name);
        }
        return this.locale_name;
    }

    public String getName() {
        return this.group != null ? this.group.getName() + "/" + this.getLocaleName() : this.getLocaleName();
    }

    public String getRawName() {
        return this.group != null ? this.group.getRawName() + "/" + this.name : this.name;
    }

    public void setIcon(String iconName) {
        Collection<String> s = Main.pref.getCollection("taggingpreset.icon.sources", null);
        ImageIcon icon = ImageProvider.getIfAvailable(s, "presets", null, iconName);
        if (icon == null) {
            System.out.println("Could not get presets icon " + iconName);
            icon = new ImageIcon(iconName);
        }
        if (Math.max(icon.getIconHeight(), icon.getIconWidth()) != 16) {
            icon = new ImageIcon(icon.getImage().getScaledInstance(16, 16, 4));
        }
        this.putValue("SmallIcon", icon);
    }

    public void setType(String types) throws SAXException {
        this.types = Arrays.asList(types.split(","));
        for (String type : this.types) {
            if (allowedtypes.contains(type)) continue;
            throw new SAXException(I18n.tr("Unknown type: {0}", type));
        }
    }

    public static List<TaggingPreset> readAll(Reader in) throws SAXException {
        XmlObjectParser parser = new XmlObjectParser();
        parser.mapOnStart("item", TaggingPreset.class);
        parser.mapOnStart("separator", TaggingPresetSeparator.class);
        parser.mapBoth("group", TaggingPresetMenu.class);
        parser.map("text", Text.class);
        parser.map("link", Link.class);
        parser.mapOnStart("optional", Optional.class);
        parser.map("check", Check.class);
        parser.map("combo", Combo.class);
        parser.map("label", Label.class);
        parser.map("space", Space.class);
        parser.map("key", Key.class);
        LinkedList<TaggingPreset> all = new LinkedList<TaggingPreset>();
        TaggingPreset lastmenu = null;
        parser.start(in);
        while (parser.hasNext()) {
            TaggingPreset tp;
            Object o = parser.next();
            if (o instanceof TaggingPresetMenu) {
                tp = (TaggingPresetMenu)o;
                if (tp == lastmenu) {
                    lastmenu = ((TaggingPresetMenu)tp).group;
                    continue;
                }
                ((TaggingPresetMenu)tp).group = lastmenu;
                ((TaggingPresetMenu)tp).setDisplayName();
                lastmenu = tp;
                all.add(tp);
                Main.toolbar.register(tp);
                continue;
            }
            if (o instanceof TaggingPresetSeparator) {
                tp = (TaggingPresetSeparator)o;
                ((TaggingPresetSeparator)tp).group = lastmenu;
                all.add(tp);
                continue;
            }
            if (o instanceof TaggingPreset) {
                tp = (TaggingPreset)o;
                tp.group = lastmenu;
                tp.setDisplayName();
                all.add(tp);
                Main.toolbar.register(tp);
                continue;
            }
            all.getLast().data.add((Item)o);
        }
        return all;
    }

    public static Collection<TaggingPreset> readFromPreferences() {
        LinkedList<TaggingPreset> allPresets = new LinkedList<TaggingPreset>();
        LinkedList<String> sources = new LinkedList<String>();
        if (Main.pref.getBoolean("taggingpreset.enable-defaults", true)) {
            sources.add("resource://presets/presets.xml");
        }
        sources.addAll(Main.pref.getCollection("taggingpreset.sources", new LinkedList<String>()));
        for (String source : sources) {
            try {
                InputStreamReader r;
                MirroredInputStream s = new MirroredInputStream(source);
                try {
                    r = new InputStreamReader((InputStream)s, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    r = new InputStreamReader(s);
                }
                allPresets.addAll(TaggingPreset.readAll(new BufferedReader(r)));
            }
            catch (IOException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Could not read tagging preset source: {0}", source), I18n.tr("Error"), 0);
            }
            catch (SAXException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Error parsing {0}: ", source) + e.getMessage(), I18n.tr("Error"), 0);
            }
        }
        return allPresets;
    }

    public PresetPanel createPanel(Collection<OsmPrimitive> selected) {
        if (this.data == null) {
            return null;
        }
        OsmDataLayer layer = Main.main.getEditLayer();
        if (layer != null) {
            AutoCompletionCache.getCacheForLayer(layer).initFromDataSet();
        }
        PresetPanel p = new PresetPanel();
        LinkedList<Item> l = new LinkedList<Item>();
        if (this.types != null) {
            JPanel pp = new JPanel();
            for (String t : this.types) {
                JLabel la = new JLabel(ImageProvider.get("Mf_" + t));
                la.setToolTipText(I18n.tr("Elements of type {0} are supported.", I18n.tr(t)));
                pp.add(la);
            }
            p.add((Component)pp, GBC.eol());
        }
        for (Item i : this.data) {
            if (i instanceof Link) {
                l.add(i);
                continue;
            }
            if (!i.addToPanel(p, selected)) continue;
            p.hasElements = true;
        }
        for (Item link : l) {
            link.addToPanel(p, selected);
        }
        return p;
    }

    public boolean isShowable() {
        for (Item i : this.data) {
            if (i instanceof Optional || i instanceof Space || i instanceof Key) continue;
            return true;
        }
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Command cmd;
        if (Main.main == null) {
            return;
        }
        if (Main.main.getCurrentDataSet() == null) {
            return;
        }
        Collection<OsmPrimitive> sel = this.createSelection(Main.main.getCurrentDataSet().getSelected());
        PresetPanel p = this.createPanel(sel);
        if (p == null) {
            return;
        }
        int answer = 1;
        if (p.getComponentCount() != 0 && (sel.size() == 0 || p.hasElements)) {
            String title = I18n.trn("Change {0} object", "Change {0} objects", sel.size(), sel.size());
            if (sel.size() == 0) {
                title = this.originalSelectionEmpty ? I18n.tr("Nothing selected!") : I18n.tr("Selection unsuitable!");
            }
            class PresetDialog
            extends ExtendedDialog {
                public PresetDialog(Component content, String title, boolean disableApply) {
                    super(Main.parent, title, new String[]{I18n.tr("Apply Preset"), I18n.tr("Cancel")}, true);
                    this.contentConstraints = GBC.eol().fill().insets(5, 10, 5, 0);
                    this.setButtonIcons(new String[]{"ok.png", "cancel.png"});
                    this.setContent(content);
                    this.setupDialog();
                    ((JButton)this.buttons.get(0)).setEnabled(!disableApply);
                    ((JButton)this.buttons.get(0)).setToolTipText(title);
                    this.setVisible(true);
                }
            }
            answer = new PresetDialog(p, title, sel.size() == 0).getValue();
        }
        if (sel.size() != 0 && answer == 1 && (cmd = this.createCommand(sel)) != null) {
            Main.main.undoRedo.add(cmd);
        }
        Main.main.getCurrentDataSet().setSelected(Main.main.getCurrentDataSet().getSelected());
    }

    private Collection<OsmPrimitive> createSelection(Collection<OsmPrimitive> participants) {
        this.originalSelectionEmpty = participants.size() == 0;
        LinkedList<OsmPrimitive> sel = new LinkedList<OsmPrimitive>();
        for (OsmPrimitive osm : participants) {
            if (this.types != null && (osm instanceof Relation ? !this.types.contains("relation") : (osm instanceof Node ? !this.types.contains("node") : osm instanceof Way && !this.types.contains("way") && (!this.types.contains("closedway") || !((Way)osm).isClosed())))) continue;
            sel.add(osm);
        }
        return sel;
    }

    private Command createCommand(Collection<OsmPrimitive> sel) {
        LinkedList<Command> cmds = new LinkedList<Command>();
        for (Item i : this.data) {
            i.addCommands(sel, cmds);
        }
        if (cmds.size() == 0) {
            return null;
        }
        if (cmds.size() == 1) {
            return (Command)cmds.get(0);
        }
        return new SequenceCommand(I18n.tr("Change Properties"), cmds);
    }

    protected void updateEnabledState() {
        this.setEnabled(Main.main != null && Main.main.getCurrentDataSet() != null);
    }

    @Override
    public void activeLayerChange(Layer oldLayer, Layer newLayer) {
        this.updateEnabledState();
    }

    @Override
    public void layerAdded(Layer newLayer) {
        this.updateEnabledState();
    }

    @Override
    public void layerRemoved(Layer oldLayer) {
        this.updateEnabledState();
    }

    private class PresetPanel
    extends JPanel {
        boolean hasElements;

        PresetPanel() {
            super(new GridBagLayout());
            this.hasElements = false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Key
    extends Item {
        public String key;
        public String value;

        @Override
        public boolean addToPanel(JPanel p, Collection<OsmPrimitive> sel) {
            return false;
        }

        @Override
        public void addCommands(Collection<OsmPrimitive> sel, List<Command> cmds) {
            cmds.add(new ChangePropertyCommand(sel, this.key, this.value != null && !this.value.equals("") ? this.value : null));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Space
    extends Item {
        @Override
        public boolean addToPanel(JPanel p, Collection<OsmPrimitive> sel) {
            p.add((Component)new JLabel(" "), GBC.eol());
            return false;
        }

        @Override
        public void addCommands(Collection<OsmPrimitive> sel, List<Command> cmds) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Optional
    extends Item {
        @Override
        public boolean addToPanel(JPanel p, Collection<OsmPrimitive> sel) {
            p.add((Component)new JLabel(" "), GBC.eol());
            p.add((Component)new JLabel(I18n.tr("Optional Attributes:")), GBC.eol());
            p.add((Component)new JLabel(" "), GBC.eol());
            return false;
        }

        @Override
        public void addCommands(Collection<OsmPrimitive> sel, List<Command> cmds) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Link
    extends Item {
        public String href;
        public String text;
        public String text_context;
        public String locale_text;
        public String locale_href;

        @Override
        public boolean addToPanel(JPanel p, Collection<OsmPrimitive> sel) {
            String url;
            if (this.locale_text == null) {
                this.locale_text = this.text == null ? I18n.tr("More information about this feature") : (this.text_context != null ? I18n.trc(this.text_context, this.text) : I18n.tr(this.text));
            }
            if ((url = this.locale_href) == null) {
                url = this.href;
            }
            if (url != null) {
                p.add((Component)new UrlLabel(url, this.locale_text), GBC.eol().anchor(17));
            }
            return false;
        }

        @Override
        public void addCommands(Collection<OsmPrimitive> sel, List<Command> cmds) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Label
    extends Item {
        public String text;
        public String text_context;
        public String locale_text;

        @Override
        public boolean addToPanel(JPanel p, Collection<OsmPrimitive> sel) {
            if (this.locale_text == null) {
                this.locale_text = this.text_context != null ? I18n.trc(this.text_context, this.text) : I18n.tr(this.text);
            }
            p.add((Component)new JLabel(this.locale_text), GBC.eol());
            return false;
        }

        @Override
        public void addCommands(Collection<OsmPrimitive> sel, List<Command> cmds) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Combo
    extends Item {
        public String key;
        public String text;
        public String text_context;
        public String locale_text;
        public String values;
        public String values_context;
        public String display_values;
        public String locale_display_values;
        public String default_;
        public boolean delete_if_empty = false;
        public boolean editable = true;
        public boolean use_last_as_default = false;
        private JComboBox combo;
        private LinkedHashMap<String, String> lhm;
        private Usage usage;
        private String originalValue;

        @Override
        public boolean addToPanel(JPanel p, Collection<OsmPrimitive> sel) {
            this.usage = TaggingPreset.determineTextUsage(sel, this.key);
            String[] value_array = this.values.split(",");
            String[] display_array = this.locale_display_values != null ? this.locale_display_values.split(",") : (this.display_values != null ? this.display_values.split(",") : value_array);
            this.lhm = new LinkedHashMap();
            if (!this.usage.hasUniqueValue() && !this.usage.unused()) {
                this.lhm.put(DIFFERENT, DIFFERENT);
            }
            for (int i = 0; i < value_array.length; ++i) {
                this.lhm.put(value_array[i], this.locale_display_values == null ? (this.values_context == null ? I18n.tr(display_array[i]) : I18n.tr(this.values_context, display_array[i])) : display_array[i]);
            }
            if (!this.usage.unused()) {
                for (String s : this.usage.values) {
                    if (this.lhm.containsKey(s)) continue;
                    this.lhm.put(s, s);
                }
            }
            if (this.default_ != null && !this.lhm.containsKey(this.default_)) {
                this.lhm.put(this.default_, this.default_);
            }
            if (!this.lhm.containsKey("")) {
                this.lhm.put("", "");
            }
            this.combo = new JComboBox<Object>(this.lhm.values().toArray());
            this.combo.setEditable(this.editable);
            AutoCompletingTextField tf = new AutoCompletingTextField();
            this.initAutoCompletionField(tf, this.key);
            tf.getAutoCompletionList().add(Arrays.asList(display_array), AutoCompletionItemPritority.IS_IN_STANDARD);
            this.combo.setEditor(tf);
            if (this.usage.hasUniqueValue() && !this.usage.unused()) {
                this.originalValue = this.usage.getFirst();
                this.combo.setSelectedItem(this.lhm.get(this.originalValue));
            } else if (this.default_ != null && !this.usage.hadKeys()) {
                this.combo.setSelectedItem(this.default_);
                this.originalValue = DIFFERENT;
            } else if (this.usage.unused()) {
                this.combo.setSelectedItem("");
                this.originalValue = "";
            } else {
                this.combo.setSelectedItem(DIFFERENT);
                this.originalValue = DIFFERENT;
            }
            if (this.locale_text == null) {
                this.locale_text = this.text_context != null ? I18n.trc(this.text_context, this.text) : I18n.tr(this.text);
            }
            p.add((Component)new JLabel(this.locale_text + ":"), GBC.std().insets(0, 0, 10, 0));
            p.add((Component)this.combo, GBC.eol().fill(2));
            return true;
        }

        @Override
        public void addCommands(Collection<OsmPrimitive> sel, List<Command> cmds) {
            Object obj = this.combo.getSelectedItem();
            String display = obj == null ? null : obj.toString();
            String value = null;
            if (display == null && this.combo.isEditable()) {
                display = this.combo.getEditor().getItem().toString();
            }
            if (display != null) {
                for (String key : this.lhm.keySet()) {
                    String k = this.lhm.get(key);
                    if (k == null || !k.equals(display)) continue;
                    value = key;
                }
                if (value == null) {
                    value = display;
                }
            } else {
                value = "";
            }
            if (value.equals(this.originalValue) || this.originalValue == null && value.length() == 0) {
                return;
            }
            if (this.delete_if_empty && value.length() == 0) {
                value = null;
            }
            cmds.add(new ChangePropertyCommand(sel, this.key, value));
        }

        @Override
        boolean requestFocusInWindow() {
            return this.combo.requestFocusInWindow();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Check
    extends Item {
        public String key;
        public String text;
        public String text_context;
        public String locale_text;
        public boolean default_ = false;
        public boolean use_last_as_default = false;
        private QuadStateCheckBox check;
        private QuadStateCheckBox.State initialState;
        private boolean def;

        @Override
        public boolean addToPanel(JPanel p, Collection<OsmPrimitive> sel) {
            Usage usage = TaggingPreset.determineBooleanUsage(sel, this.key);
            this.def = this.default_;
            if (this.locale_text == null) {
                this.locale_text = this.text_context != null ? I18n.trc(this.text_context, this.text) : I18n.tr(this.text);
            }
            String oneValue = null;
            Iterator<Object> i$ = usage.values.iterator();
            while (i$.hasNext()) {
                String string;
                oneValue = string = i$.next();
            }
            if (usage.values.size() < 2 && (oneValue == null || "yes".equals(oneValue) || "no".equals(oneValue))) {
                if (this.def) {
                    for (OsmPrimitive osmPrimitive : sel) {
                        if (!osmPrimitive.hasKeys()) continue;
                        this.def = false;
                    }
                }
                this.initialState = "yes".equals(oneValue) ? QuadStateCheckBox.State.SELECTED : ("no".equals(oneValue) ? QuadStateCheckBox.State.NOT_SELECTED : (this.def ? QuadStateCheckBox.State.SELECTED : QuadStateCheckBox.State.UNSET));
                this.check = new QuadStateCheckBox(this.locale_text, this.initialState, new QuadStateCheckBox.State[]{QuadStateCheckBox.State.SELECTED, QuadStateCheckBox.State.NOT_SELECTED, QuadStateCheckBox.State.UNSET});
            } else {
                this.def = false;
                this.initialState = QuadStateCheckBox.State.PARTIAL;
                this.check = new QuadStateCheckBox(this.locale_text, QuadStateCheckBox.State.PARTIAL, new QuadStateCheckBox.State[]{QuadStateCheckBox.State.PARTIAL, QuadStateCheckBox.State.SELECTED, QuadStateCheckBox.State.NOT_SELECTED, QuadStateCheckBox.State.UNSET});
            }
            p.add((Component)this.check, GBC.eol().fill(2));
            return true;
        }

        @Override
        public void addCommands(Collection<OsmPrimitive> sel, List<Command> cmds) {
            if (this.check.getState() == this.initialState && !this.def) {
                return;
            }
            cmds.add(new ChangePropertyCommand(sel, this.key, this.check.getState() == QuadStateCheckBox.State.SELECTED ? "yes" : (this.check.getState() == QuadStateCheckBox.State.NOT_SELECTED ? "no" : null)));
        }

        @Override
        boolean requestFocusInWindow() {
            return this.check.requestFocusInWindow();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Text
    extends Item {
        public String key;
        public String text;
        public String locale_text;
        public String text_context;
        public String default_;
        public String originalValue;
        public boolean use_last_as_default = false;
        public boolean delete_if_empty = false;
        private JComponent value;

        @Override
        public boolean addToPanel(JPanel p, Collection<OsmPrimitive> sel) {
            Usage usage = TaggingPreset.determineTextUsage(sel, this.key);
            AutoCompletingTextField textField = new AutoCompletingTextField();
            this.initAutoCompletionField(textField, this.key);
            if (usage.unused()) {
                if (this.use_last_as_default && lastValue.containsKey(this.key)) {
                    textField.setText((String)lastValue.get(this.key));
                } else {
                    textField.setText(this.default_);
                }
                this.value = textField;
                this.originalValue = null;
            } else if (usage.hasUniqueValue()) {
                textField.setText(usage.getFirst());
                this.value = textField;
                this.originalValue = usage.getFirst();
            } else {
                JComboBox<Object> comboBox = new JComboBox<Object>(usage.values.toArray());
                comboBox.setEditable(true);
                comboBox.setEditor(textField);
                comboBox.getEditor().setItem(DIFFERENT);
                this.value = comboBox;
                this.originalValue = DIFFERENT;
            }
            if (this.locale_text == null) {
                this.locale_text = this.text_context != null ? I18n.trc(this.text_context, this.text) : I18n.tr(this.text);
            }
            p.add((Component)new JLabel(this.locale_text + ":"), GBC.std().insets(0, 0, 10, 0));
            p.add((Component)this.value, GBC.eol().fill(2));
            return true;
        }

        @Override
        public void addCommands(Collection<OsmPrimitive> sel, List<Command> cmds) {
            String v;
            String string = v = this.value instanceof JComboBox ? ((JComboBox)this.value).getEditor().getItem().toString() : ((JTextField)this.value).getText();
            if (this.use_last_as_default) {
                lastValue.put(this.key, v);
            }
            if (v.equals(this.originalValue) || this.originalValue == null && v.length() == 0) {
                return;
            }
            if (this.delete_if_empty && v.length() == 0) {
                v = null;
            }
            cmds.add(new ChangePropertyCommand(sel, this.key, v));
        }

        @Override
        boolean requestFocusInWindow() {
            return this.value.requestFocusInWindow();
        }
    }

    public static class Usage {
        TreeSet<String> values;
        boolean hadKeys = false;
        boolean hadEmpty = false;

        public boolean hasUniqueValue() {
            return this.values.size() == 1 && !this.hadEmpty;
        }

        public boolean unused() {
            return this.values.size() == 0;
        }

        public String getFirst() {
            return this.values.first();
        }

        public boolean hadKeys() {
            return this.hadKeys;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Item {
        public boolean focus = false;

        protected void initAutoCompletionField(AutoCompletingTextField field, String key) {
            OsmDataLayer layer = Main.main.getEditLayer();
            if (layer == null) {
                return;
            }
            AutoCompletionList list = new AutoCompletionList();
            List<String> values = AutoCompletionCache.getCacheForLayer(Main.main.getEditLayer()).getValues(key);
            list.add(values, AutoCompletionItemPritority.IS_IN_DATASET);
            field.setAutoCompletionList(list);
        }

        abstract boolean addToPanel(JPanel var1, Collection<OsmPrimitive> var2);

        abstract void addCommands(Collection<OsmPrimitive> var1, List<Command> var2);

        boolean requestFocusInWindow() {
            return false;
        }
    }
}

