/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.widgets;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import org.openstreetmap.josm.gui.widgets.HistoryChangedListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComboBoxHistory
extends DefaultComboBoxModel
implements Iterable<String> {
    private int maxSize = 10;
    private List<HistoryChangedListener> listeners = new ArrayList<HistoryChangedListener>();

    public ComboBoxHistory(int size) {
        this.maxSize = size;
    }

    @Override
    public void addElement(Object o) {
        String newEntry = (String)o;
        for (int i = 0; i < this.getSize(); ++i) {
            String oldEntry = (String)this.getElementAt(i);
            if (!oldEntry.equals(newEntry)) continue;
            this.removeElementAt(i);
        }
        this.insertElementAt(o, 0);
        if (this.getSize() > this.maxSize) {
            this.removeElementAt(this.getSize() - 1);
        }
        this.setSelectedItem(o);
        this.fireHistoryChanged();
    }

    @Override
    public Iterator<String> iterator() {
        return new Iterator<String>(){
            private int position = -1;

            @Override
            public void remove() {
                ComboBoxHistory.this.removeElementAt(this.position);
            }

            @Override
            public boolean hasNext() {
                return this.position < ComboBoxHistory.this.getSize() - 1 && ComboBoxHistory.this.getSize() > 0;
            }

            @Override
            public String next() {
                ++this.position;
                return ComboBoxHistory.this.getElementAt(this.position).toString();
            }
        };
    }

    public void setItems(List<String> items) {
        this.removeAllElements();
        Collections.reverse(items);
        for (String item : items) {
            this.addElement(item);
        }
        Collections.reverse(items);
    }

    public List<String> asList() {
        ArrayList<String> list = new ArrayList<String>(this.maxSize);
        for (String item : this) {
            list.add(item);
        }
        return list;
    }

    public void addHistoryChangedListener(HistoryChangedListener l) {
        this.listeners.add(l);
    }

    public void removeHistoryChangedListener(HistoryChangedListener l) {
        this.listeners.remove(l);
    }

    private void fireHistoryChanged() {
        for (HistoryChangedListener l : this.listeners) {
            l.historyChanged(this.asList());
        }
    }
}

