/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.util.Date;
import org.openstreetmap.josm.data.coor.CoordinateFormat;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.tools.DateUtils;
import org.openstreetmap.josm.tools.I18n;

public class ChangesetQuery {
    private Long user = null;
    private LatLon min = null;
    private LatLon max = null;
    private Date closedAfter = null;
    private Date createdBefore = null;
    private Boolean open = null;
    private Boolean closed = null;

    public ChangesetQuery forUser(long uid) {
        if (uid <= 0L) {
            throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' > 0 expected. Got ''{1}''.", "uid", uid));
        }
        this.user = uid;
        return this;
    }

    public ChangesetQuery inBbox(double minLon, double minLat, double maxLon, double maxLat) {
        return this.inBbox(new LatLon(minLon, minLat), new LatLon(maxLon, maxLat));
    }

    public ChangesetQuery inBbox(LatLon min, LatLon max) {
        this.min = min;
        this.max = max;
        return this;
    }

    public ChangesetQuery closedAfter(Date d) {
        this.closedAfter = d;
        return this;
    }

    public ChangesetQuery between(Date closedAfter, Date createdBefore) {
        this.closedAfter = closedAfter;
        this.createdBefore = createdBefore;
        return this;
    }

    public ChangesetQuery beingOpen() {
        this.open = true;
        this.closed = null;
        return this;
    }

    public ChangesetQuery beingClosed() {
        this.open = null;
        this.closed = true;
        return this;
    }

    public String getQueryString() {
        StringBuffer sb = new StringBuffer();
        if (this.user != null) {
            sb.append("user").append("=").append(this.user);
        }
        if (this.min != null && this.max != null) {
            if (sb.length() > 0) {
                sb.append("&");
            }
            sb.append("min_lon").append("=").append(this.min.lonToString(CoordinateFormat.DECIMAL_DEGREES));
            sb.append("&");
            sb.append("min_lat").append("=").append(this.min.latToString(CoordinateFormat.DECIMAL_DEGREES));
            sb.append("&");
            sb.append("max_lon").append("=").append(this.max.lonToString(CoordinateFormat.DECIMAL_DEGREES));
            sb.append("&");
            sb.append("max_lat").append("=").append(this.max.latToString(CoordinateFormat.DECIMAL_DEGREES));
        }
        if (this.closedAfter != null && this.createdBefore != null) {
            if (sb.length() > 0) {
                sb.append("&");
            }
            sb.append("time").append("=").append(DateUtils.fromDate(this.closedAfter)).append(",").append(DateUtils.fromDate(this.createdBefore));
        } else if (this.closedAfter != null) {
            if (sb.length() > 0) {
                sb.append("&");
            }
            sb.append("time").append("=").append(DateUtils.fromDate(this.closedAfter));
        }
        if (this.open != null) {
            if (sb.length() > 0) {
                sb.append("&");
            }
            sb.append("open=true");
        } else if (this.closed != null) {
            if (sb.length() > 0) {
                sb.append("&");
            }
            sb.append("closed=true");
        }
        return sb.toString();
    }
}

