/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.util.Collection;
import java.util.LinkedList;
import java.util.logging.Logger;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OsmServerWriter {
    private static final Logger logger = Logger.getLogger(OsmServerWriter.class.getName());
    private Collection<OsmPrimitive> processed;
    private OsmApi api = OsmApi.getOsmApi();
    private static final int MSECS_PER_SECOND = 1000;
    private static final int SECONDS_PER_MINUTE = 60;
    private static final int MSECS_PER_MINUTE = 60000;
    long uploadStartTime;

    public String timeLeft(int progress, int list_size) {
        long now = System.currentTimeMillis();
        long elapsed = now - this.uploadStartTime;
        if (elapsed == 0L) {
            elapsed = 1L;
        }
        float uploads_per_ms = (float)progress / (float)elapsed;
        float uploads_left = list_size - progress;
        int ms_left = (int)(uploads_left / uploads_per_ms);
        int minutes_left = ms_left / 60000;
        int seconds_left = ms_left / 1000 % 60;
        String time_left_str = Integer.toString(minutes_left) + ":";
        if (seconds_left < 10) {
            time_left_str = time_left_str + "0";
        }
        time_left_str = time_left_str + Integer.toString(seconds_left);
        return time_left_str;
    }

    protected void uploadChangesIndividually(Collection<OsmPrimitive> primitives, ProgressMonitor progressMonitor) throws OsmTransferException {
        try {
            progressMonitor.beginTask(I18n.tr("Starting to upload with one request per primitive ..."));
            progressMonitor.setTicksCount(primitives.size());
            this.uploadStartTime = System.currentTimeMillis();
            for (OsmPrimitive osm : primitives) {
                int progress = progressMonitor.getTicks();
                String time_left_str = this.timeLeft(progress, primitives.size());
                String msg = "";
                switch (OsmPrimitiveType.from(osm)) {
                    case NODE: {
                        msg = I18n.marktr("{0}% ({1}/{2}), {3} left. Uploading node ''{4}'' (id: {5})");
                        break;
                    }
                    case WAY: {
                        msg = I18n.marktr("{0}% ({1}/{2}), {3} left. Uploading way ''{4}'' (id: {5})");
                        break;
                    }
                    case RELATION: {
                        msg = I18n.marktr("{0}% ({1}/{2}), {3} left. Uploading relation ''{4}'' (id: {5})");
                    }
                }
                progressMonitor.subTask(I18n.tr(msg, Math.round(100.0 * (double)progress / (double)primitives.size()), progress, primitives.size(), time_left_str, osm.getName() == null ? Long.valueOf(osm.getId()) : osm.getName(), osm.getId()));
                this.makeApiRequest(osm, progressMonitor);
                this.processed.add(osm);
                progressMonitor.worked(1);
            }
        }
        catch (OsmTransferException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OsmTransferException(e);
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    protected void uploadChangesAsDiffUpload(Collection<OsmPrimitive> primitives, ProgressMonitor progressMonitor) throws OsmTransferException {
        try {
            progressMonitor.beginTask(I18n.tr("Starting to upload in one request ..."));
            this.processed.addAll(this.api.uploadDiff(primitives, progressMonitor.createSubTaskMonitor(-1, false)));
        }
        catch (OsmTransferException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OsmTransferException(e);
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    public void uploadOsm(String apiVersion, Collection<OsmPrimitive> primitives, Changeset changeset, ProgressMonitor monitor) throws OsmTransferException {
        if (changeset == null) {
            throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' must not be null", "changeset"));
        }
        this.processed = new LinkedList<OsmPrimitive>();
        monitor = monitor == null ? NullProgressMonitor.INSTANCE : monitor;
        monitor.beginTask(I18n.tr("Uploading data ..."));
        try {
            boolean useDiffUpload;
            this.api.initialize(monitor);
            boolean canUseDiffUpload = this.api.hasSupportForDiffUploads();
            if (apiVersion == null) {
                System.out.println(I18n.tr("WARNING: no API version defined for data to upload. Falling back to version 0.6"));
                apiVersion = "0.6";
            }
            if ((useDiffUpload = Main.pref.getBoolean("osm-server.atomic-upload", apiVersion.compareTo("0.6") >= 0)) && !canUseDiffUpload) {
                System.out.println(I18n.tr("WARNING: preference ''{0}'' or API version ''{1}'' of dataset requires to use diff uploads, but API is not able to handle them. Ignoring diff upload.", "osm-server.atomic-upload", apiVersion));
                useDiffUpload = false;
            }
            if (changeset.getId() == 0L) {
                this.api.openChangeset(changeset, monitor.createSubTaskMonitor(0, false));
            } else {
                this.api.updateChangeset(changeset, monitor.createSubTaskMonitor(0, false));
            }
            this.api.setChangeset(changeset);
            if (useDiffUpload) {
                this.uploadChangesAsDiffUpload(primitives, monitor.createSubTaskMonitor(0, false));
            } else {
                this.uploadChangesIndividually(primitives, monitor.createSubTaskMonitor(0, false));
            }
        }
        catch (OsmTransferException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OsmTransferException(e);
        }
        finally {
            monitor.finishTask();
            this.api.setChangeset(null);
        }
    }

    void makeApiRequest(OsmPrimitive osm, ProgressMonitor progressMonitor) throws OsmTransferException {
        if (osm.isDeleted()) {
            this.api.deletePrimitive(osm, progressMonitor);
        } else if (osm.isNew()) {
            this.api.createPrimitive(osm, progressMonitor);
        } else {
            this.api.modifyPrimitive(osm, progressMonitor);
        }
    }

    public void cancel() {
        if (this.api != null) {
            this.api.cancel();
        }
    }

    public Collection<OsmPrimitive> getProcessedPrimitives() {
        return this.processed;
    }
}

