/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ShowStatusReportAction;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public final class BugReportExceptionHandler
implements Thread.UncaughtExceptionHandler {
    public void uncaughtException(Thread t, Throwable e) {
        BugReportExceptionHandler.handleException(e);
    }

    public static void handleException(Throwable e) {
        e.printStackTrace();
        if (Main.parent != null) {
            if (e instanceof OutOfMemoryError) {
                JOptionPane.showMessageDialog(Main.parent, "JOSM is out of memory. Strange things may happen.\nPlease restart JOSM with the -Xmx###M option,\nwhere ### is the the number of MB assigned to JOSM (e.g. 256).\nCurrently, " + Runtime.getRuntime().maxMemory() / 1024L / 1024L + " MB are available to JOSM.", I18n.tr("Error"), 0);
                return;
            }
            if (PluginHandler.checkException(e).booleanValue()) {
                return;
            }
            Object[] options = new String[]{I18n.tr("Do nothing"), I18n.tr("Report Bug")};
            int answer = JOptionPane.showOptionDialog(Main.parent, I18n.tr("An unexpected exception occurred.\n\nThis is always a coding error. If you are running the latest\nversion of JOSM, please consider being kind and file a bug report."), I18n.tr("Unexpected Exception"), 0, 0, null, options, options[0]);
            if (answer == 1) {
                try {
                    StringWriter stack = new StringWriter();
                    e.printStackTrace(new PrintWriter(stack));
                    String text = ShowStatusReportAction.getReportHeader() + stack.getBuffer().toString();
                    JPanel p = new JPanel(new GridBagLayout());
                    p.add((Component)new JLabel("<html>" + I18n.tr("Please report a ticket at {0}", "http://josm.openstreetmap.de/newticket") + "<br>" + I18n.tr("Include your steps to get to the error (as detailed as possible)!") + "<br>" + I18n.tr("Try updating to the newest version of JOSM and all plugins before reporting a bug.") + "<br>" + I18n.tr("Be sure to include the following information:") + "</html>"), GBC.eol());
                    try {
                        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(text), new ClipboardOwner(){

                            public void lostOwnership(Clipboard clipboard, Transferable contents) {
                            }
                        });
                        p.add((Component)new JLabel(I18n.tr("(The text has already been copied to your clipboard.)")), GBC.eop());
                    }
                    catch (RuntimeException x) {
                        // empty catch block
                    }
                    JTextArea info = new JTextArea(text, 20, 60);
                    info.setCaretPosition(0);
                    info.setEditable(false);
                    p.add((Component)new JScrollPane(info), GBC.eop());
                    JOptionPane.showMessageDialog(Main.parent, p, I18n.tr("Warning"), 2);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        }
    }
}

