/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.OsmApiException;
import org.openstreetmap.josm.io.OsmApiInitializationException;
import org.openstreetmap.josm.io.OsmChangesetCloseException;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExceptionUtil {
    private ExceptionUtil() {
    }

    public static String explainOsmApiInitializationException(OsmApiInitializationException e) {
        e.printStackTrace();
        String msg = I18n.tr("<html>Failed to initialize communication with the OSM server {0}.<br>Check the server URL in your preferences and your internet connection.</html>", Main.pref.get("osm-server.url", "http://api.openstreetmap.org/api"));
        return msg;
    }

    public static String explainOsmChangesetCloseException(OsmChangesetCloseException e) {
        e.printStackTrace();
        String changsetId = e.getChangeset() == null ? I18n.tr("unknown") : Long.toString(e.getChangeset().getId());
        String msg = I18n.tr("<html>Failed to close changeset ''{0}'' on the OSM server ''{1}''.<br>The changeset will automatically be closed by the server after a timeout.</html>", changsetId, Main.pref.get("osm-server.url", "http://api.openstreetmap.org/api"));
        return msg;
    }

    public static String explainDeletedRelationStillInUse(OsmApiException e, long childRelation, long parentRelation) {
        String msg = I18n.tr("<html><strong>Failed</strong> to delete <strong>relation {0}</strong>. It is still referred to by relation {1}.<br>Please load relation {1}, remove the reference to relation {0}, and upload again.</html>", childRelation, parentRelation);
        return msg;
    }

    public static String explainPreconditionFailed(OsmApiException e) {
        String pattern;
        Pattern p;
        Matcher m;
        e.printStackTrace();
        String msg = e.getErrorHeader();
        if (msg != null && (m = (p = Pattern.compile(pattern = "Precondition failed: The relation (\\d+) is used in relation (\\d+)\\.")).matcher(msg)).matches()) {
            long childRelation = Long.parseLong(m.group(1));
            long parentRelation = Long.parseLong(m.group(2));
            return ExceptionUtil.explainDeletedRelationStillInUse(e, childRelation, parentRelation);
        }
        msg = I18n.tr("<html>Uploading to the server <strong>failed</strong> because your current<br>dataset violates a precondition.<br>The error message is:<br>{0}</html>", e.getMessage().replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;"));
        return msg;
    }

    public static String explainConflict(OsmApiException e) {
        e.printStackTrace();
        String msg = e.getErrorHeader();
        if (msg != null) {
            String pattern = "The changeset (\\d+) was closed at (.*)";
            Pattern p = Pattern.compile(pattern);
            Matcher m = p.matcher(msg);
            if (m.matches()) {
                long changesetId = Long.parseLong(m.group(1));
                SimpleDateFormat formatter = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy");
                Date closeDate = null;
                try {
                    closeDate = formatter.parse(m.group(2));
                }
                catch (ParseException ex) {
                    System.err.println(I18n.tr("Failed to parse date ''{0}'' replied by server.", m.group(2)));
                    ex.printStackTrace();
                }
                if (closeDate == null) {
                    msg = I18n.tr("<html>Closing of changeset <strong>{0}</strong> failed <br>because it has already been closed.</html>", changesetId);
                } else {
                    SimpleDateFormat dateFormat = new SimpleDateFormat();
                    msg = I18n.tr("<html>Closing of changeset <strong>{0}</strong> failed<br> because it has already been closed on {1}.</html>", changesetId, dateFormat.format(closeDate));
                }
                return msg;
            }
            msg = I18n.tr("<html>The server reported that it has detected a conflict.<br>Error message (untranslated):<br>{0}", msg);
        }
        msg = I18n.tr("<html>The server reported that it has detected a conflict.</html>");
        return msg;
    }

    public static String explainGeneric(Exception e) {
        String msg = e.getMessage();
        if (msg == null || msg.trim().equals("")) {
            msg = e.toString();
        }
        e.printStackTrace();
        return msg;
    }

    public static String explainSecurityException(OsmTransferException e) {
        String apiUrl = OsmApi.getOsmApi().getBaseUrl();
        String host = I18n.tr("unknown");
        try {
            host = new URL(apiUrl).getHost();
        }
        catch (MalformedURLException ex) {
            // empty catch block
        }
        String message = I18n.tr("<html>Failed to open a connection to the remote server<br>''{0}''<br>for security reasons. This is most likely because you are running<br>in an applet and because you didn''t load your applet from ''{1}''.</html>", apiUrl, host);
        return message;
    }

    public static String explainNestedSocketException(OsmTransferException e) {
        String apiUrl = OsmApi.getOsmApi().getBaseUrl();
        String message = I18n.tr("<html>Failed to open a connection to the remote server<br>''{0}''.<br>Please check your internet connection.</html>", apiUrl);
        e.printStackTrace();
        return message;
    }

    public static String explainNestedIOException(OsmTransferException e) {
        IOException ioe = ExceptionUtil.getNestedException(e, IOException.class);
        String apiUrl = OsmApi.getOsmApi().getBaseUrl();
        String message = I18n.tr("<html>Failed to upload data to or download data from<br>''{0}''<br>due to a problem with transferring data.<br>Details(untranslated): {1}</html>", apiUrl, ioe.getMessage());
        e.printStackTrace();
        return message;
    }

    public static String explainInternalServerError(OsmTransferException e) {
        String apiUrl = OsmApi.getOsmApi().getBaseUrl();
        String message = I18n.tr("<html>The OSM server<br>''{0}''<br>reported an internal server error.<br>This is most likely a temporary problem. Please try again later.</html>", apiUrl);
        e.printStackTrace();
        return message;
    }

    public static String explainBadRequest(OsmApiException e) {
        String apiUrl = OsmApi.getOsmApi().getBaseUrl();
        String message = I18n.tr("The OSM server ''{0}'' reported a bad request.<br>", apiUrl);
        if (e.getErrorHeader() != null && e.getErrorHeader().startsWith("The maximum bbox")) {
            message = message + "<br>" + I18n.tr("The area you tried to download is too big or your request was too large.<br>Either request a smaller area or use an export file provided by the OSM community.");
        } else if (e.getErrorHeader() != null) {
            message = message + I18n.tr("<br>Error message(untranslated): {0}", e.getErrorHeader());
        }
        message = "<html>" + message + "</html>";
        e.printStackTrace();
        return message;
    }

    public static String explainNotFound(OsmApiException e) {
        String apiUrl = OsmApi.getOsmApi().getBaseUrl();
        String message = I18n.tr("The OSM server ''{0}'' doesn''t know about an object<br>you tried to read, update, or delete. Either the respective object<br>doesn''t exist on the server or you''re using an invalid URL to access<br>it. Please carefully check the servers address ''{0}'' for typos.", apiUrl);
        message = "<html>" + message + "</html>";
        e.printStackTrace();
        return message;
    }

    public static String explainNestedUnkonwnHostException(OsmTransferException e) {
        String apiUrl = OsmApi.getOsmApi().getBaseUrl();
        String host = I18n.tr("unknown");
        try {
            host = new URL(apiUrl).getHost();
        }
        catch (MalformedURLException ex) {
            // empty catch block
        }
        String message = I18n.tr("<html>Failed to open a connection to the remote server<br>''{0}''.<br>Host name ''{1}'' couldn''t be resolved. <br>Please check the API URL in your preferences and your internet connection.</html>", apiUrl, host);
        e.printStackTrace();
        return message;
    }

    protected static <T> T getNestedException(Exception e, Class<T> nestedClass) {
        Throwable t;
        for (t = e; t != null && !nestedClass.isInstance(t); t = t.getCause()) {
        }
        if (t == null) {
            return null;
        }
        if (nestedClass.isInstance(t)) {
            return nestedClass.cast(t);
        }
        return null;
    }

    public static String explainOsmTransferException(OsmTransferException e) {
        if (ExceptionUtil.getNestedException(e, SecurityException.class) != null) {
            return ExceptionUtil.explainSecurityException(e);
        }
        if (ExceptionUtil.getNestedException(e, SocketException.class) != null) {
            return ExceptionUtil.explainNestedSocketException(e);
        }
        if (ExceptionUtil.getNestedException(e, UnknownHostException.class) != null) {
            return ExceptionUtil.explainNestedUnkonwnHostException(e);
        }
        if (ExceptionUtil.getNestedException(e, IOException.class) != null) {
            return ExceptionUtil.explainNestedIOException(e);
        }
        if (e instanceof OsmApiInitializationException) {
            return ExceptionUtil.explainOsmApiInitializationException((OsmApiInitializationException)e);
        }
        if (e instanceof OsmChangesetCloseException) {
            return ExceptionUtil.explainOsmChangesetCloseException((OsmChangesetCloseException)e);
        }
        if (e instanceof OsmApiException) {
            OsmApiException oae = (OsmApiException)e;
            if (oae.getResponseCode() == 412) {
                return ExceptionUtil.explainPreconditionFailed(oae);
            }
            if (oae.getResponseCode() == 410) {
                return ExceptionUtil.explainGoneForUnknownPrimitive(oae);
            }
            if (oae.getResponseCode() == 500) {
                return ExceptionUtil.explainInternalServerError(oae);
            }
            if (oae.getResponseCode() == 400) {
                return ExceptionUtil.explainBadRequest(oae);
            }
        }
        return ExceptionUtil.explainGeneric(e);
    }

    public static String explainGoneForUnknownPrimitive(OsmApiException e) {
        String msg = I18n.tr("<html>The server reports that an object is deleted.<br><strong>Uploading failed</strong> if you tried to update or delete this object.<br> <strong>Downloading failed</strong> if you tried to download this object.<br><br>The error message is:<br>{0}</html>", e.getMessage().replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;"));
        return msg;
    }

    public static String explainException(Exception e) {
        String msg = "";
        msg = e instanceof OsmTransferException ? ExceptionUtil.explainOsmTransferException((OsmTransferException)e) : ExceptionUtil.explainGeneric(e);
        e.printStackTrace();
        return msg;
    }
}

