/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.interceptor;

import com.sun.jmx.interceptor.MBeanServerInterceptorSupport;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.namespace.JMXNamespace;

public abstract class DispatchInterceptor<T extends MBeanServer, N extends JMXNamespace>
extends MBeanServerInterceptorSupport {
    static final QueryInvoker<ObjectName> queryNamesInvoker = new QueryInvoker<ObjectName>(){

        @Override
        Set<ObjectName> query(MBeanServer mBeanServer, ObjectName objectName, QueryExp queryExp) {
            return mBeanServer.queryNames(objectName, queryExp);
        }
    };
    static final QueryInvoker<ObjectInstance> queryMBeansInvoker = new QueryInvoker<ObjectInstance>(){

        @Override
        Set<ObjectInstance> query(MBeanServer mBeanServer, ObjectName objectName, QueryExp queryExp) {
            return mBeanServer.queryMBeans(objectName, queryExp);
        }
    };
    private final Map<String, T> handlerMap = Collections.synchronizedMap(new HashMap());

    abstract String getHandlerKey(ObjectName var1);

    abstract MBeanServer getInterceptorOrNullFor(ObjectName var1);

    abstract QueryInterceptor getInterceptorForQuery(ObjectName var1);

    abstract ObjectName getHandlerNameFor(String var1);

    abstract T createInterceptorFor(String var1, ObjectName var2, N var3, Queue<Runnable> var4);

    abstract MBeanServer getNextInterceptor();

    void interceptorReleased(T t, Queue<Runnable> queue) {
    }

    MBeanServer getInterceptorForCreate(ObjectName objectName) throws MBeanRegistrationException {
        MBeanServer mBeanServer = this.getInterceptorOrNullFor(objectName);
        if (mBeanServer == null) {
            throw new MBeanRegistrationException(new IllegalArgumentException("No such MBean handler: " + this.getHandlerKey(objectName) + " for " + objectName));
        }
        return mBeanServer;
    }

    MBeanServer getInterceptorForInstance(ObjectName objectName) throws InstanceNotFoundException {
        MBeanServer mBeanServer = this.getInterceptorOrNullFor(objectName);
        if (mBeanServer == null) {
            throw new InstanceNotFoundException(String.valueOf(objectName));
        }
        return mBeanServer;
    }

    void validateHandlerNameFor(String string, ObjectName objectName) {
        if (string == null || string.equals("")) {
            throw new IllegalArgumentException("invalid key for " + objectName + ": " + string);
        }
        ObjectName objectName2 = this.getHandlerNameFor(string);
        if (!objectName.equals(objectName2)) {
            throw new IllegalArgumentException("bad handler name: " + objectName + ". Should be: " + objectName2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInterceptorFor(ObjectName objectName, N n, Queue<Runnable> queue) {
        String string = this.getHandlerKey(objectName);
        this.validateHandlerNameFor(string, objectName);
        Map<String, T> map = this.handlerMap;
        synchronized (map) {
            MBeanServer mBeanServer = (MBeanServer)this.handlerMap.get(string);
            if (mBeanServer != null) {
                throw new IllegalArgumentException(string + ": handler already exists");
            }
            T t = this.createInterceptorFor(string, objectName, n, queue);
            this.handlerMap.put(string, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInterceptorFor(ObjectName objectName, N n, Queue<Runnable> queue) {
        MBeanServer mBeanServer;
        String string = this.getHandlerKey(objectName);
        Map<String, T> map = this.handlerMap;
        synchronized (map) {
            mBeanServer = (MBeanServer)this.handlerMap.remove(string);
        }
        this.interceptorReleased(mBeanServer, queue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    T getInterceptor(String string) {
        Map<String, T> map = this.handlerMap;
        synchronized (map) {
            return (T)((MBeanServer)this.handlerMap.get(string));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getKeys() {
        Map<String, T> map = this.handlerMap;
        synchronized (map) {
            int n = this.handlerMap.size();
            return this.handlerMap.keySet().toArray(new String[n]);
        }
    }

    @Override
    public final ObjectInstance createMBean(String string, ObjectName objectName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        return this.getInterceptorForCreate(objectName).createMBean(string, objectName);
    }

    @Override
    public final ObjectInstance createMBean(String string, ObjectName objectName, ObjectName objectName2) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        return this.getInterceptorForCreate(objectName).createMBean(string, objectName, objectName2);
    }

    @Override
    public final ObjectInstance createMBean(String string, ObjectName objectName, Object[] objectArray, String[] stringArray) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        return this.getInterceptorForCreate(objectName).createMBean(string, objectName, objectArray, stringArray);
    }

    @Override
    public final ObjectInstance createMBean(String string, ObjectName objectName, ObjectName objectName2, Object[] objectArray, String[] stringArray) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        return this.getInterceptorForCreate(objectName).createMBean(string, objectName, objectName2, objectArray, stringArray);
    }

    @Override
    public final ObjectInstance registerMBean(Object object, ObjectName objectName) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        return this.getInterceptorForCreate(objectName).registerMBean(object, objectName);
    }

    @Override
    public final void unregisterMBean(ObjectName objectName) throws InstanceNotFoundException, MBeanRegistrationException {
        this.getInterceptorForInstance(objectName).unregisterMBean(objectName);
    }

    @Override
    public final ObjectInstance getObjectInstance(ObjectName objectName) throws InstanceNotFoundException {
        return this.getInterceptorForInstance(objectName).getObjectInstance(objectName);
    }

    @Override
    public final Set<ObjectInstance> queryMBeans(ObjectName objectName, QueryExp queryExp) {
        QueryInterceptor queryInterceptor = this.getInterceptorForQuery(objectName);
        if (queryInterceptor == null) {
            return Collections.emptySet();
        }
        return queryInterceptor.queryMBeans(objectName, queryExp);
    }

    @Override
    public final Set<ObjectName> queryNames(ObjectName objectName, QueryExp queryExp) {
        QueryInterceptor queryInterceptor = this.getInterceptorForQuery(objectName);
        if (queryInterceptor == null) {
            return Collections.emptySet();
        }
        return queryInterceptor.queryNames(objectName, queryExp);
    }

    @Override
    public final boolean isRegistered(ObjectName objectName) {
        MBeanServer mBeanServer = this.getInterceptorOrNullFor(objectName);
        if (mBeanServer == null) {
            return false;
        }
        return mBeanServer.isRegistered(objectName);
    }

    @Override
    public Integer getMBeanCount() {
        return this.getNextInterceptor().getMBeanCount();
    }

    @Override
    public final Object getAttribute(ObjectName objectName, String string) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        return this.getInterceptorForInstance(objectName).getAttribute(objectName, string);
    }

    @Override
    public final AttributeList getAttributes(ObjectName objectName, String[] stringArray) throws InstanceNotFoundException, ReflectionException {
        return this.getInterceptorForInstance(objectName).getAttributes(objectName, stringArray);
    }

    @Override
    public final void setAttribute(ObjectName objectName, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        this.getInterceptorForInstance(objectName).setAttribute(objectName, attribute);
    }

    @Override
    public final AttributeList setAttributes(ObjectName objectName, AttributeList attributeList) throws InstanceNotFoundException, ReflectionException {
        return this.getInterceptorForInstance(objectName).setAttributes(objectName, attributeList);
    }

    @Override
    public final Object invoke(ObjectName objectName, String string, Object[] objectArray, String[] stringArray) throws InstanceNotFoundException, MBeanException, ReflectionException {
        return this.getInterceptorForInstance(objectName).invoke(objectName, string, objectArray, stringArray);
    }

    @Override
    public String getDefaultDomain() {
        return this.getNextInterceptor().getDefaultDomain();
    }

    @Override
    public abstract String[] getDomains();

    @Override
    public final void addNotificationListener(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException {
        this.getInterceptorForInstance(objectName).addNotificationListener(objectName, notificationListener, notificationFilter, object);
    }

    @Override
    public final void addNotificationListener(ObjectName objectName, ObjectName objectName2, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException {
        this.getInterceptorForInstance(objectName).addNotificationListener(objectName, objectName2, notificationFilter, object);
    }

    @Override
    public final void removeNotificationListener(ObjectName objectName, ObjectName objectName2) throws InstanceNotFoundException, ListenerNotFoundException {
        this.getInterceptorForInstance(objectName).removeNotificationListener(objectName, objectName2);
    }

    @Override
    public final void removeNotificationListener(ObjectName objectName, ObjectName objectName2, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException, ListenerNotFoundException {
        this.getInterceptorForInstance(objectName).removeNotificationListener(objectName, objectName2, notificationFilter, object);
    }

    @Override
    public final void removeNotificationListener(ObjectName objectName, NotificationListener notificationListener) throws InstanceNotFoundException, ListenerNotFoundException {
        this.getInterceptorForInstance(objectName).removeNotificationListener(objectName, notificationListener);
    }

    @Override
    public final void removeNotificationListener(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException, ListenerNotFoundException {
        this.getInterceptorForInstance(objectName).removeNotificationListener(objectName, notificationListener, notificationFilter, object);
    }

    @Override
    public final MBeanInfo getMBeanInfo(ObjectName objectName) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        return this.getInterceptorForInstance(objectName).getMBeanInfo(objectName);
    }

    @Override
    public final boolean isInstanceOf(ObjectName objectName, String string) throws InstanceNotFoundException {
        return this.getInterceptorForInstance(objectName).isInstanceOf(objectName, string);
    }

    @Override
    public final ClassLoader getClassLoaderFor(ObjectName objectName) throws InstanceNotFoundException {
        return this.getInterceptorForInstance(objectName).getClassLoaderFor(objectName);
    }

    @Override
    public final ClassLoader getClassLoader(ObjectName objectName) throws InstanceNotFoundException {
        return this.getInterceptorForInstance(objectName).getClassLoader(objectName);
    }

    static class QueryInterceptor {
        final MBeanServer wrapped;

        QueryInterceptor(MBeanServer mBeanServer) {
            this.wrapped = mBeanServer;
        }

        <X> Set<X> query(ObjectName objectName, QueryExp queryExp, QueryInvoker<X> queryInvoker, MBeanServer mBeanServer) {
            return queryInvoker.query(mBeanServer, objectName, queryExp);
        }

        public Set<ObjectName> queryNames(ObjectName objectName, QueryExp queryExp) {
            return this.query(objectName, queryExp, queryNamesInvoker, this.wrapped);
        }

        public Set<ObjectInstance> queryMBeans(ObjectName objectName, QueryExp queryExp) {
            return this.query(objectName, queryExp, queryMBeansInvoker, this.wrapped);
        }
    }

    static abstract class QueryInvoker<T> {
        QueryInvoker() {
        }

        abstract Set<T> query(MBeanServer var1, ObjectName var2, QueryExp var3);
    }
}

