/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.namespace;

import com.sun.jmx.defaults.JmxProperties;
import com.sun.jmx.interceptor.MBeanServerInterceptor;
import com.sun.jmx.mbeanserver.Util;
import com.sun.jmx.namespace.RoutingMBeanServerConnection;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import javax.management.loading.ClassLoaderRepository;
import javax.management.namespace.JMXNamespace;

public abstract class HandlerInterceptor<T extends JMXNamespace>
extends RoutingMBeanServerConnection<MBeanServer>
implements MBeanServerInterceptor {
    private static final Logger LOG = JmxProperties.NAMESPACE_LOGGER;
    private final T handler;

    public HandlerInterceptor(T t) {
        if (t == null) {
            throw new IllegalArgumentException("null");
        }
        this.handler = t;
    }

    @Override
    protected MBeanServer source() {
        return ((JMXNamespace)this.handler).getSourceServer();
    }

    MBeanServer getServerForLoading() {
        return this.source();
    }

    T getHandlerInterceptorMBean() {
        return this.handler;
    }

    RuntimeException handleIOException(IOException iOException, String string, Object ... objectArray) {
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("IO Exception in " + string + ": " + iOException + " - " + " rethrowing as RuntimeOperationsException.");
        }
        throw new RuntimeOperationsException(Util.newRuntimeIOException(iOException));
    }

    @Override
    public AttributeList getAttributes(ObjectName objectName, String[] stringArray) throws InstanceNotFoundException, ReflectionException {
        try {
            String[] stringArray2 = this.checkAttributes(objectName, stringArray, "getAttribute");
            AttributeList attributeList = super.getAttributes(objectName, stringArray2);
            return attributeList;
        }
        catch (IOException iOException) {
            throw this.handleIOException(iOException, "getAttributes", objectName, stringArray);
        }
    }

    @Override
    public ClassLoader getClassLoaderFor(ObjectName objectName) throws InstanceNotFoundException {
        ObjectName objectName2 = this.toSourceOrRuntime(objectName);
        try {
            this.check(objectName, null, "getClassLoaderFor");
            return this.getServerForLoading().getClassLoaderFor(objectName2);
        }
        catch (RuntimeException runtimeException) {
            throw this.makeCompliantRuntimeException(runtimeException);
        }
    }

    @Override
    public ClassLoader getClassLoader(ObjectName objectName) throws InstanceNotFoundException {
        ObjectName objectName2 = this.toSourceOrRuntime(objectName);
        try {
            this.check(objectName, null, "getClassLoader");
            return this.getServerForLoading().getClassLoader(objectName2);
        }
        catch (RuntimeException runtimeException) {
            throw this.makeCompliantRuntimeException(runtimeException);
        }
    }

    @Override
    public ObjectInstance registerMBean(Object object, ObjectName objectName) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        ObjectName objectName2 = this.newSourceMBeanName(objectName);
        try {
            this.checkCreate(objectName, object.getClass().getName(), "registerMBean");
            return this.processOutputInstance(this.source().registerMBean(object, objectName2));
        }
        catch (RuntimeException runtimeException) {
            throw this.makeCompliantRuntimeException(runtimeException);
        }
    }

    @Override
    public void removeNotificationListener(ObjectName objectName, ObjectName objectName2) throws InstanceNotFoundException, ListenerNotFoundException {
        try {
            this.check(objectName, null, "removeNotificationListener");
            super.removeNotificationListener(objectName, objectName2);
        }
        catch (IOException iOException) {
            throw this.handleIOException(iOException, "removeNotificationListener", objectName, objectName2);
        }
    }

    @Override
    public String getDefaultDomain() {
        try {
            return super.getDefaultDomain();
        }
        catch (IOException iOException) {
            throw this.handleIOException(iOException, "getDefaultDomain", new Object[0]);
        }
    }

    @Override
    public String[] getDomains() {
        try {
            this.check(null, null, "getDomains");
            String[] stringArray = super.getDomains();
            return this.checkDomains(stringArray, "getDomains");
        }
        catch (IOException iOException) {
            throw this.handleIOException(iOException, "getDomains", new Object[0]);
        }
    }

    @Override
    public Integer getMBeanCount() {
        try {
            return super.getMBeanCount();
        }
        catch (IOException iOException) {
            throw this.handleIOException(iOException, "getMBeanCount", new Object[0]);
        }
    }

    @Override
    public void setAttribute(ObjectName objectName, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        try {
            this.check(objectName, attribute == null ? null : attribute.getName(), "setAttribute");
            super.setAttribute(objectName, attribute);
        }
        catch (IOException iOException) {
            throw this.handleIOException(iOException, "setAttribute", objectName, attribute);
        }
    }

    @Override
    public Set<ObjectName> queryNames(ObjectName objectName, QueryExp queryExp) {
        if (objectName == null) {
            objectName = ObjectName.WILDCARD;
        }
        try {
            this.checkPattern(objectName, null, "queryNames");
            return super.queryNames(objectName, queryExp);
        }
        catch (IOException iOException) {
            throw this.handleIOException(iOException, "queryNames", objectName, queryExp);
        }
    }

    @Override
    public Set<ObjectInstance> queryMBeans(ObjectName objectName, QueryExp queryExp) {
        if (objectName == null) {
            objectName = ObjectName.WILDCARD;
        }
        try {
            this.checkPattern(objectName, null, "queryMBeans");
            return super.queryMBeans(objectName, queryExp);
        }
        catch (IOException iOException) {
            throw this.handleIOException(iOException, "queryMBeans", objectName, queryExp);
        }
    }

    @Override
    public boolean isInstanceOf(ObjectName objectName, String string) throws InstanceNotFoundException {
        try {
            this.check(objectName, null, "isInstanceOf");
            return super.isInstanceOf(objectName, string);
        }
        catch (IOException iOException) {
            throw this.handleIOException(iOException, "isInstanceOf", objectName, string);
        }
    }

    @Override
    public ObjectInstance createMBean(String string, ObjectName objectName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        try {
            this.checkCreate(objectName, string, "instantiate");
            this.checkCreate(objectName, string, "registerMBean");
            return super.createMBean(string, objectName);
        }
        catch (IOException iOException) {
            throw this.handleIOException(iOException, "createMBean", string, objectName);
        }
    }

    @Override
    public ObjectInstance createMBean(String string, ObjectName objectName, ObjectName objectName2) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        try {
            this.checkCreate(objectName, string, "instantiate");
            this.checkCreate(objectName, string, "registerMBean");
            return super.createMBean(string, objectName, objectName2);
        }
        catch (IOException iOException) {
            throw this.handleIOException(iOException, "createMBean", string, objectName, objectName2);
        }
    }

    @Override
    public Object getAttribute(ObjectName objectName, String string) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        try {
            this.check(objectName, string, "getAttribute");
            return super.getAttribute(objectName, string);
        }
        catch (IOException iOException) {
            throw this.handleIOException(iOException, "getAttribute", objectName, string);
        }
    }

    @Override
    public void removeNotificationListener(ObjectName objectName, ObjectName objectName2, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException, ListenerNotFoundException {
        try {
            this.check(objectName, null, "removeNotificationListener");
            super.removeNotificationListener(objectName, objectName2, notificationFilter, object);
        }
        catch (IOException iOException) {
            throw this.handleIOException(iOException, "removeNotificationListener", objectName, objectName2, notificationFilter, object);
        }
    }

    @Override
    public void removeNotificationListener(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException, ListenerNotFoundException {
        try {
            this.check(objectName, null, "removeNotificationListener");
            super.removeNotificationListener(objectName, notificationListener, notificationFilter, object);
        }
        catch (IOException iOException) {
            throw this.handleIOException(iOException, "removeNotificationListener", objectName, notificationListener, notificationFilter, object);
        }
    }

    @Override
    public void removeNotificationListener(ObjectName objectName, NotificationListener notificationListener) throws InstanceNotFoundException, ListenerNotFoundException {
        try {
            this.check(objectName, null, "removeNotificationListener");
            super.removeNotificationListener(objectName, notificationListener);
        }
        catch (IOException iOException) {
            throw this.handleIOException(iOException, "removeNotificationListener", objectName, notificationListener);
        }
    }

    @Override
    public void addNotificationListener(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException {
        try {
            this.check(objectName, null, "addNotificationListener");
            super.addNotificationListener(objectName, notificationListener, notificationFilter, object);
        }
        catch (IOException iOException) {
            throw this.handleIOException(iOException, "addNotificationListener", objectName, notificationListener, notificationFilter, object);
        }
    }

    @Override
    public void addNotificationListener(ObjectName objectName, ObjectName objectName2, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException {
        try {
            this.check(objectName, null, "addNotificationListener");
            super.addNotificationListener(objectName, objectName2, notificationFilter, object);
        }
        catch (IOException iOException) {
            throw this.handleIOException(iOException, "addNotificationListener", objectName, objectName2, notificationFilter, object);
        }
    }

    @Override
    public boolean isRegistered(ObjectName objectName) {
        try {
            return super.isRegistered(objectName);
        }
        catch (IOException iOException) {
            throw this.handleIOException(iOException, "isRegistered", objectName);
        }
    }

    @Override
    public void unregisterMBean(ObjectName objectName) throws InstanceNotFoundException, MBeanRegistrationException {
        try {
            this.check(objectName, null, "unregisterMBean");
            super.unregisterMBean(objectName);
        }
        catch (IOException iOException) {
            throw this.handleIOException(iOException, "unregisterMBean", objectName);
        }
    }

    @Override
    public MBeanInfo getMBeanInfo(ObjectName objectName) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        try {
            this.check(objectName, null, "getMBeanInfo");
            return super.getMBeanInfo(objectName);
        }
        catch (IOException iOException) {
            throw this.handleIOException(iOException, "getMBeanInfo", objectName);
        }
    }

    @Override
    public ObjectInstance getObjectInstance(ObjectName objectName) throws InstanceNotFoundException {
        try {
            this.check(objectName, null, "getObjectInstance");
            return super.getObjectInstance(objectName);
        }
        catch (IOException iOException) {
            throw this.handleIOException(iOException, "getObjectInstance", objectName);
        }
    }

    @Override
    public ObjectInstance createMBean(String string, ObjectName objectName, Object[] objectArray, String[] stringArray) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        try {
            this.checkCreate(objectName, string, "instantiate");
            this.checkCreate(objectName, string, "registerMBean");
            return super.createMBean(string, objectName, objectArray, stringArray);
        }
        catch (IOException iOException) {
            throw this.handleIOException(iOException, "createMBean", string, objectName, objectArray, stringArray);
        }
    }

    @Override
    public ObjectInstance createMBean(String string, ObjectName objectName, ObjectName objectName2, Object[] objectArray, String[] stringArray) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        try {
            this.checkCreate(objectName, string, "instantiate");
            this.checkCreate(objectName, string, "registerMBean");
            return super.createMBean(string, objectName, objectName2, objectArray, stringArray);
        }
        catch (IOException iOException) {
            throw this.handleIOException(iOException, "createMBean", string, objectName, objectName2, objectArray, stringArray);
        }
    }

    @Override
    public AttributeList setAttributes(ObjectName objectName, AttributeList attributeList) throws InstanceNotFoundException, ReflectionException {
        try {
            AttributeList attributeList2 = this.checkAttributes(objectName, attributeList, "setAttribute");
            return super.setAttributes(objectName, attributeList2);
        }
        catch (IOException iOException) {
            throw this.handleIOException(iOException, "setAttributes", objectName, attributeList);
        }
    }

    @Override
    public Object invoke(ObjectName objectName, String string, Object[] objectArray, String[] stringArray) throws InstanceNotFoundException, MBeanException, ReflectionException {
        try {
            this.check(objectName, string, "invoke");
            return super.invoke(objectName, string, objectArray, stringArray);
        }
        catch (IOException iOException) {
            throw this.handleIOException(iOException, "invoke", objectName, string, objectArray, stringArray);
        }
    }

    @Override
    public Object instantiate(String string) throws ReflectionException, MBeanException {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("call to unsupported instantiate method: trowing UnsupportedOperationException");
        }
        throw new UnsupportedOperationException("Not applicable.");
    }

    @Override
    public Object instantiate(String string, ObjectName objectName) throws ReflectionException, MBeanException, InstanceNotFoundException {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("call to unsupported method: instantiate(...) -throwing UnsupportedOperationException");
        }
        throw new UnsupportedOperationException("Not applicable.");
    }

    @Override
    public Object instantiate(String string, Object[] objectArray, String[] stringArray) throws ReflectionException, MBeanException {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("call to unsupported method: instantiate(...) -throwing UnsupportedOperationException");
        }
        throw new UnsupportedOperationException("Not applicable.");
    }

    @Override
    public Object instantiate(String string, ObjectName objectName, Object[] objectArray, String[] stringArray) throws ReflectionException, MBeanException, InstanceNotFoundException {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("call to unsupported method: instantiate(...) -throwing UnsupportedOperationException");
        }
        throw new UnsupportedOperationException("Not applicable.");
    }

    @Override
    @Deprecated
    public ObjectInputStream deserialize(ObjectName objectName, byte[] byArray) throws InstanceNotFoundException, OperationsException {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("call to unsupported method: deserialize(...) -throwing UnsupportedOperationException");
        }
        throw new UnsupportedOperationException("Not applicable.");
    }

    @Override
    @Deprecated
    public ObjectInputStream deserialize(String string, byte[] byArray) throws OperationsException, ReflectionException {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("call to unsupported method: deserialize(...) -throwing UnsupportedOperationException");
        }
        throw new UnsupportedOperationException("Not applicable.");
    }

    @Override
    @Deprecated
    public ObjectInputStream deserialize(String string, ObjectName objectName, byte[] byArray) throws InstanceNotFoundException, OperationsException, ReflectionException {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("call to unsupported method: deserialize(...) -throwing UnsupportedOperationException");
        }
        throw new UnsupportedOperationException("Not applicable.");
    }

    @Override
    public ClassLoaderRepository getClassLoaderRepository() {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("call to unsupported method: getClassLoaderRepository() -throwing UnsupportedOperationException");
        }
        throw new UnsupportedOperationException("Not applicable.");
    }

    static RuntimeException newUnsupportedException(String string) {
        return new RuntimeOperationsException(new UnsupportedOperationException("Not supported in this namespace: " + string));
    }

    @Override
    boolean excludesFromResult(ObjectName objectName, String string) {
        return !this.checkQuery(objectName, string);
    }

    abstract void check(ObjectName var1, String var2, String var3);

    abstract void checkCreate(ObjectName var1, String var2, String var3);

    abstract boolean checkQuery(ObjectName var1, String var2);

    abstract String[] checkAttributes(ObjectName var1, String[] var2, String var3);

    abstract AttributeList checkAttributes(ObjectName var1, AttributeList var2, String var3);

    String[] checkDomains(String[] stringArray, String string) {
        return stringArray;
    }

    void checkPattern(ObjectName objectName, String string, String string2) {
        this.check(null, null, string2);
    }
}

