/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rowset.internal;

import com.sun.rowset.CachedRowSetImpl;
import com.sun.rowset.JdbcRowSetResourceBundle;
import com.sun.rowset.internal.CachedRowSetReader;
import com.sun.rowset.internal.SyncResolverImpl;
import java.io.IOException;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Vector;
import javax.sql.RowSetInternal;
import javax.sql.rowset.CachedRowSet;
import javax.sql.rowset.RowSetMetaDataImpl;
import javax.sql.rowset.spi.SyncProviderException;
import javax.sql.rowset.spi.TransactionalWriter;

public class CachedRowSetWriter
implements TransactionalWriter,
Serializable {
    private transient Connection con;
    private String selectCmd;
    private String updateCmd;
    private String updateWhere;
    private String deleteCmd;
    private String deleteWhere;
    private String insertCmd;
    private int[] keyCols;
    private Object[] params;
    private CachedRowSetReader reader;
    private ResultSetMetaData callerMd;
    private int callerColumnCount;
    private CachedRowSetImpl crsResolve;
    private ArrayList status;
    private int iChangedValsInDbAndCRS;
    private int iChangedValsinDbOnly;
    private JdbcRowSetResourceBundle resBundle;

    public CachedRowSetWriter() {
        try {
            this.resBundle = JdbcRowSetResourceBundle.getJdbcRowSetResourceBundle();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    @Override
    public boolean writeData(RowSetInternal rowSetInternal) throws SQLException {
        int n;
        int n2;
        int n3;
        boolean bl = false;
        boolean bl2 = false;
        Statement statement = null;
        this.iChangedValsInDbAndCRS = 0;
        this.iChangedValsinDbOnly = 0;
        CachedRowSetImpl cachedRowSetImpl = (CachedRowSetImpl)rowSetInternal;
        this.crsResolve = new CachedRowSetImpl();
        this.con = this.reader.connect(rowSetInternal);
        if (this.con == null) {
            throw new SQLException(this.resBundle.handleGetObject("crswriter.connect").toString());
        }
        this.initSQLStatements(cachedRowSetImpl);
        RowSetMetaDataImpl rowSetMetaDataImpl = (RowSetMetaDataImpl)cachedRowSetImpl.getMetaData();
        RowSetMetaDataImpl rowSetMetaDataImpl2 = new RowSetMetaDataImpl();
        int n4 = rowSetMetaDataImpl.getColumnCount();
        int n5 = cachedRowSetImpl.size() + 1;
        this.status = new ArrayList(n5);
        this.status.add(0, null);
        rowSetMetaDataImpl2.setColumnCount(n4);
        for (n3 = 1; n3 <= n4; ++n3) {
            rowSetMetaDataImpl2.setColumnType(n3, rowSetMetaDataImpl.getColumnType(n3));
            rowSetMetaDataImpl2.setColumnName(n3, rowSetMetaDataImpl.getColumnName(n3));
            rowSetMetaDataImpl2.setNullable(n3, 2);
        }
        this.crsResolve.setMetaData(rowSetMetaDataImpl2);
        if (this.callerColumnCount < 1) {
            if (this.reader.getCloseConnection()) {
                this.con.close();
            }
            return true;
        }
        bl2 = cachedRowSetImpl.getShowDeleted();
        cachedRowSetImpl.setShowDeleted(true);
        cachedRowSetImpl.beforeFirst();
        n3 = 1;
        while (cachedRowSetImpl.next()) {
            if (cachedRowSetImpl.rowDeleted()) {
                bl = this.deleteOriginalRow(cachedRowSetImpl, this.crsResolve);
                if (bl) {
                    this.status.add(n3, new Integer(1));
                } else {
                    this.status.add(n3, new Integer(3));
                }
            } else if (cachedRowSetImpl.rowInserted()) {
                statement = this.con.prepareStatement(this.insertCmd);
                bl = this.insertNewRow(cachedRowSetImpl, (PreparedStatement)statement, this.crsResolve);
                if (bl) {
                    this.status.add(n3, new Integer(2));
                } else {
                    this.status.add(n3, new Integer(3));
                }
            } else if (cachedRowSetImpl.rowUpdated()) {
                bl = this.updateOriginalRow(cachedRowSetImpl);
                if (bl) {
                    this.status.add(n3, new Integer(0));
                } else {
                    this.status.add(n3, new Integer(3));
                }
            } else {
                n2 = cachedRowSetImpl.getMetaData().getColumnCount();
                this.status.add(n3, new Integer(3));
                this.crsResolve.moveToInsertRow();
                for (n = 0; n < n4; ++n) {
                    this.crsResolve.updateNull(n + 1);
                }
                this.crsResolve.insertRow();
                this.crsResolve.moveToCurrentRow();
            }
            ++n3;
        }
        if (statement != null) {
            statement.close();
        }
        cachedRowSetImpl.setShowDeleted(bl2);
        n2 = 0;
        for (n = 1; n < this.status.size(); ++n) {
            if (this.status.get(n).equals(new Integer(3))) continue;
            n2 = 1;
            break;
        }
        cachedRowSetImpl.beforeFirst();
        this.crsResolve.beforeFirst();
        if (n2 != 0) {
            SyncProviderException syncProviderException = new SyncProviderException(this.status.size() - 1 + this.resBundle.handleGetObject("crswriter.conflictsno").toString());
            SyncResolverImpl syncResolverImpl = (SyncResolverImpl)syncProviderException.getSyncResolver();
            syncResolverImpl.setCachedRowSet(cachedRowSetImpl);
            syncResolverImpl.setCachedRowSetResolver(this.crsResolve);
            syncResolverImpl.setStatus(this.status);
            syncResolverImpl.setCachedRowSetWriter(this);
            throw syncProviderException;
        }
        return true;
    }

    private boolean updateOriginalRow(CachedRowSet cachedRowSet) throws SQLException {
        int n = 0;
        int n2 = 0;
        ResultSet resultSet = cachedRowSet.getOriginalRow();
        resultSet.next();
        try {
            Object object;
            this.updateWhere = this.buildWhereClause(this.updateWhere, resultSet);
            String string = this.selectCmd.toLowerCase();
            int n3 = string.indexOf("where");
            if (n3 != -1) {
                object = this.selectCmd.substring(0, n3);
                this.selectCmd = object;
            }
            PreparedStatement preparedStatement = this.con.prepareStatement(this.selectCmd + this.updateWhere, 1005, 1007);
            for (n = 0; n < this.keyCols.length; ++n) {
                if (this.params[n] == null) continue;
                preparedStatement.setObject(++n2, this.params[n]);
            }
            try {
                preparedStatement.setMaxRows(cachedRowSet.getMaxRows());
                preparedStatement.setMaxFieldSize(cachedRowSet.getMaxFieldSize());
                preparedStatement.setEscapeProcessing(cachedRowSet.getEscapeProcessing());
                preparedStatement.setQueryTimeout(cachedRowSet.getQueryTimeout());
            }
            catch (Exception exception) {
                // empty catch block
            }
            object = null;
            object = preparedStatement.executeQuery();
            if (object.next()) {
                if (object.next()) {
                    return true;
                }
                object.first();
                int n4 = 0;
                Vector<Integer> vector = new Vector<Integer>();
                String string2 = new String(this.updateCmd);
                boolean bl = true;
                Object object2 = null;
                boolean bl2 = true;
                boolean bl3 = true;
                this.crsResolve.moveToInsertRow();
                for (n = 1; n <= this.callerColumnCount; ++n) {
                    Object object3 = resultSet.getObject(n);
                    Object object4 = cachedRowSet.getObject(n);
                    Object object5 = object.getObject(n);
                    bl = true;
                    if (object5 == null && object3 != null) {
                        ++this.iChangedValsinDbOnly;
                        bl = false;
                        object2 = object5;
                    } else if (object5 != null && !object5.equals(object3)) {
                        ++this.iChangedValsinDbOnly;
                        bl = false;
                        object2 = object5;
                    } else if (object3 == null || object4 == null) {
                        if (!bl2 || !bl3) {
                            string2 = string2 + ", ";
                        }
                        string2 = string2 + cachedRowSet.getMetaData().getColumnName(n);
                        vector.add(new Integer(n));
                        string2 = string2 + " = ? ";
                        bl2 = false;
                    } else if (object3.equals(object4)) {
                        ++n4;
                    } else if (!object3.equals(object4) && cachedRowSet.columnUpdated(n)) {
                        if (object5.equals(object3)) {
                            if (!bl3 || !bl2) {
                                string2 = string2 + ", ";
                            }
                            string2 = string2 + cachedRowSet.getMetaData().getColumnName(n);
                            vector.add(new Integer(n));
                            string2 = string2 + " = ? ";
                            bl3 = false;
                        } else {
                            bl = false;
                            object2 = object5;
                            ++this.iChangedValsInDbAndCRS;
                        }
                    }
                    if (!bl) {
                        this.crsResolve.updateObject(n, object2);
                        continue;
                    }
                    this.crsResolve.updateNull(n);
                }
                this.crsResolve.insertRow();
                this.crsResolve.moveToCurrentRow();
                if (!bl2 && vector.size() == 0 || n4 == this.callerColumnCount) {
                    return false;
                }
                if (this.iChangedValsInDbAndCRS != 0 || this.iChangedValsinDbOnly != 0) {
                    return true;
                }
                string2 = string2 + this.updateWhere;
                preparedStatement = this.con.prepareStatement(string2);
                for (n = 0; n < vector.size(); ++n) {
                    Object object6 = cachedRowSet.getObject((Integer)vector.get(n));
                    if (object6 != null) {
                        preparedStatement.setObject(n + 1, object6);
                        continue;
                    }
                    preparedStatement.setNull(n + 1, cachedRowSet.getMetaData().getColumnType(n + 1));
                }
                n2 = n;
                for (n = 0; n < this.keyCols.length; ++n) {
                    if (this.params[n] == null) continue;
                    preparedStatement.setObject(++n2, this.params[n]);
                }
                n = preparedStatement.executeUpdate();
                return false;
            }
            return true;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            this.crsResolve.moveToInsertRow();
            for (n = 1; n <= this.callerColumnCount; ++n) {
                this.crsResolve.updateNull(n);
            }
            this.crsResolve.insertRow();
            this.crsResolve.moveToCurrentRow();
            return true;
        }
    }

    private boolean insertNewRow(CachedRowSet cachedRowSet, PreparedStatement preparedStatement, CachedRowSetImpl cachedRowSetImpl) throws SQLException {
        int n = 0;
        int n2 = cachedRowSet.getMetaData().getColumnCount();
        boolean bl = false;
        PreparedStatement preparedStatement2 = this.con.prepareStatement(this.selectCmd, 1005, 1007);
        ResultSet resultSet = null;
        DatabaseMetaData databaseMetaData = this.con.getMetaData();
        ResultSet resultSet2 = preparedStatement2.executeQuery();
        String string = cachedRowSet.getTableName();
        resultSet = databaseMetaData.getPrimaryKeys(null, null, string);
        String[] stringArray = new String[n2];
        int n3 = 0;
        while (resultSet.next()) {
            String string2;
            stringArray[n3] = string2 = resultSet.getString("COLUMN_NAME");
            ++n3;
        }
        if (resultSet2.next()) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string3;
                if (stringArray[i] == null) continue;
                if (cachedRowSet.getObject(stringArray[i]) == null) break;
                String string4 = cachedRowSet.getObject(stringArray[i]).toString();
                if (!string4.equals(string3 = resultSet2.getObject(stringArray[i]).toString())) continue;
                bl = true;
                this.crsResolve.moveToInsertRow();
                for (n = 1; n <= n2; ++n) {
                    String string5 = resultSet2.getMetaData().getColumnName(n);
                    if (string5.equals(stringArray[i])) {
                        this.crsResolve.updateObject(n, (Object)string3);
                        continue;
                    }
                    this.crsResolve.updateNull(n);
                }
                this.crsResolve.insertRow();
                this.crsResolve.moveToCurrentRow();
            }
        }
        if (bl) {
            return bl;
        }
        try {
            for (n = 1; n <= n2; ++n) {
                Object object = cachedRowSet.getObject(n);
                if (object != null) {
                    preparedStatement.setObject(n, object);
                    continue;
                }
                preparedStatement.setNull(n, cachedRowSet.getMetaData().getColumnType(n));
            }
            n = preparedStatement.executeUpdate();
            return false;
        }
        catch (SQLException sQLException) {
            this.crsResolve.moveToInsertRow();
            for (n = 1; n <= n2; ++n) {
                this.crsResolve.updateNull(n);
            }
            this.crsResolve.insertRow();
            this.crsResolve.moveToCurrentRow();
            return true;
        }
    }

    private boolean deleteOriginalRow(CachedRowSet cachedRowSet, CachedRowSetImpl cachedRowSetImpl) throws SQLException {
        int n;
        int n2 = 0;
        ResultSet resultSet = cachedRowSet.getOriginalRow();
        resultSet.next();
        this.deleteWhere = this.buildWhereClause(this.deleteWhere, resultSet);
        PreparedStatement preparedStatement = this.con.prepareStatement(this.selectCmd + this.deleteWhere, 1005, 1007);
        for (n = 0; n < this.keyCols.length; ++n) {
            if (this.params[n] == null) continue;
            preparedStatement.setObject(++n2, this.params[n]);
        }
        try {
            preparedStatement.setMaxRows(cachedRowSet.getMaxRows());
            preparedStatement.setMaxFieldSize(cachedRowSet.getMaxFieldSize());
            preparedStatement.setEscapeProcessing(cachedRowSet.getEscapeProcessing());
            preparedStatement.setQueryTimeout(cachedRowSet.getQueryTimeout());
        }
        catch (Exception exception) {
            // empty catch block
        }
        ResultSet resultSet2 = preparedStatement.executeQuery();
        if (resultSet2.next()) {
            Object object;
            if (resultSet2.next()) {
                return true;
            }
            resultSet2.first();
            boolean bl = false;
            cachedRowSetImpl.moveToInsertRow();
            for (n = 1; n <= cachedRowSet.getMetaData().getColumnCount(); ++n) {
                object = resultSet.getObject(n);
                Object object2 = resultSet2.getObject(n);
                if (object != null && object2 != null) {
                    if (object.toString().equals(object2.toString())) continue;
                    bl = true;
                    cachedRowSetImpl.updateObject(n, resultSet.getObject(n));
                    continue;
                }
                cachedRowSetImpl.updateNull(n);
            }
            cachedRowSetImpl.insertRow();
            cachedRowSetImpl.moveToCurrentRow();
            if (bl) {
                return true;
            }
            object = this.deleteCmd + this.deleteWhere;
            preparedStatement = this.con.prepareStatement((String)object);
            n2 = 0;
            for (n = 0; n < this.keyCols.length; ++n) {
                if (this.params[n] == null) continue;
                preparedStatement.setObject(++n2, this.params[n]);
            }
            if (preparedStatement.executeUpdate() != 1) {
                return true;
            }
        } else {
            return true;
        }
        preparedStatement.close();
        return false;
    }

    public void setReader(CachedRowSetReader cachedRowSetReader) throws SQLException {
        this.reader = cachedRowSetReader;
    }

    public CachedRowSetReader getReader() throws SQLException {
        return this.reader;
    }

    private void initSQLStatements(CachedRowSet cachedRowSet) throws SQLException {
        int n;
        this.callerMd = cachedRowSet.getMetaData();
        this.callerColumnCount = this.callerMd.getColumnCount();
        if (this.callerColumnCount < 1) {
            return;
        }
        String string = cachedRowSet.getTableName();
        if (string == null && ((string = this.callerMd.getTableName(1)) == null || string.length() == 0)) {
            throw new SQLException(this.resBundle.handleGetObject("crswriter.tname").toString());
        }
        String string2 = this.callerMd.getCatalogName(1);
        String string3 = this.callerMd.getSchemaName(1);
        DatabaseMetaData databaseMetaData = this.con.getMetaData();
        this.selectCmd = "SELECT ";
        for (n = 1; n <= this.callerColumnCount; ++n) {
            this.selectCmd = this.selectCmd + this.callerMd.getColumnName(n);
            this.selectCmd = n < this.callerMd.getColumnCount() ? this.selectCmd + ", " : this.selectCmd + " ";
        }
        this.selectCmd = this.selectCmd + "FROM " + this.buildTableName(databaseMetaData, string2, string3, string);
        this.updateCmd = "UPDATE " + this.buildTableName(databaseMetaData, string2, string3, string);
        String string4 = this.updateCmd.toLowerCase();
        int n2 = string4.indexOf("where");
        if (n2 != -1) {
            this.updateCmd = this.updateCmd.substring(0, n2);
        }
        this.updateCmd = this.updateCmd + "SET ";
        this.insertCmd = "INSERT INTO " + this.buildTableName(databaseMetaData, string2, string3, string);
        this.insertCmd = this.insertCmd + "(";
        for (n = 1; n <= this.callerColumnCount; ++n) {
            this.insertCmd = this.insertCmd + this.callerMd.getColumnName(n);
            this.insertCmd = n < this.callerMd.getColumnCount() ? this.insertCmd + ", " : this.insertCmd + ") VALUES (";
        }
        for (n = 1; n <= this.callerColumnCount; ++n) {
            this.insertCmd = this.insertCmd + "?";
            this.insertCmd = n < this.callerColumnCount ? this.insertCmd + ", " : this.insertCmd + ")";
        }
        this.deleteCmd = "DELETE FROM " + this.buildTableName(databaseMetaData, string2, string3, string);
        this.buildKeyDesc(cachedRowSet);
    }

    private String buildTableName(DatabaseMetaData databaseMetaData, String string, String string2, String string3) throws SQLException {
        String string4 = new String();
        string = string.trim();
        string2 = string2.trim();
        string3 = string3.trim();
        if (databaseMetaData.isCatalogAtStart()) {
            if (string != null && string.length() > 0) {
                string4 = string4 + string + databaseMetaData.getCatalogSeparator();
            }
            if (string2 != null && string2.length() > 0) {
                string4 = string4 + string2 + ".";
            }
            string4 = string4 + string3;
        } else {
            if (string2 != null && string2.length() > 0) {
                string4 = string4 + string2 + ".";
            }
            string4 = string4 + string3;
            if (string != null && string.length() > 0) {
                string4 = string4 + databaseMetaData.getCatalogSeparator() + string;
            }
        }
        string4 = string4 + " ";
        return string4;
    }

    private void buildKeyDesc(CachedRowSet cachedRowSet) throws SQLException {
        this.keyCols = cachedRowSet.getKeyColumns();
        if (this.keyCols == null || this.keyCols.length == 0) {
            this.keyCols = new int[this.callerColumnCount];
            int n = 0;
            while (n < this.keyCols.length) {
                this.keyCols[n++] = n;
            }
        }
        this.params = new Object[this.keyCols.length];
    }

    private String buildWhereClause(String string, ResultSet resultSet) throws SQLException {
        string = "WHERE ";
        for (int i = 0; i < this.keyCols.length; ++i) {
            if (i > 0) {
                string = string + "AND ";
            }
            string = string + this.callerMd.getColumnName(this.keyCols[i]);
            this.params[i] = resultSet.getObject(this.keyCols[i]);
            string = resultSet.wasNull() ? string + " IS NULL " : string + " = ? ";
        }
        return string;
    }

    void updateResolvedConflictToDB(CachedRowSet cachedRowSet, Connection connection) throws SQLException {
        int n;
        int n2;
        int n3;
        String string = "WHERE ";
        String string2 = " ";
        String string3 = "UPDATE ";
        int n4 = cachedRowSet.getMetaData().getColumnCount();
        int[] nArray = cachedRowSet.getKeyColumns();
        String string4 = "";
        string = this.buildWhereClause(string, cachedRowSet);
        if (nArray == null || nArray.length == 0) {
            nArray = new int[n4];
            n3 = 0;
            while (n3 < nArray.length) {
                nArray[n3++] = n3;
            }
        }
        Object[] objectArray = new Object[nArray.length];
        string3 = "UPDATE " + this.buildTableName(connection.getMetaData(), cachedRowSet.getMetaData().getCatalogName(1), cachedRowSet.getMetaData().getSchemaName(1), cachedRowSet.getTableName());
        string3 = string3 + "SET ";
        n3 = 1;
        for (n2 = 1; n2 <= n4; ++n2) {
            if (!cachedRowSet.columnUpdated(n2)) continue;
            if (n3 == 0) {
                string4 = string4 + ", ";
            }
            string4 = string4 + cachedRowSet.getMetaData().getColumnName(n2);
            string4 = string4 + " = ? ";
            n3 = 0;
        }
        string3 = string3 + string4;
        string = "WHERE ";
        for (n2 = 0; n2 < nArray.length; ++n2) {
            if (n2 > 0) {
                string = string + "AND ";
            }
            string = string + cachedRowSet.getMetaData().getColumnName(nArray[n2]);
            objectArray[n2] = cachedRowSet.getObject(nArray[n2]);
            string = cachedRowSet.wasNull() ? string + " IS NULL " : string + " = ? ";
        }
        string3 = string3 + string;
        PreparedStatement preparedStatement = connection.prepareStatement(string3);
        n2 = 0;
        for (n = 0; n < n4; ++n) {
            if (!cachedRowSet.columnUpdated(n + 1)) continue;
            Object object = cachedRowSet.getObject(n + 1);
            if (object != null) {
                preparedStatement.setObject(++n2, object);
                continue;
            }
            preparedStatement.setNull(n + 1, cachedRowSet.getMetaData().getColumnType(n + 1));
        }
        for (n = 0; n < nArray.length; ++n) {
            if (objectArray[n] == null) continue;
            preparedStatement.setObject(++n2, objectArray[n]);
        }
        n = preparedStatement.executeUpdate();
    }

    @Override
    public void commit() throws SQLException {
        this.con.commit();
        if (this.reader.getCloseConnection()) {
            this.con.close();
        }
    }

    public void commit(CachedRowSetImpl cachedRowSetImpl, boolean bl) throws SQLException {
        this.con.commit();
        if (bl && cachedRowSetImpl.getCommand() != null) {
            cachedRowSetImpl.execute(this.con);
        }
        if (this.reader.getCloseConnection()) {
            this.con.close();
        }
    }

    @Override
    public void rollback() throws SQLException {
        this.con.rollback();
        if (this.reader.getCloseConnection()) {
            this.con.close();
        }
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.con.rollback(savepoint);
        if (this.reader.getCloseConnection()) {
            this.con.close();
        }
    }
}

