/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.encoding;

import java.awt.datatransfer.DataFlavor;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.activation.ActivationDataFlavor;
import javax.activation.DataContentHandler;
import javax.activation.DataSource;

public class StringDataContentHandler
implements DataContentHandler {
    @Override
    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] flavors = new DataFlavor[]{new ActivationDataFlavor(String.class, "text/plain", "text string"), new DataFlavor("text/plain", "Plain Text")};
        return flavors;
    }

    @Override
    public Object getTransferData(DataFlavor df, DataSource ds) {
        if (df.getMimeType().startsWith("text/plain")) {
            if (df.getRepresentationClass().getName().equals("java.lang.String")) {
                StringBuffer buf = new StringBuffer();
                char[] data = new char[1024];
                InputStreamReader isr = null;
                int bytes_read = 0;
                int total_bytes = 0;
                try {
                    isr = new InputStreamReader(ds.getInputStream());
                    while ((bytes_read = isr.read(data)) > 0) {
                        buf.append(data, 0, bytes_read);
                        total_bytes += bytes_read;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                return buf.toString();
            }
            if (df.getRepresentationClass().getName().equals("java.io.InputStream")) {
                try {
                    return ds.getInputStream();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    @Override
    public Object getContent(DataSource ds) {
        StringBuffer buf = new StringBuffer();
        char[] data = new char[1024];
        InputStreamReader isr = null;
        int bytes_read = 0;
        int total_bytes = 0;
        try {
            isr = new InputStreamReader(ds.getInputStream());
            while ((bytes_read = isr.read(data)) > 0) {
                buf.append(data, 0, bytes_read);
                total_bytes += bytes_read;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return buf.toString();
    }

    @Override
    public void writeTo(Object obj, String mimeType, OutputStream os) throws IOException {
        if (!mimeType.startsWith("text/plain")) {
            throw new IOException("Invalid type \"" + mimeType + "\" on StringDCH");
        }
        OutputStreamWriter out = new OutputStreamWriter(os);
        out.write((String)obj);
        ((Writer)out).flush();
    }
}

