/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import com.sun.jmx.mbeanserver.NotificationMBeanSupport;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.Set;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.Query;
import javax.management.QueryEval;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.ValueExp;

public class QueryNotificationFilter
implements NotificationFilter {
    private static final long serialVersionUID = -8408613922660635231L;
    private static final ObjectName DEFAULT_NAME = ObjectName.valueOf(":type=Notification");
    private static final QueryExp trueQuery;
    private final QueryExp query;

    public QueryNotificationFilter(QueryExp queryExp) {
        this.query = queryExp == null ? trueQuery : queryExp;
    }

    public QueryNotificationFilter(String string) {
        this(Query.fromString(string));
    }

    public QueryNotificationFilter(Class<? extends Notification> clazz, String string) {
        this(Query.and(Query.isInstanceOf(Query.value(QueryNotificationFilter.notNull(clazz).getName())), Query.fromString(string)));
    }

    private static <T> T notNull(T t) {
        if (t == null) {
            throw new IllegalArgumentException("Null argument");
        }
        return t;
    }

    public QueryExp getQuery() {
        return this.query;
    }

    @Override
    public boolean isNotificationEnabled(Notification notification) {
        Object object = notification.getSource();
        ObjectName objectName = object instanceof ObjectName ? (ObjectName)object : DEFAULT_NAME;
        MBS mBS = new MBS(notification, objectName);
        MBeanServer mBeanServer = (MBeanServer)Proxy.newProxyInstance(MBeanServer.class.getClassLoader(), new Class[]{MBeanServer.class}, new ForwardIH(mBS));
        return QueryNotificationFilter.evalQuery(this.query, mBeanServer, objectName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean evalQuery(QueryExp queryExp, MBeanServer mBeanServer, ObjectName objectName) {
        MBeanServer mBeanServer2 = QueryEval.getMBeanServer();
        try {
            if (mBeanServer != null) {
                queryExp.setMBeanServer(mBeanServer);
            }
            boolean bl = queryExp.apply(objectName);
            return bl;
        }
        catch (Exception exception) {
            boolean bl = false;
            return bl;
        }
        finally {
            queryExp.setMBeanServer(mBeanServer2);
        }
    }

    static {
        ValueExp valueExp = Query.value(0);
        trueQuery = Query.eq(valueExp, valueExp);
    }

    private static class MBS {
        private final Notification notification;
        private final ObjectName objectName;
        private final ObjectInstance objectInstance;
        private volatile DynamicMBean mbean;

        MBS(Notification notification, ObjectName objectName) {
            this.notification = notification;
            this.objectName = objectName;
            this.objectInstance = new ObjectInstance(objectName, notification.getClass().getName());
        }

        private void checkName(ObjectName objectName) throws InstanceNotFoundException {
            if (!this.objectName.equals(objectName)) {
                throw new InstanceNotFoundException(String.valueOf(objectName));
            }
        }

        private DynamicMBean mbean(ObjectName objectName) throws InstanceNotFoundException, ReflectionException {
            if (this.mbean == null) {
                try {
                    this.mbean = new NotificationMBeanSupport(this.notification);
                }
                catch (NotCompliantMBeanException notCompliantMBeanException) {
                    throw new ReflectionException(notCompliantMBeanException);
                }
            }
            return this.mbean;
        }

        public ObjectInstance getObjectInstance(ObjectName objectName) throws InstanceNotFoundException {
            this.checkName(objectName);
            return this.objectInstance;
        }

        public Set<ObjectInstance> queryMBeans(ObjectName objectName, QueryExp queryExp) {
            Set<ObjectName> set = this.queryNames(objectName, queryExp);
            switch (set.size()) {
                case 0: {
                    return Collections.emptySet();
                }
                case 1: {
                    return Collections.singleton(this.objectInstance);
                }
            }
            throw new UnsupportedOperationException("Internal error");
        }

        public Set<ObjectName> queryNames(ObjectName objectName, QueryExp queryExp) {
            if (objectName != null && !objectName.apply(this.objectName) || queryExp != null && !QueryNotificationFilter.evalQuery(queryExp, null, objectName)) {
                return Collections.emptySet();
            }
            return Collections.singleton(this.objectName);
        }

        public boolean isRegistered(ObjectName objectName) {
            return this.objectName.equals(objectName);
        }

        public Integer getMBeanCount() {
            return 1;
        }

        public Object getAttribute(ObjectName objectName, String string) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
            return this.mbean(objectName).getAttribute(string);
        }

        public AttributeList getAttributes(ObjectName objectName, String[] stringArray) throws InstanceNotFoundException, ReflectionException {
            return this.mbean(objectName).getAttributes(stringArray);
        }

        public String getDefaultDomain() {
            return this.objectName.getDomain();
        }

        public String[] getDomains() {
            return new String[]{this.objectName.getDomain()};
        }

        public MBeanInfo getMBeanInfo(ObjectName objectName) throws InstanceNotFoundException, ReflectionException {
            return this.mbean(objectName).getMBeanInfo();
        }

        public boolean isInstanceOf(ObjectName objectName, String string) throws InstanceNotFoundException {
            try {
                this.mbean(objectName);
                ClassLoader classLoader = this.notification.getClass().getClassLoader();
                Class<?> clazz = Class.forName(string, false, classLoader);
                return clazz.isInstance(this.notification);
            }
            catch (ReflectionException reflectionException) {
                return false;
            }
            catch (ClassNotFoundException classNotFoundException) {
                return false;
            }
        }

        public ClassLoader getClassLoaderFor(ObjectName objectName) throws InstanceNotFoundException {
            this.checkName(objectName);
            return this.notification.getClass().getClassLoader();
        }
    }

    private static class ForwardIH
    implements InvocationHandler {
        private final MBS mbs;

        ForwardIH(MBS mBS) {
            this.mbs = mBS;
        }

        @Override
        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            Method method2;
            try {
                method2 = MBS.class.getMethod(method.getName(), method.getParameterTypes());
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new UnsupportedOperationException(method.getName());
            }
            try {
                return method2.invoke(this.mbs, objectArray);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw invocationTargetException.getCause();
            }
        }
    }
}

