/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Vector;
import javax.swing.SizeRequirements;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BoxView;
import javax.swing.text.CompositeView;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.BlockView;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.ParagraphView;
import javax.swing.text.html.StyleSheet;

class TableView
extends BoxView
implements ViewFactory {
    private AttributeSet attr;
    private StyleSheet.BoxPainter painter;
    private int cellSpacing;
    private int borderWidth;
    private int captionIndex = -1;
    private boolean relativeCells;
    private boolean multiRowCells;
    int[] columnSpans;
    int[] columnOffsets;
    SizeRequirements totalColumnRequirements;
    SizeRequirements[] columnRequirements;
    RowIterator rowIterator = new RowIterator();
    ColumnIterator colIterator = new ColumnIterator();
    Vector<RowView> rows = new Vector();
    boolean skipComments = false;
    boolean gridValid = false;
    private static final BitSet EMPTY = new BitSet();

    public TableView(Element element) {
        super(element, 1);
        this.totalColumnRequirements = new SizeRequirements();
    }

    protected RowView createTableRow(Element element) {
        Object object = element.getAttributes().getAttribute(StyleConstants.NameAttribute);
        if (object == HTML.Tag.TR) {
            return new RowView(element);
        }
        return null;
    }

    public int getColumnCount() {
        return this.columnSpans.length;
    }

    public int getColumnSpan(int n) {
        if (n < this.columnSpans.length) {
            return this.columnSpans[n];
        }
        return 0;
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public int getMultiRowSpan(int n, int n2) {
        RowView rowView = this.getRow(n);
        RowView rowView2 = this.getRow(n2);
        if (rowView != null && rowView2 != null) {
            int n3 = rowView.viewIndex;
            int n4 = rowView2.viewIndex;
            int n5 = this.getOffset(1, n4) - this.getOffset(1, n3) + this.getSpan(1, n4);
            return n5;
        }
        return 0;
    }

    public int getRowSpan(int n) {
        RowView rowView = this.getRow(n);
        if (rowView != null) {
            return this.getSpan(1, rowView.viewIndex);
        }
        return 0;
    }

    RowView getRow(int n) {
        if (n < this.rows.size()) {
            return this.rows.elementAt(n);
        }
        return null;
    }

    @Override
    protected View getViewAtPoint(int n, int n2, Rectangle rectangle) {
        int n3 = this.getViewCount();
        Rectangle rectangle2 = new Rectangle();
        for (int i = 0; i < n3; ++i) {
            rectangle2.setBounds(rectangle);
            this.childAllocation(i, rectangle2);
            View view = this.getView(i);
            if (!(view instanceof RowView) || (view = ((RowView)view).findViewAtPoint(n, n2, rectangle2)) == null) continue;
            rectangle.setBounds(rectangle2);
            return view;
        }
        return super.getViewAtPoint(n, n2, rectangle);
    }

    protected int getColumnsOccupied(View view) {
        String string;
        AttributeSet attributeSet = view.getElement().getAttributes();
        if (attributeSet.isDefined(HTML.Attribute.COLSPAN) && (string = (String)attributeSet.getAttribute(HTML.Attribute.COLSPAN)) != null) {
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 1;
    }

    protected int getRowsOccupied(View view) {
        String string;
        AttributeSet attributeSet = view.getElement().getAttributes();
        if (attributeSet.isDefined(HTML.Attribute.ROWSPAN) && (string = (String)attributeSet.getAttribute(HTML.Attribute.ROWSPAN)) != null) {
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 1;
    }

    protected void invalidateGrid() {
        this.gridValid = false;
    }

    protected StyleSheet getStyleSheet() {
        HTMLDocument hTMLDocument = (HTMLDocument)this.getDocument();
        return hTMLDocument.getStyleSheet();
    }

    void updateInsets() {
        short s = (short)this.painter.getInset(1, this);
        short s2 = (short)this.painter.getInset(3, this);
        if (this.captionIndex != -1) {
            View view = this.getView(this.captionIndex);
            short s3 = (short)view.getPreferredSpan(1);
            AttributeSet attributeSet = view.getAttributes();
            Object object = attributeSet.getAttribute(CSS.Attribute.CAPTION_SIDE);
            if (object != null && object.equals("bottom")) {
                s2 = (short)(s2 + s3);
            } else {
                s = (short)(s + s3);
            }
        }
        this.setInsets(s, (short)this.painter.getInset(2, this), s2, (short)this.painter.getInset(4, this));
    }

    protected void setPropertiesFromAttributes() {
        StyleSheet styleSheet = this.getStyleSheet();
        this.attr = styleSheet.getViewAttributes(this);
        this.painter = styleSheet.getBoxPainter(this.attr);
        if (this.attr != null) {
            this.setInsets((short)this.painter.getInset(1, this), (short)this.painter.getInset(2, this), (short)this.painter.getInset(3, this), (short)this.painter.getInset(4, this));
            CSS.LengthValue lengthValue = (CSS.LengthValue)this.attr.getAttribute(CSS.Attribute.BORDER_SPACING);
            this.cellSpacing = lengthValue != null ? (int)lengthValue.getValue() : 0;
            lengthValue = (CSS.LengthValue)this.attr.getAttribute(CSS.Attribute.BORDER_TOP_WIDTH);
            this.borderWidth = lengthValue != null ? (int)lengthValue.getValue() : 0;
        }
    }

    void updateGrid() {
        if (!this.gridValid) {
            int n;
            Object object;
            int n2;
            this.relativeCells = false;
            this.multiRowCells = false;
            this.captionIndex = -1;
            this.rows.removeAllElements();
            int n3 = this.getViewCount();
            for (n2 = 0; n2 < n3; ++n2) {
                Object object2;
                View view = this.getView(n2);
                if (view instanceof RowView) {
                    this.rows.addElement((RowView)view);
                    object2 = (RowView)view;
                    ((RowView)object2).clearFilledColumns();
                    ((RowView)object2).rowIndex = this.rows.size() - 1;
                    ((RowView)object2).viewIndex = n2;
                    continue;
                }
                object2 = view.getElement().getAttributes().getAttribute(StyleConstants.NameAttribute);
                if (!(object2 instanceof HTML.Tag) || (object = (HTML.Tag)object2) != HTML.Tag.CAPTION) continue;
                this.captionIndex = n2;
            }
            n2 = 0;
            int n4 = this.rows.size();
            for (n = 0; n < n4; ++n) {
                object = this.getRow(n);
                int n5 = 0;
                int n6 = 0;
                while (n6 < ((CompositeView)object).getViewCount()) {
                    int n7;
                    AttributeSet attributeSet;
                    CSS.LengthValue lengthValue;
                    View view = ((CompositeView)object).getView(n6);
                    if (!this.relativeCells && (lengthValue = (CSS.LengthValue)(attributeSet = view.getAttributes()).getAttribute(CSS.Attribute.WIDTH)) != null && lengthValue.isPercentage()) {
                        this.relativeCells = true;
                    }
                    while (((RowView)object).isFilled(n5)) {
                        ++n5;
                    }
                    int n8 = this.getRowsOccupied(view);
                    if (n8 > 1) {
                        this.multiRowCells = true;
                    }
                    if ((n7 = this.getColumnsOccupied(view)) > 1 || n8 > 1) {
                        int n9 = n + n8;
                        int n10 = n5 + n7;
                        for (int i = n; i < n9; ++i) {
                            for (int j = n5; j < n10; ++j) {
                                if (i == n && j == n5) continue;
                                this.addFill(i, j);
                            }
                        }
                        if (n7 > 1) {
                            n5 += n7 - 1;
                        }
                    }
                    ++n6;
                    ++n5;
                }
                n2 = Math.max(n2, n5);
            }
            this.columnSpans = new int[n2];
            this.columnOffsets = new int[n2];
            this.columnRequirements = new SizeRequirements[n2];
            for (n = 0; n < n2; ++n) {
                this.columnRequirements[n] = new SizeRequirements();
                this.columnRequirements[n].maximum = Integer.MAX_VALUE;
            }
            this.gridValid = true;
        }
    }

    void addFill(int n, int n2) {
        RowView rowView = this.getRow(n);
        if (rowView != null) {
            rowView.fillColumn(n2);
        }
    }

    protected void layoutColumns(int n, int[] nArray, int[] nArray2, SizeRequirements[] sizeRequirementsArray) {
        Arrays.fill(nArray, 0);
        Arrays.fill(nArray2, 0);
        this.colIterator.setLayoutArrays(nArray, nArray2, n);
        CSS.calculateTiledLayout(this.colIterator, n);
    }

    void calculateColumnRequirements(int n) {
        int n2;
        View view;
        int n3;
        int n4;
        int n5;
        RowView rowView;
        int n6;
        for (SizeRequirements n62 : this.columnRequirements) {
            n62.minimum = 0;
            n62.preferred = 0;
            n62.maximum = Integer.MAX_VALUE;
        }
        Container container = this.getContainer();
        if (container != null) {
            this.skipComments = container instanceof JTextComponent ? !((JTextComponent)container).isEditable() : true;
        }
        int n7 = 0;
        int n8 = this.getRowCount();
        for (n6 = 0; n6 < n8; ++n6) {
            rowView = this.getRow(n6);
            n5 = 0;
            n4 = rowView.getViewCount();
            for (n3 = 0; n3 < n4; ++n3) {
                view = rowView.getView(n3);
                if (this.skipComments && !(view instanceof CellView)) continue;
                while (rowView.isFilled(n5)) {
                    ++n5;
                }
                n2 = this.getRowsOccupied(view);
                int n9 = this.getColumnsOccupied(view);
                if (n9 == 1) {
                    this.checkSingleColumnCell(n, n5, view);
                } else {
                    n7 = 1;
                    n5 += n9 - 1;
                }
                ++n5;
            }
        }
        if (n7 != 0) {
            for (n6 = 0; n6 < n8; ++n6) {
                rowView = this.getRow(n6);
                n5 = 0;
                n4 = rowView.getViewCount();
                for (n3 = 0; n3 < n4; ++n3) {
                    view = rowView.getView(n3);
                    if (this.skipComments && !(view instanceof CellView)) continue;
                    while (rowView.isFilled(n5)) {
                        ++n5;
                    }
                    n2 = this.getColumnsOccupied(view);
                    if (n2 > 1) {
                        this.checkMultiColumnCell(n, n5, n2, view);
                        n5 += n2 - 1;
                    }
                    ++n5;
                }
            }
        }
    }

    void checkSingleColumnCell(int n, int n2, View view) {
        SizeRequirements sizeRequirements = this.columnRequirements[n2];
        sizeRequirements.minimum = Math.max((int)view.getMinimumSpan(n), sizeRequirements.minimum);
        sizeRequirements.preferred = Math.max((int)view.getPreferredSpan(n), sizeRequirements.preferred);
    }

    void checkMultiColumnCell(int n, int n2, int n3, View view) {
        int n4;
        Object[] objectArray;
        SizeRequirements[] sizeRequirementsArray;
        int n5;
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        for (n5 = 0; n5 < n3; ++n5) {
            sizeRequirementsArray = this.columnRequirements[n2 + n5];
            l += (long)sizeRequirementsArray.minimum;
            l2 += (long)sizeRequirementsArray.preferred;
            l3 += (long)sizeRequirementsArray.maximum;
        }
        n5 = (int)view.getMinimumSpan(n);
        if ((long)n5 > l) {
            sizeRequirementsArray = new SizeRequirements[n3];
            for (int i = 0; i < n3; ++i) {
                sizeRequirementsArray[i] = this.columnRequirements[n2 + i];
            }
            objectArray = new int[n3];
            int[] nArray = new int[n3];
            SizeRequirements.calculateTiledPositions(n5, null, sizeRequirementsArray, nArray, objectArray);
            for (int i = 0; i < n3; ++i) {
                SizeRequirements sizeRequirements = sizeRequirementsArray[i];
                sizeRequirements.minimum = Math.max(objectArray[i], sizeRequirements.minimum);
                sizeRequirements.preferred = Math.max(sizeRequirements.minimum, sizeRequirements.preferred);
                sizeRequirements.maximum = Math.max(sizeRequirements.preferred, sizeRequirements.maximum);
            }
        }
        if ((long)(n4 = (int)view.getPreferredSpan(n)) > l2) {
            objectArray = new SizeRequirements[n3];
            for (int i = 0; i < n3; ++i) {
                objectArray[i] = (int)this.columnRequirements[n2 + i];
            }
            int[] nArray = new int[n3];
            int[] nArray2 = new int[n3];
            SizeRequirements.calculateTiledPositions(n4, null, (SizeRequirements[])objectArray, nArray2, nArray);
            for (int i = 0; i < n3; ++i) {
                int n6 = objectArray[i];
                n6.preferred = Math.max(nArray[i], n6.preferred);
                n6.maximum = Math.max(n6.preferred, n6.maximum);
            }
        }
    }

    @Override
    protected SizeRequirements calculateMinorAxisRequirements(int n, SizeRequirements sizeRequirements) {
        String string;
        int n2;
        this.updateGrid();
        this.calculateColumnRequirements(n);
        if (sizeRequirements == null) {
            sizeRequirements = new SizeRequirements();
        }
        long l = 0L;
        long l2 = 0L;
        for (SizeRequirements object2 : this.columnRequirements) {
            l += (long)object2.minimum;
            l2 += (long)object2.preferred;
        }
        int n3 = (n2 + 1) * this.cellSpacing + 2 * this.borderWidth;
        sizeRequirements.minimum = (int)(l += (long)n3);
        sizeRequirements.preferred = (int)(l2 += (long)n3);
        sizeRequirements.maximum = (int)l2;
        AttributeSet attributeSet = this.getAttributes();
        CSS.LengthValue lengthValue = (CSS.LengthValue)attributeSet.getAttribute(CSS.Attribute.WIDTH);
        if (BlockView.spanSetFromAttributes(n, sizeRequirements, lengthValue, null) && sizeRequirements.minimum < (int)l) {
            sizeRequirements.minimum = sizeRequirements.preferred = (int)l;
            sizeRequirements.maximum = sizeRequirements.preferred;
        }
        this.totalColumnRequirements.minimum = sizeRequirements.minimum;
        this.totalColumnRequirements.preferred = sizeRequirements.preferred;
        this.totalColumnRequirements.maximum = sizeRequirements.maximum;
        Object object = attributeSet.getAttribute(CSS.Attribute.TEXT_ALIGN);
        sizeRequirements.alignment = object != null ? ((string = object.toString()).equals("left") ? 0.0f : (string.equals("center") ? 0.5f : (string.equals("right") ? 1.0f : 0.0f))) : 0.0f;
        return sizeRequirements;
    }

    @Override
    protected SizeRequirements calculateMajorAxisRequirements(int n, SizeRequirements sizeRequirements) {
        this.updateInsets();
        this.rowIterator.updateAdjustments();
        sizeRequirements = CSS.calculateTiledRequirements(this.rowIterator, sizeRequirements);
        sizeRequirements.maximum = sizeRequirements.preferred;
        return sizeRequirements;
    }

    @Override
    protected void layoutMinorAxis(int n, int n2, int[] nArray, int[] nArray2) {
        this.updateGrid();
        int n3 = this.getRowCount();
        for (int i = 0; i < n3; ++i) {
            RowView rowView = this.getRow(i);
            rowView.layoutChanged(n2);
        }
        this.layoutColumns(n, this.columnOffsets, this.columnSpans, this.columnRequirements);
        super.layoutMinorAxis(n, n2, nArray, nArray2);
    }

    @Override
    protected void layoutMajorAxis(int n, int n2, int[] nArray, int[] nArray2) {
        this.rowIterator.setLayoutArrays(nArray, nArray2);
        CSS.calculateTiledLayout(this.rowIterator, n);
        if (this.captionIndex != -1) {
            int n3;
            View view = this.getView(this.captionIndex);
            nArray2[this.captionIndex] = n3 = (int)view.getPreferredSpan(1);
            short s = (short)this.painter.getInset(3, this);
            nArray[this.captionIndex] = s != this.getBottomInset() ? n + s : (int)(-this.getTopInset());
        }
    }

    @Override
    protected View getViewAtPosition(int n, Rectangle rectangle) {
        int n2 = this.getViewCount();
        for (int i = 0; i < n2; ++i) {
            View view = this.getView(i);
            int n3 = view.getStartOffset();
            int n4 = view.getEndOffset();
            if (n < n3 || n >= n4) continue;
            if (rectangle != null) {
                this.childAllocation(i, rectangle);
            }
            return view;
        }
        if (n == this.getEndOffset()) {
            View view = this.getView(n2 - 1);
            if (rectangle != null) {
                this.childAllocation(n2 - 1, rectangle);
            }
            return view;
        }
        return null;
    }

    @Override
    public AttributeSet getAttributes() {
        if (this.attr == null) {
            StyleSheet styleSheet = this.getStyleSheet();
            this.attr = styleSheet.getViewAttributes(this);
        }
        return this.attr;
    }

    @Override
    public void paint(Graphics graphics, Shape shape) {
        int n;
        int n2;
        Rectangle rectangle = shape.getBounds();
        this.setSize(rectangle.width, rectangle.height);
        if (this.captionIndex != -1) {
            n2 = (int)this.painter.getInset(1, this);
            n = (int)this.painter.getInset(3, this);
            if (n2 != this.getTopInset()) {
                int n3 = this.getTopInset() - n2;
                rectangle.y += n3;
                rectangle.height -= n3;
            } else {
                rectangle.height -= this.getBottomInset() - n;
            }
        }
        this.painter.paint(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height, this);
        n2 = this.getViewCount();
        for (n = 0; n < n2; ++n) {
            View view = this.getView(n);
            view.paint(graphics, this.getChildAllocation(n, shape));
        }
    }

    @Override
    public void setParent(View view) {
        super.setParent(view);
        if (view != null) {
            this.setPropertiesFromAttributes();
        }
    }

    @Override
    public ViewFactory getViewFactory() {
        return this;
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        super.insertUpdate(documentEvent, shape, this);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        super.removeUpdate(documentEvent, shape, this);
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        super.changedUpdate(documentEvent, shape, this);
    }

    @Override
    protected void forwardUpdate(DocumentEvent.ElementChange elementChange, DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        Container container;
        super.forwardUpdate(elementChange, documentEvent, shape, viewFactory);
        if (shape != null && (container = this.getContainer()) != null) {
            Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
            container.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    @Override
    public void replace(int n, int n2, View[] viewArray) {
        super.replace(n, n2, viewArray);
        this.invalidateGrid();
    }

    @Override
    public View create(Element element) {
        ViewFactory viewFactory;
        Object object;
        Object object2 = element.getAttributes().getAttribute(StyleConstants.NameAttribute);
        if (object2 instanceof HTML.Tag) {
            object = (HTML.Tag)object2;
            if (object == HTML.Tag.TR) {
                return this.createTableRow(element);
            }
            if (object == HTML.Tag.TD || object == HTML.Tag.TH) {
                return new CellView(element);
            }
            if (object == HTML.Tag.CAPTION) {
                return new ParagraphView(element);
            }
        }
        if ((object = this.getParent()) != null && (viewFactory = ((View)object).getViewFactory()) != null) {
            return viewFactory.create(element);
        }
        return null;
    }

    class CellView
    extends BlockView {
        public CellView(Element element) {
            super(element, 1);
        }

        @Override
        protected void layoutMajorAxis(int n, int n2, int[] nArray, int[] nArray2) {
            int n3;
            super.layoutMajorAxis(n, n2, nArray, nArray2);
            int n4 = 0;
            int n5 = nArray2.length;
            for (n3 = 0; n3 < n5; ++n3) {
                n4 += nArray2[n3];
            }
            n3 = 0;
            if (n4 < n) {
                String string = (String)this.getElement().getAttributes().getAttribute(HTML.Attribute.VALIGN);
                if (string == null) {
                    AttributeSet attributeSet = this.getElement().getParentElement().getAttributes();
                    string = (String)attributeSet.getAttribute(HTML.Attribute.VALIGN);
                }
                if (string == null || string.equals("middle")) {
                    n3 = (n - n4) / 2;
                } else if (string.equals("bottom")) {
                    n3 = n - n4;
                }
            }
            if (n3 != 0) {
                int n6 = 0;
                while (n6 < n5) {
                    int n7 = n6++;
                    nArray[n7] = nArray[n7] + n3;
                }
            }
        }

        @Override
        protected SizeRequirements calculateMajorAxisRequirements(int n, SizeRequirements sizeRequirements) {
            SizeRequirements sizeRequirements2 = super.calculateMajorAxisRequirements(n, sizeRequirements);
            sizeRequirements2.maximum = Integer.MAX_VALUE;
            return sizeRequirements2;
        }

        @Override
        protected SizeRequirements calculateMinorAxisRequirements(int n, SizeRequirements sizeRequirements) {
            SizeRequirements sizeRequirements2 = super.calculateMinorAxisRequirements(n, sizeRequirements);
            int n2 = this.getViewCount();
            int n3 = 0;
            for (int i = 0; i < n2; ++i) {
                View view = this.getView(i);
                n3 = Math.max((int)view.getMinimumSpan(n), n3);
            }
            sizeRequirements2.minimum = Math.min(sizeRequirements2.minimum, n3);
            return sizeRequirements2;
        }
    }

    public class RowView
    extends BoxView {
        private StyleSheet.BoxPainter painter;
        private AttributeSet attr;
        BitSet fillColumns;
        int rowIndex;
        int viewIndex;
        boolean multiRowCells;

        public RowView(Element element) {
            super(element, 0);
            this.fillColumns = new BitSet();
            this.setPropertiesFromAttributes();
        }

        void clearFilledColumns() {
            this.fillColumns.and(EMPTY);
        }

        void fillColumn(int n) {
            this.fillColumns.set(n);
        }

        boolean isFilled(int n) {
            return this.fillColumns.get(n);
        }

        int getColumnCount() {
            int n = 0;
            int n2 = this.fillColumns.size();
            for (int i = 0; i < n2; ++i) {
                if (!this.fillColumns.get(i)) continue;
                ++n;
            }
            return this.getViewCount() + n;
        }

        @Override
        public AttributeSet getAttributes() {
            return this.attr;
        }

        View findViewAtPoint(int n, int n2, Rectangle rectangle) {
            int n3 = this.getViewCount();
            for (int i = 0; i < n3; ++i) {
                if (!this.getChildAllocation(i, rectangle).contains(n, n2)) continue;
                this.childAllocation(i, rectangle);
                return this.getView(i);
            }
            return null;
        }

        protected StyleSheet getStyleSheet() {
            HTMLDocument hTMLDocument = (HTMLDocument)this.getDocument();
            return hTMLDocument.getStyleSheet();
        }

        @Override
        public void preferenceChanged(View view, boolean bl, boolean bl2) {
            super.preferenceChanged(view, bl, bl2);
            if (TableView.this.multiRowCells && bl2) {
                for (int i = this.rowIndex - 1; i >= 0; --i) {
                    RowView rowView = TableView.this.getRow(i);
                    if (!rowView.multiRowCells) continue;
                    rowView.preferenceChanged(null, false, true);
                    break;
                }
            }
        }

        @Override
        protected SizeRequirements calculateMajorAxisRequirements(int n, SizeRequirements sizeRequirements) {
            SizeRequirements sizeRequirements2 = new SizeRequirements();
            sizeRequirements2.minimum = TableView.this.totalColumnRequirements.minimum;
            sizeRequirements2.maximum = TableView.this.totalColumnRequirements.maximum;
            sizeRequirements2.preferred = TableView.this.totalColumnRequirements.preferred;
            sizeRequirements2.alignment = 0.0f;
            return sizeRequirements2;
        }

        @Override
        public float getMinimumSpan(int n) {
            float f = n == 0 ? (float)(TableView.this.totalColumnRequirements.minimum + this.getLeftInset() + this.getRightInset()) : super.getMinimumSpan(n);
            return f;
        }

        @Override
        public float getMaximumSpan(int n) {
            float f = n == 0 ? 2.1474836E9f : super.getMaximumSpan(n);
            return f;
        }

        @Override
        public float getPreferredSpan(int n) {
            float f = n == 0 ? (float)(TableView.this.totalColumnRequirements.preferred + this.getLeftInset() + this.getRightInset()) : super.getPreferredSpan(n);
            return f;
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
            super.changedUpdate(documentEvent, shape, viewFactory);
            int n = documentEvent.getOffset();
            if (n <= this.getStartOffset() && n + documentEvent.getLength() >= this.getEndOffset()) {
                this.setPropertiesFromAttributes();
            }
        }

        @Override
        public void paint(Graphics graphics, Shape shape) {
            Rectangle rectangle = (Rectangle)shape;
            this.painter.paint(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height, this);
            super.paint(graphics, rectangle);
        }

        @Override
        public void replace(int n, int n2, View[] viewArray) {
            super.replace(n, n2, viewArray);
            TableView.this.invalidateGrid();
        }

        @Override
        protected SizeRequirements calculateMinorAxisRequirements(int n, SizeRequirements sizeRequirements) {
            long l = 0L;
            long l2 = 0L;
            long l3 = 0L;
            this.multiRowCells = false;
            int n2 = this.getViewCount();
            for (int i = 0; i < n2; ++i) {
                View view = this.getView(i);
                if (TableView.this.getRowsOccupied(view) > 1) {
                    this.multiRowCells = true;
                    l3 = Math.max((long)((int)view.getMaximumSpan(n)), l3);
                    continue;
                }
                l = Math.max((long)((int)view.getMinimumSpan(n)), l);
                l2 = Math.max((long)((int)view.getPreferredSpan(n)), l2);
                l3 = Math.max((long)((int)view.getMaximumSpan(n)), l3);
            }
            if (sizeRequirements == null) {
                sizeRequirements = new SizeRequirements();
                sizeRequirements.alignment = 0.5f;
            }
            sizeRequirements.preferred = (int)l2;
            sizeRequirements.minimum = (int)l;
            sizeRequirements.maximum = (int)l3;
            return sizeRequirements;
        }

        @Override
        protected void layoutMajorAxis(int n, int n2, int[] nArray, int[] nArray2) {
            int n3 = 0;
            int n4 = this.getViewCount();
            for (int i = 0; i < n4; ++i) {
                View view = this.getView(i);
                if (TableView.this.skipComments && !(view instanceof CellView)) continue;
                while (this.isFilled(n3)) {
                    ++n3;
                }
                int n5 = TableView.this.getColumnsOccupied(view);
                nArray2[i] = TableView.this.columnSpans[n3];
                nArray[i] = TableView.this.columnOffsets[n3];
                if (n5 > 1) {
                    int n6 = TableView.this.columnSpans.length;
                    for (int j = 1; j < n5; ++j) {
                        if (n3 + j >= n6) continue;
                        int n7 = i;
                        nArray2[n7] = nArray2[n7] + TableView.this.columnSpans[n3 + j];
                        int n8 = i;
                        nArray2[n8] = nArray2[n8] + TableView.this.cellSpacing;
                    }
                    n3 += n5 - 1;
                }
                ++n3;
            }
        }

        @Override
        protected void layoutMinorAxis(int n, int n2, int[] nArray, int[] nArray2) {
            super.layoutMinorAxis(n, n2, nArray, nArray2);
            int n3 = 0;
            int n4 = this.getViewCount();
            int n5 = 0;
            while (n5 < n4) {
                View view = this.getView(n5);
                while (this.isFilled(n3)) {
                    ++n3;
                }
                int n6 = TableView.this.getColumnsOccupied(view);
                int n7 = TableView.this.getRowsOccupied(view);
                if (n7 > 1) {
                    int n8 = this.rowIndex;
                    int n9 = Math.min(this.rowIndex + n7 - 1, TableView.this.getRowCount() - 1);
                    nArray2[n5] = TableView.this.getMultiRowSpan(n8, n9);
                }
                if (n6 > 1) {
                    n3 += n6 - 1;
                }
                ++n5;
                ++n3;
            }
        }

        @Override
        public int getResizeWeight(int n) {
            return 1;
        }

        @Override
        protected View getViewAtPosition(int n, Rectangle rectangle) {
            int n2 = this.getViewCount();
            for (int i = 0; i < n2; ++i) {
                View view = this.getView(i);
                int n3 = view.getStartOffset();
                int n4 = view.getEndOffset();
                if (n < n3 || n >= n4) continue;
                if (rectangle != null) {
                    this.childAllocation(i, rectangle);
                }
                return view;
            }
            if (n == this.getEndOffset()) {
                View view = this.getView(n2 - 1);
                if (rectangle != null) {
                    this.childAllocation(n2 - 1, rectangle);
                }
                return view;
            }
            return null;
        }

        void setPropertiesFromAttributes() {
            StyleSheet styleSheet = this.getStyleSheet();
            this.attr = styleSheet.getViewAttributes(this);
            this.painter = styleSheet.getBoxPainter(this.attr);
        }
    }

    class RowIterator
    implements CSS.LayoutIterator {
        private int row;
        private int[] adjustments;
        private int[] offsets;
        private int[] spans;

        RowIterator() {
        }

        void updateAdjustments() {
            int n = 1;
            if (TableView.this.multiRowCells) {
                int n2 = TableView.this.getRowCount();
                this.adjustments = new int[n2];
                for (int i = 0; i < n2; ++i) {
                    RowView rowView = TableView.this.getRow(i);
                    if (!rowView.multiRowCells) continue;
                    int n3 = rowView.getViewCount();
                    for (int j = 0; j < n3; ++j) {
                        View view = rowView.getView(j);
                        int n4 = TableView.this.getRowsOccupied(view);
                        if (n4 <= 1) continue;
                        int n5 = (int)view.getPreferredSpan(n);
                        this.adjustMultiRowSpan(n5, n4, i);
                    }
                }
            } else {
                this.adjustments = null;
            }
        }

        void adjustMultiRowSpan(int n, int n2, int n3) {
            int n4;
            if (n3 + n2 > this.getCount() && (n2 = this.getCount() - n3) < 1) {
                return;
            }
            int n5 = 0;
            for (n4 = 0; n4 < n2; ++n4) {
                RowView rowView = TableView.this.getRow(n3 + n4);
                n5 = (int)((float)n5 + rowView.getPreferredSpan(1));
            }
            if (n > n5) {
                n4 = n - n5;
                int n6 = n4 / n2;
                int n7 = n6 + (n4 - n6 * n2);
                RowView rowView = TableView.this.getRow(n3);
                this.adjustments[n3] = Math.max(this.adjustments[n3], n7);
                for (int i = 1; i < n2; ++i) {
                    this.adjustments[n3 + i] = Math.max(this.adjustments[n3 + i], n6);
                }
            }
        }

        void setLayoutArrays(int[] nArray, int[] nArray2) {
            this.offsets = nArray;
            this.spans = nArray2;
        }

        @Override
        public void setOffset(int n) {
            RowView rowView = TableView.this.getRow(this.row);
            if (rowView != null) {
                this.offsets[rowView.viewIndex] = n;
            }
        }

        @Override
        public int getOffset() {
            RowView rowView = TableView.this.getRow(this.row);
            if (rowView != null) {
                return this.offsets[rowView.viewIndex];
            }
            return 0;
        }

        @Override
        public void setSpan(int n) {
            RowView rowView = TableView.this.getRow(this.row);
            if (rowView != null) {
                this.spans[rowView.viewIndex] = n;
            }
        }

        @Override
        public int getSpan() {
            RowView rowView = TableView.this.getRow(this.row);
            if (rowView != null) {
                return this.spans[rowView.viewIndex];
            }
            return 0;
        }

        @Override
        public int getCount() {
            return TableView.this.rows.size();
        }

        @Override
        public void setIndex(int n) {
            this.row = n;
        }

        @Override
        public float getMinimumSpan(float f) {
            return this.getPreferredSpan(f);
        }

        @Override
        public float getPreferredSpan(float f) {
            RowView rowView = TableView.this.getRow(this.row);
            if (rowView != null) {
                int n = this.adjustments != null ? this.adjustments[this.row] : 0;
                return rowView.getPreferredSpan(TableView.this.getAxis()) + (float)n;
            }
            return 0.0f;
        }

        @Override
        public float getMaximumSpan(float f) {
            return this.getPreferredSpan(f);
        }

        @Override
        public float getBorderWidth() {
            return TableView.this.borderWidth;
        }

        @Override
        public float getLeadingCollapseSpan() {
            return TableView.this.cellSpacing;
        }

        @Override
        public float getTrailingCollapseSpan() {
            return TableView.this.cellSpacing;
        }

        @Override
        public int getAdjustmentWeight() {
            return 0;
        }
    }

    class ColumnIterator
    implements CSS.LayoutIterator {
        private int col;
        private int[] percentages;
        private int[] adjustmentWeights;
        private int[] offsets;
        private int[] spans;

        ColumnIterator() {
        }

        void disablePercentages() {
            this.percentages = null;
        }

        private void updatePercentagesAndAdjustmentWeights(int n) {
            int n2;
            this.adjustmentWeights = new int[TableView.this.columnRequirements.length];
            for (n2 = 0; n2 < TableView.this.columnRequirements.length; ++n2) {
                this.adjustmentWeights[n2] = 0;
            }
            this.percentages = (int[])(TableView.this.relativeCells ? new int[TableView.this.columnRequirements.length] : null);
            n2 = TableView.this.getRowCount();
            for (int i = 0; i < n2; ++i) {
                RowView rowView = TableView.this.getRow(i);
                int n3 = 0;
                int n4 = rowView.getViewCount();
                int n5 = 0;
                while (n5 < n4) {
                    View view = rowView.getView(n5);
                    while (rowView.isFilled(n3)) {
                        ++n3;
                    }
                    int n6 = TableView.this.getRowsOccupied(view);
                    int n7 = TableView.this.getColumnsOccupied(view);
                    AttributeSet attributeSet = view.getAttributes();
                    CSS.LengthValue lengthValue = (CSS.LengthValue)attributeSet.getAttribute(CSS.Attribute.WIDTH);
                    if (lengthValue != null) {
                        int n8 = (int)(lengthValue.getValue(n) / (float)n7 + 0.5f);
                        for (int j = 0; j < n7; ++j) {
                            if (lengthValue.isPercentage()) {
                                this.percentages[n3 + j] = Math.max(this.percentages[n3 + j], n8);
                                this.adjustmentWeights[n3 + j] = Math.max(this.adjustmentWeights[n3 + j], 2);
                                continue;
                            }
                            this.adjustmentWeights[n3 + j] = Math.max(this.adjustmentWeights[n3 + j], 1);
                        }
                    }
                    n3 += n7 - 1;
                    ++n5;
                    ++n3;
                }
            }
        }

        public void setLayoutArrays(int[] nArray, int[] nArray2, int n) {
            this.offsets = nArray;
            this.spans = nArray2;
            this.updatePercentagesAndAdjustmentWeights(n);
        }

        @Override
        public int getCount() {
            return TableView.this.columnRequirements.length;
        }

        @Override
        public void setIndex(int n) {
            this.col = n;
        }

        @Override
        public void setOffset(int n) {
            this.offsets[this.col] = n;
        }

        @Override
        public int getOffset() {
            return this.offsets[this.col];
        }

        @Override
        public void setSpan(int n) {
            this.spans[this.col] = n;
        }

        @Override
        public int getSpan() {
            return this.spans[this.col];
        }

        @Override
        public float getMinimumSpan(float f) {
            return TableView.this.columnRequirements[this.col].minimum;
        }

        @Override
        public float getPreferredSpan(float f) {
            if (this.percentages != null && this.percentages[this.col] != 0) {
                return Math.max(this.percentages[this.col], TableView.this.columnRequirements[this.col].minimum);
            }
            return TableView.this.columnRequirements[this.col].preferred;
        }

        @Override
        public float getMaximumSpan(float f) {
            return TableView.this.columnRequirements[this.col].maximum;
        }

        @Override
        public float getBorderWidth() {
            return TableView.this.borderWidth;
        }

        @Override
        public float getLeadingCollapseSpan() {
            return TableView.this.cellSpacing;
        }

        @Override
        public float getTrailingCollapseSpan() {
            return TableView.this.cellSpacing;
        }

        @Override
        public int getAdjustmentWeight() {
            return this.adjustmentWeights[this.col];
        }
    }
}

