/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.InvocationEvent;
import java.awt.event.WindowEvent;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.awt.ComponentAccessor;
import sun.awt.SunToolkit;
import sun.awt.X11.WindowDimensions;
import sun.awt.X11.XAtom;
import sun.awt.X11.XAtomList;
import sun.awt.X11.XBaseWindow;
import sun.awt.X11.XClientMessageEvent;
import sun.awt.X11.XConfigureEvent;
import sun.awt.X11.XContentWindow;
import sun.awt.X11.XCreateWindowParams;
import sun.awt.X11.XEvent;
import sun.awt.X11.XFocusChangeEvent;
import sun.awt.X11.XFocusProxyWindow;
import sun.awt.X11.XIconInfo;
import sun.awt.X11.XIconWindow;
import sun.awt.X11.XKeyboardFocusManagerPeer;
import sun.awt.X11.XPropertyEvent;
import sun.awt.X11.XReparentEvent;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XWM;
import sun.awt.X11.XWindowAttributes;
import sun.awt.X11.XWindowAttributesData;
import sun.awt.X11.XWindowPeer;
import sun.awt.X11.XlibUtil;
import sun.awt.X11.XlibWrapper;

abstract class XDecoratedPeer
extends XWindowPeer {
    private static final Logger log = Logger.getLogger("sun.awt.X11.XDecoratedPeer");
    private static final Logger insLog = Logger.getLogger("sun.awt.X11.insets.XDecoratedPeer");
    private static final Logger focusLog = Logger.getLogger("sun.awt.X11.focus.XDecoratedPeer");
    private static final Logger iconLog = Logger.getLogger("sun.awt.X11.icon.XDecoratedPeer");
    boolean configure_seen;
    boolean insets_corrected;
    XIconWindow iconWindow;
    WindowDimensions dimensions;
    XContentWindow content;
    Insets currentInsets;
    XFocusProxyWindow focusProxy;
    private Insets wm_set_insets;
    long reparent_serial = 0L;
    boolean no_reparent_artifacts = false;
    XWindowPeer actualFocusedWindow = null;

    XDecoratedPeer(Window window) {
        super(window);
    }

    XDecoratedPeer(XCreateWindowParams xCreateWindowParams) {
        super(xCreateWindowParams);
    }

    public long getShell() {
        return this.window;
    }

    @Override
    public long getContentWindow() {
        return this.content == null ? this.window : this.content.getWindow();
    }

    @Override
    void preInit(XCreateWindowParams xCreateWindowParams) {
        super.preInit(xCreateWindowParams);
        this.winAttr.initialFocus = true;
        this.currentInsets = new Insets(0, 0, 0, 0);
        this.applyGuessedInsets();
        Rectangle rectangle = (Rectangle)xCreateWindowParams.get("bounds");
        this.dimensions = new WindowDimensions(rectangle, this.getRealInsets(), false);
        xCreateWindowParams.put("bounds", this.dimensions.getClientRect());
        insLog.log(Level.FINE, "Initial dimensions {0}", new Object[]{this.dimensions});
        Long l = (Long)xCreateWindowParams.get("event mask");
        xCreateWindowParams.add((Object)"event mask", l & 0xFFFFFFFFFFDFFFFCL);
    }

    @Override
    void postInit(XCreateWindowParams xCreateWindowParams) {
        super.postInit(xCreateWindowParams);
        this.initResizability();
        this.updateSizeHints(this.dimensions);
        XWM.requestWMExtents(this.getWindow());
        this.content = XContentWindow.createContent(this);
        if (this.warningWindow != null) {
            this.warningWindow.toFront();
        }
        this.focusProxy = this.createFocusProxy();
    }

    @Override
    void setIconHints(List<XIconInfo> list) {
        if (!XWM.getWM().setNetWMIcon(this, list) && list.size() > 0) {
            if (this.iconWindow == null) {
                this.iconWindow = new XIconWindow(this);
            }
            this.iconWindow.setIconImages(list);
        }
    }

    @Override
    public void updateMinimumSize() {
        super.updateMinimumSize();
        this.updateMinSizeHints();
    }

    private void updateMinSizeHints() {
        if (this.isResizable()) {
            Dimension dimension = this.getTargetMinimumSize();
            if (dimension != null) {
                Insets insets = this.getRealInsets();
                int n = dimension.width - insets.left - insets.right;
                int n2 = dimension.height - insets.top - insets.bottom;
                if (n < 0) {
                    n = 0;
                }
                if (n2 < 0) {
                    n2 = 0;
                }
                this.setSizeHints(0x10L | (this.isLocationByPlatform() ? 0L : 5L), this.getX(), this.getY(), n, n2);
                if (this.isVisible()) {
                    int n3;
                    Rectangle rectangle = this.getShellBounds();
                    int n4 = rectangle.width < n ? n : rectangle.width;
                    int n5 = n3 = rectangle.height < n2 ? n2 : rectangle.height;
                    if (n4 != rectangle.width || n3 != rectangle.height) {
                        this.setShellSize(new Rectangle(0, 0, n4, n3));
                    }
                }
            } else {
                boolean bl = this.isMinSizeSet();
                XWM.removeSizeHints(this, 16L);
                if (bl && this.isShowing() && XWM.needRemap(this)) {
                    this.xSetVisible(false);
                    XToolkit.XSync();
                    this.xSetVisible(true);
                }
            }
        }
    }

    XFocusProxyWindow createFocusProxy() {
        return new XFocusProxyWindow(this);
    }

    @Override
    protected XAtomList getWMProtocols() {
        XAtomList xAtomList = super.getWMProtocols();
        xAtomList.add(wm_delete_window);
        xAtomList.add(wm_take_focus);
        return xAtomList;
    }

    @Override
    public Graphics getGraphics() {
        return this.getGraphics(this.content.surfaceData, ComponentAccessor.getForeground(this.target), ComponentAccessor.getBackground(this.target), ComponentAccessor.getFont_NoClientCode(this.target));
    }

    public void setTitle(String string) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Title is " + string);
        }
        this.winAttr.title = string;
        this.updateWMName();
    }

    @Override
    protected String getWMName() {
        if (this.winAttr.title == null || this.winAttr.title.trim().equals("")) {
            return " ";
        }
        return this.winAttr.title;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void updateWMName() {
        super.updateWMName();
        String string = this.getWMName();
        XToolkit.awtLock();
        try {
            if (string == null || string.trim().equals("")) {
                string = "Java";
            }
            XAtom xAtom = XAtom.get(37L);
            xAtom.setProperty(this.getWindow(), string);
            XAtom xAtom2 = XAtom.get("_NET_WM_ICON_NAME");
            xAtom2.setPropertyUTF8(this.getWindow(), string);
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    @Override
    public void handleIconify() {
        this.postEvent(new WindowEvent((Window)this.target, 203));
    }

    @Override
    public void handleDeiconify() {
        this.postEvent(new WindowEvent((Window)this.target, 204));
    }

    @Override
    public void handleFocusEvent(XEvent xEvent) {
        super.handleFocusEvent(xEvent);
        XFocusChangeEvent xFocusChangeEvent = xEvent.get_xfocus();
        focusLog.finer("Received focus event on shell: " + xFocusChangeEvent);
    }

    @Override
    protected boolean isInitialReshape() {
        return false;
    }

    private static Insets difference(Insets insets, Insets insets2) {
        return new Insets(insets.top - insets2.top, insets.left - insets2.left, insets.bottom - insets2.bottom, insets.right - insets2.right);
    }

    private static boolean isNull(Insets insets) {
        return insets == null || (insets.left | insets.top | insets.right | insets.bottom) == 0;
    }

    private static Insets copy(Insets insets) {
        return new Insets(insets.top, insets.left, insets.bottom, insets.right);
    }

    private Insets getWMSetInsets(XAtom xAtom) {
        if (this.isEmbedded()) {
            return null;
        }
        if (this.wm_set_insets != null) {
            return this.wm_set_insets;
        }
        this.wm_set_insets = xAtom == null ? XWM.getInsetsFromExtents(this.getWindow()) : XWM.getInsetsFromProp(this.getWindow(), xAtom);
        insLog.log(Level.FINER, "FRAME_EXTENTS: {0}", new Object[]{this.wm_set_insets});
        if (this.wm_set_insets != null) {
            this.wm_set_insets = XDecoratedPeer.copy(this.wm_set_insets);
        }
        return this.wm_set_insets;
    }

    private void resetWMSetInsets() {
        this.wm_set_insets = null;
    }

    @Override
    public void handlePropertyNotify(XEvent xEvent) {
        super.handlePropertyNotify(xEvent);
        XPropertyEvent xPropertyEvent = xEvent.get_xproperty();
        if (xPropertyEvent.get_atom() == XWM.XA_KDE_NET_WM_FRAME_STRUT.getAtom() || xPropertyEvent.get_atom() == XWM.XA_NET_FRAME_EXTENTS.getAtom()) {
            this.getWMSetInsets(XAtom.get(xPropertyEvent.get_atom()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleReparentNotifyEvent(XEvent xEvent) {
        XReparentEvent xReparentEvent = xEvent.get_xreparent();
        if (insLog.isLoggable(Level.FINE)) {
            insLog.fine(xReparentEvent.toString());
        }
        this.reparent_serial = xReparentEvent.get_serial();
        XToolkit.awtLock();
        try {
            long l = XlibWrapper.RootWindow(XToolkit.getDisplay(), this.getScreenNumber());
            if (this.isEmbedded()) {
                this.setReparented(true);
                this.insets_corrected = true;
                return;
            }
            Component component = this.target;
            if (this.getDecorations() == XWindowAttributesData.AWT_DECOR_NONE) {
                this.setReparented(true);
                this.insets_corrected = true;
                this.reshape(this.dimensions, 2, false);
            } else if (xReparentEvent.get_parent() == l) {
                this.configure_seen = false;
                this.insets_corrected = false;
                if (this.isVisible()) {
                    XWM.getWM().unshadeKludge(this);
                    insLog.fine("- WM exited");
                } else {
                    insLog.fine(" - reparent due to hide");
                }
            } else {
                this.setReparented(true);
                this.insets_corrected = false;
                Insets insets = this.getWMSetInsets(null);
                if (insets != null) {
                    insLog.log(Level.FINER, "wm-provided insets {0}", new Object[]{insets});
                    Insets insets2 = this.dimensions.getInsets();
                    if (insets.equals(insets2)) {
                        insLog.finer("Insets are the same as estimated - no additional reshapes necessary");
                        this.no_reparent_artifacts = true;
                        this.insets_corrected = true;
                        this.applyGuessedInsets();
                        return;
                    }
                } else {
                    insets = XWM.getWM().getInsets(this, xReparentEvent.get_window(), xReparentEvent.get_parent());
                    if (insets != null) {
                        insLog.log(Level.FINER, "correctWM {0}", new Object[]{insets});
                    } else {
                        insLog.log(Level.FINER, "correctWM insets are not available, waiting for configureNotify");
                    }
                }
                if (insets != null) {
                    this.handleCorrectInsets(insets);
                }
            }
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleCorrectInsets(Insets insets) {
        XToolkit.awtLock();
        try {
            Insets insets2 = XDecoratedPeer.difference(insets, this.currentInsets);
            insLog.log(Level.FINEST, "Corrention {0}", new Object[]{insets2});
            if (!XDecoratedPeer.isNull(insets2)) {
                this.currentInsets = XDecoratedPeer.copy(insets);
                this.applyGuessedInsets();
                this.updateMinSizeHints();
            }
            if (insLog.isLoggable(Level.FINER)) {
                insLog.finer("Dimensions before reparent: " + this.dimensions);
            }
            this.dimensions.setInsets(this.getRealInsets());
            this.insets_corrected = true;
            if (this.isMaximized()) {
                return;
            }
            if ((this.getHints().get_flags() & 5L) != 0L) {
                this.reshape(this.dimensions, 3, false);
            } else {
                this.reshape(this.dimensions, 2, false);
            }
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    public void handleMoved(WindowDimensions windowDimensions) {
        Point point = windowDimensions.getLocation();
        ComponentAccessor.setX(this.target, point.x);
        ComponentAccessor.setY(this.target, point.y);
        this.postEvent(new ComponentEvent(this.target, 100));
    }

    protected Insets guessInsets() {
        if (this.isEmbedded() || this.isTargetUndecorated()) {
            return new Insets(0, 0, 0, 0);
        }
        if (!XDecoratedPeer.isNull(this.currentInsets)) {
            return XDecoratedPeer.copy(this.currentInsets);
        }
        Insets insets = this.getWMSetInsets(null);
        if (insets == null) {
            insets = XWM.getWM().guessInsets(this);
        }
        return insets;
    }

    private void applyGuessedInsets() {
        Insets insets = this.guessInsets();
        this.currentInsets = XDecoratedPeer.copy(insets);
    }

    public void revalidate() {
        XToolkit.executeOnEventHandlerThread(this.target, new Runnable(){

            @Override
            public void run() {
                XDecoratedPeer.this.target.invalidate();
                XDecoratedPeer.this.target.validate();
            }
        });
    }

    Insets getRealInsets() {
        if (XDecoratedPeer.isNull(this.currentInsets)) {
            this.applyGuessedInsets();
        }
        return this.currentInsets;
    }

    @Override
    public Insets getInsets() {
        Insets insets = XDecoratedPeer.copy(this.getRealInsets());
        insets.top += this.getMenuBarHeight();
        if (insLog.isLoggable(Level.FINEST)) {
            insLog.log(Level.FINEST, "Get insets returns {0}", new Object[]{insets});
        }
        return insets;
    }

    boolean gravityBug() {
        return XWM.configureGravityBuggy();
    }

    int getInputMethodHeight() {
        return 0;
    }

    void updateSizeHints(WindowDimensions windowDimensions) {
        Rectangle rectangle = windowDimensions.getClientRect();
        this.checkShellRect(rectangle);
        this.updateSizeHints(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    @Override
    void updateSizeHints() {
        this.updateSizeHints(this.dimensions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reshape(WindowDimensions windowDimensions, int n, boolean bl) {
        Cloneable cloneable;
        Cloneable cloneable2;
        if (insLog.isLoggable(Level.FINE)) {
            insLog.fine("Reshaping " + this + " to " + windowDimensions + " op " + n + " user reshape " + bl);
        }
        if (bl) {
            cloneable2 = windowDimensions.getBounds();
            cloneable = windowDimensions.getInsets();
            if (windowDimensions.isClientSizeSet()) {
                cloneable2 = new Rectangle(cloneable2.x, cloneable2.y, cloneable2.width - ((Insets)cloneable).left - ((Insets)cloneable).right, cloneable2.height - ((Insets)cloneable).top - ((Insets)cloneable).bottom);
            }
            windowDimensions = new WindowDimensions((Rectangle)cloneable2, (Insets)cloneable, windowDimensions.isClientSizeSet());
        }
        XToolkit.awtLock();
        try {
            if (!this.isReparented() || !this.isVisible()) {
                insLog.log(Level.FINE, "- not reparented({0}) or not visible({1}), default reshape", new Object[]{this.isReparented(), this.visible});
                cloneable2 = this.getLocation();
                cloneable = new Point(ComponentAccessor.getX(this.target), ComponentAccessor.getY(this.target));
                if (!((Point)cloneable).equals(cloneable2)) {
                    this.handleMoved(windowDimensions);
                }
                this.dimensions = new WindowDimensions(windowDimensions);
                this.updateSizeHints(this.dimensions);
                Rectangle rectangle = this.dimensions.getClientRect();
                this.checkShellRect(rectangle);
                this.setShellBounds(rectangle);
                if (this.content != null && !this.content.getSize().equals(windowDimensions.getSize())) {
                    this.reconfigureContentWindow(windowDimensions);
                }
                return;
            }
            int n2 = XWM.getWMID();
            this.updateChildrenSizes();
            this.applyGuessedInsets();
            cloneable = windowDimensions.getClientRect();
            if (this.gravityBug()) {
                Insets insets = windowDimensions.getInsets();
                ((Rectangle)cloneable).translate(insets.left, insets.top);
            }
            if ((n & 0x4000) == 0 && this.isEmbedded()) {
                ((Rectangle)cloneable).setLocation(0, 0);
            }
            this.checkShellRectSize((Rectangle)cloneable);
            if (!this.isEmbedded()) {
                this.checkShellRectPos((Rectangle)cloneable);
            }
            if ((n &= 0xFFFFBFFF) == 1) {
                this.setShellPosition((Rectangle)cloneable);
            } else if (this.isResizable()) {
                if (n == 3) {
                    this.setShellBounds((Rectangle)cloneable);
                } else {
                    this.setShellSize((Rectangle)cloneable);
                }
            } else {
                XWM.setShellNotResizable(this, windowDimensions, (Rectangle)cloneable, true);
                if (n == 3) {
                    this.setShellPosition((Rectangle)cloneable);
                }
            }
            this.reconfigureContentWindow(windowDimensions);
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    private void reshape(int n, int n2, int n3, int n4, int n5, boolean bl) {
        boolean bl2 = false;
        WindowDimensions windowDimensions = new WindowDimensions(this.dimensions);
        switch (n5 & 0xFFFFBFFF) {
            case 1: {
                windowDimensions.setLocation(n, n2);
                break;
            }
            case 2: {
                windowDimensions.setSize(n3, n4);
                break;
            }
            case 4: {
                Insets insets = this.currentInsets;
                windowDimensions.setClientSize(n3 -= insets.left + insets.right, n4 -= insets.top + insets.bottom);
                break;
            }
            default: {
                windowDimensions.setLocation(n, n2);
                windowDimensions.setSize(n3, n4);
            }
        }
        if (insLog.isLoggable(Level.FINE)) {
            insLog.log(Level.FINE, "For the operation {0} new dimensions are {1}", new Object[]{XDecoratedPeer.operationToString(n5), windowDimensions});
        }
        this.reshape(windowDimensions, n5, bl);
    }

    abstract boolean isTargetUndecorated();

    @Override
    public void setBounds(int n, int n2, int n3, int n4, int n5) {
        this.reshape(n, n2, n3, n4, n5, true);
        this.validateSurface();
    }

    void reconfigureContentWindow(WindowDimensions windowDimensions) {
        if (this.content == null) {
            insLog.fine("WARNING: Content window is null");
            return;
        }
        this.content.setContentBounds(windowDimensions);
    }

    @Override
    public void handleConfigureNotifyEvent(XEvent xEvent) {
        Object object;
        assert (SunToolkit.isAWTLockHeldByCurrentThread());
        XConfigureEvent xConfigureEvent = xEvent.get_xconfigure();
        insLog.log(Level.FINE, "Configure notify {0}", new Object[]{xConfigureEvent});
        if (this.isReparented()) {
            this.configure_seen = true;
        }
        if (!(this.isMaximized() || xConfigureEvent.get_serial() != this.reparent_serial && xConfigureEvent.get_window() == this.getShell() || this.no_reparent_artifacts)) {
            insLog.fine("- reparent artifact, skipping");
            return;
        }
        this.no_reparent_artifacts = false;
        if (!this.isVisible() && XWM.getWMID() != 2) {
            insLog.fine(" - not visible, skipping");
            return;
        }
        int n = XWM.getWMID();
        if (insLog.isLoggable(Level.FINE)) {
            insLog.log(Level.FINE, "reparented={0}, visible={1}, WM={2}, decorations={3}", new Object[]{this.isReparented(), this.isVisible(), n, this.getDecorations()});
        }
        if (!this.isReparented() && this.isVisible() && n != 2 && !XWM.isNonReparentingWM() && this.getDecorations() != XWindowAttributesData.AWT_DECOR_NONE) {
            insLog.fine("- visible but not reparented, skipping");
            return;
        }
        if (!this.insets_corrected && this.getDecorations() != XWindowAttributesData.AWT_DECOR_NONE) {
            long l = XlibUtil.getParentWindow(this.window);
            Object object2 = object = l != -1L ? XWM.getWM().getInsets(this, this.window, l) : null;
            if (insLog.isLoggable(Level.FINER)) {
                if (object != null) {
                    insLog.finer("Configure notify - insets : " + object);
                } else {
                    insLog.finer("Configure notify - insets are still not available");
                }
            }
            if (object != null) {
                this.handleCorrectInsets((Insets)object);
            } else {
                this.insets_corrected = true;
            }
        }
        this.updateChildrenSizes();
        Rectangle rectangle = new Rectangle(ComponentAccessor.getX(this.target), ComponentAccessor.getY(this.target), ComponentAccessor.getWidth(this.target), ComponentAccessor.getHeight(this.target));
        Cloneable cloneable = rectangle.getLocation();
        if (xConfigureEvent.get_send_event() || n == 2 || XWM.isNonReparentingWM()) {
            cloneable = new Point(xConfigureEvent.get_x() - this.currentInsets.left, xConfigureEvent.get_y() - this.currentInsets.top);
        } else {
            switch (XWM.getWMID()) {
                case 5: 
                case 6: 
                case 9: 
                case 11: {
                    object = this.queryXLocation();
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "New X location: {0}", new Object[]{object});
                    }
                    if (object == null) break;
                    cloneable = object;
                    break;
                }
            }
        }
        object = new WindowDimensions((Point)cloneable, new Dimension(xConfigureEvent.get_width(), xConfigureEvent.get_height()), XDecoratedPeer.copy(this.currentInsets), true);
        insLog.log(Level.FINER, "Insets are {0}, new dimensions {1}", new Object[]{this.currentInsets, object});
        this.checkIfOnNewScreen(((WindowDimensions)object).getBounds());
        Point point = this.getLocation();
        this.dimensions = object;
        if (!((Point)cloneable).equals(point)) {
            this.handleMoved((WindowDimensions)object);
        }
        this.reconfigureContentWindow((WindowDimensions)object);
        this.updateChildrenSizes();
        this.repositionSecurityWarning();
    }

    private void checkShellRectSize(Rectangle rectangle) {
        if (rectangle.width < 0) {
            rectangle.width = 1;
        }
        if (rectangle.height < 0) {
            rectangle.height = 1;
        }
    }

    private void checkShellRectPos(Rectangle rectangle) {
        int n = XWM.getWMID();
        if ((n == 5 || n == 6) && rectangle.x == 0 && rectangle.y == 0) {
            rectangle.y = 1;
            rectangle.x = 1;
        }
    }

    private void checkShellRect(Rectangle rectangle) {
        this.checkShellRectSize(rectangle);
        this.checkShellRectPos(rectangle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setShellBounds(Rectangle rectangle) {
        if (insLog.isLoggable(Level.FINE)) {
            insLog.fine("Setting shell bounds on " + this + " to " + rectangle);
        }
        XToolkit.awtLock();
        try {
            this.updateSizeHints(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            XlibWrapper.XResizeWindow(XToolkit.getDisplay(), this.getShell(), rectangle.width, rectangle.height);
            XlibWrapper.XMoveWindow(XToolkit.getDisplay(), this.getShell(), rectangle.x, rectangle.y);
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setShellSize(Rectangle rectangle) {
        if (insLog.isLoggable(Level.FINE)) {
            insLog.fine("Setting shell size on " + this + " to " + rectangle);
        }
        XToolkit.awtLock();
        try {
            this.updateSizeHints(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            XlibWrapper.XResizeWindow(XToolkit.getDisplay(), this.getShell(), rectangle.width, rectangle.height);
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setShellPosition(Rectangle rectangle) {
        if (insLog.isLoggable(Level.FINE)) {
            insLog.fine("Setting shell position on " + this + " to " + rectangle);
        }
        XToolkit.awtLock();
        try {
            this.updateSizeHints(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            XlibWrapper.XMoveWindow(XToolkit.getDisplay(), this.getShell(), rectangle.x, rectangle.y);
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    void initResizability() {
        this.setResizable(this.winAttr.initialResizability);
    }

    public void setResizable(boolean bl) {
        int n = this.winAttr.functions;
        if (!this.isResizable() && bl) {
            this.currentInsets = new Insets(0, 0, 0, 0);
            this.resetWMSetInsets();
            if (!this.isEmbedded()) {
                this.setReparented(false);
            }
            this.winAttr.isResizable = bl;
            n = (n & 1) != 0 ? (n &= 0xFFFFFFED) : (n |= 0x12);
            this.winAttr.functions = n;
            XWM.setShellResizable(this);
        } else if (this.isResizable() && !bl) {
            this.currentInsets = new Insets(0, 0, 0, 0);
            this.resetWMSetInsets();
            if (!this.isEmbedded()) {
                this.setReparented(false);
            }
            this.winAttr.isResizable = bl;
            n = (n & 1) != 0 ? (n |= 0x12) : (n &= 0xFFFFFFED);
            this.winAttr.functions = n;
            XWM.setShellNotResizable(this, this.dimensions, this.dimensions.getBounds(), false);
        }
    }

    Rectangle getShellBounds() {
        return this.dimensions.getClientRect();
    }

    @Override
    public Rectangle getBounds() {
        return this.dimensions.getBounds();
    }

    @Override
    public Dimension getSize() {
        return this.dimensions.getSize();
    }

    @Override
    public int getX() {
        return this.dimensions.getLocation().x;
    }

    @Override
    public int getY() {
        return this.dimensions.getLocation().y;
    }

    public Point getLocation() {
        return this.dimensions.getLocation();
    }

    @Override
    public int getAbsoluteX() {
        return this.dimensions.getScreenBounds().x;
    }

    @Override
    public int getAbsoluteY() {
        return this.dimensions.getScreenBounds().y;
    }

    @Override
    public int getWidth() {
        return this.getSize().width;
    }

    @Override
    public int getHeight() {
        return this.getSize().height;
    }

    public final WindowDimensions getDimensions() {
        return this.dimensions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Point getLocationOnScreen() {
        XToolkit.awtLock();
        try {
            if (this.configure_seen) {
                Point point = this.toGlobal(0, 0);
                return point;
            }
            Point point = this.target.getLocation();
            if (insLog.isLoggable(Level.FINE)) {
                insLog.log(Level.FINE, "getLocationOnScreen {0} not reparented: {1} ", new Object[]{this, point});
            }
            Point point2 = point;
            return point2;
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    @Override
    protected boolean isEventDisabled(XEvent xEvent) {
        switch (xEvent.get_type()) {
            case 22: {
                return true;
            }
            case 7: 
            case 8: {
                return true;
            }
        }
        return super.isEventDisabled(xEvent);
    }

    int getDecorations() {
        return this.winAttr.decorations;
    }

    int getFunctions() {
        return this.winAttr.functions;
    }

    @Override
    public void setVisible(boolean bl) {
        log.log(Level.FINER, "Setting {0} to visible {1}", new Object[]{this, bl});
        if (bl && !this.isVisible()) {
            XWM.setShellDecor(this);
            super.setVisible(bl);
            if (this.winAttr.isResizable) {
                XWM.removeSizeHints(this, 32L);
                this.updateMinimumSize();
            }
        } else {
            super.setVisible(bl);
        }
    }

    @Override
    protected void suppressWmTakeFocus(boolean bl) {
        XAtomList xAtomList = this.getWMProtocols();
        if (bl) {
            xAtomList.remove(wm_take_focus);
        } else {
            xAtomList.add(wm_take_focus);
        }
        wm_protocols.setAtomListProperty((XBaseWindow)this, xAtomList);
    }

    @Override
    public void dispose() {
        if (this.content != null) {
            this.content.destroy();
        }
        this.focusProxy.destroy();
        if (this.iconWindow != null) {
            this.iconWindow.destroy();
        }
        super.dispose();
    }

    @Override
    public void handleClientMessage(XEvent xEvent) {
        super.handleClientMessage(xEvent);
        XClientMessageEvent xClientMessageEvent = xEvent.get_xclient();
        if (wm_protocols != null && xClientMessageEvent.get_message_type() == wm_protocols.getAtom()) {
            if (xClientMessageEvent.get_data(0) == wm_delete_window.getAtom()) {
                this.handleQuit();
            } else if (xClientMessageEvent.get_data(0) == wm_take_focus.getAtom()) {
                this.handleWmTakeFocus(xClientMessageEvent);
            }
        }
    }

    private void handleWmTakeFocus(XClientMessageEvent xClientMessageEvent) {
        focusLog.log(Level.FINE, "WM_TAKE_FOCUS on {0}", new Object[]{this});
        this.requestWindowFocus(xClientMessageEvent.get_data(1), true);
    }

    @Override
    protected void requestXFocus(long l, boolean bl) {
        if (this.focusProxy == null) {
            if (focusLog.isLoggable(Level.FINE)) {
                focusLog.warning("Focus proxy is null for " + this);
            }
        } else {
            if (focusLog.isLoggable(Level.FINE)) {
                focusLog.fine("Requesting focus to proxy: " + this.focusProxy);
            }
            if (bl) {
                this.focusProxy.xRequestFocus(l);
            } else {
                this.focusProxy.xRequestFocus();
            }
        }
    }

    XFocusProxyWindow getFocusProxy() {
        return this.focusProxy;
    }

    public void handleQuit() {
        this.postEvent(new WindowEvent((Window)this.target, 201));
    }

    final void dumpMe() {
        System.err.println(">>> Peer: " + this.x + ", " + this.y + ", " + this.width + ", " + this.height);
    }

    final void dumpTarget() {
        int n = ComponentAccessor.getWidth(this.target);
        int n2 = ComponentAccessor.getHeight(this.target);
        int n3 = ComponentAccessor.getX(this.target);
        int n4 = ComponentAccessor.getY(this.target);
        System.err.println(">>> Target: " + n3 + ", " + n4 + ", " + n + ", " + n2);
    }

    final void dumpShell() {
        this.dumpWindow("Shell", this.getShell());
    }

    final void dumpContent() {
        this.dumpWindow("Content", this.getContentWindow());
    }

    final void dumpParent() {
        long l = XlibUtil.getParentWindow(this.getShell());
        if (l != 0L) {
            this.dumpWindow("Parent", l);
        } else {
            System.err.println(">>> NO PARENT");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void dumpWindow(String string, long l) {
        XWindowAttributes xWindowAttributes = new XWindowAttributes();
        try {
            XToolkit.awtLock();
            try {
                int n = XlibWrapper.XGetWindowAttributes(XToolkit.getDisplay(), l, xWindowAttributes.pData);
            }
            finally {
                XToolkit.awtUnlock();
            }
            System.err.println(">>>> " + string + ": " + xWindowAttributes.get_x() + ", " + xWindowAttributes.get_y() + ", " + xWindowAttributes.get_width() + ", " + xWindowAttributes.get_height());
        }
        finally {
            xWindowAttributes.dispose();
        }
    }

    final void dumpAll() {
        this.dumpTarget();
        this.dumpMe();
        this.dumpParent();
        this.dumpShell();
        this.dumpContent();
    }

    boolean isMaximized() {
        return false;
    }

    @Override
    boolean isOverrideRedirect() {
        return ((XToolkit)Toolkit.getDefaultToolkit()).isOverrideRedirect((Window)this.target);
    }

    @Override
    public boolean requestWindowFocus(long l, boolean bl) {
        focusLog.fine("Request for decorated window focus");
        Window window = XKeyboardFocusManagerPeer.getCurrentNativeFocusedWindow();
        Window window2 = XWindowPeer.getDecoratedOwner(window);
        focusLog.log(Level.FINER, "Current window is: active={0}, focused={1}", new Object[]{this.target == window2, this.target == window});
        XWindowPeer xWindowPeer = this;
        while (xWindowPeer.nextTransientFor != null) {
            xWindowPeer = xWindowPeer.nextTransientFor;
        }
        if (xWindowPeer == null || !xWindowPeer.focusAllowedFor()) {
            return false;
        }
        if (this == xWindowPeer) {
            if (this.isWMStateNetHidden()) {
                focusLog.fine("The window is unmapped, so rejecting the request");
                return false;
            }
            if (this.target == window2 && this.target != window) {
                focusLog.fine("Focus is on child window - transfering it back to the owner");
                this.handleWindowFocusInSync(-1L);
                return true;
            }
            Window window3 = XWindowPeer.getNativeFocusedWindow();
            focusLog.finest("Real native focused window: " + window3 + "\nKFM's focused window: " + window);
            if (this.target == window3) {
                focusLog.fine("The window is already natively focused.");
                return true;
            }
        }
        focusLog.fine("Requesting focus to " + (this == xWindowPeer ? "this window" : xWindowPeer));
        if (bl) {
            xWindowPeer.requestXFocus(l);
        } else {
            xWindowPeer.requestXFocus();
        }
        return this == xWindowPeer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void setActualFocusedWindow(XWindowPeer xWindowPeer) {
        Object object = this.getStateLock();
        synchronized (object) {
            this.actualFocusedWindow = xWindowPeer;
        }
    }

    boolean requestWindowFocus(XWindowPeer xWindowPeer, long l, boolean bl) {
        this.setActualFocusedWindow(xWindowPeer);
        return this.requestWindowFocus(l, bl);
    }

    @Override
    public void handleWindowFocusIn(long l) {
        if (null == this.actualFocusedWindow) {
            super.handleWindowFocusIn(l);
        } else {
            this.postEvent(new InvocationEvent((Object)this.target, new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    XWindowPeer xWindowPeer = null;
                    Object object = XDecoratedPeer.this.getStateLock();
                    synchronized (object) {
                        xWindowPeer = XDecoratedPeer.this.actualFocusedWindow;
                        XDecoratedPeer.this.actualFocusedWindow = null;
                        if (null == xWindowPeer || !xWindowPeer.isVisible() || !xWindowPeer.isFocusableWindow()) {
                            xWindowPeer = XDecoratedPeer.this;
                        }
                    }
                    xWindowPeer.handleWindowFocusIn_Dispatch();
                }
            }));
        }
    }

    @Override
    public void handleWindowFocusOut(Window window, long l) {
        Window window2;
        Window window3 = XKeyboardFocusManagerPeer.getCurrentNativeFocusedWindow();
        if (window3 != null && window3 != this.target && (window2 = XWindowPeer.getDecoratedOwner(window3)) != null && window2 == this.target) {
            this.setActualFocusedWindow((XWindowPeer)ComponentAccessor.getPeer(window3));
        }
        super.handleWindowFocusOut(window, l);
    }

    private Point queryXLocation() {
        return XlibUtil.translateCoordinates(this.getContentWindow(), XlibWrapper.RootWindow(XToolkit.getDisplay(), this.getScreenNumber()), new Point(0, 0));
    }
}

