/*
 * Decompiled with CFR 0.152.
 */
package sun.dyn;

import java.dyn.MethodHandle;
import java.dyn.MethodHandles;
import java.dyn.MethodType;
import sun.dyn.Access;
import sun.dyn.AdapterMethodHandle;
import sun.dyn.BoundMethodHandle;
import sun.dyn.DirectMethodHandle;
import sun.dyn.FromGeneric;
import sun.dyn.MemberName;
import sun.dyn.MethodHandleNatives;
import sun.dyn.ToGeneric;
import sun.dyn.util.VerifyType;

public abstract class MethodHandleImpl {
    private byte vmentry;
    protected Object vmtarget;
    static final int INT_FIELD = 0;
    static final long LONG_FIELD = 0L;
    private static final MemberName.Factory LOOKUP = MemberName.Factory.INSTANCE;
    private static MethodHandles.Lookup IMPL_LOOKUP_INIT;
    static final MethodHandles.Lookup IMPL_LOOKUP;

    public MethodHandleImpl(Access access) {
        Access.check(access);
    }

    public static void init(Access access, MethodType methodType) {
        Access.check(access);
        if (MethodHandleNatives.JVM_SUPPORT) {
            MethodHandleNatives.init(methodType);
        }
    }

    public static void initLookup(Access access, MethodHandles.Lookup lookup) {
        Access.check(access);
        if (IMPL_LOOKUP_INIT != null || lookup.lookupClass() != null) {
            throw new InternalError();
        }
        IMPL_LOOKUP_INIT = lookup;
    }

    public static MethodHandles.Lookup getLookup(Access access) {
        Access.check(access);
        return IMPL_LOOKUP;
    }

    public static void initStatics() {
    }

    public static MethodHandle findMethod(Access access, MemberName memberName, boolean bl, Class<?> clazz) {
        Object object;
        MethodType methodType;
        Access.check(access);
        MethodType methodType2 = methodType = memberName.getMethodType();
        if (memberName.isStatic()) {
            bl = false;
        } else {
            object = memberName.getDeclaringClass();
            methodType = methodType.insertParameterType(0, (Class<?>)object);
            if (memberName.isConstructor()) {
                bl = true;
            }
            methodType2 = methodType;
            if (((Class)object).getClassLoader() != null) {
                methodType2 = methodType2.changeParameterType(0, Object.class);
            }
        }
        object = new DirectMethodHandle(methodType, memberName, bl, clazz);
        if (!((DirectMethodHandle)object).isValid()) {
            throw MemberName.newNoAccessException(memberName, clazz);
        }
        MethodHandle methodHandle = AdapterMethodHandle.makePairwiseConvert(access, methodType2, (MethodHandle)object);
        if (methodHandle == null) {
            throw new InternalError();
        }
        return methodHandle;
    }

    public static MethodHandle accessField(Access access, MemberName memberName, boolean bl, Class<?> clazz) {
        Access.check(access);
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public static MethodHandle accessArrayElement(Access access, Class<?> clazz, boolean bl) {
        Access.check(access);
        if (!clazz.isArray()) {
            throw MethodHandleImpl.newIllegalArgumentException("not an array: " + clazz);
        }
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public static MethodHandle bindReceiver(Access access, MethodHandle methodHandle, Object object) {
        Object object2;
        Access.check(access);
        if (methodHandle instanceof AdapterMethodHandle && (object2 = MethodHandleNatives.getTargetInfo(methodHandle)) instanceof DirectMethodHandle) {
            DirectMethodHandle directMethodHandle = (DirectMethodHandle)object2;
            if (object == null || directMethodHandle.type().parameterType(0).isAssignableFrom(object.getClass())) {
                methodHandle = directMethodHandle;
            }
        }
        if (methodHandle instanceof DirectMethodHandle) {
            return new BoundMethodHandle((DirectMethodHandle)methodHandle, object, 0);
        }
        return null;
    }

    public static MethodHandle bindArgument(Access access, MethodHandle methodHandle, int n, Object object) {
        Access.check(access);
        throw new UnsupportedOperationException("NYI");
    }

    public static MethodHandle convertArguments(Access access, MethodHandle methodHandle, MethodType methodType, MethodType methodType2, int[] nArray) {
        Access.check(access);
        MethodHandle methodHandle2 = AdapterMethodHandle.makePairwiseConvert(access, methodType, methodHandle);
        if (methodHandle2 != null) {
            return methodHandle2;
        }
        int n = methodType2.parameterCount();
        MethodType methodType3 = MethodType.makeGeneric(n);
        MethodHandle methodHandle3 = AdapterMethodHandle.makePairwiseConvert(access, methodType3, methodHandle);
        if (methodHandle3 == null) {
            methodHandle3 = FromGeneric.make(methodHandle);
        }
        if ((methodHandle2 = AdapterMethodHandle.makePairwiseConvert(access, methodType, methodHandle3)) != null) {
            return methodHandle2;
        }
        return ToGeneric.make(methodType, methodHandle3);
    }

    public static MethodHandle spreadArguments(Access access, MethodHandle methodHandle, MethodType methodType, int n) {
        Access.check(access);
        MethodType methodType2 = methodHandle.type();
        int n2 = methodType2.parameterCount() - n;
        Class<Object[]> clazz = Object[].class;
        MethodHandle methodHandle2 = AdapterMethodHandle.makeSpreadArguments(access, methodType, methodHandle, clazz, n, n2);
        if (methodHandle2 != null) {
            return methodHandle2;
        }
        Class<?> clazz2 = null;
        if (n < 0 || n >= methodType.parameterCount() || !VerifyType.isSpreadArgType(clazz2 = methodType.parameterType(n))) {
            throw MethodHandleImpl.newIllegalArgumentException("no restarg in " + methodType);
        }
        Class<?>[] classArray = methodType2.parameterArray();
        for (int i = 0; i < n2; ++i) {
            classArray[n + i] = VerifyType.spreadArgElementType(clazz2, i);
        }
        MethodType methodType3 = MethodType.make(methodType.returnType(), classArray);
        if ((methodHandle = MethodHandleImpl.convertArguments(access, methodHandle, methodType3, methodType2, null)) == null) {
            throw new UnsupportedOperationException("NYI: convert " + methodType3 + " =calls=> " + methodType2);
        }
        methodHandle2 = AdapterMethodHandle.makeSpreadArguments(access, methodType, methodHandle, clazz, n, n2);
        return methodHandle2;
    }

    public static MethodHandle collectArguments(Access access, MethodHandle methodHandle, MethodType methodType, int n) {
        if (n > 0) {
            throw new UnsupportedOperationException("NYI");
        }
        throw new UnsupportedOperationException("NYI");
    }

    public static MethodHandle dropArguments(Access access, MethodHandle methodHandle, MethodType methodType, int n) {
        Access.check(access);
        throw new UnsupportedOperationException("NYI");
    }

    public static MethodHandle makeGuardWithTest(Access access, final MethodHandle methodHandle, final MethodHandle methodHandle2, final MethodHandle methodHandle3) {
        Access.check(access);
        MethodType methodType = methodHandle2.type();
        Class<?> clazz = methodType.returnType();
        if (methodType.parameterCount() != 1 || methodType.parameterType(0).isPrimitive()) {
            MethodType methodType2 = MethodType.make(Boolean.TYPE, Object[].class);
            MethodType methodType3 = MethodType.make(clazz, Object[].class);
            MethodHandle methodHandle4 = MethodHandleImpl.makeGuardWithTest(access, MethodHandles.spreadArguments(methodHandle, methodType2), MethodHandles.spreadArguments(methodHandle2, methodType3), MethodHandles.spreadArguments(methodHandle3, methodType3));
            return MethodHandles.collectArguments(methodHandle4, methodType);
        }
        if (clazz.isPrimitive()) {
            MethodType methodType4 = methodType.changeReturnType(Object.class);
            MethodHandle methodHandle5 = MethodHandleImpl.makeGuardWithTest(access, methodHandle, MethodHandles.convertArguments(methodHandle2, methodType4), MethodHandles.convertArguments(methodHandle3, methodType4));
            return MethodHandles.convertArguments(methodHandle5, methodType);
        }
        class Guarder {
            Guarder() {
            }

            Object invoke(Object object) {
                boolean bl = (Boolean)MethodHandles.invoke_1(methodHandle, object);
                MethodHandle methodHandle4 = bl ? methodHandle2 : methodHandle3;
                return MethodHandles.invoke_1(methodHandle4, object);
            }

            MethodHandle handle() {
                MethodType methodType = MethodType.makeGeneric(0, true);
                MethodHandle methodHandle4 = IMPL_LOOKUP.bind(this, "invoke", methodType);
                return MethodHandles.collectArguments(methodHandle4, methodHandle2.type());
            }
        }
        return new Guarder().handle();
    }

    public static MethodHandle combineArguments(Access access, MethodHandle methodHandle, MethodHandle methodHandle2, int n) {
        Access.check(access);
        throw new UnsupportedOperationException("Not yet implemented");
    }

    protected static String basicToString(MethodHandle methodHandle) {
        MemberName memberName = null;
        if (methodHandle != null) {
            memberName = MethodHandleNatives.getMethodName(methodHandle);
        }
        if (memberName == null) {
            return "<unknown>";
        }
        return memberName.getName();
    }

    protected static String addTypeString(MethodHandle methodHandle, String string) {
        if (methodHandle == null) {
            return string;
        }
        return string + methodHandle.type();
    }

    static RuntimeException newIllegalArgumentException(String string) {
        return new IllegalArgumentException(string);
    }

    public String toString() {
        MethodHandle methodHandle = (MethodHandle)this;
        return MethodHandleImpl.addTypeString(methodHandle, MethodHandleImpl.basicToString(methodHandle));
    }

    static {
        MethodHandles.Lookup.PUBLIC_LOOKUP.lookupClass();
        if (IMPL_LOOKUP_INIT == null) {
            throw new InternalError();
        }
        IMPL_LOOKUP = IMPL_LOOKUP_INIT;
    }
}

