/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.attribute.UserDefinedFileAttributeView;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sun.nio.fs.DynamicFileAttributeView;

abstract class AbstractUserDefinedFileAttributeView
implements UserDefinedFileAttributeView,
DynamicFileAttributeView {
    protected AbstractUserDefinedFileAttributeView() {
    }

    protected void checkAccess(String string, boolean bl, boolean bl2) {
        assert (bl || bl2);
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (bl) {
                securityManager.checkRead(string);
            }
            if (bl2) {
                securityManager.checkWrite(string);
            }
            securityManager.checkPermission(new RuntimePermission("accessUserDefinedAttributes"));
        }
    }

    @Override
    public final String name() {
        return "user";
    }

    @Override
    public final Object getAttribute(String string) throws IOException {
        int n;
        try {
            n = this.size(string);
        }
        catch (IOException iOException) {
            if (this.list().contains(string)) {
                throw iOException;
            }
            return null;
        }
        byte[] byArray = new byte[n];
        int n2 = this.read(string, ByteBuffer.wrap(byArray));
        return n2 == n ? byArray : Arrays.copyOf(byArray, n2);
    }

    @Override
    public final void setAttribute(String string, Object object) throws IOException {
        ByteBuffer byteBuffer = object instanceof byte[] ? ByteBuffer.wrap((byte[])object) : (ByteBuffer)object;
        this.write(string, byteBuffer);
    }

    @Override
    public final Map<String, ?> readAttributes(String[] stringArray) throws IOException {
        List<String> list = new ArrayList<String>();
        for (String object : stringArray) {
            if (object.equals("*")) {
                list = this.list();
                break;
            }
            list.add(object);
        }
        HashMap hashMap = new HashMap();
        for (String string : list) {
            Object object = this.getAttribute(string);
            if (object == null) continue;
            hashMap.put(string, object);
        }
        return hashMap;
    }
}

