/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.io.IOException;
import java.security.cert.CertPathValidatorException;
import sun.security.provider.certpath.CertId;
import sun.security.util.Debug;
import sun.security.util.DerOutputStream;
import sun.security.x509.SerialNumber;
import sun.security.x509.X509CertImpl;

class OCSPRequest {
    private static final Debug debug = Debug.getInstance("certpath");
    private static final boolean dump = false;
    private SerialNumber serialNumber;
    private X509CertImpl issuerCert;
    private CertId certId = null;

    OCSPRequest(X509CertImpl x509CertImpl, X509CertImpl x509CertImpl2) throws CertPathValidatorException {
        if (x509CertImpl2 == null) {
            throw new CertPathValidatorException("Null IssuerCertificate");
        }
        this.issuerCert = x509CertImpl2;
        this.serialNumber = x509CertImpl.getSerialNumberObject();
    }

    byte[] encodeBytes() throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        SingleRequest singleRequest = null;
        try {
            singleRequest = new SingleRequest(this.issuerCert, this.serialNumber);
        }
        catch (Exception exception) {
            throw new IOException("Error encoding OCSP request");
        }
        this.certId = singleRequest.getCertId();
        singleRequest.encode(derOutputStream2);
        derOutputStream.write((byte)48, derOutputStream2);
        DerOutputStream derOutputStream3 = new DerOutputStream();
        derOutputStream3.write((byte)48, derOutputStream);
        DerOutputStream derOutputStream4 = new DerOutputStream();
        derOutputStream4.write((byte)48, derOutputStream3);
        byte[] byArray = derOutputStream4.toByteArray();
        return byArray;
    }

    CertId getCertId() {
        return this.certId;
    }

    private static class SingleRequest {
        private CertId certId;

        private SingleRequest(X509CertImpl x509CertImpl, SerialNumber serialNumber) throws Exception {
            this.certId = new CertId(x509CertImpl, serialNumber);
        }

        private void encode(DerOutputStream derOutputStream) throws IOException {
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.certId.encode(derOutputStream2);
            derOutputStream.write((byte)48, derOutputStream2);
        }

        private CertId getCertId() {
            return this.certId;
        }
    }
}

