/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import sun.security.ssl.CipherSuiteList;
import sun.security.ssl.DefaultSSLContextImpl;
import sun.security.ssl.SSLContextImpl;
import sun.security.ssl.SSLServerSocketImpl;

public final class SSLServerSocketFactoryImpl
extends SSLServerSocketFactory {
    private static final int DEFAULT_BACKLOG = 50;
    private SSLContextImpl context;

    public SSLServerSocketFactoryImpl() throws Exception {
        this.context = DefaultSSLContextImpl.getDefaultImpl();
    }

    SSLServerSocketFactoryImpl(SSLContextImpl sSLContextImpl) {
        this.context = sSLContextImpl;
    }

    @Override
    public ServerSocket createServerSocket() throws IOException {
        return new SSLServerSocketImpl(this.context);
    }

    @Override
    public ServerSocket createServerSocket(int n) throws IOException {
        return new SSLServerSocketImpl(n, 50, this.context);
    }

    @Override
    public ServerSocket createServerSocket(int n, int n2) throws IOException {
        return new SSLServerSocketImpl(n, n2, this.context);
    }

    @Override
    public ServerSocket createServerSocket(int n, int n2, InetAddress inetAddress) throws IOException {
        return new SSLServerSocketImpl(n, n2, inetAddress, this.context);
    }

    @Override
    public String[] getDefaultCipherSuites() {
        CipherSuiteList.clearAvailableCache();
        return CipherSuiteList.getDefault().toStringArray();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        CipherSuiteList.clearAvailableCache();
        return CipherSuiteList.getSupported().toStringArray();
    }
}

