/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.scope;

import org.jruby.Ruby;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.scope.NoVarsDynamicScope;

public class DummyDynamicScope
extends NoVarsDynamicScope {
    private static final int SIZE = 0;
    private static final String GROW_ERROR = "DummyDynamicScope cannot be grown; use ManyVarsDynamicScope";

    public DummyDynamicScope(StaticScope staticScope, DynamicScope parent) {
        super(staticScope, parent);
    }

    public DummyDynamicScope(StaticScope staticScope) {
        super(staticScope);
    }

    public void growIfNeeded() {
        this.growIfNeeded(0, GROW_ERROR);
    }

    protected void growIfNeeded(int size2, String message2) {
        if (this.staticScope.getNumberOfVariables() != size2) {
            throw new RuntimeException(message2);
        }
    }

    public DynamicScope cloneScope() {
        return new DummyDynamicScope(this.staticScope, this.parent);
    }

    public IRubyObject getBackRef(Ruby runtime2) {
        if (!this.staticScope.isBackrefLastlineScope()) {
            return this.parent.getBackRef(runtime2);
        }
        throw new RuntimeException("DummyDynamicScope should never be used for backref storage");
    }

    public IRubyObject setBackRef(IRubyObject backref) {
        if (!this.staticScope.isBackrefLastlineScope()) {
            return this.parent.setBackRef(backref);
        }
        throw new RuntimeException("DummyDynamicScope should never be used for backref storage");
    }

    public IRubyObject getLastLine(Ruby runtime2) {
        if (!this.staticScope.isBackrefLastlineScope()) {
            return this.parent.getLastLine(runtime2);
        }
        throw new RuntimeException("DummyDynamicScope should never be used for lastline storage");
    }

    public IRubyObject setLastLine(IRubyObject lastline) {
        if (!this.staticScope.isBackrefLastlineScope()) {
            return this.parent.setLastLine(lastline);
        }
        throw new RuntimeException("DummyDynamicScope should never be used for backref storage");
    }
}

