/*
 * Decompiled with CFR 0.152.
 */
package org.jvyamlb;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jruby.util.ByteList;
import org.jvyamlb.Composer;
import org.jvyamlb.Parser;
import org.jvyamlb.ParserImpl;
import org.jvyamlb.Resolver;
import org.jvyamlb.ResolverImpl;
import org.jvyamlb.ScannerImpl;
import org.jvyamlb.events.AliasEvent;
import org.jvyamlb.events.Event;
import org.jvyamlb.events.MappingEndEvent;
import org.jvyamlb.events.MappingStartEvent;
import org.jvyamlb.events.NodeEvent;
import org.jvyamlb.events.ScalarEvent;
import org.jvyamlb.events.SequenceEndEvent;
import org.jvyamlb.events.SequenceStartEvent;
import org.jvyamlb.events.StreamEndEvent;
import org.jvyamlb.events.StreamStartEvent;
import org.jvyamlb.exceptions.ComposerException;
import org.jvyamlb.nodes.MappingNode;
import org.jvyamlb.nodes.Node;
import org.jvyamlb.nodes.ScalarNode;
import org.jvyamlb.nodes.SequenceNode;

public class ComposerImpl
implements Composer {
    protected Parser parser;
    private Resolver resolver;
    private Map anchors;
    private static final boolean[] FALS = new boolean[]{false};
    private static final boolean[] TRU = new boolean[]{true};

    public ComposerImpl(Parser parser, Resolver resolver) {
        this.parser = parser;
        this.resolver = resolver;
        this.anchors = new HashMap();
    }

    public boolean checkNode() {
        return !(this.parser.peekEvent() instanceof StreamEndEvent);
    }

    public Node getNode() {
        return this.checkNode() ? this.composeDocument() : (Node)null;
    }

    public Iterator eachNode() {
        return new NodeIterator();
    }

    public Iterator iterator() {
        return this.eachNode();
    }

    public Node composeDocument() {
        if (this.parser.peekEvent() instanceof StreamStartEvent) {
            this.parser.getEvent();
        }
        this.parser.getEvent();
        Node node = this.composeNode(null, null);
        this.parser.getEvent();
        this.anchors.clear();
        return node;
    }

    protected Node getScalar(String tag, ByteList value2, char style, Event e) {
        return new ScalarNode(tag, value2, style);
    }

    protected Node createMapping(String tag, Map value2, boolean flowStyle, Event e) {
        return new MappingNode(tag, value2, flowStyle);
    }

    protected void finalizeMapping(Node node, Event e) {
    }

    protected Node createSequence(String tag, List value2, boolean flowStyle, Event e) {
        return new SequenceNode(tag, value2, flowStyle);
    }

    protected void finalizeSequence(Node node, Event e) {
    }

    protected void composerException(String when, String what, String note, Event e) {
        throw new ComposerException(when, what, note);
    }

    public Node composeNode(Node parent, Object index2) {
        if (this.parser.peekEvent() instanceof AliasEvent) {
            AliasEvent event = (AliasEvent)this.parser.getEvent();
            String anchor = event.getAnchor();
            if (!this.anchors.containsKey(anchor)) {
                this.composerException(null, "found undefined alias " + anchor, null, event);
            }
            return (Node)this.anchors.get(anchor);
        }
        Event event = this.parser.peekEvent();
        String anchor = null;
        if (event instanceof NodeEvent) {
            anchor = ((NodeEvent)event).getAnchor();
        }
        this.resolver.descendResolver(parent, index2);
        Node node = null;
        if (event instanceof ScalarEvent) {
            ScalarEvent ev = (ScalarEvent)this.parser.getEvent();
            String tag = ev.getTag();
            if (tag == null || tag.equals("!")) {
                tag = this.resolver.resolve(ScalarNode.class, ev.getValue(), ev.getImplicit());
            }
            node = this.getScalar(tag, ev.getValue(), ev.getStyle(), ev);
            if (null != anchor) {
                this.anchors.put(anchor, node);
            }
        } else if (event instanceof SequenceStartEvent) {
            SequenceStartEvent start2 = (SequenceStartEvent)this.parser.getEvent();
            String tag = start2.getTag();
            if (tag == null || tag.equals("!")) {
                tag = this.resolver.resolve(SequenceNode.class, null, start2.getImplicit() ? TRU : FALS);
            }
            node = this.createSequence(tag, new ArrayList(), start2.getFlowStyle(), start2);
            if (null != anchor) {
                this.anchors.put(anchor, node);
            }
            int ix = 0;
            while (!(this.parser.peekEvent() instanceof SequenceEndEvent)) {
                ((List)node.getValue()).add(this.composeNode(node, new Integer(ix++)));
            }
            this.finalizeSequence(node, this.parser.getEvent());
        } else if (event instanceof MappingStartEvent) {
            MappingStartEvent start3 = (MappingStartEvent)this.parser.getEvent();
            String tag = start3.getTag();
            if (tag == null || tag.equals("!")) {
                tag = this.resolver.resolve(MappingNode.class, null, start3.getImplicit() ? TRU : FALS);
            }
            node = this.createMapping(tag, new HashMap(), start3.getFlowStyle(), start3);
            if (null != anchor) {
                this.anchors.put(anchor, node);
            }
            while (!(this.parser.peekEvent() instanceof MappingEndEvent)) {
                Event key2 = this.parser.peekEvent();
                Node itemKey = this.composeNode(node, null);
                if (((Map)node.getValue()).containsKey(itemKey)) {
                    this.composeNode(node, itemKey);
                    continue;
                }
                ((Map)node.getValue()).put(itemKey, this.composeNode(node, itemKey));
            }
            this.finalizeMapping(node, this.parser.getEvent());
        }
        this.resolver.ascendResolver();
        return node;
    }

    public static void main(String[] args2) throws Exception {
        String filename2 = args2[0];
        System.out.println("Reading of file: \"" + filename2 + "\"");
        ByteList input = new ByteList(1024);
        FileInputStream reader = new FileInputStream(filename2);
        byte[] buff = new byte[1024];
        int read2 = 0;
        do {
            read2 = ((InputStream)reader).read(buff);
            input.append(buff, 0, read2);
        } while (read2 >= 1024);
        ((InputStream)reader).close();
        long before = System.currentTimeMillis();
        for (int i = 0; i < 1; ++i) {
            ComposerImpl cmp2 = new ComposerImpl(new ParserImpl(new ScannerImpl(input)), new ResolverImpl());
            Iterator iter = cmp2.eachNode();
            while (iter.hasNext()) {
                iter.next();
            }
        }
        long after = System.currentTimeMillis();
        long time = after - before;
        double timeS = (double)(after - before) / 1000.0;
        System.out.println("Walking through the nodes for the file: " + filename2 + " took " + time + "ms, or " + timeS + " seconds");
    }

    private class NodeIterator
    implements Iterator {
        private NodeIterator() {
        }

        public boolean hasNext() {
            return ComposerImpl.this.checkNode();
        }

        public Object next() {
            return ComposerImpl.this.getNode();
        }

        public void remove() {
        }
    }
}

