/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.jdwp.processor;

import gnu.classpath.jdwp.VMVirtualMachine;
import gnu.classpath.jdwp.exception.JdwpException;
import gnu.classpath.jdwp.exception.JdwpInternalErrorException;
import gnu.classpath.jdwp.exception.NotImplementedException;
import gnu.classpath.jdwp.id.ObjectId;
import gnu.classpath.jdwp.id.ReferenceTypeId;
import gnu.classpath.jdwp.processor.CommandSet;
import gnu.classpath.jdwp.util.JdwpString;
import gnu.classpath.jdwp.util.Signature;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;

public class VirtualMachineCommandSet
extends CommandSet {
    public boolean runCommand(ByteBuffer byteBuffer, DataOutputStream dataOutputStream, byte by) throws JdwpException {
        boolean bl = false;
        try {
            switch (by) {
                case 1: {
                    this.executeVersion(byteBuffer, dataOutputStream);
                    break;
                }
                case 2: {
                    this.executeClassesBySignature(byteBuffer, dataOutputStream);
                    break;
                }
                case 3: {
                    this.executeAllClasses(byteBuffer, dataOutputStream);
                    break;
                }
                case 4: {
                    this.executeAllThreads(byteBuffer, dataOutputStream);
                    break;
                }
                case 5: {
                    this.executeTopLevelThreadGroups(byteBuffer, dataOutputStream);
                    break;
                }
                case 7: {
                    this.executeIDsizes(byteBuffer, dataOutputStream);
                    break;
                }
                case 6: {
                    bl = true;
                    this.executeDispose(byteBuffer, dataOutputStream);
                    break;
                }
                case 8: {
                    this.executeSuspend(byteBuffer, dataOutputStream);
                    break;
                }
                case 9: {
                    this.executeResume(byteBuffer, dataOutputStream);
                    break;
                }
                case 10: {
                    bl = true;
                    this.executeExit(byteBuffer, dataOutputStream);
                    break;
                }
                case 11: {
                    this.executeCreateString(byteBuffer, dataOutputStream);
                    break;
                }
                case 12: {
                    this.executeCapabilities(byteBuffer, dataOutputStream);
                    break;
                }
                case 13: {
                    this.executeClassPaths(byteBuffer, dataOutputStream);
                    break;
                }
                case 14: {
                    this.executeDisposeObjects(byteBuffer, dataOutputStream);
                    break;
                }
                case 15: {
                    this.executeHoldEvents(byteBuffer, dataOutputStream);
                    break;
                }
                case 16: {
                    this.executeReleaseEvents(byteBuffer, dataOutputStream);
                    break;
                }
                case 17: {
                    this.executeCapabilitiesNew(byteBuffer, dataOutputStream);
                    break;
                }
                case 18: {
                    this.executeRedefineClasses(byteBuffer, dataOutputStream);
                    break;
                }
                case 19: {
                    this.executeSetDefaultStratum(byteBuffer, dataOutputStream);
                    break;
                }
                case 20: {
                    this.executeAllClassesWithGeneric(byteBuffer, dataOutputStream);
                    break;
                }
                default: {
                    throw new NotImplementedException("Command " + by + " not found in VirtualMachine Command Set.");
                }
            }
        }
        catch (IOException iOException) {
            throw new JdwpInternalErrorException(iOException);
        }
        return bl;
    }

    private final void executeVersion(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException, IOException {
        Properties properties = System.getProperties();
        int n = 1;
        int n2 = 4;
        String string = "JDWP version " + n + '.' + n2 + ", JVM version " + properties.getProperty("java.vm.name") + ' ' + properties.getProperty("java.vm.version") + ' ' + properties.getProperty("java.version");
        String string2 = properties.getProperty("java.version");
        String string3 = properties.getProperty("java.vm.name");
        JdwpString.writeString(dataOutputStream, string);
        dataOutputStream.writeInt(n);
        dataOutputStream.writeInt(n2);
        JdwpString.writeString(dataOutputStream, string3);
        JdwpString.writeString(dataOutputStream, string2);
    }

    private final void executeClassesBySignature(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException, IOException {
        Object object;
        String string = JdwpString.readString(byteBuffer);
        ArrayList arrayList = new ArrayList();
        Iterator iterator = VMVirtualMachine.getAllLoadedClasses();
        while (iterator.hasNext()) {
            Class clazz = (Class)iterator.next();
            object = Signature.computeClassSignature(clazz);
            if (!((String)object).equals(string)) continue;
            arrayList.add(clazz);
        }
        dataOutputStream.writeInt(arrayList.size());
        int n = 0;
        while (n < arrayList.size()) {
            object = (Class)arrayList.get(n);
            ReferenceTypeId referenceTypeId = this.idMan.getReferenceTypeId((Class)object);
            referenceTypeId.writeTagged(dataOutputStream);
            int n2 = VMVirtualMachine.getClassStatus((Class)object);
            dataOutputStream.writeInt(n2);
            ++n;
        }
    }

    private final void executeAllClasses(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException, IOException {
        int n = VMVirtualMachine.getAllLoadedClassesCount();
        dataOutputStream.writeInt(n);
        Iterator iterator = VMVirtualMachine.getAllLoadedClasses();
        int n2 = 0;
        while (iterator.hasNext() && n2++ < n) {
            Class clazz = (Class)iterator.next();
            ReferenceTypeId referenceTypeId = this.idMan.getReferenceTypeId(clazz);
            referenceTypeId.writeTagged(dataOutputStream);
            String string = Signature.computeClassSignature(clazz);
            JdwpString.writeString(dataOutputStream, string);
            int n3 = VMVirtualMachine.getClassStatus(clazz);
            dataOutputStream.writeInt(n3);
        }
    }

    private final void executeAllThreads(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException, IOException {
        Thread thread;
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        ThreadGroup threadGroup2 = this.getRootThreadGroup(threadGroup);
        int n = threadGroup2.activeCount();
        Thread[] threadArray = new Thread[n];
        threadGroup2.enumerate(threadArray);
        n = 0;
        int n2 = 0;
        while (n2 < threadArray.length) {
            thread = threadArray[n2];
            if (thread == null) break;
            if (!thread.getThreadGroup().equals(threadGroup)) {
                ++n;
            }
            ++n2;
        }
        dataOutputStream.writeInt(n);
        n2 = 0;
        while (n2 < threadArray.length) {
            thread = threadArray[n2];
            if (thread == null) break;
            if (!thread.getThreadGroup().equals(threadGroup)) {
                this.idMan.getObjectId(thread).write(dataOutputStream);
            }
            ++n2;
        }
    }

    private final void executeTopLevelThreadGroups(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException, IOException {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        ThreadGroup threadGroup2 = this.getRootThreadGroup(threadGroup);
        dataOutputStream.writeInt(1);
        this.idMan.getObjectId(threadGroup2);
    }

    private final void executeDispose(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException {
        throw new NotImplementedException("Command VirtualMachine.Dispose not implemented");
    }

    private final void executeIDsizes(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException, IOException {
        dataOutputStream.writeInt(8);
        dataOutputStream.writeInt(8);
        dataOutputStream.writeInt(8);
        dataOutputStream.writeInt(8);
        dataOutputStream.writeInt(8);
    }

    private final void executeSuspend(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException {
        VMVirtualMachine.suspendAllThreads();
    }

    private final void executeResume(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException {
        VMVirtualMachine.resumeAllThreads();
    }

    private final void executeExit(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException, IOException {
        int n = byteBuffer.getInt();
        System.exit(n);
    }

    private final void executeCreateString(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException, IOException {
        String string = JdwpString.readString(byteBuffer);
        ObjectId objectId = this.idMan.getObjectId(string);
        objectId.disableCollection();
        objectId.write(dataOutputStream);
    }

    private final void executeCapabilities(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException, IOException {
        dataOutputStream.writeBoolean(false);
        dataOutputStream.writeBoolean(false);
        dataOutputStream.writeBoolean(false);
        dataOutputStream.writeBoolean(false);
        dataOutputStream.writeBoolean(false);
        dataOutputStream.writeBoolean(false);
        dataOutputStream.writeBoolean(false);
    }

    private final void executeClassPaths(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException, IOException {
        String string = System.getProperty("user.dir");
        JdwpString.writeString(dataOutputStream, string);
        String string2 = System.getProperty("java.class.path");
        String[] stringArray = string2.split(":");
        dataOutputStream.writeInt(stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            JdwpString.writeString(dataOutputStream, stringArray[n]);
            ++n;
        }
        String string3 = System.getProperty("sun.boot.class.path");
        stringArray = string3.split(":");
        dataOutputStream.writeInt(stringArray.length);
        int n2 = 0;
        while (n2 < stringArray.length) {
            JdwpString.writeString(dataOutputStream, stringArray[n2]);
            ++n2;
        }
    }

    private final void executeDisposeObjects(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException {
    }

    private final void executeHoldEvents(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException {
        throw new NotImplementedException("Command VirtualMachine.HoldEvents not implemented");
    }

    private final void executeReleaseEvents(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException {
        throw new NotImplementedException("Command VirtualMachine.ReleaseEvents not implemented");
    }

    private final void executeCapabilitiesNew(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException, IOException {
        dataOutputStream.writeBoolean(false);
        dataOutputStream.writeBoolean(false);
        dataOutputStream.writeBoolean(false);
        dataOutputStream.writeBoolean(false);
        dataOutputStream.writeBoolean(false);
        dataOutputStream.writeBoolean(false);
        dataOutputStream.writeBoolean(false);
        dataOutputStream.writeBoolean(false);
        dataOutputStream.writeBoolean(false);
        dataOutputStream.writeBoolean(false);
        dataOutputStream.writeBoolean(false);
        dataOutputStream.writeBoolean(false);
        dataOutputStream.writeBoolean(false);
        dataOutputStream.writeBoolean(false);
        dataOutputStream.writeBoolean(false);
        int n = 15;
        while (n < 32) {
            dataOutputStream.writeBoolean(false);
            ++n;
        }
    }

    private final void executeRedefineClasses(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException {
        throw new NotImplementedException("Command VirtualMachine.RedefineClasses not implemented");
    }

    private final void executeSetDefaultStratum(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException {
        throw new NotImplementedException("Command VirtualMachine.SetDefaultStratum not implemented");
    }

    private final void executeAllClassesWithGeneric(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException {
        throw new NotImplementedException("Command VirtualMachine.AllClassesWithGeneric not implemented");
    }

    private final ThreadGroup getRootThreadGroup(ThreadGroup threadGroup) {
        ThreadGroup threadGroup2 = threadGroup.getParent();
        while (threadGroup2 != null) {
            threadGroup = threadGroup2;
            threadGroup2 = threadGroup.getParent();
        }
        return threadGroup;
    }
}

