/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.net;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public class CRLFInputStream
extends InputStream {
    public static final int CR = 13;
    public static final int LF = 10;
    protected InputStream in;
    private boolean doReset;

    public int read() throws IOException {
        int n = this.in.read();
        if (n == 13) {
            this.in.mark(1);
            int n2 = this.in.read();
            if (n2 == 10) {
                n = n2;
            } else {
                this.in.reset();
            }
        }
        return n;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.in.mark(n2 + 1);
        int n3 = this.in.read(byArray, n, n2);
        if (n3 > 0) {
            int n4 = this.indexOfCRLF(byArray, n, n3);
            if (this.doReset) {
                this.in.reset();
                if (n4 != -1) {
                    n3 = this.in.read(byArray, n, n4 + 1 - n);
                    this.in.read();
                    byArray[n4] = 10;
                } else {
                    n3 = this.in.read(byArray, n, n2);
                }
            }
        }
        return n3;
    }

    private final int indexOfCRLF(byte[] byArray, int n, int n2) throws IOException {
        this.doReset = false;
        int n3 = n + n2;
        int n4 = n3 - 1;
        int n5 = n;
        while (n5 < n3) {
            if (byArray[n5] == 13) {
                int n6;
                if (n5 == n4) {
                    n6 = this.in.read();
                    this.doReset = true;
                } else {
                    n6 = byArray[n5 + 1];
                }
                if (n6 == 10) {
                    this.doReset = true;
                    return n5;
                }
            }
            ++n5;
        }
        return -1;
    }

    public CRLFInputStream(InputStream inputStream) {
        this.in = inputStream.markSupported() ? inputStream : new BufferedInputStream(inputStream);
    }
}

