/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.UnknownHostException;

public class PlainSocketImpl
extends SocketImpl {
    private InputStream in;
    private OutputStream out;
    protected int timeout = -1;
    private boolean closed;
    private boolean blocking = true;
    private boolean connecting;
    private int native_fd = -1;
    private int fdUsed;
    private boolean inChannelOperation;

    public final boolean isInChannelOperation() {
        return this.inChannelOperation;
    }

    public final void setInChannelOperation(boolean bl) {
        this.inChannelOperation = bl;
    }

    public int getNativeFD() {
        return this.native_fd;
    }

    protected void accept(SocketImpl socketImpl) throws IOException {
        if (!(socketImpl instanceof PlainSocketImpl)) {
            throw new IllegalArgumentException("Kaffe only supports PlainSocketImpl in accept.");
        }
        this.socketAccept(socketImpl);
    }

    protected int available() throws IOException {
        int n = 0;
        if (!this.closed) {
            n = this.socketAvailable();
        }
        return n;
    }

    protected void bind(InetAddress inetAddress, int n) throws IOException {
        this.socketBind(inetAddress, n);
    }

    protected void close() throws IOException {
        if (!this.closed) {
            this.socketClose();
        }
        this.closed = true;
        this.in = null;
        this.out = null;
    }

    protected void connect(String string, int n) throws IOException {
        this.connect(InetAddress.getByName(string), n);
    }

    protected void connect(InetAddress inetAddress, int n) throws IOException {
        this.socketConnect(inetAddress, n, this.timeout);
    }

    protected void connect(SocketAddress socketAddress, int n) throws IOException {
        InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
        InetAddress inetAddress = inetSocketAddress.getAddress();
        if (inetAddress == null) {
            throw new IllegalArgumentException("address is unresolved: " + inetSocketAddress);
        }
        if (n < 0) {
            throw new IllegalArgumentException("negative timeout");
        }
        if (n == 0) {
            n = -1;
        }
        this.socketConnect(inetAddress, inetSocketAddress.getPort(), n);
    }

    protected void create(boolean bl) throws IOException {
        this.socketCreate(bl);
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    protected InputStream getInputStream() throws IOException {
        if (this.in == null) {
            this.in = new SocketInputStream(this);
        }
        return this.in;
    }

    protected OutputStream getOutputStream() throws IOException {
        if (this.out == null) {
            this.out = new SocketOutputStream(this);
        }
        return this.out;
    }

    protected void listen(int n) throws IOException {
        this.socketListen(n);
    }

    protected void setTcpNoDelay(boolean bl) throws SocketException {
        this.socketSetOption(1, new Integer(bl ? 1 : 0));
    }

    protected boolean getTcpNoDelay() throws SocketException {
        boolean bl = false;
        if (this.socketGetOption(1) != 0) {
            bl = true;
        }
        return bl;
    }

    protected void setSoLinger(boolean bl, int n) throws SocketException {
        int n2 = 0;
        if (bl) {
            n2 = n;
        }
        this.socketSetOption(128, new Integer(n2));
    }

    protected int getSoLinger() throws SocketException {
        return this.socketGetOption(128);
    }

    protected void setSoTimeout(int n) throws SocketException {
        this.setOption(4102, new Integer(n));
    }

    protected int getSoTimeout() throws SocketException {
        return (Integer)this.getOption(4102);
    }

    protected void setSendBufferSize(int n) throws SocketException {
        this.socketSetOption(4097, new Integer(n));
    }

    protected int getSendBufferSize() throws SocketException {
        return this.socketGetOption(4097);
    }

    protected void setReceiveBufferSize(int n) throws SocketException {
        this.socketSetOption(4098, new Integer(n));
    }

    protected int getReceiveBufferSize() throws SocketException {
        return this.socketGetOption(4098);
    }

    public void setOption(int n, Object object) throws SocketException {
        int n2;
        int n3 = 0;
        if (object instanceof Boolean && !((Boolean)object).booleanValue()) {
            n3 = 1;
        }
        if ((n2 = n3) != 0) {
            object = new Integer(0);
        }
        switch (n) {
            case 4: 
            case 128: 
            case 4097: 
            case 4098: {
                break;
            }
            case 1: {
                object = new Integer(1 - n2);
                break;
            }
            case 4102: {
                int n4 = (Integer)object;
                if (n4 < 0) {
                    throw new IllegalArgumentException("timeout < 0");
                }
                this.timeout = n4 == 0 ? -1 : n4;
                return;
            }
            case 15: {
                throw new SocketException("Read-only socket option");
            }
            default: {
                throw new SocketException("Unknown socket option");
            }
        }
        this.socketSetOption(n, object);
    }

    public Object getOption(int n) throws SocketException {
        switch (n) {
            case 128: 
            case 4097: 
            case 4098: {
                return new Integer(this.socketGetOption(n));
            }
            case 1: 
            case 4: {
                boolean bl = false;
                if (this.socketGetOption(n) != 0) {
                    bl = true;
                }
                return new Boolean(bl);
            }
            case 4102: {
                if (this.timeout == -1) {
                    return new Integer(0);
                }
                return new Integer(this.timeout);
            }
            case 15: {
                int n2 = this.socketGetOption(n);
                try {
                    return InetAddress.getByName("" + (n2 >> 24 & 0xFF) + '.' + (n2 >> 16 & 0xFF) + '.' + (n2 >> 8 & 0xFF) + '.' + (n2 & 0xFF));
                }
                catch (UnknownHostException unknownHostException) {
                    throw new Error("impossible result");
                }
            }
        }
        throw new SocketException("Unknown socket option");
    }

    protected int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.closed) {
            return -1;
        }
        int n3 = this.socketRead(byArray, n, n2);
        if (n3 > 0 || n2 == 0) {
            return n3;
        }
        return -1;
    }

    protected void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.closed) {
            throw new IOException("socket closed");
        }
        this.socketWrite(byArray, n, n2);
    }

    protected void sendUrgentData(int n) throws IOException {
    }

    public synchronized native void socketSetOption(int var1, Object var2) throws SocketException;

    public synchronized native int socketGetOption(int var1) throws SocketException;

    protected native void socketAccept(SocketImpl var1);

    protected native int socketAvailable();

    protected native void socketBind(InetAddress var1, int var2);

    protected native void socketClose();

    protected native void socketConnect(InetAddress var1, int var2, int var3);

    protected native void socketCreate(boolean var1);

    protected native void socketListen(int var1);

    protected native int socketRead(byte[] var1, int var2, int var3) throws IOException;

    protected native void socketWrite(byte[] var1, int var2, int var3) throws IOException;

    protected native void waitForConnection() throws IOException;

    protected native void setBlocking(boolean var1);

    static {
        System.loadLibrary("javanet");
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class SocketInputStream
    extends InputStream {
        private PlainSocketImpl impl;

        public int available() throws IOException {
            return this.impl.available();
        }

        public boolean markSupported() {
            return false;
        }

        public void mark(int n) {
        }

        public void reset() throws IOException {
            throw new IOException("Socket InputStreams do not support mark/reset");
        }

        public void close() throws IOException {
            this.impl.close();
        }

        public int read() throws IOException {
            byte[] byArray = new byte[1];
            int n = this.read(byArray, 0, byArray.length);
            if (n != -1) {
                return byArray[0] & 0xFF;
            }
            return -1;
        }

        public int read(byte[] byArray) throws IOException {
            return this.read(byArray, 0, byArray.length);
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3 = this.impl.read(byArray, n, n2);
            if (n3 == 0) {
                return -1;
            }
            return n3;
        }

        protected SocketInputStream(PlainSocketImpl plainSocketImpl2) {
            this.impl = plainSocketImpl2;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class SocketOutputStream
    extends OutputStream {
        private PlainSocketImpl impl;

        public void close() throws IOException {
            this.impl.close();
        }

        public void flush() throws IOException {
        }

        public void write(int n) throws IOException {
            byte[] byArray = new byte[1];
            Integer n2 = new Integer(n);
            byArray[0] = n2.byteValue();
            this.write(byArray, 0, byArray.length);
        }

        public void write(byte[] byArray) throws IOException {
            this.write(byArray, 0, byArray.length);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.impl.write(byArray, n, n2);
        }

        protected SocketOutputStream(PlainSocketImpl plainSocketImpl2) {
            this.impl = plainSocketImpl2;
        }
    }
}

