/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.net.protocol.http;

import gnu.classpath.SystemProperties;
import gnu.java.net.protocol.http.Authenticator;
import gnu.java.net.protocol.http.ByteArrayRequestBodyWriter;
import gnu.java.net.protocol.http.Credentials;
import gnu.java.net.protocol.http.HTTPConnection;
import gnu.java.net.protocol.http.Headers;
import gnu.java.net.protocol.http.Request;
import gnu.java.net.protocol.http.RequestBodyWriter;
import gnu.java.net.protocol.http.Response;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ProtocolException;
import java.net.URL;
import java.security.cert.Certificate;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocketFactory;

public class HTTPURLConnection
extends HttpsURLConnection
implements HandshakeCompletedListener {
    private HTTPConnection connection;
    String proxyHostname;
    int proxyPort;
    String agent;
    boolean keepAlive;
    private Request request;
    private Headers requestHeaders = new Headers();
    private ByteArrayOutputStream requestSink;
    private boolean requestMethodSetExplicitly;
    private Response response;
    private InputStream responseSink;
    private InputStream errorSink;
    private HandshakeCompletedEvent handshakeEvent;

    public void connect() throws IOException {
        boolean bl;
        int n;
        if (this.connected) {
            return;
        }
        String string = this.url.getProtocol();
        boolean bl2 = "https".equals(string);
        String string2 = this.url.getHost();
        int n2 = this.url.getPort();
        if (n2 < 0) {
            n2 = bl2 ? 443 : 80;
        }
        Object object = this.url.getFile();
        String string3 = this.url.getUserInfo();
        String string4 = null;
        if (string3 != null && (n = string3.indexOf(58)) != -1) {
            string4 = string3.substring(n + 1);
            string3 = string3.substring(0, n);
        }
        final Credentials credentials = string3 == null ? null : new Credentials(string3, string4);
        do {
            Object object2;
            Object object3;
            bl = false;
            if (this.connection == null) {
                this.connection = this.getConnection(string2, n2, bl2);
                if (bl2) {
                    object3 = this.getSSLSocketFactory();
                    object2 = this.getHostnameVerifier();
                    if (object3 != null) {
                        this.connection.setSSLSocketFactory((SSLSocketFactory)object3);
                    }
                    this.connection.addHandshakeCompletedListener(this);
                }
            }
            if (this.proxyHostname != null) {
                if (this.proxyPort < 0) {
                    this.proxyPort = bl2 ? 443 : 80;
                }
                this.connection.setProxy(this.proxyHostname, this.proxyPort);
            }
            try {
                this.request = this.connection.newRequest(this.method, (String)object);
                if (!this.keepAlive) {
                    this.request.setHeader("Connection", "close");
                }
                if (this.agent != null) {
                    this.request.setHeader("User-Agent", this.agent);
                }
                this.request.getHeaders().putAll(this.requestHeaders);
                if (this.requestSink != null) {
                    object3 = this.requestSink.toByteArray();
                    object2 = new ByteArrayRequestBodyWriter((byte[])object3);
                    this.request.setRequestBodyWriter((RequestBodyWriter)object2);
                }
                if (credentials != null) {
                    this.request.setAuthenticator(new Authenticator(){

                        public final Credentials getCredentials(String string, int n) {
                            return n < 2 ? credentials : null;
                        }
                    });
                }
                this.response = this.request.dispatch();
            }
            catch (IOException iOException) {
                if (this.connection.useCount > 0) {
                    try {
                        this.connection.close();
                    }
                    catch (IOException iOException2) {}
                    this.connection = null;
                    bl = true;
                    continue;
                }
                throw iOException;
            }
            if (this.response.isRedirect() && this.getInstanceFollowRedirects()) {
                int n3;
                int n4;
                object3 = this.response.getBody();
                if (object3 != null) {
                    int n5;
                    object2 = new byte[1024];
                    while ((n5 = ((InputStream)object3).read((byte[])object2, 0, ((Object)object2).length)) != -1) {
                    }
                }
                if ((object2 = this.response.getHeader("Location")) == null) continue;
                String string5 = this.connection.getURI();
                int n6 = string5.length();
                if (((String)object2).startsWith(string5) && ((String)object2).charAt(n6) == '/') {
                    object = ((String)object2).substring(n6);
                    bl = true;
                    continue;
                }
                if (((String)object2).startsWith("http:")) {
                    this.connection.close();
                    this.connection = null;
                    bl2 = false;
                    n6 = 7;
                    n4 = ((String)object2).indexOf(47, n6);
                    string2 = ((String)object2).substring(n6, n4);
                    n3 = string2.lastIndexOf(58);
                    if (n3 != -1) {
                        n2 = Integer.parseInt(string2.substring(n3 + 1));
                        string2 = string2.substring(0, n3);
                    } else {
                        n2 = 80;
                    }
                    object = ((String)object2).substring(n4);
                    bl = true;
                    continue;
                }
                if (((String)object2).startsWith("https:")) {
                    this.connection.close();
                    this.connection = null;
                    bl2 = true;
                    n6 = 8;
                    n4 = ((String)object2).indexOf(47, n6);
                    string2 = ((String)object2).substring(n6, n4);
                    n3 = string2.lastIndexOf(58);
                    if (n3 != -1) {
                        n2 = Integer.parseInt(string2.substring(n3 + 1));
                        string2 = string2.substring(0, n3);
                    } else {
                        n2 = 443;
                    }
                    object = ((String)object2).substring(n4);
                    bl = true;
                    continue;
                }
                if (((String)object2).length() <= 0) continue;
                if (((String)object2).charAt(0) == '/') {
                    object = object2;
                } else {
                    n4 = ((String)object).lastIndexOf(47);
                    object = n4 == -1 ? "/" : ((String)object).substring(0, n4 + 1);
                    object = (String)object + (String)object2;
                }
                bl = true;
                continue;
            }
            this.responseSink = this.response.getBody();
            if (!this.response.isError()) continue;
            this.errorSink = this.responseSink;
        } while (bl);
        this.connected = true;
    }

    HTTPConnection getConnection(String string, int n, boolean bl) throws IOException {
        HTTPConnection hTTPConnection = this.keepAlive ? HTTPConnection.Pool.instance.get(string, n, bl) : new HTTPConnection(string, n, bl);
        return hTTPConnection;
    }

    public void disconnect() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (IOException iOException) {}
        }
    }

    public boolean usingProxy() {
        boolean bl = false;
        if (this.proxyHostname != null) {
            bl = true;
        }
        return bl;
    }

    public void setRequestMethod(String string) throws ProtocolException {
        if (this.connected) {
            throw new ProtocolException("Already connected");
        }
        int n = (string = string.toUpperCase()).length();
        if (n == 0) {
            throw new ProtocolException("Empty method name");
        }
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c < 'A' || c > 'Z') {
                throw new ProtocolException("Illegal character '" + c + "' at index " + n2);
            }
            ++n2;
        }
        this.method = string;
        this.requestMethodSetExplicitly = true;
    }

    public String getRequestProperty(String string) {
        return this.requestHeaders.getValue(string);
    }

    public Map getRequestProperties() {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        Map map = this.requestHeaders.getAsMap();
        return Collections.unmodifiableMap(map);
    }

    public void setRequestProperty(String string, String string2) {
        super.setRequestProperty(string, string2);
        this.requestHeaders.put(string, string2);
    }

    public void addRequestProperty(String string, String string2) {
        super.addRequestProperty(string, string2);
        this.requestHeaders.addValue(string, string2);
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.connected) {
            throw new ProtocolException("Already connected");
        }
        if (!this.doOutput) {
            throw new ProtocolException("doOutput is false");
        }
        if (!this.requestMethodSetExplicitly) {
            this.method = "POST";
        }
        if (this.requestSink == null) {
            this.requestSink = new ByteArrayOutputStream();
        }
        return this.requestSink;
    }

    public InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        if (!this.doInput) {
            throw new ProtocolException("doInput is false");
        }
        if (this.response.isError()) {
            int n = this.response.getCode();
            if (n == 404 || n == 410) {
                throw new FileNotFoundException(this.url.toString());
            }
            throw new IOException("Server returned HTTP response code " + n + " for URL " + this.url.toString());
        }
        return this.responseSink;
    }

    public InputStream getErrorStream() {
        return this.errorSink;
    }

    public Map getHeaderFields() {
        if (!this.connected) {
            try {
                this.connect();
            }
            catch (IOException iOException) {
                return null;
            }
        }
        Map map = this.response.getHeaders().getAsMap();
        map.put(null, Collections.singletonList(this.getStatusLine(this.response)));
        return Collections.unmodifiableMap(map);
    }

    String getStatusLine(Response response) {
        return "HTTP/" + response.getMajorVersion() + '.' + response.getMinorVersion() + ' ' + response.getCode() + ' ' + response.getMessage();
    }

    public String getHeaderField(int n) {
        if (!this.connected) {
            try {
                this.connect();
            }
            catch (IOException iOException) {
                return null;
            }
        }
        if (n == 0) {
            return this.getStatusLine(this.response);
        }
        return this.response.getHeaders().getHeaderValue(n - 1);
    }

    public String getHeaderFieldKey(int n) {
        if (!this.connected) {
            try {
                this.connect();
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return this.response.getHeaders().getHeaderName(n - 1);
    }

    public String getHeaderField(String string) {
        if (!this.connected) {
            try {
                this.connect();
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return this.response.getHeader(string);
    }

    public long getHeaderFieldDate(String string, long l) {
        Date date;
        if (!this.connected) {
            try {
                this.connect();
            }
            catch (IOException iOException) {
                return l;
            }
        }
        return (date = this.response.getDateHeader(string)) == null ? l : date.getTime();
    }

    public String getContentType() {
        return this.getHeaderField("Content-Type");
    }

    public int getResponseCode() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        return this.response.getCode();
    }

    public String getResponseMessage() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        return this.response.getMessage();
    }

    public String getCipherSuite() {
        if (!this.connected) {
            throw new IllegalStateException("not connected");
        }
        return this.handshakeEvent.getCipherSuite();
    }

    public Certificate[] getLocalCertificates() {
        if (!this.connected) {
            throw new IllegalStateException("not connected");
        }
        return this.handshakeEvent.getLocalCertificates();
    }

    public Certificate[] getServerCertificates() throws SSLPeerUnverifiedException {
        if (!this.connected) {
            throw new IllegalStateException("not connected");
        }
        return this.handshakeEvent.getPeerCertificates();
    }

    public void handshakeCompleted(HandshakeCompletedEvent handshakeCompletedEvent) {
        this.handshakeEvent = handshakeCompletedEvent;
    }

    public HTTPURLConnection(URL uRL) throws IOException {
        super(uRL);
        String string;
        this.proxyHostname = SystemProperties.getProperty("http.proxyHost");
        if (this.proxyHostname != null && this.proxyHostname.length() > 0) {
            string = SystemProperties.getProperty("http.proxyPort");
            if (string != null && string.length() > 0) {
                this.proxyPort = Integer.parseInt(string);
            } else {
                this.proxyHostname = null;
                this.proxyPort = -1;
            }
        }
        this.agent = SystemProperties.getProperty("http.agent");
        string = SystemProperties.getProperty("http.keepAlive");
        boolean bl = false;
        if (string != null && "false".equals(string)) {
            bl = true;
        }
        this.keepAlive = bl ^ true;
    }
}

