/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.PropertyPermission;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class Properties {
    private static final String NAME = "Properties";
    private static final boolean DEBUG = false;
    private static final PrintWriter err = new PrintWriter(System.out, true);
    public static final String VERSION = "gnu.crypto.version";
    public static final String PROPERTIES_FILE = "gnu.crypto.properties.file";
    public static final String REPRODUCIBLE_PRNG = "gnu.crypto.with.reproducible.prng";
    public static final String CHECK_WEAK_KEYS = "gnu.crypto.with.check.for.weak.keys";
    public static final String DO_RSA_BLINDING = "gnu.crypto.with.rsa.blinding";
    private static final String TRUE = Boolean.TRUE.toString();
    private static final String FALSE = Boolean.FALSE.toString();
    private static final HashMap props = new HashMap();
    private static Properties singleton = null;
    private boolean reproducible;
    private boolean checkForWeakKeys;
    private boolean doRSABlinding;

    private static final void debug(String string) {
        err.println(">>> Properties: " + string);
    }

    public static final synchronized String getProperty(String string) {
        if (string == null) {
            return null;
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new PropertyPermission(string, "read"));
        }
        if ("".equals(string = string.trim().toLowerCase())) {
            return null;
        }
        return (String)props.get(string);
    }

    public static final synchronized void setProperty(String string, String string2) {
        if (string == null || string2 == null) {
            return;
        }
        if ("".equals(string = string.trim().toLowerCase())) {
            return;
        }
        if (string.equals(VERSION)) {
            return;
        }
        if ("".equals(string2 = string2.trim())) {
            return;
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new PropertyPermission(string, "write"));
        }
        if (string.equals(REPRODUCIBLE_PRNG) && (string2.equalsIgnoreCase(TRUE) || string2.equalsIgnoreCase(FALSE))) {
            Properties.setReproducible(Boolean.valueOf(string2));
        } else if (string.equals(CHECK_WEAK_KEYS) && (string2.equalsIgnoreCase(TRUE) || string2.equalsIgnoreCase(FALSE))) {
            Properties.setCheckForWeakKeys(Boolean.valueOf(string2));
        } else if (string.equals(DO_RSA_BLINDING) && (string2.equalsIgnoreCase(TRUE) || string2.equalsIgnoreCase(FALSE))) {
            Properties.setDoRSABlinding(Boolean.valueOf(string2));
        } else {
            props.put(string, string2);
        }
    }

    public static final synchronized boolean isReproducible() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new PropertyPermission(REPRODUCIBLE_PRNG, "read"));
        }
        return Properties.instance().reproducible;
    }

    public static final synchronized boolean checkForWeakKeys() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new PropertyPermission(CHECK_WEAK_KEYS, "read"));
        }
        return Properties.instance().checkForWeakKeys;
    }

    public static final synchronized boolean doRSABlinding() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new PropertyPermission(DO_RSA_BLINDING, "read"));
        }
        return Properties.instance().doRSABlinding;
    }

    public static final synchronized void setReproducible(boolean bl) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new PropertyPermission(REPRODUCIBLE_PRNG, "write"));
        }
        Properties.instance().reproducible = bl;
        props.put(REPRODUCIBLE_PRNG, String.valueOf(bl));
    }

    public static final synchronized void setCheckForWeakKeys(boolean bl) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new PropertyPermission(CHECK_WEAK_KEYS, "write"));
        }
        Properties.instance().checkForWeakKeys = bl;
        props.put(CHECK_WEAK_KEYS, String.valueOf(bl));
    }

    public static final synchronized void setDoRSABlinding(boolean bl) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new PropertyPermission(DO_RSA_BLINDING, "write"));
        }
        Properties.instance().doRSABlinding = bl;
        props.put(DO_RSA_BLINDING, String.valueOf(bl));
    }

    private static final synchronized Properties instance() {
        if (singleton == null) {
            singleton = new Properties();
        }
        return singleton;
    }

    private final void init() {
        props.put(REPRODUCIBLE_PRNG, this.reproducible ? "true" : "false");
        props.put(CHECK_WEAK_KEYS, this.checkForWeakKeys ? "true" : "false");
        props.put(DO_RSA_BLINDING, this.doRSABlinding ? "true" : "false");
        String string = null;
        try {
            string = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public final Object run() {
                    return System.getProperty(Properties.PROPERTIES_FILE);
                }
            });
        }
        catch (SecurityException securityException) {}
        if (string != null) {
            try {
                java.util.Properties properties = new java.util.Properties();
                FileInputStream fileInputStream = new FileInputStream(string);
                properties.load(fileInputStream);
                properties.list(System.out);
                props.putAll(properties);
            }
            catch (IOException iOException) {
            }
            catch (SecurityException securityException) {}
        }
        this.handleBooleanProperty(REPRODUCIBLE_PRNG);
        this.handleBooleanProperty(CHECK_WEAK_KEYS);
        this.handleBooleanProperty(DO_RSA_BLINDING);
        this.reproducible = new Boolean((String)props.get(REPRODUCIBLE_PRNG));
        this.checkForWeakKeys = new Boolean((String)props.get(CHECK_WEAK_KEYS));
        this.doRSABlinding = new Boolean((String)props.get(DO_RSA_BLINDING));
        props.put(VERSION, "2.1.0");
    }

    private final void handleBooleanProperty(String string) {
        String string2 = null;
        try {
            string2 = System.getProperty(string);
        }
        catch (SecurityException securityException) {}
        if (string2 != null && ((string2 = string2.trim().toLowerCase()).equals(TRUE) || string2.equals(FALSE))) {
            props.put(string, string2);
        }
    }

    private final /* synthetic */ void this() {
        this.reproducible = false;
        this.checkForWeakKeys = true;
        this.doRSABlinding = true;
    }

    private Properties() {
        this.this();
        this.init();
    }
}

