/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.sig.rsa;

import gnu.java.security.hash.HashFactory;
import gnu.java.security.hash.IMessageDigest;
import java.io.ByteArrayOutputStream;

public class EMSA_PKCS1_V1_5
implements Cloneable {
    private static final byte[] MD2_PREFIX;
    private static final byte[] MD5_PREFIX;
    private static final byte[] SHA160_PREFIX;
    private static final byte[] SHA256_PREFIX;
    private static final byte[] SHA384_PREFIX;
    private static final byte[] SHA512_PREFIX;
    private IMessageDigest hash;
    private int hLen;
    private byte[] prefix;

    public static final EMSA_PKCS1_V1_5 getInstance(String string) {
        IMessageDigest iMessageDigest = HashFactory.getInstance(string);
        String string2 = iMessageDigest.name();
        if (!(string2.equals("md2") || string2.equals("md5") || string2.equals("sha-160") || string2.equals("sha-256") || string2.equals("sha-384") || string2.equals("sha-512"))) {
            throw new UnsupportedOperationException("hash with no OID: " + string2);
        }
        return new EMSA_PKCS1_V1_5(iMessageDigest);
    }

    public Object clone() {
        return EMSA_PKCS1_V1_5.getInstance(this.hash.name());
    }

    public byte[] encode(byte[] byArray, int n) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(this.prefix, 0, this.prefix.length);
        byteArrayOutputStream.write(byArray, 0, byArray.length);
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        int n2 = byArray2.length;
        if (n < n2 + 11) {
            throw new IllegalArgumentException("emLen too short");
        }
        byte[] byArray3 = new byte[n - n2 - 3];
        int n3 = 0;
        while (n3 < byArray3.length) {
            byArray3[n3] = -1;
            ++n3;
        }
        byteArrayOutputStream.reset();
        byteArrayOutputStream.write(0);
        byteArrayOutputStream.write(1);
        byteArrayOutputStream.write(byArray3, 0, byArray3.length);
        byteArrayOutputStream.write(0);
        byteArrayOutputStream.write(byArray2, 0, n2);
        byte[] byArray4 = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.reset();
        return byArray4;
    }

    private EMSA_PKCS1_V1_5(IMessageDigest iMessageDigest) {
        this.hash = iMessageDigest;
        this.hLen = iMessageDigest.hashSize();
        String string = iMessageDigest.name();
        if (string.equals("md2")) {
            this.prefix = MD2_PREFIX;
        } else if (string.equals("md5")) {
            this.prefix = MD5_PREFIX;
        } else if (string.equals("sha-160")) {
            this.prefix = SHA160_PREFIX;
        } else if (string.equals("sha-256")) {
            this.prefix = SHA256_PREFIX;
        } else if (string.equals("sha-384")) {
            this.prefix = SHA384_PREFIX;
        } else if (string.equals("sha-512")) {
            this.prefix = SHA512_PREFIX;
        } else {
            throw new UnsupportedOperationException();
        }
    }

    static {
        byte[] byArray = new byte[18];
        byArray[0] = 48;
        byArray[1] = 32;
        byArray[2] = 48;
        byArray[3] = 12;
        byArray[4] = 6;
        byArray[5] = 8;
        byArray[6] = 42;
        byArray[7] = -122;
        byArray[8] = 72;
        byArray[9] = -122;
        byArray[10] = -9;
        byArray[11] = 13;
        byArray[12] = 2;
        byArray[13] = 2;
        byArray[14] = 5;
        byArray[16] = 4;
        byArray[17] = 16;
        MD2_PREFIX = byArray;
        byte[] byArray2 = new byte[18];
        byArray2[0] = 48;
        byArray2[1] = 32;
        byArray2[2] = 48;
        byArray2[3] = 12;
        byArray2[4] = 6;
        byArray2[5] = 8;
        byArray2[6] = 42;
        byArray2[7] = -122;
        byArray2[8] = 72;
        byArray2[9] = -122;
        byArray2[10] = -9;
        byArray2[11] = 13;
        byArray2[12] = 2;
        byArray2[13] = 5;
        byArray2[14] = 5;
        byArray2[16] = 4;
        byArray2[17] = 16;
        MD5_PREFIX = byArray2;
        byte[] byArray3 = new byte[15];
        byArray3[0] = 48;
        byArray3[1] = 33;
        byArray3[2] = 48;
        byArray3[3] = 9;
        byArray3[4] = 6;
        byArray3[5] = 5;
        byArray3[6] = 43;
        byArray3[7] = 14;
        byArray3[8] = 3;
        byArray3[9] = 2;
        byArray3[10] = 26;
        byArray3[11] = 5;
        byArray3[13] = 4;
        byArray3[14] = 20;
        SHA160_PREFIX = byArray3;
        byte[] byArray4 = new byte[19];
        byArray4[0] = 48;
        byArray4[1] = 49;
        byArray4[2] = 48;
        byArray4[3] = 13;
        byArray4[4] = 6;
        byArray4[5] = 9;
        byArray4[6] = 96;
        byArray4[7] = -122;
        byArray4[8] = 72;
        byArray4[9] = 1;
        byArray4[10] = 101;
        byArray4[11] = 3;
        byArray4[12] = 4;
        byArray4[13] = 2;
        byArray4[14] = 1;
        byArray4[15] = 5;
        byArray4[17] = 4;
        byArray4[18] = 32;
        SHA256_PREFIX = byArray4;
        byte[] byArray5 = new byte[19];
        byArray5[0] = 48;
        byArray5[1] = 65;
        byArray5[2] = 48;
        byArray5[3] = 13;
        byArray5[4] = 6;
        byArray5[5] = 9;
        byArray5[6] = 96;
        byArray5[7] = -122;
        byArray5[8] = 72;
        byArray5[9] = 1;
        byArray5[10] = 101;
        byArray5[11] = 3;
        byArray5[12] = 4;
        byArray5[13] = 2;
        byArray5[14] = 2;
        byArray5[15] = 5;
        byArray5[17] = 4;
        byArray5[18] = 48;
        SHA384_PREFIX = byArray5;
        byte[] byArray6 = new byte[19];
        byArray6[0] = 48;
        byArray6[1] = 81;
        byArray6[2] = 48;
        byArray6[3] = 13;
        byArray6[4] = 6;
        byArray6[5] = 9;
        byArray6[6] = 96;
        byArray6[7] = -122;
        byArray6[8] = 72;
        byArray6[9] = 1;
        byArray6[10] = 101;
        byArray6[11] = 3;
        byArray6[12] = 4;
        byArray6[13] = 2;
        byArray6[14] = 3;
        byArray6[15] = 5;
        byArray6[17] = 4;
        byArray6[18] = 64;
        SHA512_PREFIX = byArray6;
    }
}

