/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.sig.rsa;

import gnu.java.security.hash.HashFactory;
import gnu.java.security.hash.IMessageDigest;
import java.io.PrintWriter;
import java.util.Arrays;

public class EMSA_PSS
implements Cloneable {
    private static final String NAME = "emsa-pss";
    private static final boolean DEBUG = false;
    private static final int debuglevel = 5;
    private static final PrintWriter err = new PrintWriter(System.out, true);
    private IMessageDigest hash;
    private int hLen;

    private static final void debug(String string) {
        err.println(">>> emsa-pss: " + string);
    }

    public static EMSA_PSS getInstance(String string) {
        IMessageDigest iMessageDigest = HashFactory.getInstance(string);
        return new EMSA_PSS(iMessageDigest);
    }

    public Object clone() {
        return EMSA_PSS.getInstance(this.hash.name());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] encode(byte[] byArray, int n, byte[] byArray2) {
        byte[] byArray3;
        int n2;
        int n3 = byArray2.length;
        if (this.hLen != byArray.length) {
            throw new IllegalArgumentException("wrong hash");
        }
        if (n < 8 * this.hLen + 8 * n3 + 9) {
            throw new IllegalArgumentException("encoding error");
        }
        int n4 = (n + 7) / 8;
        IMessageDigest iMessageDigest = this.hash;
        synchronized (iMessageDigest) {
            n2 = 0;
            while (true) {
                if (n2 >= 8) {
                    this.hash.update(byArray, 0, this.hLen);
                    this.hash.update(byArray2, 0, n3);
                    byArray3 = this.hash.digest();
                    break;
                }
                this.hash.update((byte)0);
                ++n2;
            }
        }
        byte[] byArray4 = new byte[n4 - n3 - this.hLen - 2 + 1 + n3];
        byArray4[n4 - n3 - this.hLen - 2] = 1;
        System.arraycopy(byArray2, 0, byArray4, n4 - n3 - this.hLen - 1, n3);
        byte[] byArray5 = this.MGF(byArray3, n4 - this.hLen - 1);
        n2 = 0;
        while (n2 < byArray4.length) {
            byArray4[n2] = (byte)(byArray4[n2] ^ byArray5[n2]);
            ++n2;
        }
        byArray4[0] = (byte)(byArray4[0] & 255 >>> 8 * n4 - n);
        byte[] byArray6 = new byte[n4];
        System.arraycopy(byArray4, 0, byArray6, 0, n4 - this.hLen - 1);
        System.arraycopy(byArray3, 0, byArray6, n4 - this.hLen - 1, this.hLen);
        byArray6[n4 - 1] = -68;
        return byArray6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean decode(byte[] byArray, byte[] byArray2, int n, int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("sLen");
        }
        if (this.hLen != byArray.length) {
            throw new IllegalArgumentException("wrong hash");
        }
        if (n < 8 * this.hLen + 8 * n2 + 9) {
            throw new IllegalArgumentException("decoding error");
        }
        int n3 = (n + 7) / 8;
        if ((byArray2[byArray2.length - 1] & 0xFF) != 188) {
            return false;
        }
        if ((byArray2[0] & 255 << 8 - (8 * n3 - n)) != 0) {
            return false;
        }
        byte[] byArray3 = new byte[n3 - this.hLen - 1];
        byte[] byArray4 = new byte[this.hLen];
        System.arraycopy(byArray2, 0, byArray3, 0, n3 - this.hLen - 1);
        System.arraycopy(byArray2, n3 - this.hLen - 1, byArray4, 0, this.hLen);
        byte[] byArray5 = this.MGF(byArray4, n3 - this.hLen - 1);
        int n4 = 0;
        while (n4 < byArray3.length) {
            byArray3[n4] = (byte)(byArray3[n4] ^ byArray5[n4]);
            ++n4;
        }
        byArray3[0] = (byte)(byArray3[0] & 255 >>> 8 * n3 - n);
        n4 = 0;
        while (n4 < n3 - this.hLen - n2 - 2) {
            if (byArray3[n4] != 0) {
                return false;
            }
            ++n4;
        }
        if (byArray3[n4] != 1) {
            return false;
        }
        byte[] byArray6 = new byte[n2];
        System.arraycopy(byArray3, byArray3.length - n2, byArray6, 0, n2);
        IMessageDigest iMessageDigest = this.hash;
        synchronized (iMessageDigest) {
            n4 = 0;
            while (true) {
                if (n4 >= 8) {
                    this.hash.update(byArray, 0, this.hLen);
                    this.hash.update(byArray6, 0, n2);
                    byte[] byArray7 = this.hash.digest();
                    return Arrays.equals(byArray4, byArray7);
                }
                this.hash.update((byte)0);
                ++n4;
            }
        }
    }

    private final byte[] MGF(byte[] byArray, int n) {
        if (n < 1 || ((long)n & 0xFFFFFFFFL) > ((long)this.hLen & 0xFFFFFFFFL) << 32) {
            throw new IllegalArgumentException("mask too long");
        }
        byte[] byArray2 = new byte[n];
        int n2 = (n + this.hLen - 1) / this.hLen - 1;
        IMessageDigest iMessageDigest = null;
        iMessageDigest = (IMessageDigest)this.hash.clone();
        iMessageDigest.digest();
        iMessageDigest.update(byArray, 0, byArray.length);
        IMessageDigest iMessageDigest2 = null;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            iMessageDigest2 = (IMessageDigest)iMessageDigest.clone();
            iMessageDigest2.update((byte)(n4 >>> 24));
            iMessageDigest2.update((byte)(n4 >>> 16));
            iMessageDigest2.update((byte)(n4 >>> 8));
            iMessageDigest2.update((byte)n4);
            byte[] byArray3 = iMessageDigest2.digest();
            int n5 = n - n3;
            n5 = n5 > this.hLen ? this.hLen : n5;
            System.arraycopy(byArray3, 0, byArray2, n3, n5);
            n3 += n5;
            ++n4;
        }
        return byArray2;
    }

    private EMSA_PSS(IMessageDigest iMessageDigest) {
        this.hash = iMessageDigest;
        this.hLen = iMessageDigest.hashSize();
    }
}

