/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.assembly;

import gnu.javax.crypto.assembly.Cascade;
import gnu.javax.crypto.assembly.Transformer;
import gnu.javax.crypto.assembly.TransformerException;
import java.security.InvalidKeyException;
import java.util.Map;

class CascadeTransformer
extends Transformer {
    private Cascade delegate;
    private int blockSize;

    void initDelegate(Map map) throws TransformerException {
        map.put("gnu.crypto.assembly.cascade.direction", this.wired);
        try {
            this.delegate.init(map);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new TransformerException("initDelegate()", invalidKeyException);
        }
        this.blockSize = this.delegate.currentBlockSize();
    }

    int delegateBlockSize() {
        return this.blockSize;
    }

    void resetDelegate() {
        this.delegate.reset();
        this.blockSize = 0;
    }

    byte[] updateDelegate(byte[] byArray, int n, int n2) throws TransformerException {
        byte[] byArray2 = this.updateInternal(byArray, n, n2);
        return byArray2;
    }

    byte[] lastUpdateDelegate() throws TransformerException {
        if (this.inBuffer.size() != 0) {
            throw new TransformerException("lastUpdateDelegate()", new IllegalStateException("Cascade transformer, after last update, must be empty but isn't"));
        }
        return new byte[0];
    }

    private final byte[] updateInternal(byte[] byArray, int n, int n2) {
        byte[] byArray2;
        int n3 = 0;
        while (n3 < n2) {
            this.inBuffer.write(byArray[n++] & 0xFF);
            if (this.inBuffer.size() >= this.blockSize) {
                byArray2 = this.inBuffer.toByteArray();
                this.inBuffer.reset();
                this.delegate.update(byArray2, 0, byArray2, 0);
                this.outBuffer.write(byArray2, 0, this.blockSize);
            }
            ++n3;
        }
        byArray2 = this.outBuffer.toByteArray();
        this.outBuffer.reset();
        return byArray2;
    }

    CascadeTransformer(Cascade cascade) {
        this.delegate = cascade;
    }
}

