/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.jce.sig;

import gnu.java.security.jce.sig.KeyPairGeneratorAdapter;
import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashMap;
import javax.crypto.spec.DHGenParameterSpec;

public class DHKeyPairGeneratorSpi
extends KeyPairGeneratorAdapter {
    public void initialize(int n, SecureRandom secureRandom) {
        HashMap hashMap = new HashMap();
        hashMap.put("gnu.crypto.dh.L", new Integer(n));
        if (secureRandom != null) {
            hashMap.put("gnu.crypto.dh.prng", secureRandom);
        }
        hashMap.put("gnu.crypto.dh.encoding", new Integer(4));
        this.adaptee.setup(hashMap);
    }

    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        HashMap hashMap = new HashMap();
        if (algorithmParameterSpec != null) {
            if (!(algorithmParameterSpec instanceof DHGenParameterSpec)) {
                throw new InvalidAlgorithmParameterException("params");
            }
            hashMap.put("gnu.crypto.dh.params", algorithmParameterSpec);
        }
        if (secureRandom != null) {
            hashMap.put("gnu.crypto.dh.prng", secureRandom);
        }
        hashMap.put("gnu.crypto.dh.encoding", new Integer(4));
        this.adaptee.setup(hashMap);
    }

    public DHKeyPairGeneratorSpi() {
        super("dh");
    }
}

