/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.pad;

import gnu.javax.crypto.pad.IPad;
import gnu.javax.crypto.pad.WrongPaddingException;

public abstract class BasePad
implements IPad {
    protected String name;
    protected int blockSize;

    public String name() {
        StringBuffer stringBuffer = new StringBuffer(this.name);
        if (this.blockSize != -1) {
            stringBuffer.append('-').append(String.valueOf(8 * this.blockSize));
        }
        return stringBuffer.toString();
    }

    public void init(int n) throws IllegalStateException {
        if (this.blockSize != -1) {
            throw new IllegalStateException();
        }
        this.blockSize = n;
        this.setup();
    }

    public void reset() {
        this.blockSize = -1;
    }

    public boolean selfTest() {
        byte[] byArray = new byte[1024];
        int n = 2;
        while (n < 256) {
            this.init(n);
            int n2 = 0;
            while (n2 < 1019 - this.blockSize) {
                byte[] byArray2 = this.pad(byArray, 5, n2);
                if ((n2 + byArray2.length) % this.blockSize != 0) {
                    new RuntimeException(this.name()).printStackTrace(System.err);
                    return false;
                }
                System.arraycopy(byArray2, 0, byArray, 5 + n2, byArray2.length);
                try {
                    if (byArray2.length != this.unpad(byArray, 5, n2 + byArray2.length)) {
                        new RuntimeException(this.name()).printStackTrace(System.err);
                        return false;
                    }
                }
                catch (WrongPaddingException wrongPaddingException) {
                    wrongPaddingException.printStackTrace(System.err);
                    return false;
                }
                ++n2;
            }
            this.reset();
            ++n;
        }
        return true;
    }

    public abstract void setup();

    public abstract byte[] pad(byte[] var1, int var2, int var3);

    public abstract int unpad(byte[] var1, int var2, int var3) throws WrongPaddingException;

    protected BasePad(String string) {
        this.name = string;
        this.blockSize = -1;
    }
}

