/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.Certificate;
import gnu.javax.net.ssl.provider.CertificateRequest;
import gnu.javax.net.ssl.provider.CertificateType;
import gnu.javax.net.ssl.provider.CertificateVerify;
import gnu.javax.net.ssl.provider.CipherSuite;
import gnu.javax.net.ssl.provider.ClientHello;
import gnu.javax.net.ssl.provider.ClientKeyExchange;
import gnu.javax.net.ssl.provider.CompressionMethod;
import gnu.javax.net.ssl.provider.Constructed;
import gnu.javax.net.ssl.provider.Enumerated;
import gnu.javax.net.ssl.provider.Finished;
import gnu.javax.net.ssl.provider.ProtocolVersion;
import gnu.javax.net.ssl.provider.Random;
import gnu.javax.net.ssl.provider.ServerHello;
import gnu.javax.net.ssl.provider.ServerKeyExchange;
import gnu.javax.net.ssl.provider.Util;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collections;
import javax.net.ssl.SSLProtocolException;

final class Handshake
implements Constructed {
    private static final buffer BUF = new buffer();
    private final Type type;
    private final Body body;

    static final Handshake read(byte[] byArray) throws IOException {
        return Handshake.read(new ByteArrayInputStream(byArray));
    }

    static final Handshake read(byte[] byArray, CipherSuite cipherSuite, PublicKey publicKey) throws IOException {
        return Handshake.read(new ByteArrayInputStream(byArray), cipherSuite, publicKey);
    }

    static final Handshake read(InputStream inputStream) throws IOException {
        return Handshake.read(inputStream, null, null);
    }

    static final Handshake read(InputStream inputStream, CipherSuite cipherSuite, PublicKey publicKey) throws IOException {
        return Handshake.read(inputStream, cipherSuite, publicKey, null);
    }

    static final Handshake read(InputStream inputStream, CertificateType certificateType) throws IOException {
        return Handshake.read(inputStream, null, null, certificateType);
    }

    static final Handshake read(InputStream inputStream, CipherSuite cipherSuite, PublicKey publicKey, CertificateType certificateType) throws IOException {
        Type type = Type.read(inputStream);
        byte[] byArray = new byte[3];
        inputStream.read(byArray);
        int n = (byArray[0] & 0xFF) << 16 | (byArray[1] & 0xFF) << 8 | byArray[2] & 0xFF;
        Body body = null;
        if (type == Type.HELLO_REQUEST) {
            body = null;
        } else if (type == Type.CLIENT_HELLO) {
            if (byArray[0] == 3 && byArray[1] >= 0 && byArray[1] <= 2) {
                ProtocolVersion protocolVersion = null;
                switch (byArray[1]) {
                    case 0: {
                        protocolVersion = ProtocolVersion.SSL_3;
                        break;
                    }
                    case 1: {
                        protocolVersion = ProtocolVersion.TLS_1;
                        break;
                    }
                    case 2: {
                        protocolVersion = ProtocolVersion.TLS_1_1;
                        break;
                    }
                }
                int n2 = (byArray[2] & 0xFF) << 8 | inputStream.read() & 0xFF;
                int n3 = (inputStream.read() & 0xFF) << 8 | inputStream.read() & 0xFF;
                int n4 = (inputStream.read() & 0xFF) << 8 | inputStream.read() & 0xFF;
                ArrayList arrayList = new ArrayList(n2 / 3);
                int n5 = 0;
                while (n5 < n2) {
                    if (inputStream.read() == 0) {
                        arrayList.add(CipherSuite.read(inputStream).resolve(protocolVersion));
                    } else {
                        inputStream.read();
                        inputStream.read();
                    }
                    n5 += 3;
                }
                byte[] byArray2 = new byte[n3];
                inputStream.read(byArray2);
                byte[] byArray3 = new byte[n4];
                inputStream.read(byArray3);
                if (byArray3.length > 32) {
                    byArray3 = Util.trim(byArray3, 32);
                } else if (byArray3.length < 32) {
                    byte[] byArray4 = new byte[32];
                    System.arraycopy(byArray3, 0, byArray4, byArray4.length - byArray3.length, byArray3.length);
                    byArray3 = byArray4;
                }
                int n6 = (byArray3[0] & 0xFF) << 24 | (byArray3[1] & 0xFF) << 16 | (byArray3[2] & 0xFF) << 8 | byArray3[3] & 0xFF;
                Random random = new Random(n6, Util.trim(byArray3, 4, 28));
                return new Handshake(Type.CLIENT_HELLO, new ClientHello(protocolVersion, random, byArray2, arrayList, Collections.singletonList(CompressionMethod.NULL)));
            }
            byte[] byArray5 = new byte[n];
            int n7 = 0;
            while (n7 < n) {
                int n8 = inputStream.read(byArray5, n7, n - n7);
                if (n8 == -1) {
                    throw new EOFException("unexpected end of input stream");
                }
                n7 += n8;
            }
            body = ClientHello.read(new ByteArrayInputStream(byArray5));
        } else if (type == Type.SERVER_HELLO) {
            byte[] byArray6 = new byte[n];
            int n9 = 0;
            while (n9 < n) {
                int n10 = inputStream.read(byArray6, n9, n - n9);
                if (n10 == -1) {
                    throw new EOFException("unexpected end of input stream");
                }
                n9 += n10;
            }
            body = ServerHello.read(new ByteArrayInputStream(byArray6));
        } else if (type == Type.CERTIFICATE) {
            body = Certificate.read(inputStream, certificateType);
        } else if (type == Type.SERVER_KEY_EXCHANGE) {
            body = ServerKeyExchange.read(inputStream, cipherSuite, publicKey);
        } else if (type == Type.CERTIFICATE_REQUEST) {
            body = CertificateRequest.read(inputStream);
        } else if (type == Type.CERTIFICATE_VERIFY) {
            body = (CertificateVerify)CertificateVerify.read(inputStream, cipherSuite, publicKey);
        } else if (type == Type.CLIENT_KEY_EXCHANGE) {
            body = ClientKeyExchange.read(inputStream, cipherSuite, publicKey);
        } else if (type == Type.SERVER_HELLO_DONE) {
            body = null;
        } else if (type == Type.FINISHED) {
            body = Finished.read(inputStream, cipherSuite);
        } else {
            throw new SSLProtocolException("unknown HandshakeType: " + type.getValue());
        }
        return new Handshake(type, body);
    }

    public final void write(OutputStream outputStream) {
        throw new UnsupportedOperationException();
    }

    public final int write(OutputStream outputStream, ProtocolVersion protocolVersion) throws IOException {
        outputStream.write(this.type.getValue());
        if (this.body == null) {
            outputStream.write(0);
            outputStream.write(0);
            outputStream.write(0);
            return 4;
        }
        ByteArrayOutputStream byteArrayOutputStream = BUF.getBuffer();
        byteArrayOutputStream.reset();
        if (this.body instanceof ServerKeyExchange) {
            ((ServerKeyExchange)this.body).write(byteArrayOutputStream, protocolVersion);
        } else if (this.body instanceof ClientKeyExchange) {
            ((ClientKeyExchange)this.body).write(byteArrayOutputStream, protocolVersion);
        } else if (this.body instanceof CertificateVerify) {
            ((CertificateVerify)this.body).write(byteArrayOutputStream, protocolVersion);
        } else {
            this.body.write(byteArrayOutputStream);
        }
        outputStream.write(byteArrayOutputStream.size() >>> 16 & 0xFF);
        outputStream.write(byteArrayOutputStream.size() >>> 8 & 0xFF);
        outputStream.write(byteArrayOutputStream.size() & 0xFF);
        byteArrayOutputStream.writeTo(outputStream);
        return 4 + byteArrayOutputStream.size();
    }

    final Type getType() {
        return this.type;
    }

    final Body getBody() {
        return this.body;
    }

    public final String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        String string = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer();
        printWriter.println("struct {");
        printWriter.println("  type = " + this.type + ';');
        if (this.body != null) {
            BufferedReader bufferedReader = new BufferedReader(new StringReader(this.body.toString()));
            try {
                String string2;
                while ((string2 = bufferedReader.readLine()) != null) {
                    printWriter.print("  ");
                    printWriter.println(string2);
                }
            }
            catch (IOException iOException) {}
        }
        printWriter.println("} Handshake;");
        return stringWriter.toString();
    }

    Handshake(Type type, Body body) {
        this.type = type;
        this.body = body;
    }

    static class Type
    implements Enumerated {
        public static final Type HELLO_REQUEST = new Type(0);
        public static final Type CLIENT_HELLO = new Type(1);
        public static final Type SERVER_HELLO = new Type(2);
        public static final Type CERTIFICATE = new Type(11);
        public static final Type SERVER_KEY_EXCHANGE = new Type(12);
        public static final Type CERTIFICATE_REQUEST = new Type(13);
        public static final Type SERVER_HELLO_DONE = new Type(14);
        public static final Type CERTIFICATE_VERIFY = new Type(15);
        public static final Type CLIENT_KEY_EXCHANGE = new Type(16);
        public static final Type FINISHED = new Type(20);
        public static final Type CERTIFICATE_URL = new Type(21);
        public static final Type CERTIFICATE_STATUS = new Type(22);
        private final int value;

        public static Type read(InputStream inputStream) throws IOException {
            int n = inputStream.read();
            if (n == -1) {
                throw new EOFException("unexpected end of input stream");
            }
            switch (n & 0xFF) {
                case 0: {
                    return HELLO_REQUEST;
                }
                case 1: {
                    return CLIENT_HELLO;
                }
                case 2: {
                    return SERVER_HELLO;
                }
                case 11: {
                    return CERTIFICATE;
                }
                case 12: {
                    return SERVER_KEY_EXCHANGE;
                }
                case 13: {
                    return CERTIFICATE_REQUEST;
                }
                case 14: {
                    return SERVER_HELLO_DONE;
                }
                case 15: {
                    return CERTIFICATE_VERIFY;
                }
                case 16: {
                    return CLIENT_KEY_EXCHANGE;
                }
                case 20: {
                    return FINISHED;
                }
                case 21: {
                    return CERTIFICATE_URL;
                }
                case 22: {
                    return CERTIFICATE_STATUS;
                }
            }
            return new Type(n);
        }

        public byte[] getEncoded() {
            return new byte[]{(byte)this.value};
        }

        public int getValue() {
            return this.value;
        }

        public String toString() {
            switch (this.value) {
                case 0: {
                    return "hello_request";
                }
                case 1: {
                    return "client_hello";
                }
                case 2: {
                    return "server_hello";
                }
                case 11: {
                    return "certificate";
                }
                case 12: {
                    return "server_key_exchange";
                }
                case 13: {
                    return "certificate_request";
                }
                case 14: {
                    return "server_hello_done";
                }
                case 15: {
                    return "certificate_verify";
                }
                case 16: {
                    return "client_key_exchange";
                }
                case 20: {
                    return "finished";
                }
                case 21: {
                    return "certificate_url";
                }
                case 22: {
                    return "certificate_status";
                }
            }
            return "unknown(" + this.value + ')';
        }

        private Type(int n) {
            this.value = n;
        }
    }

    private static class buffer
    extends ThreadLocal {
        static final int SIZE = 2048;

        protected Object initialValue() {
            return new ByteArrayOutputStream(2048);
        }

        ByteArrayOutputStream getBuffer() {
            return (ByteArrayOutputStream)this.get();
        }

        private buffer() {
        }
    }

    static interface Body
    extends Constructed {
    }
}

